/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.poll;

import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class PollingUI {
    private static final String TAG = PollingUI.class.getSimpleName();
    private static PollingUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle = 0L;

    public static synchronized PollingUI getInstance() {
        if (instance == null) {
            instance = new PollingUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private PollingUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L) {
            this.nativeUninit(this.mNativeHandle);
        }
        super.finalize();
    }

    public void addListener(IPollingUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IPollingUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IPollingUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    protected void onPollingDocReceived() {
        try {
            this.onPollingDocReceivedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onPollingDocReceivedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IPollingUIListener l = (IPollingUIListener)lTmp;
                l.onPollingDocReceived();
            }
        }
    }

    protected void onPollingStatusChanged(int pollstate, String strPID) {
        try {
            this.onPollingStatusChangedImpl(pollstate, strPID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onPollingStatusChangedImpl(int pollstate, String strPID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IPollingUIListener l = (IPollingUIListener)lTmp;
                l.onPollingStatusChanged(pollstate, strPID);
            }
        }
    }

    protected void onPollingResultUpdated(String strPID) {
        try {
            this.onPollingResultUpdatedImpl(strPID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onPollingResultUpdatedImpl(String strPID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IPollingUIListener l = (IPollingUIListener)lTmp;
                l.onPollingResultUpdated(strPID);
            }
        }
    }

    protected void onPollingActionResult(int cmd, String strPID, int ret) {
        try {
            this.onPollingActionResultImpl(cmd, strPID, ret);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onPollingActionResultImpl(int cmd, String strPID, int ret) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IPollingUIListener l = (IPollingUIListener)lTmp;
                l.onPollingActionResult(cmd, strPID, ret);
            }
        }
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimplePollingUIListener
    implements IPollingUIListener {
        @Override
        public void onPollingDocReceived() {
        }

        @Override
        public void onPollingStatusChanged(int pollstate, String strPID) {
        }

        @Override
        public void onPollingResultUpdated(String strPID) {
        }

        @Override
        public void onPollingActionResult(int cmd, String strPID, int ret) {
        }
    }

    public static interface IPollingUIListener
    extends IListener {
        public void onPollingDocReceived();

        public void onPollingStatusChanged(int var1, String var2);

        public void onPollingResultUpdated(String var1);

        public void onPollingActionResult(int var1, String var2, int var3);
    }
}

