/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.meeting.confhelper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjectionManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentManager;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.box.BoxFileListAdapter;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.meeting.confhelper.ShareOptionType;
import com.zipow.videobox.dialog.ShareAlertDialog;
import com.zipow.videobox.dialog.SharePermissionAlertDialog;
import com.zipow.videobox.dropbox.DropboxFileListAdapter;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.googledrive.GoogleDriveFileListAdapter;
import com.zipow.videobox.onedrive.OneDriveBusinessFileListAdapter;
import com.zipow.videobox.onedrive.OneDriveFileListAdapter;
import com.zipow.videobox.onedrive.OneDrivePicker;
import com.zipow.videobox.share.ScreenShareMgr;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ConfShareLocalHelper;
import com.zipow.videobox.util.IPicker;
import com.zipow.videobox.util.IPickerResult;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.view.ShareTip;
import com.zipow.videobox.view.bookmark.BookmarkListViewFragment;
import java.io.File;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFileListActivity;
import us.zoom.androidlib.app.ZMLocalFileListAdapter;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class ShareComponent {
    private static final String TAG = ShareComponent.class.getName();
    private static final String[] FILTER_EXTENS = new String[]{".jpg", ".png", ".gif", ".bmp", ".jpeg", ".pdf"};
    public static final int REQUEST_CHOOSE_PICTURE = 1004;
    public static final int REQUEST_CHOOSE_BOOKMARK = 1005;
    public static final int REQUEST_DOCUMENT = 1010;
    public static final int REQUEST_DOCUMENT_PICKER = 1014;
    public static final int REQUEST_SHARE_SCREEN_PERMISSION = 1013;
    public static final int REQUEST_DOCUMENT_BUSINESS_PICKER = 1099;
    private final ConfActivity mConfActivity;
    private final ShareActionCallBack mShareActionCallBack;
    private IPicker mPicker;
    public boolean mbMarkedAsGrabShare = false;

    public ShareComponent(@NonNull ConfActivity confActivity) {
        this.mConfActivity = confActivity;
        this.mShareActionCallBack = (ShareActionCallBack)((Object)confActivity);
    }

    private boolean isShareRequestCode(int requestCode) {
        return requestCode == 1004 || requestCode == 1005 || requestCode == 1010 || requestCode == 1014 || requestCode == 1013;
    }

    public boolean processShareRequest(int requestCode, int resultCode, Intent data) {
        FragmentManager fragmentManager = this.mConfActivity.getSupportFragmentManager();
        SharePermissionAlertDialog dialog = this.buildShareAlertDialogIfNeed();
        boolean bMarkedAsGrabShare = this.mbMarkedAsGrabShare;
        if (this.isShareRequestCode(requestCode)) {
            this.mbMarkedAsGrabShare = false;
            if (ConfLocalHelper.isInSilentMode()) {
                return true;
            }
            switch (requestCode) {
                case 1004: {
                    Uri uri = null;
                    if (data != null) {
                        uri = data.getData();
                    }
                    if (resultCode != -1 || uri == null) break;
                    String path = ImageUtil.getPathFromUri((Context)this.mConfActivity, uri);
                    if (path == null) {
                        this.alertImageInvalid();
                        return true;
                    }
                    boolean isLocalPath = path.startsWith(File.separator);
                    if (!isLocalPath || ImageUtil.isValidImageFile(path)) {
                        if (dialog != null && !bMarkedAsGrabShare) {
                            dialog.setShareInfo(1, path, isLocalPath);
                            dialog.show(fragmentManager);
                            break;
                        }
                        this.mShareActionCallBack.startShareImage(uri, isLocalPath);
                        break;
                    }
                    if (dialog != null && !bMarkedAsGrabShare) {
                        dialog.setShareInfo(2, path, true);
                        dialog.show(fragmentManager);
                        break;
                    }
                    this.mShareActionCallBack.shareByPathExtension(path);
                    break;
                }
                case 1005: {
                    if (resultCode != -1) break;
                    Bundle bundle = data.getExtras();
                    if (bundle == null) {
                        return true;
                    }
                    String url = bundle.getString("bookmark_url");
                    if (url == null || "".equals(url.trim())) {
                        this.alertUrlInvalid();
                        return true;
                    }
                    if (!url.startsWith("http://") && !url.startsWith("https://")) {
                        url = "http://" + url;
                    }
                    if (dialog != null && !bMarkedAsGrabShare) {
                        dialog.setShareInfo(3, url, true);
                        dialog.show(fragmentManager);
                        break;
                    }
                    this.mShareActionCallBack.startShareWebview(url);
                    break;
                }
                case 1014: 
                case 1099: {
                    if (resultCode == 0) break;
                    if (resultCode != -1) {
                        ShareAlertDialog.showDialog(fragmentManager, this.mConfActivity.getString(R.string.zm_msg_load_file_fail_without_name), false);
                        break;
                    }
                    if (this.mPicker == null) {
                        this.mPicker = OneDrivePicker.createPicker((Context)this.mConfActivity, requestCode, FILTER_EXTENS, requestCode == 1099);
                    }
                    if (data == null) break;
                    IPickerResult result = this.mPicker.getPickerResult(requestCode, resultCode, data);
                    if (result == null) {
                        ShareAlertDialog.showDialog(fragmentManager, this.mConfActivity.getString(R.string.zm_msg_load_file_fail_without_name), false);
                        break;
                    }
                    if (!result.acceptFileType()) {
                        ShareAlertDialog.showDialog(fragmentManager, this.mConfActivity.getString(R.string.zm_alert_unsupported_format), false);
                        break;
                    }
                    Uri link = result.getLink();
                    if (result.isLocal()) {
                        this.mShareActionCallBack.shareByPathExtension(link.getPath());
                        break;
                    }
                    String path = AppUtil.getShareCachePathByExtension(AppUtil.getCachePath(), result.getName());
                    this.mShareActionCallBack.asyncDownloadFile(link, result.getSize(), path);
                    break;
                }
                case 1010: {
                    Bundle extras;
                    if (resultCode == -1) {
                        String path;
                        Bundle extras2;
                        if (data == null || (extras2 = data.getExtras()) == null || StringUtil.isEmptyOrNull((String)(path = extras2.getString("selected_file_path")))) break;
                        if (dialog != null && !bMarkedAsGrabShare) {
                            dialog.setShareInfo(2, path, true);
                            dialog.show(fragmentManager);
                            break;
                        }
                        this.mShareActionCallBack.shareByPathExtension(path);
                        break;
                    }
                    if (resultCode != 0 || data == null || (extras = data.getExtras()) == null) break;
                    String errPromt = extras.getString("failed_promt");
                    if (StringUtil.isEmptyOrNull((String)errPromt)) {
                        errPromt = this.mConfActivity.getString(R.string.zm_alert_auth_token_failed_msg);
                    }
                    ShareAlertDialog.showDialog(fragmentManager, errPromt, false);
                    break;
                }
                case 1013: {
                    if (resultCode != -1) break;
                    if (dialog != null && !bMarkedAsGrabShare) {
                        dialog.setShareInfo(4, data);
                        dialog.show(fragmentManager);
                        break;
                    }
                    this.mShareActionCallBack.startShareScreen(data);
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkShareNetWorkForReady(@NonNull ZMActivity activity, ShareOptionType type) {
        if (!(type != ShareOptionType.SHARE_ONE_DRIVE && type != ShareOptionType.SHARE_ONE_DRIVE_BUSINESS && type != ShareOptionType.SHARE_DROPBOX && type != ShareOptionType.SHARE_BOX && type != ShareOptionType.SHARE_GOOGLE_DRIVE || NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance()))) {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_alert_network_disconnected);
            dialog.show(activity.getSupportFragmentManager(), SimpleMessageDialog.class.getName());
            return false;
        }
        return true;
    }

    public void selectShareType(ShareOptionType type) {
        if (!this.checkShareNetWorkForReady(this.mConfActivity, type)) {
            return;
        }
        FragmentManager fragmentManager = this.mConfActivity.getSupportFragmentManager();
        ShareTip.dismiss(fragmentManager);
        switch (type) {
            case SHARE_IMAGE: {
                AndroidAppUtil.selectImageNoDefault((Activity)this.mConfActivity, (int)R.string.zm_select_a_image, (int)1004);
                break;
            }
            case SHARE_URL: {
                ConfActivityNormal.SelectURLDialog.show(fragmentManager);
                break;
            }
            case SHARE_BOOKMARK: {
                Bundle bundle = new Bundle();
                BookmarkListViewFragment.showAsActivity(this.mConfActivity, bundle, 1005);
                break;
            }
            case SHARE_BOX: {
                ZMFileListActivity.startFileListActivity((Activity)this.mConfActivity, BoxFileListAdapter.class, (int)1010, (String[])FILTER_EXTENS, null, (int)R.string.zm_btn_share, (String)this.mConfActivity.getString(R.string.zm_msg_file_supported_type_prompt));
                break;
            }
            case SHARE_DROPBOX: {
                ZMFileListActivity.startFileListActivity((Activity)this.mConfActivity, DropboxFileListAdapter.class, (int)1010, (String[])FILTER_EXTENS, null, (int)R.string.zm_btn_share, (String)this.mConfActivity.getString(R.string.zm_msg_file_supported_type_prompt));
                break;
            }
            case SHARE_NATIVE_FILE: {
                ZMFileListActivity.startFileListActivity((Activity)this.mConfActivity, ZMLocalFileListAdapter.class, (int)1010, (String[])FILTER_EXTENS, null, (int)R.string.zm_btn_share, (String)this.mConfActivity.getString(R.string.zm_msg_file_supported_type_prompt));
                break;
            }
            case SHARE_ONE_DRIVE: {
                if (OneDrivePicker.hasPicker((Context)this.mConfActivity, false)) {
                    this.mPicker = OneDrivePicker.createPicker((Context)this.mConfActivity, 1014, FILTER_EXTENS, false);
                    this.mPicker.startPicking(this.mConfActivity);
                    break;
                }
                ZMFileListActivity.startFileListActivity((Activity)this.mConfActivity, OneDriveFileListAdapter.class, (int)1010, (String[])FILTER_EXTENS, null, (int)R.string.zm_btn_share, (String)this.mConfActivity.getString(R.string.zm_msg_file_supported_type_prompt));
                break;
            }
            case SHARE_ONE_DRIVE_BUSINESS: {
                if (OneDrivePicker.hasPicker((Context)this.mConfActivity, true)) {
                    this.mPicker = OneDrivePicker.createPicker((Context)this.mConfActivity, 1099, FILTER_EXTENS, true);
                    this.mPicker.startPicking(this.mConfActivity);
                    break;
                }
                ZMFileListActivity.startFileListActivity((Activity)this.mConfActivity, OneDriveBusinessFileListAdapter.class, (int)1010, (String[])FILTER_EXTENS, null, (int)R.string.zm_btn_share, (String)this.mConfActivity.getString(R.string.zm_msg_file_supported_type_prompt));
                break;
            }
            case SHARE_GOOGLE_DRIVE: {
                ZMFileListActivity.startFileListActivity((Activity)this.mConfActivity, GoogleDriveFileListAdapter.class, (int)1010, (String[])FILTER_EXTENS, null, (int)R.string.zm_btn_share, (String)this.mConfActivity.getString(R.string.zm_msg_file_supported_type_prompt));
                break;
            }
            case SHARE_SCREEN: {
                ScreenShareMgr.getInstance().setIsCustomShare(false);
                this.askScreenSharePermission();
                break;
            }
            case SHARE_WHITEBOARD: {
                this.mShareActionCallBack.startShareWhiteboard();
                break;
            }
            case SHARE_CUSTOM_SCREEN: {
                ScreenShareMgr.getInstance().setIsCustomShare(true);
                this.askScreenSharePermission();
            }
        }
    }

    protected void askScreenSharePermission() {
        Intent intent;
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        MediaProjectionManager mgr = (MediaProjectionManager)this.mConfActivity.getSystemService("media_projection");
        if (mgr != null && AndroidAppUtil.hasActivityForIntent((Context)this.mConfActivity, (Intent)(intent = mgr.createScreenCaptureIntent()))) {
            try {
                this.mConfActivity.startActivityForResult(mgr.createScreenCaptureIntent(), 1013);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SharePermissionAlertDialog buildShareAlertDialogIfNeed() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return null;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return null;
        }
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return null;
        }
        int shareSettingType = shareSession.getShareSettingType();
        boolean isAnyoneGrab = shareSettingType == 2;
        boolean isMultShare = shareSettingType == 3;
        SharePermissionAlertDialog dialog = null;
        boolean isShareLocked = ConfMgr.getInstance().isShareLocked();
        boolean isHost = myself.isHost() || myself.isCoHost() || myself.isBOModerator();
        boolean isViewPureAudio = shareSession.isViewingPureComputerAudio();
        if (isHost || !isShareLocked && isAnyoneGrab) {
            if (!(!ConfShareLocalHelper.isOtherScreenSharing() && !ConfShareLocalHelper.isOtherPureAudioSharing() || isHost && isMultShare)) {
                dialog = SharePermissionAlertDialog.createAlertDialog(3, isViewPureAudio);
            }
        } else if (isShareLocked) {
            dialog = SharePermissionAlertDialog.createAlertDialog(1, isViewPureAudio);
        } else if (ConfShareLocalHelper.isOtherScreenSharing() || ConfShareLocalHelper.isOtherPureAudioSharing()) {
            dialog = SharePermissionAlertDialog.createAlertDialog(2, isViewPureAudio);
        }
        return dialog;
    }

    private void alertImageInvalid() {
        String message = this.mConfActivity.getString(R.string.zm_alert_invalid_image);
        ShareAlertDialog.showDialog(this.mConfActivity.getSupportFragmentManager(), message, true);
    }

    private void alertUrlInvalid() {
        String message = this.mConfActivity.getString(R.string.zm_alert_invlid_url);
        ShareAlertDialog.showDialog(this.mConfActivity.getSupportFragmentManager(), message, true);
    }

    public static interface ShareActionCallBack {
        public void startShareImage(Uri var1, boolean var2);

        public void shareByPathExtension(String var1);

        public void asyncDownloadFile(Uri var1, long var2, String var4);

        public void startShareScreen(Intent var1);

        public void startShareWhiteboard();

        public void startShareWebview(String var1);
    }
}

