/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.meeting.confhelper;

import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.TipMessageType;
import com.zipow.videobox.dialog.LiveStreamDialog;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.NormalMessageTip;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class LiveStreamComponent {
    private static final String TAG = LiveStreamComponent.class.getSimpleName();
    private final ConfActivity mConfActivity;
    private final View mPanelLiveStream;
    private final TextView mTxtLiveStreamName;

    public LiveStreamComponent(ConfActivity confActivity, View parentView) {
        this.mConfActivity = confActivity;
        this.mPanelLiveStream = parentView.findViewById(R.id.panelLiveStream);
        this.mTxtLiveStreamName = (TextView)parentView.findViewById(R.id.txtLiveName);
        this.mPanelLiveStream.setVisibility(8);
        this.mPanelLiveStream.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LiveStreamComponent.this.onClickLiveStream();
            }
        });
    }

    public void onHostCohostChanged(ConfActivity confActivity) {
        LiveStreamDialog.refresh(confActivity);
    }

    public boolean onConfStatusChanged2(int cmd, long ret) {
        switch (cmd) {
            case 47: {
                this.sinkLiveStreamStatusChange();
                return true;
            }
            case 48: {
                this.sinkLiveStreamStartTimeOut((int)ret);
                return true;
            }
        }
        return false;
    }

    private void sinkLiveStreamStatusChange() {
        EventTaskManager eventTaskManager = this.mConfActivity.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.pushLater(new EventAction("onLiveStreamStatusChange"){

                public void run(IUIElement ui) {
                    LiveStreamComponent.this.onLiveStreamStatusChange();
                }
            });
        }
    }

    private void sinkLiveStreamStartTimeOut(final int index) {
        EventTaskManager eventTaskManager = this.mConfActivity.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.pushLater(new EventAction("onLiveStreamStartTimeOut"){

                public void run(IUIElement ui) {
                    LiveStreamComponent.this.onLiveStreamStartTimeOut(index);
                }
            });
        }
    }

    public void onLiveStreamStatusChange() {
        if (this.mConfActivity.isInDivveMode()) {
            this.mPanelLiveStream.setVisibility(8);
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (ConfMgr.getInstance().isViewOnlyMeeting()) {
            this.mPanelLiveStream.setVisibility(8);
            return;
        }
        boolean isLiveOn = confStatus.isLiveOn();
        if (isLiveOn) {
            this.mPanelLiveStream.setVisibility(0);
            String name = ConfLocalHelper.getLiveChannelStreamName();
            this.mTxtLiveStreamName.setText((CharSequence)this.mConfActivity.getString(R.string.zm_lbl_live_stream_info, new Object[]{name}));
        } else if (confStatus.isLiveConnecting()) {
            this.mPanelLiveStream.setVisibility(0);
            this.mTxtLiveStreamName.setText((CharSequence)this.mConfActivity.getString(R.string.zm_lbl_live_connecting));
        } else {
            this.mPanelLiveStream.setVisibility(8);
        }
    }

    private void onClickLiveStream() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isLiveOn()) {
            LiveStreamDialog.show(this.mConfActivity);
        }
    }

    private void onLiveStreamStartTimeOut(int index) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        String name = confStatus.getLiveChannelsName(index);
        if (StringUtil.isEmptyOrNull((String)name)) {
            name = "";
        }
        String message = this.mConfActivity.getString(R.string.zm_alert_live_streaming_failed, new Object[]{name});
        NormalMessageTip.show(this.mConfActivity.getSupportFragmentManager(), TipMessageType.TIP_LIVE_STREAM_START_FAIL.name(), null, message, 3000L);
    }
}

