/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.meeting.confhelper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.view.View;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.SSB_MC_DATA_BLOCK_FECC_TALK_RIGHT_INFO;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.meeting.confhelper.CameraComponent;
import com.zipow.videobox.fragment.PListFragment;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.FeccMessageButtonTip;
import com.zipow.videobox.view.NormalMessageTip;
import com.zipow.videobox.view.ZMFeccView;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.NormalVideoScene;
import com.zipow.videobox.view.video.VideoSceneMgr;
import java.util.HashMap;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class FeccComponent
implements ZMFeccView.FeccListener,
ConfUI.IVideoFECCCmdListener {
    private static final String TAG = FeccComponent.class.getSimpleName();
    private final ConfActivity mConfActivity;
    private final ZMFeccView mPanelFecc;
    private final Handler mHandler = new Handler();
    @SuppressLint(value={"UseSparseArrays"})
    private final HashMap<Long, ZMAlertDialog> mMapFeccDialogs = new HashMap();

    public FeccComponent(ConfActivity confActivity) {
        this.mConfActivity = confActivity;
        this.mPanelFecc = (ZMFeccView)confActivity.findViewById(R.id.panelFecc);
        this.mPanelFecc.setListener(this);
        this.mPanelFecc.setVisibility(8);
        ConfUI.getInstance().addVideoFECCCmdListener(this);
    }

    @Override
    public void onVideoFECCCmd(final int command, final SSB_MC_DATA_BLOCK_FECC_TALK_RIGHT_INFO info) {
        if (command == 13) {
            if (UIMgr.isLargeMode((Context)this.mConfActivity)) {
                PListFragment.dismiss(this.mConfActivity.getSupportFragmentManager());
            } else {
                this.mConfActivity.finishActivity(1001);
            }
        }
        if (command == 20) {
            CameraComponent cameraComponent;
            if (this.mConfActivity.isActive() && (cameraComponent = this.mConfActivity.getmCameraComponent()) != null && cameraComponent.switchToNextCamera() && AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.mConfActivity)) {
                AccessibilityUtil.announceNoInterruptForAccessibilityCompat((View)this.mPanelFecc, (int)(cameraComponent.getCameraFace() == 1 ? R.string.zm_accessibility_selected_front_camera_23059 : R.string.zm_accessibility_selected_back_camera_23059));
            }
            return;
        }
        EventTaskManager eventTaskManager = this.mConfActivity.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.push(new EventAction("onVideoFECCCmdImpl"){

                public void run(IUIElement ui) {
                    FeccComponent.this.handleOnVideoFECCCmd(command, info);
                }
            });
        }
    }

    @Override
    public void onFeccClick(int action, int event) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        long userId = this.getControllCameraUserId();
        if (userId == 0L) {
            return;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        int cmd = 15;
        if (action == 1) {
            cmd = 15;
        } else if (action == 2) {
            cmd = 16;
        } else if (action == 3) {
            cmd = 17;
        }
        int motion = 128;
        if (event == 3) {
            motion = 128;
        } else if (event == 4) {
            motion = 192;
        } else if (event == 1) {
            motion = 32;
        } else if (event == 2) {
            motion = 48;
        } else if (event == 5) {
            motion = 12;
        } else if (event == 6) {
            motion = 8;
        }
        videoMgr.handleFECCCmd(cmd, userId, motion);
    }

    @Override
    public void onFeccSwitchCam() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        long userId = this.getControllCameraUserId();
        if (userId == 0L) {
            return;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        videoMgr.handleFECCCmd(20, userId, 0);
    }

    @Override
    public void onFeccClose() {
        this.mPanelFecc.setVisibility(8);
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        long userId = this.getControllCameraUserId();
        if (userId == 0L) {
            return;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        videoMgr.handleFECCCmd(14, userId);
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.mConfActivity.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        sceneMgr.unPinVideo();
    }

    public void removeVideoFECCCmdListener() {
        ConfUI.getInstance().removeVideoFECCCmdListener(this);
    }

    public void onFeccUserApproved(long userId) {
        if (userId == 0L) {
            return;
        }
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.mConfActivity.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        sceneMgr.switchToNormalScene();
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.isSelectedUser(userId)) {
            return;
        }
        sceneMgr.pinVideo(userId);
    }

    public void refreshFeccUI() {
        long userId = this.getControllCameraUserId();
        if (userId == 0L) {
            this.mPanelFecc.setVisibility(8);
            return;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        boolean show = this.shouldShowFeccUI(userId);
        if (show) {
            boolean canControll = this.canControlUserCamera(userId);
            CmmVideoStatus videoStatus = user.getVideoStatusObj();
            boolean userVideoIsSending = false;
            if (videoStatus != null) {
                userVideoIsSending = videoStatus.getIsSending();
            }
            this.mPanelFecc.setVisibility(0);
            this.mPanelFecc.showPieView(canControll && userVideoIsSending);
        } else {
            this.mPanelFecc.setVisibility(8);
        }
    }

    private long getControllCameraUserId() {
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return 0L;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return 0L;
        }
        int count = userList.getUserCount();
        for (int i = 0; i < count; ++i) {
            long userId;
            CmmUser user = userList.getUserAt(i);
            if (user == null || !videoMgr.canControlltheCam(userId = user.getNodeId()) || !videoMgr.isCamInControl(userId)) continue;
            return userId;
        }
        return 0L;
    }

    private boolean shouldShowFeccUI(long userId) {
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.mConfActivity.getVideoSceneMgr();
        if (sceneMgr == null) {
            return false;
        }
        AbsVideoScene activeScene = sceneMgr.getActiveScene();
        if (!(activeScene instanceof NormalVideoScene)) {
            return false;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return false;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return false;
        }
        if (!videoMgr.isManualMode()) {
            return false;
        }
        if (!videoMgr.isSelectedUser(userId)) {
            return false;
        }
        boolean canControll = this.canControlUserCamera(userId);
        boolean canSwitch = this.canSwitchUserCamera(userId);
        return canControll || canSwitch;
    }

    private boolean canControlUserCamera(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return false;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return false;
        }
        CmmVideoStatus videoStatus = user.getVideoStatusObj();
        int camFcc = videoStatus.getCamFecc();
        boolean canControl = videoMgr.canControlltheCam(userId);
        return camFcc > 0 && canControl;
    }

    private boolean canSwitchUserCamera(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return false;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        return user != null && user.supportSwitchCam() && videoMgr.canControlltheCam(userId);
    }

    private void onFeccRequest(final long userId) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.isKubiEnabled()) {
            this.approveCameraControl(true, userId);
            return;
        }
        if (this.mMapFeccDialogs.containsKey(userId)) {
            return;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        String message = this.mConfActivity.getString(R.string.zm_fecc_msg_request, new Object[]{user.getScreenName()});
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)this.mConfActivity).setTitle(message).setPositiveButton(R.string.zm_fecc_btn_approve, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                FeccComponent.this.approveCameraControl(true, userId);
            }
        }).setNegativeButton(R.string.zm_fecc_btn_decline, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                FeccComponent.this.approveCameraControl(false, userId);
            }
        }).create();
        dlg.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                FeccComponent.this.mMapFeccDialogs.remove(userId);
            }
        });
        dlg.setCancelable(false);
        this.mMapFeccDialogs.put(userId, dlg);
        dlg.show();
    }

    private void onFeccApprove(CmmUser user, long userId) {
        if (ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() <= 2) {
            VideoSceneMgr sceneMgr = (VideoSceneMgr)this.mConfActivity.getVideoSceneMgr();
            if (sceneMgr == null) {
                return;
            }
            sceneMgr.pinVideo(userId);
        } else if (this.canControlUserCamera(userId) || this.canSwitchUserCamera(userId)) {
            String message = this.mConfActivity.getString(R.string.zm_fecc_msg_approve, new Object[]{user.getScreenName()});
            String button = this.mConfActivity.getString(R.string.zm_fecc_msg_start_control);
            FeccMessageButtonTip.show(this.mConfActivity.getSupportFragmentManager(), "fecc_approve", userId, message, button, 5000L);
        }
        this.refreshFeccUI();
    }

    private void onFeccDecline(CmmUser user) {
        String message = this.mConfActivity.getString(R.string.zm_fecc_msg_decline, new Object[]{user.getScreenName()});
        NormalMessageTip.show(this.mConfActivity.getSupportFragmentManager(), "fecc_decline", null, message, 3000L);
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.mConfActivity.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        sceneMgr.unPinVideo();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                FeccComponent.this.refreshFeccUI();
            }
        });
    }

    private void handleOnVideoFECCCmd(int command, SSB_MC_DATA_BLOCK_FECC_TALK_RIGHT_INFO info) {
        if (command == 13 || command == 12) {
            PListFragment.dismiss(this.mConfActivity.getSupportFragmentManager());
        }
        if (info == null) {
            return;
        }
        long userId = info.executive;
        if (command == 11) {
            this.onFeccRequest(userId);
        } else {
            CmmUser user = ConfMgr.getInstance().getUserById(userId);
            if (user == null) {
                return;
            }
            if (command == 14) {
                String message = this.mConfActivity.getString(R.string.zm_fecc_msg_giveup, new Object[]{user.getScreenName()});
                NormalMessageTip.show(this.mConfActivity.getSupportFragmentManager(), "fecc_giveup", null, message, 3000L);
            } else if (command == 13) {
                this.onFeccApprove(user, userId);
            } else if (command == 12) {
                this.onFeccDecline(user);
            }
        }
    }

    private void approveCameraControl(boolean bApprove, long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.handleFECCCmd(bApprove ? 13 : 12, userId);
    }
}

