/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.meeting.confhelper;

import android.content.Context;
import android.hardware.Camera;
import android.support.annotation.NonNull;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.Toast;
import com.zipow.nydus.NydusUtil;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.meeting.ConfParams;
import com.zipow.videobox.share.ScreenShareMgr;
import com.zipow.videobox.util.DialogUtils;
import com.zipow.videobox.view.VideoTip;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ViewPressEffectHelper;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.videomeetings.R;

public class CameraComponent {
    private static final String TAG = CameraComponent.class.getName();
    private final ConfActivity mConfActivity;
    private final View mBtnSwitchCamera;
    private int mMyVideoRotation = 0;

    public CameraComponent(@NonNull ConfActivity confActivity) {
        this.mConfActivity = confActivity;
        this.mBtnSwitchCamera = confActivity.findViewById(R.id.btnSwitchCamera);
        if (this.mBtnSwitchCamera != null) {
            this.mBtnSwitchCamera.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CameraComponent.this.onClickSwitchCamera();
                }
            });
            ViewPressEffectHelper.attach((View)this.mBtnSwitchCamera);
            this.mBtnSwitchCamera.setContentDescription((CharSequence)this.mConfActivity.getString(this.getCameraFace() == 1 ? R.string.zm_accessibility_current_front_camera_23059 : R.string.zm_accessibility_current_back_camera_23059));
        }
    }

    public void onResume() {
        this.mMyVideoRotation = this.getCurrentMyVideoRotation();
        this.rotateMyVideo(this.mMyVideoRotation);
    }

    public static int getNumberOfCameras() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return 0;
        }
        return videoMgr.getNumberOfCameras();
    }

    public void switchCamera(String cameraId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        this.mConfActivity.setIsVideoOnBeforeShare(false);
        AbsVideoSceneMgr videoSceneMgr = this.mConfActivity.getVideoSceneMgr();
        if (videoSceneMgr != null) {
            videoSceneMgr.beforeSwitchCamera();
        }
        if (!ConfMgr.getInstance().canUnmuteMyVideo()) {
            this.alertCameraDisabledByHost();
        } else if (!videoMgr.switchCamera(cameraId) && !videoMgr.isVideoStarted()) {
            this.mConfActivity.alertStartCameraFailed();
        }
        if (videoSceneMgr != null) {
            videoSceneMgr.afterSwitchCamera();
        }
        this.mMyVideoRotation = this.getCurrentMyVideoRotation();
        this.rotateMyVideo(this.mMyVideoRotation);
    }

    public boolean switchToNextCamera() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null && videoMgr.getNumberOfCameras() > 1) {
            this.mConfActivity.setIsVideoOnBeforeShare(false);
            AbsVideoSceneMgr videoSceneMgr = this.mConfActivity.getVideoSceneMgr();
            if (videoSceneMgr != null) {
                videoSceneMgr.beforeSwitchCamera();
            }
            if (!videoMgr.switchToNextCam() && !videoMgr.isVideoStarted()) {
                this.alertStartCameraFailedUsingToast();
            }
            if (videoSceneMgr != null) {
                videoSceneMgr.afterSwitchCamera();
            }
            this.mMyVideoRotation = this.getCurrentMyVideoRotation();
            return this.rotateMyVideo(this.mMyVideoRotation);
        }
        return false;
    }

    public void checkRotation() {
        int rotation = this.getCurrentMyVideoRotation();
        if (this.mMyVideoRotation == rotation) {
            return;
        }
        this.mMyVideoRotation = rotation;
        this.rotateMyVideo(rotation);
        if (ScreenShareMgr.getInstance().isSharing()) {
            ScreenShareMgr.getInstance().onOrientationChanged();
        }
    }

    public boolean canSwitchCamera() {
        return this.mConfActivity.isSendingVideo() && CameraComponent.getNumberOfCameras() >= 2 && ConfMgr.getInstance().isConfConnected() && !ConfMgr.getInstance().isCallingOut();
    }

    private String getCameraId() {
        String cameraId = null;
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null) {
            if (videoMgr.isVideoStarted() || videoMgr.isPreviewing()) {
                cameraId = videoMgr.getDefaultDevice();
            }
            if (StringUtil.isEmptyOrNull((String)cameraId)) {
                cameraId = videoMgr.getDefaultCameraToUse();
            }
        } else {
            int iFrontCamId = NydusUtil.getFrontCameraId();
            if (iFrontCamId >= 0) {
                cameraId = String.valueOf(iFrontCamId);
            }
        }
        return cameraId;
    }

    private int getCurrentMyVideoRotation() {
        String cameraId = this.getCameraId();
        if (StringUtil.isEmptyOrNull((String)cameraId)) {
            return 0;
        }
        Display display = ((WindowManager)this.mConfActivity.getSystemService("window")).getDefaultDisplay();
        int displayRotation = display.getRotation();
        int orientation = 0;
        switch (displayRotation) {
            case 0: {
                orientation = 0;
                break;
            }
            case 1: {
                orientation = 270;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 90;
                break;
            }
        }
        return this.getRotation(cameraId, orientation);
    }

    private int getRotation(String sCameraId, int orientation) {
        if (sCameraId == null) {
            return 0;
        }
        int cameraId = -1;
        try {
            cameraId = Integer.parseInt(sCameraId);
        }
        catch (NumberFormatException e) {
            ZMLog.e((String)TAG, (Throwable)e, (String)"getRotation NumberFormatException", (Object[])new Object[0]);
        }
        if (cameraId < 0) {
            return 0;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        NydusUtil.getCameraInfo(cameraId, info);
        int cameraOrientatin = NydusUtil.getRealCameraOrientation(cameraId);
        orientation = (orientation + 45) / 90 * 90;
        int rotation = 0;
        rotation = !NydusUtil.isCameraMirror(cameraId) ? (info.facing == 1 ? (cameraOrientatin - orientation + 360) % 360 : (cameraOrientatin + orientation) % 360) : (info.facing == 0 ? (cameraOrientatin - orientation + 360) % 360 : (cameraOrientatin + orientation) % 360);
        return rotation;
    }

    public int getCameraFace() {
        int face = 1;
        String cameraStrId = this.getCameraId();
        if (StringUtil.isEmptyOrNull((String)cameraStrId)) {
            return 0;
        }
        int cameraId = -1;
        try {
            cameraId = Integer.parseInt(cameraStrId);
        }
        catch (NumberFormatException e) {
            ZMLog.e((String)TAG, (Throwable)e, (String)"getRotation NumberFormatException", (Object[])new Object[0]);
        }
        if (cameraId < 0) {
            return face;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        NydusUtil.getCameraInfo(cameraId, info);
        return info.facing;
    }

    private boolean rotateMyVideo(int rotation) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null) {
            int action = 0;
            switch (rotation) {
                case 0: {
                    action = 0;
                    break;
                }
                case 90: {
                    action = 1;
                    break;
                }
                case 180: {
                    action = 2;
                    break;
                }
                case 270: {
                    action = 3;
                    break;
                }
            }
            boolean success = videoMgr.rotateDevice(action, 0L);
            AbsVideoSceneMgr videoSceneMgr = this.mConfActivity.getVideoSceneMgr();
            if (videoSceneMgr != null) {
                videoSceneMgr.onMyVideoRotationChanged(action);
            }
            return success;
        }
        return false;
    }

    public void onClickSwitchCamera() {
        if (this.mConfActivity == null) {
            return;
        }
        int num = CameraComponent.getNumberOfCameras();
        if (num == 2) {
            if (this.switchToNextCamera() && AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.mConfActivity)) {
                int cameraFace = this.getCameraFace();
                if (cameraFace == 1) {
                    if (!AccessibilityUtil.getIsAccessibilityFocused((View)this.mBtnSwitchCamera)) {
                        AccessibilityUtil.announceForAccessibilityCompat((View)this.mBtnSwitchCamera, (int)R.string.zm_accessibility_selected_front_camera_23059);
                    }
                    this.mBtnSwitchCamera.setContentDescription((CharSequence)this.mConfActivity.getString(R.string.zm_accessibility_current_front_camera_23059));
                } else {
                    if (!AccessibilityUtil.getIsAccessibilityFocused((View)this.mBtnSwitchCamera)) {
                        AccessibilityUtil.announceForAccessibilityCompat((View)this.mBtnSwitchCamera, (int)R.string.zm_accessibility_selected_back_camera_23059);
                    }
                    this.mBtnSwitchCamera.setContentDescription((CharSequence)this.mConfActivity.getString(R.string.zm_accessibility_current_back_camera_23059));
                }
            }
            this.mConfActivity.hideToolbarDefaultDelayed();
        } else if (num > 2) {
            VideoTip.show(this.mConfActivity.getSupportFragmentManager(), R.id.btnSwitchCamera, 1, false);
        }
    }

    public void updateSwitchCameraButton() {
        boolean enable;
        if (this.mConfActivity == null) {
            return;
        }
        ConfParams confParams = this.mConfActivity.getConfParams();
        boolean bl = enable = this.canSwitchCamera() && !confParams.isSwitchCameraButtonDisabled();
        if (this.mBtnSwitchCamera != null) {
            this.mBtnSwitchCamera.setVisibility(enable ? 0 : 8);
            if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.mConfActivity)) {
                this.mBtnSwitchCamera.setContentDescription((CharSequence)this.mConfActivity.getString(this.getCameraFace() == 1 ? R.string.zm_accessibility_current_front_camera_23059 : R.string.zm_accessibility_current_back_camera_23059));
            }
        }
    }

    private void alertStartCameraFailedUsingToast() {
        Toast.makeText((Context)this.mConfActivity.getApplicationContext(), (int)R.string.zm_alert_start_camera_failed_title, (int)1).show();
    }

    public void alertCameraDisabledByHost() {
        this.mConfActivity.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                DialogUtils.showAlertDialog((ZMActivity)CameraComponent.this.mConfActivity, R.string.zm_msg_video_cannot_start_video_for_host_has_stopped_it, R.string.zm_btn_ok);
            }
        });
    }
}

