/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.meeting;

import android.net.Uri;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import us.zoom.androidlib.util.ParamsList;
import us.zoom.androidlib.util.StringUtil;

public class ConfParams {
    public static final String CONF_PARAM_CLOSE_ON_LEAVE_MEETING = "close_on_leave_meeting";
    public static final String CONF_PARAM_NO_DRIVING_MODE = "no_driving_mode";
    public static final String CONF_PARAM_NO_INVITE = "no_invite";
    public static final String CONF_PARAM_NO_MEETING_END_MESSAGE = "no_meeting_end_message";
    public static final String CONF_PARAM_NO_MEETING_ERROR_MESSAGE = "no_meeting_error_message";
    public static final String CONF_PARAM_NO_TITLEBAR = "no_titlebar";
    public static final String CONF_PARAM_NO_BOTTOM_TOOLBAR = "no_bottom_toolbar";
    public static final String CONF_PARAM_NO_DIAL_IN = "no_dial_in_via_phone";
    public static final String CONF_PARAM_NO_DIAL_OUT = "no_dial_out_to_phone";
    public static final String CONF_PARAM_NO_DISCONNECT_AUDIO = "no_disconnect_audio";
    public static final String CONF_PARAM_NO_SHARE = "no_share";
    public static final String CONF_PARAM_MEETING_VIEWS_OPTIONS = "meeting_views_options";
    public static final String CONF_PARAM_INVITE_OPTIONS = "invite_options";
    public static final String CONF_PARAM_CUSTOM_MEETING_ID = "custom_meeting_id";
    public static final String CONF_PARAM_SHOW_WATER_MARK = "show_water_mark";
    private static final String TAG = ConfParams.class.getName();
    private boolean mbCloseOnLeaveMeeting = false;
    private boolean mbNoDrivingMode = false;
    private boolean mbNoInvite = false;
    private boolean mbNoMeetingEndMsg = false;
    private boolean mbNoTitlebar = false;
    private boolean mbNoBottomToolbar = false;
    private boolean mbNoDialIn = false;
    private boolean mbNoDialOut = false;
    private boolean mbNoDisconnectAudio = false;
    private boolean mbNoShare = false;
    private boolean mbNoMeetingErrorMsg = false;
    private int mMeetingViewsOptions = 0;
    private int mInviteOptions = 255;
    private String mCustomMeetingId = null;
    private boolean mbShowSdkWaterMark = false;

    public void parseFromParamsList(ParamsList params) {
        this.mbCloseOnLeaveMeeting = params.getBoolean(CONF_PARAM_CLOSE_ON_LEAVE_MEETING, this.mbCloseOnLeaveMeeting);
        this.mbNoDrivingMode = params.getBoolean(CONF_PARAM_NO_DRIVING_MODE, this.mbNoDrivingMode);
        this.mbNoInvite = params.getBoolean(CONF_PARAM_NO_INVITE, this.mbNoInvite);
        this.mbNoMeetingEndMsg = params.getBoolean(CONF_PARAM_NO_MEETING_END_MESSAGE, this.mbNoMeetingEndMsg);
        this.mbNoTitlebar = params.getBoolean(CONF_PARAM_NO_TITLEBAR, this.mbNoTitlebar);
        this.mbNoBottomToolbar = params.getBoolean(CONF_PARAM_NO_BOTTOM_TOOLBAR, this.mbNoBottomToolbar);
        this.mbNoDialIn = params.getBoolean(CONF_PARAM_NO_DIAL_IN, this.mbNoDialIn);
        this.mbNoDialOut = params.getBoolean(CONF_PARAM_NO_DIAL_OUT, this.mbNoDialOut);
        this.mbNoDisconnectAudio = params.getBoolean(CONF_PARAM_NO_DISCONNECT_AUDIO, this.mbNoDisconnectAudio);
        this.mbNoShare = params.getBoolean(CONF_PARAM_NO_SHARE, this.mbNoShare);
        this.mbNoMeetingErrorMsg = params.getBoolean(CONF_PARAM_NO_MEETING_ERROR_MESSAGE, this.mbNoMeetingErrorMsg);
        this.mMeetingViewsOptions = params.getInt(CONF_PARAM_MEETING_VIEWS_OPTIONS, this.mMeetingViewsOptions);
        this.mInviteOptions = params.getInt(CONF_PARAM_INVITE_OPTIONS, this.mInviteOptions);
        this.mCustomMeetingId = params.getString(CONF_PARAM_CUSTOM_MEETING_ID, this.mCustomMeetingId);
        this.mbShowSdkWaterMark = params.getBoolean(CONF_PARAM_SHOW_WATER_MARK, this.mbShowSdkWaterMark);
    }

    public void parseFromUri(Uri uri) {
        String vNoDrivingMode = uri.getQueryParameter(CONF_PARAM_NO_DRIVING_MODE);
        String vCloseOnLeaveMeeting = uri.getQueryParameter(CONF_PARAM_CLOSE_ON_LEAVE_MEETING);
        String vNoInvite = uri.getQueryParameter(CONF_PARAM_NO_INVITE);
        String vNoMeetingEndMsg = uri.getQueryParameter(CONF_PARAM_NO_MEETING_END_MESSAGE);
        String vNoTitlebar = uri.getQueryParameter(CONF_PARAM_NO_TITLEBAR);
        String vNoBottomToolbar = uri.getQueryParameter(CONF_PARAM_NO_BOTTOM_TOOLBAR);
        String vNoDialIn = uri.getQueryParameter(CONF_PARAM_NO_DIAL_IN);
        String vNoDialOut = uri.getQueryParameter(CONF_PARAM_NO_DIAL_OUT);
        String vNoDisconnectAudio = uri.getQueryParameter(CONF_PARAM_NO_DISCONNECT_AUDIO);
        String vNoShare = uri.getQueryParameter(CONF_PARAM_NO_SHARE);
        String vMeetingViewsOptions = uri.getQueryParameter(CONF_PARAM_MEETING_VIEWS_OPTIONS);
        String vInviteOptions = uri.getQueryParameter(CONF_PARAM_INVITE_OPTIONS);
        String vNoMeetingErrorMsg = uri.getQueryParameter(CONF_PARAM_NO_MEETING_ERROR_MESSAGE);
        String vCustomMeetingId = uri.getQueryParameter(CONF_PARAM_CUSTOM_MEETING_ID);
        String vShowSdkWaterMark = uri.getQueryParameter(CONF_PARAM_SHOW_WATER_MARK);
        this.mbNoDrivingMode = "1".equals(vNoDrivingMode);
        this.mbCloseOnLeaveMeeting = "1".equals(vCloseOnLeaveMeeting);
        this.mbNoInvite = "1".equals(vNoInvite);
        this.mbNoMeetingEndMsg = "1".equals(vNoMeetingEndMsg);
        this.mbNoTitlebar = "1".equals(vNoTitlebar);
        this.mbNoBottomToolbar = "1".equals(vNoBottomToolbar);
        this.mbNoDialIn = "1".equals(vNoDialIn);
        this.mbNoDialOut = "1".equals(vNoDialOut);
        this.mbNoDisconnectAudio = "1".equals(vNoDisconnectAudio);
        this.mbNoShare = "1".equals(vNoShare);
        this.mbNoMeetingErrorMsg = "1".equals(vNoMeetingErrorMsg);
        this.mbShowSdkWaterMark = "1".equals(vShowSdkWaterMark);
        if (!StringUtil.isEmptyOrNull((String)vCustomMeetingId)) {
            try {
                this.mCustomMeetingId = URLDecoder.decode(vCustomMeetingId, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (!StringUtil.isEmptyOrNull((String)vMeetingViewsOptions)) {
            try {
                this.mMeetingViewsOptions = Integer.parseInt(vMeetingViewsOptions);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!StringUtil.isEmptyOrNull((String)vInviteOptions)) {
            try {
                this.mInviteOptions = Integer.parseInt(vInviteOptions);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void saveParamList(ParamsList params) {
        params.putBoolean(CONF_PARAM_NO_DRIVING_MODE, this.mbNoDrivingMode);
        params.putBoolean(CONF_PARAM_CLOSE_ON_LEAVE_MEETING, this.mbCloseOnLeaveMeeting);
        params.putBoolean(CONF_PARAM_NO_INVITE, this.mbNoInvite);
        params.putBoolean(CONF_PARAM_NO_MEETING_END_MESSAGE, this.mbNoMeetingEndMsg);
        params.putBoolean(CONF_PARAM_NO_TITLEBAR, this.mbNoTitlebar);
        params.putBoolean(CONF_PARAM_NO_BOTTOM_TOOLBAR, this.mbNoBottomToolbar);
        params.putBoolean(CONF_PARAM_NO_DIAL_IN, this.mbNoDialIn);
        params.putBoolean(CONF_PARAM_NO_DIAL_OUT, this.mbNoDialOut);
        params.putBoolean(CONF_PARAM_NO_DISCONNECT_AUDIO, this.mbNoDisconnectAudio);
        params.putBoolean(CONF_PARAM_NO_SHARE, this.mbNoShare);
        params.putBoolean(CONF_PARAM_NO_MEETING_ERROR_MESSAGE, this.mbNoMeetingErrorMsg);
        params.putInt(CONF_PARAM_MEETING_VIEWS_OPTIONS, this.mMeetingViewsOptions);
        params.putInt(CONF_PARAM_INVITE_OPTIONS, this.mInviteOptions);
        params.putString(CONF_PARAM_CUSTOM_MEETING_ID, this.mCustomMeetingId);
        params.putBoolean(CONF_PARAM_SHOW_WATER_MARK, this.mbShowSdkWaterMark);
    }

    public boolean isMbCloseOnLeaveMeeting() {
        return this.mbCloseOnLeaveMeeting;
    }

    public boolean isMbNoDrivingMode() {
        return this.mbNoDrivingMode;
    }

    public boolean isMbNoInvite() {
        return this.mbNoInvite;
    }

    public boolean isMbNoMeetingEndMsg() {
        return this.mbNoMeetingEndMsg;
    }

    public boolean isMbNoTitlebar() {
        return this.mbNoTitlebar;
    }

    public boolean isMbNoBottomToolbar() {
        return this.mbNoBottomToolbar;
    }

    public boolean isMbNoDialIn() {
        return this.mbNoDialIn;
    }

    public boolean isMbNoDialOut() {
        return this.mbNoDialOut;
    }

    public boolean isMbNoDisconnectAudio() {
        return this.mbNoDisconnectAudio;
    }

    public boolean isMbNoShare() {
        return this.mbNoShare;
    }

    public boolean isMbNoMeetingErrorMsg() {
        return this.mbNoMeetingErrorMsg;
    }

    public int getmMeetingViewsOptions() {
        return this.mMeetingViewsOptions;
    }

    public int getmInviteOptions() {
        return this.mInviteOptions;
    }

    public String getmCustomMeetingId() {
        return this.mCustomMeetingId;
    }

    public boolean isMbShowSdkWaterMark() {
        return this.mbShowSdkWaterMark;
    }

    public int getInviteOptions() {
        return this.mInviteOptions;
    }

    public String getCustomMeetingId() {
        return this.mCustomMeetingId;
    }

    public void setCustomMeetingId(String meetingId) {
        this.mCustomMeetingId = meetingId;
    }

    public boolean isDriverModeDisabled() {
        return this.mbNoDrivingMode;
    }

    public boolean isInviteDisabled() {
        return this.mbNoInvite;
    }

    public boolean isTitleBarDisabled() {
        return this.mbNoTitlebar;
    }

    public boolean isBottomBarDisabled() {
        return this.mbNoBottomToolbar;
    }

    public boolean isDialInDisabled() {
        return this.mbNoDialIn;
    }

    public boolean isDialOutDisabled() {
        return this.mbNoDialOut;
    }

    public boolean isDisconnectAudioDisabled() {
        return this.mbNoDisconnectAudio;
    }

    public boolean isShowSdkWaterMark() {
        return this.mbShowSdkWaterMark;
    }

    public boolean isShareButtonDisabled() {
        return (this.mMeetingViewsOptions & 4) != 0 || this.mbNoShare;
    }

    public boolean isAudioButtonDisabled() {
        return (this.mMeetingViewsOptions & 2) != 0;
    }

    public boolean isVideoButtonDisabled() {
        return (this.mMeetingViewsOptions & 1) != 0;
    }

    public boolean isPlistButtonDisabled() {
        return (this.mMeetingViewsOptions & 8) != 0;
    }

    public boolean isMoreButtonDisabled() {
        return (this.mMeetingViewsOptions & 0x10) != 0;
    }

    public boolean isLeaveButtonDisabled() {
        return (this.mMeetingViewsOptions & 0x80) != 0;
    }

    public boolean isMeetingIdTextDisabled() {
        return (this.mMeetingViewsOptions & 0x20) != 0;
    }

    public boolean isPasswordTextDisabled() {
        return (this.mMeetingViewsOptions & 0x40) != 0;
    }

    public boolean isSwitchCameraButtonDisabled() {
        return (this.mMeetingViewsOptions & 0x100) != 0;
    }

    public boolean isSwitchAudioSourceButtonDisabled() {
        return (this.mMeetingViewsOptions & 0x200) != 0;
    }
}

