/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.meeting;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.zipow.videobox.ptapp.AvailableDialinCountry;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class AudioOptionParcelItem
implements Parcelable {
    private int mSelectedAudioType = 2;
    private boolean isIncludeTollFree;
    private ArrayList<String> mSelectedDialInCountries;
    private ArrayList<String> mAllDialInCountries;
    private String hash;
    public static final Parcelable.Creator<AudioOptionParcelItem> CREATOR = new Parcelable.Creator<AudioOptionParcelItem>(){

        public AudioOptionParcelItem createFromParcel(Parcel source) {
            return new AudioOptionParcelItem(source);
        }

        public AudioOptionParcelItem[] newArray(int size) {
            return new AudioOptionParcelItem[size];
        }
    };

    public boolean isCanEditCountry() {
        return this.mSelectedAudioType == 2 || this.mSelectedAudioType == 1;
    }

    public void setHash(String hash) {
        this.hash = StringUtil.safeString((String)hash);
    }

    public int getmSelectedAudioType() {
        return this.mSelectedAudioType;
    }

    public void setmSelectedAudioType(int mSelectedAudioType) {
        this.mSelectedAudioType = mSelectedAudioType;
    }

    public boolean isIncludeTollFree() {
        return this.isIncludeTollFree;
    }

    public void setIncludeTollFree(boolean includeTollFree) {
        this.isIncludeTollFree = includeTollFree;
    }

    public String getmSelectedDialInCountryDesc(Context context) {
        if (context == null || this.mSelectedDialInCountries == null || this.mSelectedDialInCountries.isEmpty()) {
            return null;
        }
        int size = this.mSelectedDialInCountries.size();
        if (size == 1) {
            return this.mSelectedDialInCountries.get(0);
        }
        if (size == 2) {
            return context.getString(R.string.zm_desc_two_countries_19247, new Object[]{this.mSelectedDialInCountries.get(0), this.mSelectedDialInCountries.get(1)});
        }
        return context.getString(R.string.zm_desc_more_than_three_countries_19247, new Object[]{this.mSelectedDialInCountries.get(0), size - 1});
    }

    public ArrayList<String> getmShowSelectedDialInCountries() {
        return this.isCanEditCountry() ? this.mSelectedDialInCountries : null;
    }

    public void setmSelectedDialInCountries(ArrayList<String> mSelectedDialInCountries) {
        this.mSelectedDialInCountries = mSelectedDialInCountries;
    }

    public List<String> getmAllDialInCountries() {
        return this.mAllDialInCountries;
    }

    public void setmAllDialInCountries(ArrayList<String> mAllDialInCountries) {
        this.mAllDialInCountries = mAllDialInCountries;
    }

    public AudioOptionParcelItem() {
    }

    public AvailableDialinCountry getAvailableDialinCountry() {
        if (this.mAllDialInCountries == null) {
            this.mAllDialInCountries = new ArrayList();
        }
        if (this.mSelectedDialInCountries == null) {
            this.mSelectedDialInCountries = new ArrayList();
        }
        return new AvailableDialinCountry(StringUtil.safeString((String)this.hash), this.isIncludeTollFree, this.mSelectedDialInCountries, this.mAllDialInCountries);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSelectedAudioType);
        dest.writeByte(this.isIncludeTollFree ? (byte)1 : 0);
        dest.writeStringList(this.mSelectedDialInCountries);
        dest.writeStringList(this.mAllDialInCountries);
        dest.writeString(this.hash);
    }

    protected AudioOptionParcelItem(Parcel in) {
        this.mSelectedAudioType = in.readInt();
        this.isIncludeTollFree = in.readByte() != 0;
        this.mSelectedDialInCountries = in.createStringArrayList();
        this.mAllDialInCountries = in.createStringArrayList();
        this.hash = in.readString();
    }
}

