/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.bo;

import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.bo.BOObject;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class BOMgr {
    private long mNativeHandle;
    public static final int BO_GET_FLAG_ASSIGN = 1;
    public static final int BO_GET_FLAG_JOINED = 2;
    public static final int BO_GET_FLAG_ANY = 3;

    public BOMgr(long handle) {
        this.mNativeHandle = handle;
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    public BOObject getMyBOObject(int flag) {
        long handler = 0L;
        if (flag == 1) {
            handler = this.getMyBOAssignedObjectHandlerImpl(this.mNativeHandle);
        } else if (flag == 2) {
            handler = this.getMyBOJoinedObjectHandlerImpl(this.mNativeHandle);
        } else if (flag == 3) {
            handler = this.getMyBOObjectHandler();
        }
        if (handler == 0L) {
            return null;
        }
        BOObject object = new BOObject(handler);
        return object;
    }

    public int getBOObjectCount() {
        if (!this.initialized()) {
            return 0;
        }
        return this.getBOObjectCountImpl(this.mNativeHandle);
    }

    public BOObject getBOObjectByIndex(int index) {
        if (!this.initialized() || index < 0) {
            return null;
        }
        long handler = this.getBOObjectHandleByIndexImpl(this.mNativeHandle, index);
        if (handler == 0L) {
            return null;
        }
        return new BOObject(handler);
    }

    public BOObject getBOObjectByBId(String bid) {
        if (!this.initialized() || StringUtil.isEmptyOrNull((String)bid)) {
            return null;
        }
        long handler = this.getBOObjectHandleByBIdImpl(this.mNativeHandle, bid);
        if (handler == 0L) {
            return null;
        }
        return new BOObject(handler);
    }

    private long getMyBOObjectHandler() {
        if (!this.initialized()) {
            return 0L;
        }
        return this.getMyBOObjectHandlerImpl(this.mNativeHandle);
    }

    private long getMyBOUserHandler() {
        if (!this.initialized()) {
            return 0L;
        }
        return this.getMyBOUserHandlerImpl(this.mNativeHandle);
    }

    public boolean isInBOMeeting() {
        if (!this.initialized()) {
            return false;
        }
        return this.isInBOMeetingImpl(this.mNativeHandle);
    }

    public int getControlStatus() {
        if (!this.initialized()) {
            return 1;
        }
        return this.getControlStatusImpl(this.mNativeHandle);
    }

    public boolean isBOController() {
        if (!this.initialized()) {
            return false;
        }
        return this.isBOControllerImpl(this.mNativeHandle);
    }

    public boolean isBOModerator() {
        if (!this.initialized()) {
            return false;
        }
        return this.isBOModeratorImpl(this.mNativeHandle);
    }

    public CmmUserList getMasterConfUserList() {
        if (!this.initialized()) {
            return null;
        }
        long userListHandle = this.getMasterConfUserListImpl(this.mNativeHandle);
        if (userListHandle == 0L) {
            return null;
        }
        CmmUserList userList = new CmmUserList(userListHandle);
        return userList;
    }

    public int getLasterError() {
        if (!this.initialized()) {
            return 0;
        }
        return this.getLasterErrorImpl(this.mNativeHandle);
    }

    public long createBO(String name, List<String> userGUIDs) {
        if (!this.initialized()) {
            return 0L;
        }
        return this.createBOImpl(this.mNativeHandle, name, userGUIDs);
    }

    public boolean updateBOImpl(String bid, String name, List<String> userGUIDs) {
        if (!this.initialized()) {
            return false;
        }
        return this.updateBOImpl(this.mNativeHandle, bid, name, userGUIDs);
    }

    public boolean removeBO(String bid) {
        if (!this.initialized() || StringUtil.isEmptyOrNull((String)bid)) {
            return false;
        }
        return this.removeBOImpl(this.mNativeHandle, bid);
    }

    public boolean isBOTokenReady() {
        if (!this.initialized()) {
            return false;
        }
        return this.isBOTokenReadyImpl(this.mNativeHandle);
    }

    public boolean start() {
        if (!this.initialized()) {
            return false;
        }
        return this.startImpl(this.mNativeHandle);
    }

    public boolean stop(int waitSeconds) {
        if (!this.initialized()) {
            return false;
        }
        if (waitSeconds < 0) {
            waitSeconds = 0;
        }
        return this.stopImpl(this.mNativeHandle, waitSeconds);
    }

    public boolean clear(int waitSeconds) {
        if (!this.initialized()) {
            return false;
        }
        if (waitSeconds < 0) {
            waitSeconds = 0;
        }
        return this.clearImpl(this.mNativeHandle, waitSeconds);
    }

    public boolean notifyHelpRequestHandled(String userGUID, int result) {
        if (!this.initialized()) {
            return false;
        }
        return this.notifyHelpRequestHandledImpl(this.mNativeHandle, userGUID, result);
    }

    public int generateNewNameIndex() {
        if (!this.initialized()) {
            return 0;
        }
        return this.generateNewNameIndexImpl(this.mNativeHandle);
    }

    public void resetNewNameIndex() {
        if (!this.initialized()) {
            return;
        }
        this.resetNewNameIndexImpl(this.mNativeHandle);
    }

    public boolean joinBO(String bid, int reason) {
        if (!this.initialized() || StringUtil.isEmptyOrNull((String)bid)) {
            return false;
        }
        return this.joinBOImpl(this.mNativeHandle, bid, reason);
    }

    public boolean leaveBO() {
        if (!this.initialized()) {
            return false;
        }
        return this.leaveBOImpl(this.mNativeHandle);
    }

    public boolean requestForHelp() {
        if (!this.initialized()) {
            return false;
        }
        return this.requestForHelpImpl(this.mNativeHandle);
    }

    private native int getBOObjectCountImpl(long var1);

    private native long getBOObjectHandleByIndexImpl(long var1, int var3);

    private native long getBOObjectHandleByBIdImpl(long var1, String var3);

    private native long getMyBOObjectHandlerImpl(long var1);

    private native long getMyBOAssignedObjectHandlerImpl(long var1);

    private native long getMyBOJoinedObjectHandlerImpl(long var1);

    private native long getMyBOUserHandlerImpl(long var1);

    private native boolean isInBOMeetingImpl(long var1);

    private native int getControlStatusImpl(long var1);

    private native boolean isBOControllerImpl(long var1);

    private native boolean isBOModeratorImpl(long var1);

    private native long getMasterConfUserListImpl(long var1);

    private native int getLasterErrorImpl(long var1);

    private native long createBOImpl(long var1, String var3, List<String> var4);

    private native boolean updateBOImpl(long var1, String var3, String var4, List<String> var5);

    private native boolean removeBOImpl(long var1, String var3);

    private native boolean isBOTokenReadyImpl(long var1);

    private native boolean startImpl(long var1);

    private native boolean stopImpl(long var1, int var3);

    private native boolean clearImpl(long var1, int var3);

    private native boolean notifyHelpRequestHandledImpl(long var1, String var3, int var4);

    private native int generateNewNameIndexImpl(long var1);

    private native void resetNewNameIndexImpl(long var1);

    private native boolean joinBOImpl(long var1, String var3, int var4);

    private native boolean leaveBOImpl(long var1);

    private native boolean requestForHelpImpl(long var1);
}

