/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.bo;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class BOMessageTip
extends ZMTipFragment {
    private static final String ARGS_MESSAGE = "args_message";
    private static final String ARGS_BOMESSAGE_TIP_INDEX = "args_bomessage_tip_index";
    private static int gChatTipIndex = 0;
    private static final int MAX_BO_MESSAGE_NUM = 4;

    public static void show(FragmentManager fragmentMgr, long duration, String message) {
        if (fragmentMgr == null || StringUtil.isEmptyOrNull((String)message)) {
            return;
        }
        BOMessageTip.dismissExceedMessageTips(fragmentMgr);
        Bundle args = new Bundle();
        args.putString(ARGS_MESSAGE, message);
        args.putInt(ARGS_BOMESSAGE_TIP_INDEX, gChatTipIndex++);
        BOMessageTip tip = new BOMessageTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, BOMessageTip.class.getName(), duration);
        fragmentMgr.executePendingTransactions();
    }

    private static void dismissExceedMessageTips(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return;
        }
        List frags = fragmentMgr.getFragments();
        if (frags == null) {
            return;
        }
        ArrayList<BOMessageTip> messageFrags = new ArrayList<BOMessageTip>();
        int count = 0;
        for (Fragment fragment : messageFrags) {
            if (!(fragment instanceof BOMessageTip)) continue;
            ++count;
            messageFrags.add((BOMessageTip)fragment);
        }
        if (count > 4) {
            Collections.sort(messageFrags, new BOMessageTipComparator());
            for (int i = 0; i < messageFrags.size(); ++i) {
                Fragment fragment = (Fragment)messageFrags.get(i);
                ((BOMessageTip)fragment).dismiss();
                if (--count < 4) break;
            }
        }
    }

    public static boolean isShown(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        BOMessageTip tip = (BOMessageTip)fragmentMgr.findFragmentByTag(BOMessageTip.class.getName());
        return tip != null;
    }

    public static boolean dismissAll(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        List frags = fragmentMgr.getFragments();
        if (frags == null) {
            return false;
        }
        boolean found = false;
        for (Fragment f : frags) {
            if (!(f instanceof BOMessageTip)) continue;
            ((BOMessageTip)f).dismiss();
            found = true;
        }
        return found;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View view = layoutInflater.inflate(R.layout.zm_bo_message_tip, null);
        TextView txtMessage = (TextView)view.findViewById(R.id.txtMessage);
        Bundle args = this.getArguments();
        String message = args.getString(ARGS_MESSAGE);
        txtMessage.setText((CharSequence)message);
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        tip.setBackgroundColor(context.getResources().getColor(R.color.zm_message_tip_background));
        tip.setBorderColor(context.getResources().getColor(R.color.zm_message_tip_border));
        tip.setShadow(4.0f, 0, 0, context.getResources().getColor(R.color.zm_message_tip_shadow));
        return tip;
    }

    public static class BOMessageTipComparator
    implements Comparator<BOMessageTip> {
        @Override
        public int compare(BOMessageTip lhs, BOMessageTip rhs) {
            Bundle argR;
            long idxL = 0L;
            long idxR = 0L;
            Bundle argL = lhs.getArguments();
            if (argL != null) {
                idxL = argL.getInt(BOMessageTip.ARGS_BOMESSAGE_TIP_INDEX, 0);
            }
            if ((argR = rhs.getArguments()) != null) {
                idxR = argR.getInt(BOMessageTip.ARGS_BOMESSAGE_TIP_INDEX, 0);
            }
            return (int)(idxL - idxR);
        }
    }
}

