/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class ZoomShareUI {
    private static final String TAG = ZoomShareUI.class.getSimpleName();
    private static ZoomShareUI instance = null;
    private long mNativeHandle = 0L;
    private ListenerList mListenerList = new ListenerList();

    public static synchronized ZoomShareUI getInstance() {
        if (instance == null) {
            instance = new ZoomShareUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    private ZoomShareUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected long getNativeHandle() {
        return this.mNativeHandle;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L) {
            this.nativeUninit(this.mNativeHandle);
        }
        super.finalize();
    }

    public void addListener(IZoomShareUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IZoomShareUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IZoomShareUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public void OnShareSettingTypeChanged(int eType) {
        try {
            this.OnShareSettingTypeChangedImpl(eType);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareSettingTypeChangedImpl(int eType) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareSettingTypeChanged(eType);
            }
        }
    }

    public void OnActiveShareSourceChanged(long nNewShareSourceID) {
        try {
            this.OnActiveShareSourceChangedImpl(nNewShareSourceID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnActiveShareSourceChangedImpl(long nNewShareSourceID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnActiveShareSourceChanged(nNewShareSourceID);
            }
        }
    }

    public void OnShareContentSizeChanged(long nShareSourceUserID) {
        try {
            this.OnShareContentSizeChangedImpl(nShareSourceUserID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareContentSizeChangedImpl(long nShareSourceUserID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareContentSizeChanged(nShareSourceUserID);
            }
        }
    }

    public void OnShareSourceSendStatusChanged(long nShareSourceUserID, boolean bPaused) {
        try {
            this.OnShareSourceSendStatusChangedImpl(nShareSourceUserID, bPaused);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareSourceSendStatusChangedImpl(long nShareSourceUserID, boolean bPaused) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareSourceSendStatusChanged(nShareSourceUserID, bPaused);
            }
        }
    }

    public void OnShareSourceContentTypeChanged(long nShareSourceID, int eContentType) {
        try {
            this.OnShareSourceContentTypeChangedImpl(nShareSourceID, eContentType);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareSourceContentTypeChangedImpl(long nShareSourceID, int eContentType) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareSourceContentTypeChanged(nShareSourceID, eContentType);
            }
        }
    }

    public void OnShareSourceRemoteControlSupportPropertyChanged(long nShareSourceID, boolean bSupportRemoteContorl) {
        try {
            this.OnShareSourceRemoteControlSupportPropertyChangedImpl(nShareSourceID, bSupportRemoteContorl);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareSourceRemoteControlSupportPropertyChangedImpl(long nShareSourceID, boolean bSupportRemoteContorl) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareSourceRemoteControlSupportPropertyChanged(nShareSourceID, bSupportRemoteContorl);
            }
        }
    }

    public void OnShareSourceAnnotationSupportPropertyChanged(long nShareSourceID, boolean bSupportAnnotation) {
        try {
            this.OnShareSourceAnnotationSupportPropertyChangedImpl(nShareSourceID, bSupportAnnotation);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareSourceAnnotationSupportPropertyChangedImpl(long nShareSourceID, boolean bSupportAnnotation) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareSourceAnnotationSupportPropertyChanged(nShareSourceID, bSupportAnnotation);
            }
        }
    }

    public void OnShareSourceAudioSharingPropertyChanged(long nShareSourceID, boolean bEnableAudioSharing) {
        try {
            this.OnShareSourceAudioSharingPropertyChangedImpl(nShareSourceID, bEnableAudioSharing);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareSourceAudioSharingPropertyChangedImpl(long nShareSourceID, boolean bEnableAudioSharing) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareSourceAudioSharingPropertyChanged(nShareSourceID, bEnableAudioSharing);
            }
        }
    }

    public void OnShareSourceVideoSharingPropertyChanged(long nShareSourceID, boolean bEnableVideoSharing) {
        try {
            this.OnShareSourceVideoSharingPropertyChangedImpl(nShareSourceID, bEnableVideoSharing);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareSourceVideoSharingPropertyChangedImpl(long nShareSourceID, boolean bEnableVideoSharing) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareSourceVideoSharingPropertyChanged(nShareSourceID, bEnableVideoSharing);
            }
        }
    }

    public void OnStartSendShare() {
        try {
            this.OnStartSendShareImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnStartSendShareImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnStartSendShare();
            }
        }
    }

    public void OnStopSendShare() {
        try {
            this.OnStopSendShareImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnStopSendShareImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnStopSendShare();
            }
        }
    }

    public void OnShareCapturerStatusChanged(int msg, int reason, int dwData) {
        try {
            this.OnShareCapturerStatusChangedImpl(msg, reason, dwData);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareCapturerStatusChangedImpl(int msg, int reason, int dwData) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareCapturerStatusChanged(msg, reason, dwData);
            }
        }
    }

    public void OnNewShareSourceViewable(long nShareSourceUserID) {
        try {
            this.OnNewShareSourceViewableImpl(nShareSourceUserID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnNewShareSourceViewableImpl(long nShareSourceUserID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnNewShareSourceViewable(nShareSourceUserID);
            }
        }
    }

    public void OnShareSourceClosed(long nShareSourceUserID) {
        try {
            this.OnShareSourceClosedImpl(nShareSourceUserID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnShareSourceClosedImpl(long nShareSourceUserID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnShareSourceClosed(nShareSourceUserID);
            }
        }
    }

    public void OnStartReceivingShareContent(long nShareSourceUserID) {
        try {
            this.OnStartReceivingShareContentImpl(nShareSourceUserID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnStartReceivingShareContentImpl(long nShareSourceUserID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnStartReceivingShareContent(nShareSourceUserID);
            }
        }
    }

    public void OnRemoteControlRequestReceived(long nRequestUserID) {
        try {
            this.OnRemoteControlRequestReceivedImpl(nRequestUserID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnRemoteControlRequestReceivedImpl(long nRequestUserID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnRemoteControlRequestReceived(nRequestUserID);
            }
        }
    }

    public void OnRemoteControlPrivilegeChanged(long nShareSourceID, long nNewControlUser) {
        try {
            this.OnRemoteControlPrivilegeChangedImpl(nShareSourceID, nNewControlUser);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnRemoteControlPrivilegeChangedImpl(long nShareSourceID, long nNewControlUser) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnRemoteControlPrivilegeChanged(nShareSourceID, nNewControlUser);
            }
        }
    }

    public void OnRemoteControllingStatusChanged(long nShareSourceID, long nNewControlUser) {
        try {
            this.OnRemoteControllingStatusChangedImpl(nShareSourceID, nNewControlUser);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnRemoteControllingStatusChangedImpl(long nShareSourceID, long nNewControlUser) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnRemoteControllingStatusChanged(nShareSourceID, nNewControlUser);
            }
        }
    }

    public void OnDeclineRemoteControlResponseReceived(long nShareSourceID) {
        try {
            this.OnDeclineRemoteControlResponseReceivedImpl(nShareSourceID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnDeclineRemoteControlResponseReceivedImpl(long nShareSourceID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnDeclineRemoteControlResponseReceived(nShareSourceID);
            }
        }
    }

    public void OnGotRemoteControlPrivilege(long nShareSourceID) {
        try {
            this.OnGotRemoteControlPrivilegeImpl(nShareSourceID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnGotRemoteControlPrivilegeImpl(long nShareSourceID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnGotRemoteControlPrivilege(nShareSourceID);
            }
        }
    }

    public void OnLostRemoteControlPrivilege(long nShareSourceID) {
        try {
            this.OnLostRemoteControlPrivilegeImpl(nShareSourceID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnLostRemoteControlPrivilegeImpl(long nShareSourceID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnLostRemoteControlPrivilege(nShareSourceID);
            }
        }
    }

    public void OnEnterRemoteControllingStatus(long nShareSourceID) {
        try {
            this.OnEnterRemoteControllingStatusImpl(nShareSourceID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnEnterRemoteControllingStatusImpl(long nShareSourceID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnEnterRemoteControllingStatus(nShareSourceID);
            }
        }
    }

    public void OnLeaveRemoteControllingStatus(long nShareSourceID) {
        try {
            this.OnLeaveRemoteControllingStatusImpl(nShareSourceID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnLeaveRemoteControllingStatusImpl(long nShareSourceID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnLeaveRemoteControllingStatus(nShareSourceID);
            }
        }
    }

    public void OnStartViewPureComputerAudio(long nShareSourceID) {
        try {
            this.OnStartViewPureComputerAudioImpl(nShareSourceID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnStartViewPureComputerAudioImpl(long nShareSourceID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnStartViewPureComputerAudio(nShareSourceID);
            }
        }
    }

    public void OnStopViewPureComputerAudio(long nShareSourceID) {
        try {
            this.OnStopViewPureComputerAudioImpl(nShareSourceID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnStopViewPureComputerAudioImpl(long nShareSourceID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomShareUIListener l = (IZoomShareUIListener)lTmp;
                l.OnStopViewPureComputerAudio(nShareSourceID);
            }
        }
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleZoomShareUIListener
    implements IZoomShareUIListener {
        @Override
        public void OnShareSettingTypeChanged(int eType) {
        }

        @Override
        public void OnActiveShareSourceChanged(long nNewShareSourceID) {
        }

        @Override
        public void OnShareContentSizeChanged(long nShareSourceUserID) {
        }

        @Override
        public void OnShareSourceSendStatusChanged(long nShareSourceUserID, boolean bPaused) {
        }

        @Override
        public void OnShareSourceContentTypeChanged(long nShareSourceID, int eContentType) {
        }

        @Override
        public void OnShareSourceRemoteControlSupportPropertyChanged(long nShareSourceID, boolean bSupportRemoteContorl) {
        }

        @Override
        public void OnShareSourceAnnotationSupportPropertyChanged(long nShareSourceID, boolean bSupportAnnotation) {
        }

        @Override
        public void OnShareSourceAudioSharingPropertyChanged(long nShareSourceID, boolean bEnableAudioSharing) {
        }

        @Override
        public void OnShareSourceVideoSharingPropertyChanged(long nShareSourceID, boolean bEnableVideoSharing) {
        }

        @Override
        public void OnStartSendShare() {
        }

        @Override
        public void OnStopSendShare() {
        }

        @Override
        public void OnShareCapturerStatusChanged(int msg, int reason, int dwData) {
        }

        @Override
        public void OnNewShareSourceViewable(long nShareSourceUserID) {
        }

        @Override
        public void OnShareSourceClosed(long nShareSourceUserID) {
        }

        @Override
        public void OnStartReceivingShareContent(long nShareSourceUserID) {
        }

        @Override
        public void OnRemoteControlRequestReceived(long nRequestUserID) {
        }

        @Override
        public void OnRemoteControlPrivilegeChanged(long nShareSourceID, long nNewControlUser) {
        }

        @Override
        public void OnRemoteControllingStatusChanged(long nShareSourceID, long nNewControlUser) {
        }

        @Override
        public void OnDeclineRemoteControlResponseReceived(long nShareSourceID) {
        }

        @Override
        public void OnGotRemoteControlPrivilege(long nShareSourceID) {
        }

        @Override
        public void OnLostRemoteControlPrivilege(long nShareSourceID) {
        }

        @Override
        public void OnEnterRemoteControllingStatus(long nShareSourceID) {
        }

        @Override
        public void OnLeaveRemoteControllingStatus(long nShareSourceID) {
        }

        @Override
        public void OnStartViewPureComputerAudio(long nShareSourceID) {
        }

        @Override
        public void OnStopViewPureComputerAudio(long nShareSourceID) {
        }
    }

    public static interface IZoomShareUIListener
    extends IListener {
        public void OnShareSettingTypeChanged(int var1);

        public void OnActiveShareSourceChanged(long var1);

        public void OnShareContentSizeChanged(long var1);

        public void OnShareSourceSendStatusChanged(long var1, boolean var3);

        public void OnShareSourceContentTypeChanged(long var1, int var3);

        public void OnShareSourceRemoteControlSupportPropertyChanged(long var1, boolean var3);

        public void OnShareSourceAnnotationSupportPropertyChanged(long var1, boolean var3);

        public void OnShareSourceAudioSharingPropertyChanged(long var1, boolean var3);

        public void OnShareSourceVideoSharingPropertyChanged(long var1, boolean var3);

        public void OnStartSendShare();

        public void OnStopSendShare();

        public void OnShareCapturerStatusChanged(int var1, int var2, int var3);

        public void OnNewShareSourceViewable(long var1);

        public void OnShareSourceClosed(long var1);

        public void OnStartReceivingShareContent(long var1);

        public void OnRemoteControlRequestReceived(long var1);

        public void OnRemoteControlPrivilegeChanged(long var1, long var3);

        public void OnRemoteControllingStatusChanged(long var1, long var3);

        public void OnDeclineRemoteControlResponseReceived(long var1);

        public void OnGotRemoteControlPrivilege(long var1);

        public void OnLostRemoteControlPrivilege(long var1);

        public void OnEnterRemoteControllingStatus(long var1);

        public void OnLeaveRemoteControllingStatus(long var1);

        public void OnStartViewPureComputerAudio(long var1);

        public void OnStopViewPureComputerAudio(long var1);
    }
}

