/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import android.text.TextUtils;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import java.util.ArrayList;
import java.util.List;

public class ZoomChatInWebinar {
    private long mNativeHandle = 0L;

    public ZoomChatInWebinar(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public boolean sendWebinarChatToAllPanelists(String text) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.sendWebinarChatToAllPanelistsImpl(this.mNativeHandle, text);
    }

    public boolean sendWebinarChatToIndividual(String text, String jid, boolean isCcPanelist) {
        if (this.mNativeHandle == 0L || TextUtils.isEmpty((CharSequence)jid)) {
            return false;
        }
        return this.sendWebinarChatToIndividualImpl(this.mNativeHandle, text, jid, isCcPanelist);
    }

    public int getChattedAttendeeCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getChattedAttendeeCountImpl(this.mNativeHandle);
    }

    public List<ZoomQABuddy> getChattedAttendees() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long[] handles = this.getChattedAttendeesImpl(this.mNativeHandle);
        if (handles == null || handles.length == 0) {
            return null;
        }
        ArrayList<ZoomQABuddy> buddies = new ArrayList<ZoomQABuddy>();
        for (long handle : handles) {
            buddies.add(new ZoomQABuddy(handle));
        }
        return buddies;
    }

    private native boolean sendWebinarChatToAllPanelistsImpl(long var1, String var3);

    private native boolean sendWebinarChatToIndividualImpl(long var1, String var3, String var4, boolean var5);

    private native int getChattedAttendeeCountImpl(long var1);

    private native long[] getChattedAttendeesImpl(long var1);
}

