/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.IRendererUnit;
import com.zipow.videobox.confapp.IVideoUnit;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.view.video.AbsVideoScene;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;

public class ShareUnit
implements IVideoUnit {
    private static String TAG = ShareUnit.class.getSimpleName();
    private static final int PIC_BORDER = 2;
    private boolean mIsDestroyed = false;
    private String mUnitName = null;
    private int mLeft;
    private int mTop;
    private int mWidth;
    private int mHeight;
    private long mRenderInfo;
    private boolean mHasBorder = false;
    private boolean mIsPaused = false;
    private boolean mIsBorderVisible = false;
    private long mUserId = 0L;
    private Bitmap mBmpBorder;
    private IRendererUnit.PicInfo mPiBorder;
    private AbsVideoScene mVideoScene;

    public ShareUnit(long renderInfo, RendererUnitInfo info) {
        this.mRenderInfo = renderInfo;
        if (info != null) {
            this.mLeft = info.left;
            this.mTop = info.top;
            this.mWidth = info.width;
            this.mHeight = info.height;
        }
    }

    public void setVideoScene(AbsVideoScene scene) {
        this.mVideoScene = scene;
    }

    @Override
    public long getRendererInfo() {
        return this.mRenderInfo;
    }

    @Override
    public void setUnitName(String name) {
        this.mUnitName = name;
        TAG = StringUtil.isEmptyOrNull((String)this.mUnitName) ? VideoUnit.class.getSimpleName() : VideoUnit.class.getSimpleName() + ":" + this.mUnitName;
    }

    @Override
    public String getUnitName() {
        return this.mUnitName;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getLeft() {
        return this.mLeft;
    }

    @Override
    public int getTop() {
        return this.mTop;
    }

    @Override
    public int getRight() {
        return this.mLeft + this.mWidth;
    }

    @Override
    public int getBottom() {
        return this.mTop + this.mHeight;
    }

    @Override
    public void pause() {
        if (!this.mIsPaused) {
            this.mIsPaused = true;
            if (this.mUserId != 0L) {
                ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
                if (shareMgr == null) {
                    return;
                }
                shareMgr.stopViewShareContent(this.mRenderInfo, false);
            }
        }
    }

    @Override
    public void resume() {
        if (this.mIsPaused) {
            this.mIsPaused = false;
            if (this.mUserId != 0L) {
                ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
                if (shareMgr == null) {
                    return;
                }
                shareMgr.showShareContent(this.mRenderInfo, this.mUserId, true);
            }
        }
    }

    @Override
    public boolean isPaused() {
        return this.mIsPaused;
    }

    @Override
    public void updateUnitInfo(RendererUnitInfo unitInfo) {
        ShareSessionMgr shareMgr;
        if (unitInfo == null) {
            return;
        }
        if (this.isSameInfo(unitInfo)) {
            return;
        }
        if (this.mVideoScene == null) {
            return;
        }
        boolean sizeChanged = this.mWidth != unitInfo.width || this.mHeight != unitInfo.height;
        this.mLeft = unitInfo.left;
        this.mTop = unitInfo.top;
        this.mWidth = unitInfo.width;
        this.mHeight = unitInfo.height;
        if (this.isBorderVisible() && sizeChanged) {
            this.destroyBorderResources();
            this.createBorderResources();
        }
        if ((shareMgr = ConfMgr.getInstance().getShareObj()) == null) {
            return;
        }
        shareMgr.updateUnitLayout(this.mRenderInfo, unitInfo);
        if (this.mHasBorder) {
            this.showBorder();
        }
    }

    private boolean isSameInfo(RendererUnitInfo unitInfo) {
        if (unitInfo == null) {
            return false;
        }
        return this.mLeft == unitInfo.left && this.mTop == unitInfo.top && this.mWidth == unitInfo.width && this.mHeight == unitInfo.height;
    }

    @Override
    public void setUser(long userId) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        if (this.mUserId != 0L && this.mUserId != userId) {
            this.removeUser();
        }
        this.mUserId = userId;
        if (!this.mIsPaused) {
            shareMgr.showShareContent(this.mRenderInfo, userId, true);
        }
    }

    public void setBorderVisible(boolean visible) {
        if (this.mIsBorderVisible == visible) {
            return;
        }
        this.mIsBorderVisible = visible;
        if (this.mUserId != 0L) {
            if (this.mIsBorderVisible) {
                this.createBorderResources();
                this.showBorder();
            } else {
                this.destroyBorderResources();
                this.removeBorder();
            }
        }
    }

    public boolean isBorderVisible() {
        return this.mIsBorderVisible;
    }

    private void createBorderResources() {
        this.destroyBorderResources();
        this.mBmpBorder = this.createBorderBitmap();
        this.mPiBorder = null;
    }

    private void destroyBorderResources() {
        if (this.mBmpBorder != null) {
            this.mBmpBorder.recycle();
            this.mBmpBorder = null;
            this.mPiBorder = null;
        }
    }

    @Override
    public long getUser() {
        return this.mUserId;
    }

    @Override
    public void removeUser() {
        this.mUserId = 0L;
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        shareMgr.showShareContent(this.mRenderInfo, this.mUserId, false);
        if (this.mVideoScene == null) {
            return;
        }
        this.removeBorder();
    }

    public void stopViewShareContent() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        shareMgr.stopViewShareContent(this.mRenderInfo, false);
    }

    @Override
    public void clearRenderer() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        shareMgr.clearRenderer(this.mRenderInfo);
    }

    @Override
    public void onIdle() {
        if (this.isBorderVisible() && !this.mHasBorder) {
            this.showBorder();
        }
    }

    @Override
    public void onCreate() {
        if (this.isBorderVisible() && this.mBmpBorder == null) {
            this.createBorderResources();
        }
        this.mIsDestroyed = false;
    }

    @Override
    public void onDestroy() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        shareMgr.destroyShareUnit(this);
        this.mIsDestroyed = true;
    }

    @Override
    public void onGLViewSizeChanged(int width, int height) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        shareMgr.glViewSizeChanged(this.mRenderInfo, width, height);
    }

    public void destAreaChanged(int left, int top, int scaleWidth, int scaleHeight) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        shareMgr.destAreaChanged(this.mRenderInfo, left, top, scaleWidth, scaleHeight);
    }

    private void showBorder() {
        if (this.mBmpBorder == null) {
            return;
        }
        if (this.mIsDestroyed) {
            return;
        }
        if (this.mPiBorder == null) {
            return;
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        int width = 0;
        int height = 0;
        if (this.mPiBorder != null) {
            width = this.mPiBorder.bmpWidth;
            height = this.mPiBorder.bmpHeight;
        } else {
            width = this.mBmpBorder.getWidth();
            height = this.mBmpBorder.getHeight();
        }
        int left = 0;
        int right = width;
        int top = 0;
        int bottom = height;
        long dataHandle = 0L;
        if (this.mPiBorder == null) {
            shareMgr.removePic(this.mRenderInfo, 2);
            dataHandle = shareMgr.addPic(this.mRenderInfo, 2, this.mBmpBorder, 255, 0, left, top, right, bottom);
            if (dataHandle != 0L) {
                this.mPiBorder = new IRendererUnit.PicInfo(dataHandle, this.mBmpBorder.getWidth(), this.mBmpBorder.getHeight());
            }
        } else {
            dataHandle = shareMgr.movePic2(this.mRenderInfo, 2, left, top, right, bottom);
        }
        this.mHasBorder = true;
    }

    private Bitmap createBorderBitmap() {
        Bitmap bitmap;
        try {
            bitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Exception e) {
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        float strokeWidth = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)2.0f);
        Paint paint = new Paint();
        paint.setColor(-2039584);
        paint.setStrokeWidth(strokeWidth);
        paint.setStyle(Paint.Style.STROKE);
        float l = strokeWidth / 2.0f;
        float t = strokeWidth / 2.0f;
        float r = (float)this.mWidth - strokeWidth / 2.0f - 1.0f;
        float b = (float)this.mHeight - strokeWidth / 2.0f - 1.0f;
        canvas.drawRect(l, t, r, b, paint);
        return bitmap;
    }

    private void removeBorder() {
        if (!this.mHasBorder) {
            return;
        }
        if (this.mIsDestroyed) {
            return;
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        if (shareMgr.removePic(this.mRenderInfo, 2)) {
            this.mPiBorder = null;
            this.mHasBorder = false;
        }
    }
}

