/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import android.content.Context;
import android.os.Looper;
import com.zipow.annotate.ZoomAnnotate;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.AttentionTrackEventSinkUI;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.ChatMessage;
import com.zipow.videobox.confapp.CmmAttentionTrackMgr;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmFeedbackMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfChatMessage;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.ZoomChatInWebinar;
import com.zipow.videobox.confapp.ZoomRaiseHandInWebinar;
import com.zipow.videobox.confapp.ZoomShareUI;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.confapp.poll.PollingMgr;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.util.E2EMeetingExternalSessionKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;

public class ConfMgr {
    private static final String TAG = ConfMgr.class.getSimpleName();
    private static ConfMgr instance = null;
    private VideoSessionMgr mVideoSessionMgr = null;
    private AudioSessionMgr mAudioSessionMgr = null;
    private ShareSessionMgr mShareSessionMgr = null;
    private CmmUserList mUserList = null;
    private RecordMgr mRecordMgr = null;
    private PollingMgr mPollingMgr = null;
    private ZoomRaiseHandInWebinar mRaiseHandInWebinar = null;
    private BOMgr mBOMgr = null;
    private CmmAttentionTrackMgr mATMgr = null;
    private CmmFeedbackMgr mFeedbackMgr = null;
    private ZoomAnnotate mZoomAnnotateMgr = null;
    private transient boolean mUserJoined = false;
    private transient int mClientUserCount = 0;

    private ConfMgr() {
    }

    public static synchronized ConfMgr getInstance() {
        if (instance == null) {
            instance = new ConfMgr();
        }
        return instance;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    public void initialize() {
        this.nativeInit();
    }

    public static Context getApplicationContext() {
        return VideoBoxApplication.getInstance();
    }

    public void dispatchIdleMessage() {
        this.dispatchIdleMessageImpl();
    }

    public void onUserInputConfNumber(boolean join, String confID) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.onUserInputConfNumberImpl(join, confID);
    }

    public void onUserConfirmToJoin(boolean join) {
        this.onUserConfirmToJoin(join, null);
    }

    public void onUserConfirmToJoin(boolean join, String screenName) {
        if (screenName == null) {
            screenName = "";
        }
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.onUserConfirmToJoinImpl(join, screenName);
    }

    public boolean handleConfCmd(int cmd) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.handleConfCmdImpl(cmd);
    }

    public boolean handleUserCmd(int cmd, long userId) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.handleUserCmdImpl(cmd, userId);
    }

    public int getConfStatus() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        int status = this.getConfStatusImpl();
        return status;
    }

    public boolean isConfConnected() {
        int status = this.getConfStatus();
        return status == 12 || status == 13;
    }

    public VideoSessionMgr getVideoObj() {
        if (this.mVideoSessionMgr != null) {
            return this.mVideoSessionMgr;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getVideoObjHandle();
        if (handle == 0L) {
            return null;
        }
        this.mVideoSessionMgr = new VideoSessionMgr(handle);
        return this.mVideoSessionMgr;
    }

    public AudioSessionMgr getAudioObj() {
        if (this.mAudioSessionMgr != null) {
            return this.mAudioSessionMgr;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getAudioObjHandle();
        if (handle == 0L) {
            return null;
        }
        this.mAudioSessionMgr = new AudioSessionMgr(handle);
        return this.mAudioSessionMgr;
    }

    public ShareSessionMgr getShareObj() {
        if (this.mShareSessionMgr != null) {
            return this.mShareSessionMgr;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getShareObjHandle();
        if (handle == 0L) {
            return null;
        }
        this.mShareSessionMgr = new ShareSessionMgr(handle);
        this.mShareSessionMgr.setShareEventSink(ZoomShareUI.getInstance().getNativeHandle());
        return this.mShareSessionMgr;
    }

    public ZoomAnnotate getZoomAnnotateMgr() {
        if (this.mZoomAnnotateMgr != null) {
            return this.mZoomAnnotateMgr;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getShareObjHandle();
        if (handle == 0L) {
            return null;
        }
        this.mZoomAnnotateMgr = new ZoomAnnotate(handle);
        return this.mZoomAnnotateMgr;
    }

    public CmmUserList getUserList() {
        if (this.mUserList != null) {
            return this.mUserList;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getUserListHandle();
        if (handle == 0L) {
            return null;
        }
        this.mUserList = new CmmUserList(handle);
        return this.mUserList;
    }

    public RecordMgr getRecordMgr() {
        if (this.mRecordMgr != null) {
            return this.mRecordMgr;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getRecordMgrHandle();
        if (handle == 0L) {
            return null;
        }
        this.mRecordMgr = new RecordMgr(handle);
        return this.mRecordMgr;
    }

    public ZoomQAComponent getQAComponent() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getQAComponentHandle();
        if (handle == 0L) {
            return null;
        }
        return new ZoomQAComponent(handle);
    }

    public ZoomChatInWebinar getChatInWebinar() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getWebinarChatAPIObjHandle();
        if (handle == 0L) {
            return null;
        }
        return new ZoomChatInWebinar(handle);
    }

    public PollingMgr getPollObj() {
        if (this.mPollingMgr != null) {
            return this.mPollingMgr;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getPollObjHandle();
        if (handle == 0L) {
            return null;
        }
        this.mPollingMgr = new PollingMgr(handle);
        return this.mPollingMgr;
    }

    public ZoomRaiseHandInWebinar getRaiseHandAPIObj() {
        if (this.mRaiseHandInWebinar != null) {
            return this.mRaiseHandInWebinar;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getRaiseHandAPIObjHandle();
        if (handle == 0L) {
            return null;
        }
        this.mRaiseHandInWebinar = new ZoomRaiseHandInWebinar(handle);
        return this.mRaiseHandInWebinar;
    }

    public BOMgr getBOMgr() {
        if (this.mBOMgr != null) {
            return this.mBOMgr;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getBOManagerHandle();
        if (handle == 0L) {
            return null;
        }
        this.mBOMgr = new BOMgr(handle);
        return this.mBOMgr;
    }

    public CmmFeedbackMgr getFeedbackMgr() {
        if (this.mFeedbackMgr != null) {
            return this.mFeedbackMgr;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getFeedbackAPIImpl();
        if (handle == 0L) {
            return null;
        }
        this.mFeedbackMgr = new CmmFeedbackMgr(handle);
        return this.mFeedbackMgr;
    }

    public CmmUser getMyself() {
        CmmUserList userList = this.getUserList();
        if (userList == null) {
            return null;
        }
        return userList.getMyself();
    }

    public CmmUser getUserById(long userId) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getUserByIdImpl(userId);
        if (handle == 0L) {
            return null;
        }
        return new CmmUser(handle);
    }

    public CmmUser getUserByQAAttendeeJID(String jid) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getUserByQAAttendeeJIDImpl(jid);
        if (handle == 0L) {
            return null;
        }
        return new CmmUser(handle);
    }

    public CmmConfStatus getConfStatusObj() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getConfStatusObjImpl();
        if (handle == 0L) {
            return null;
        }
        return new CmmConfStatus(handle);
    }

    public CmmConfContext getConfContext() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getConfContextHandleImpl();
        if (handle == 0L) {
            return null;
        }
        return new CmmConfContext(handle);
    }

    public int getClientUserCount() {
        boolean isMainThread;
        boolean bl = isMainThread = Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
        if (isMainThread) {
            if (!this.isInitialForMainboard()) {
                return 0;
            }
            this.mClientUserCount = this.getClientUserCountImpl(true);
        }
        return this.mClientUserCount;
    }

    public int getViewOnlyTelephonyUserCount() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        return this.getViewOnlyTelephonyUserCountImpl();
    }

    public int getChatMessageCount() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        return this.getChatMessageCountImpl();
    }

    public ChatMessage getChatMessageAt(int index) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        ChatMessage chatMsg = this.getChatMessageAtImpl(index);
        if (!StringUtil.isEmptyOrNull((String)chatMsg.getId())) {
            return chatMsg;
        }
        return null;
    }

    public int[] getUnreadChatMessageIndexes() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getUnreadChatMessageIndexesImpl(true);
    }

    public String[] getChatMessagesByUser(long userId, boolean privateOnly) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getChatMessagesByUserImpl(userId, privateOnly);
    }

    public String[] getUnreadChatMessagesByUser(long userId, boolean privateOnly) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getUnreadChatMessagesByUserImpl(userId, privateOnly);
    }

    public boolean setChatMessageAsReaded(String msgId) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.setChatMessageAsReadedImpl(msgId);
    }

    public boolean sendChatMessageTo(long receiver, String content, boolean toAllPanelists, boolean notShowMsgOnUI, long ccAttendeeId) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.sendChatMessageToImpl(receiver, content, toAllPanelists, notShowMsgOnUI, ccAttendeeId);
    }

    public boolean validateConfNumber(String confNumber) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.validateConfNumberImpl(confNumber);
    }

    public void leaveConference() {
        this.leaveConference(false);
    }

    public void endConference() {
        this.leaveConference(true);
    }

    private void leaveConference(boolean end) {
        AudioSessionMgr audioMgr;
        if (this.isConfConnected() && (audioMgr = this.getAudioObj()) != null) {
            if (audioMgr.isBluetoothHeadsetStarted()) {
                audioMgr.stopBluetoothHeadset();
            }
            audioMgr.setLoudSpeakerStatus(false, false);
        }
        if (end) {
            this.handleConfCmd(51);
        } else {
            this.handleConfCmd(0);
        }
    }

    public boolean notifyConfLeaveReason(String reason, boolean leave) {
        return this.notifyConfLeaveReason(reason, leave, false);
    }

    public boolean notifyConfLeaveReason(String reason, boolean leave, boolean bWithDetailErrorCode) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.notifyConfLeaveReasonImpl(reason, leave, bWithDetailErrorCode);
    }

    public void onUserInputPassword(String password, String userName, boolean cancel) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.onUserInputPasswordImpl(password, userName, cancel);
    }

    public void onUserRegisterWebinar(String userName, String email, boolean cancel) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        if (userName == null) {
            userName = "";
        }
        if (email == null) {
            email = "";
        }
        this.onUserRegisterWebinarImpl(userName, email, cancel);
    }

    public boolean notifyPTStartLogin(String reason) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (reason == null) {
            reason = "";
        }
        return this.notifyPTStartLoginImpl(reason);
    }

    public void setAndroidNetworkType(int type, int sub) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.setAndroidNetworkTypeImpl(type, sub);
    }

    public boolean updateAccount() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.upgradeAccountImpl();
    }

    public boolean notifyPTLoginToClaimHost() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.notifyPTLoginToClaimHostImpl();
    }

    public boolean canUnmuteMyself() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.canUnmuteMyselfImpl();
    }

    public boolean isCallingOut() {
        if (this.mUserJoined) {
            return false;
        }
        CmmConfContext confContext = this.getConfContext();
        if (confContext == null) {
            return false;
        }
        boolean connected = this.isConfConnected();
        boolean isCall = confContext.isCall();
        int launchReason = confContext.getLaunchReason();
        int userCount = this.getClientUserCount();
        return isCall && launchReason == 1 && (!connected || userCount < 2);
    }

    private void setUserJoined() {
        this.mUserJoined = true;
    }

    protected void onUserEvent(int eventType, long userId, int flag) {
        this.mClientUserCount = ConfMgr.getInstance().getClientUserCount();
        if (eventType == 0 && this.mClientUserCount >= 2) {
            this.setUserJoined();
        }
    }

    public String getVerifiedPhoneNumber() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getVerifiedPhoneNumberImpl();
    }

    public int getPhoneBuddyCount() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        return this.getPhoneBuddyCountImpl();
    }

    public boolean noOneIsSendingVideo() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.noOneIsSendingVideoImpl();
    }

    public boolean isNoVideoMeeting() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isNoVideoMeetingImpl();
    }

    public void getPTLoginInfo(String[] zoomUID, String[] uName, String[] snsID, int[] snsType) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.getPTLoginInfoImpl(zoomUID, uName, snsID, snsType);
    }

    public int getPTLoginType() {
        String[] zoomUID = new String[1];
        String[] uName = new String[1];
        String[] snsID = new String[1];
        int[] snsType = new int[]{102};
        this.getPTLoginInfo(zoomUID, uName, snsID, snsType);
        return snsType[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupConf() {
        Object object = ShareSessionMgr.SHARE_SESSION_LOCK;
        synchronized (object) {
            if (!this.isInitialForMainboard()) {
                return;
            }
            if (this.mShareSessionMgr != null) {
                this.mShareSessionMgr.setConfCleaned(true);
            }
            this.cleanupConfImpl();
        }
    }

    public String getTalkingUserName() {
        return this.getTalkingUserNameImpl();
    }

    public boolean isDriveModeSettingOn() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isDriveModeSettingOnImpl();
    }

    public void logUICommand(String uiContainer, String action, String param) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.logUICommandImpl(uiContainer, action, param);
    }

    public void setWifiSignalQuality(int v) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.setWifiSignalQualityImpl(v);
    }

    public boolean isViewOnlyMeeting() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isViewOnlyMeetingImpl();
    }

    public int getViewOnlyUserCount() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        return this.getViewOnlyUserCountImpl();
    }

    public boolean isShareLocked() {
        return this.isShareLockedImpl();
    }

    public boolean disabledAttendeeUnmuteSelf() {
        return this.disabledAttendeeUnmuteSelfImpl();
    }

    public int getCurrentVendor() {
        return this.getCurrentVendorImpl();
    }

    public int getLastNetworkErrorCode() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        return this.getLastNetworkErrorCodeImpl();
    }

    public boolean sendParingCode(String paringCode) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.sendParingCodeImpl(paringCode);
    }

    public boolean changeUserNameByID(String screenName, long userID) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (screenName == null) {
            return false;
        }
        return this.changeUserNameByIDImpl(screenName, userID);
    }

    public void setPlayChimeOnOff(boolean bOn) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.setPlayChimeOnOffImpl(bOn);
    }

    public boolean isPlayChimeOn() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isPlayChimeOnImpl();
    }

    public int getAuthInfo(int type, String server, int port, String[] uname, String[] psw) {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        if (StringUtil.isEmptyOrNull((String)server) || port <= 0 || uname == null || uname.length == 0 || psw == null || psw.length == 0) {
            return 0;
        }
        return this.getAuthInfoImpl(type, server, port, uname, psw);
    }

    public void setLanguageID(String langID) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.setLanguageIDImpl(langID);
    }

    public void setLanguageIdAsSystemConfiguration() {
        Locale locale = CompatUtils.getLocalDefault();
        if (locale == null) {
            return;
        }
        String langID = locale.getLanguage() + "-" + locale.getCountry();
        this.setLanguageID(langID);
    }

    public boolean promotePanelist(String jid) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.promotePanelistImpl(jid);
    }

    public boolean downgradeToAttendee(String jid) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return false;
        }
        return this.downgradeToAttendeeImpl(jid);
    }

    public boolean isUserOriginalorAltHost(String zoomId) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)zoomId)) {
            return false;
        }
        return this.isUserOriginalorAltHostImpl(zoomId);
    }

    public boolean isPublicGmailUser() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isPublicGmailUserImpl();
    }

    public boolean isGoogleImEnabled() {
        return false;
    }

    public boolean isFacebookImEnabled() {
        return false;
    }

    public boolean canUnmuteMyVideo() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.canUmmuteMyVideoImpl();
    }

    public boolean expelAttendee(String jid) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.expelAttendeeImpl(jid);
    }

    public void setPutOnHoldOnEntry(boolean bOn) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.setPutOnHoldOnEntryImpl(bOn);
    }

    public boolean isPutOnHoldOnEntryOn() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isPutOnHoldOnEntryOnImpl();
    }

    public ConfChatMessage getChatMessageItemByID(String msgId) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handler = this.getChatMessageItemByIDImpl(msgId);
        if (handler == 0L) {
            return null;
        }
        return new ConfChatMessage(handler);
    }

    public boolean sendXmppChatToAllPanelists(String text) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.sendXmppChatToAllPanelistsImpl(text);
    }

    public boolean sendXmppChatToIndividual(String text, String jid, boolean isCcPanelist) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.sendXmppChatToIndividualImpl(text, jid, isCcPanelist);
    }

    public boolean isAllowAttendeeChat() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isAllowAttendeeChatImpl();
    }

    public void updateChattedAttendees() {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.updateChattedAttendeesImpl();
    }

    public boolean verifyHostKey(String hostKey) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)hostKey)) {
            return false;
        }
        return this.verifyHostKeyImpl(hostKey);
    }

    public boolean mmrMonitorLog(String eventName, String content) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)eventName)) {
            return false;
        }
        if (content == null) {
            return false;
        }
        return this.mmrMonitorLogImpl(eventName, content);
    }

    public boolean isAllowAskQuestionAnonymously() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isAllowAskQuestionAnonymouslyImpl();
    }

    public boolean needPreviewVideoWhenStartMeeting() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.needPreviewVideoWhenStartMeetingImpl();
    }

    public CmmAttentionTrackMgr getAttentionTrackAPI() {
        if (this.mATMgr != null) {
            return this.mATMgr;
        }
        if (!this.isInitialForMainboard()) {
            return null;
        }
        long handle = this.getAttentionTrackAPIImpl();
        if (handle == 0L) {
            return null;
        }
        this.mATMgr = new CmmAttentionTrackMgr(handle);
        this.mATMgr.setEventSink(AttentionTrackEventSinkUI.getInstance());
        return this.mATMgr;
    }

    public int getClientWithoutOnHoldUserCount(boolean excludeAttendee) {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        return this.getClientWithoutOnHoldUserCountImpl(excludeAttendee);
    }

    private boolean isInBOMeeting() {
        boolean isInBOMeeting = false;
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr != null) {
            isInBOMeeting = boMgr.isInBOMeeting();
        }
        return isInBOMeeting;
    }

    public boolean isUserOnHold(CmmUser user) {
        boolean isInBOMeeting = this.isInBOMeeting();
        return user != null && !user.isMMRUser() && (isInBOMeeting || !user.isInBOMeeting()) && user.inSilentMode();
    }

    public List<CmmUser> getClientOnHoldUserList() {
        ArrayList<CmmUser> lists = new ArrayList<CmmUser>();
        CmmUserList userList = this.getUserList();
        if (userList == null) {
            return lists;
        }
        int count = userList.getUserCount();
        for (int i = 0; i < count; ++i) {
            CmmUser user = userList.getUserAt(i);
            if (!this.isUserOnHold(user)) continue;
            lists.add(user);
        }
        return lists;
    }

    public void setShowClockInMeeting(boolean bShowClock) {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.setShowClockInMeetingImpl(bShowClock);
    }

    public boolean isShowClockEnable() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isShowClockEnableImpl();
    }

    public void tryUpgradeThisFreeMeeting() {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.tryUpgradeThisFreeMeetingImpl();
    }

    public void checkCMRPrivilege() {
        if (!this.isInitialForMainboard()) {
            return;
        }
        this.checkCMRPrivilegeImpl();
    }

    public boolean isViewOnlyClientOnMMR() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isViewOnlyClientOnMMRImpl();
    }

    public int getVideoUserCount() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        return this.getVideoUserCountImpl();
    }

    public boolean handleE2EMeetingExternalSessionKeyReady(Map<String, E2EMeetingExternalSessionKey> params, boolean leave_meeting) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        String[] keys = null;
        E2EMeetingExternalSessionKey[] sessionKey = null;
        if (params != null && params.size() > 0) {
            keys = params.keySet().toArray(new String[params.size()]);
            int[] types = new int[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                types[i] = Integer.parseInt(keys[i]);
            }
            sessionKey = params.values().toArray(new E2EMeetingExternalSessionKey[params.size()]);
            return this.handleE2EMeetingExternalSessionKeyReadyImpl(types, sessionKey, leave_meeting);
        }
        return false;
    }

    public byte[] getE2EMeetingSecureKey() {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getE2EMeetingSecureKeyImpl();
    }

    public int getWaitingRoomLayoutType() {
        if (!this.isInitialForMainboard()) {
            return 0;
        }
        return this.getWaitingRoomLayoutTypeImpl();
    }

    public String getWaitingRoomLayoutTitle() {
        if (!this.isInitialForMainboard()) {
            return "";
        }
        return this.getWaitingRoomLayoutTitleImpl();
    }

    public String getWaitingRoomLayoutDescription() {
        if (!this.isInitialForMainboard()) {
            return "";
        }
        return this.getWaitingRoomLayoutDescriptionImpl();
    }

    public String getWaitingRoomLayoutImagePath() {
        if (!this.isInitialForMainboard()) {
            return "";
        }
        return this.getWaitingRoomLayoutImagePathImpl();
    }

    public boolean isWaitingRoomLayoutReady() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isWaitingRoomLayoutReadyImpl();
    }

    public boolean confirmGDPR(boolean agree) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.confirmGDPRImpl(agree);
    }

    public boolean isAllowAttendeeViewAllQuestion() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isAllowAttendeeViewAllQuestionImpl();
    }

    public boolean isAllowAttendeeUpvoteQuestion() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isAllowAttendeeUpvoteQuestionImpl();
    }

    public boolean isAllowAttendeeAnswerQuestion() {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.isAllowAttendeeAnswerQuestionImpl();
    }

    public boolean startLiveChannels(String url) {
        if (!this.isInitialForMainboard()) {
            return false;
        }
        return this.startLiveChannelsImpl(url);
    }

    private boolean isInitialForMainboard() {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return false;
        }
        return !VideoBoxApplication.getInstance().isSDKMode() || mainboard.isSDKConfAppCreated();
    }

    public String getWebDomain(boolean isInMeeting) {
        if (!this.isInitialForMainboard()) {
            return null;
        }
        return this.getWebDomainImpl(isInMeeting);
    }

    private native void nativeInit();

    private native void dispatchIdleMessageImpl();

    private native void onUserInputConfNumberImpl(boolean var1, String var2);

    private native void onUserConfirmToJoinImpl(boolean var1, String var2);

    private native boolean handleConfCmdImpl(int var1);

    private native boolean handleUserCmdImpl(int var1, long var2);

    private native int getConfStatusImpl();

    private native long getVideoObjHandle();

    private native long getAudioObjHandle();

    private native long getShareObjHandle();

    private native long getUserListHandle();

    private native long getRecordMgrHandle();

    private native long getQAComponentHandle();

    private native long getWebinarChatAPIObjHandle();

    private native long getPollObjHandle();

    private native long getRaiseHandAPIObjHandle();

    private native long getBOManagerHandle();

    private native long getFeedbackAPIImpl();

    private native long getUserByIdImpl(long var1);

    private native long getUserByQAAttendeeJIDImpl(String var1);

    private native long getConfStatusObjImpl();

    private native long getConfContextHandleImpl();

    private native int getClientUserCountImpl(boolean var1);

    private native int getViewOnlyTelephonyUserCountImpl();

    private native int getChatMessageCountImpl();

    private native ChatMessage getChatMessageAtImpl(int var1);

    private native int[] getUnreadChatMessageIndexesImpl(boolean var1);

    private native String[] getChatMessagesByUserImpl(long var1, boolean var3);

    private native String[] getUnreadChatMessagesByUserImpl(long var1, boolean var3);

    private native boolean setChatMessageAsReadedImpl(String var1);

    private native boolean sendChatMessageToImpl(long var1, String var3, boolean var4, boolean var5, long var6);

    private native boolean validateConfNumberImpl(String var1);

    private native boolean notifyConfLeaveReasonImpl(String var1, boolean var2, boolean var3);

    private native void onUserInputPasswordImpl(String var1, String var2, boolean var3);

    private native void onUserRegisterWebinarImpl(String var1, String var2, boolean var3);

    private native boolean notifyPTStartLoginImpl(String var1);

    private native void setAndroidNetworkTypeImpl(int var1, int var2);

    private native boolean upgradeAccountImpl();

    private native boolean notifyPTLoginToClaimHostImpl();

    private native boolean canUnmuteMyselfImpl();

    private native String getVerifiedPhoneNumberImpl();

    private native int getPhoneBuddyCountImpl();

    private native boolean noOneIsSendingVideoImpl();

    private native boolean isNoVideoMeetingImpl();

    private native void getPTLoginInfoImpl(String[] var1, String[] var2, String[] var3, int[] var4);

    private native void cleanupConfImpl();

    private native String getTalkingUserNameImpl();

    private native boolean isDriveModeSettingOnImpl();

    private native void logUICommandImpl(String var1, String var2, String var3);

    private native void setWifiSignalQualityImpl(int var1);

    private native boolean isViewOnlyMeetingImpl();

    private native int getViewOnlyUserCountImpl();

    private native boolean isShareLockedImpl();

    private native boolean disabledAttendeeUnmuteSelfImpl();

    private native int getCurrentVendorImpl();

    private native int getLastNetworkErrorCodeImpl();

    private native boolean sendParingCodeImpl(String var1);

    private native boolean changeUserNameByIDImpl(String var1, long var2);

    private native void setPlayChimeOnOffImpl(boolean var1);

    private native boolean isPlayChimeOnImpl();

    private native int getAuthInfoImpl(int var1, String var2, int var3, String[] var4, String[] var5);

    private native void setLanguageIDImpl(String var1);

    private native boolean promotePanelistImpl(String var1);

    private native boolean downgradeToAttendeeImpl(String var1);

    private native boolean isUserOriginalorAltHostImpl(String var1);

    private native boolean isPublicGmailUserImpl();

    private native boolean canUmmuteMyVideoImpl();

    private native boolean expelAttendeeImpl(String var1);

    private native void setPutOnHoldOnEntryImpl(boolean var1);

    private native boolean isPutOnHoldOnEntryOnImpl();

    private native long getChatMessageItemByIDImpl(String var1);

    private native boolean sendXmppChatToAllPanelistsImpl(String var1);

    private native boolean sendXmppChatToIndividualImpl(String var1, String var2, boolean var3);

    private native boolean isAllowAttendeeChatImpl();

    private native void updateChattedAttendeesImpl();

    private native boolean verifyHostKeyImpl(String var1);

    private native boolean mmrMonitorLogImpl(String var1, String var2);

    private native boolean isAllowAskQuestionAnonymouslyImpl();

    private native boolean needPreviewVideoWhenStartMeetingImpl();

    private native long getAttentionTrackAPIImpl();

    private native int getClientWithoutOnHoldUserCountImpl(boolean var1);

    private native void setShowClockInMeetingImpl(boolean var1);

    private native boolean isShowClockEnableImpl();

    private native boolean tryUpgradeThisFreeMeetingImpl();

    private native boolean checkCMRPrivilegeImpl();

    private native boolean isViewOnlyClientOnMMRImpl();

    private native int getVideoUserCountImpl();

    private native boolean handleE2EMeetingExternalSessionKeyReadyImpl(int[] var1, E2EMeetingExternalSessionKey[] var2, boolean var3);

    private native byte[] getE2EMeetingSecureKeyImpl();

    private native int getWaitingRoomLayoutTypeImpl();

    private native String getWaitingRoomLayoutTitleImpl();

    private native String getWaitingRoomLayoutDescriptionImpl();

    private native String getWaitingRoomLayoutImagePathImpl();

    private native boolean isWaitingRoomLayoutReadyImpl();

    private native boolean confirmGDPRImpl(boolean var1);

    private native boolean isAllowAttendeeViewAllQuestionImpl();

    private native boolean isAllowAttendeeUpvoteQuestionImpl();

    private native boolean isAllowAttendeeAnswerQuestionImpl();

    private native boolean startLiveChannelsImpl(String var1);

    private native String getWebDomainImpl(boolean var1);
}

