/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import org.webrtc.voiceengine.VoiceEnginContext;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.ParamsList;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMLog;

public class AudioSessionMgr {
    private static final String TAG = AudioSessionMgr.class.getSimpleName();
    public static final int LOUDSPEAKER_NOT_SET = -1;
    public static final int LOUDSPEAKER_OFF = 0;
    public static final int LOUDSPEAKER_ON = 1;
    public static final int DEVICE_ERROR_FOUND = 2;
    public static final int AUDIO_ERROR_TALK_WHENMUTED = 9;
    public static final int AUDIO_ERROR_FEEDBACK_DETECTED = 10;
    private long mNativeHandle = 0L;
    private int mDefaultAudioMode = -1;
    private boolean mBluetoothScoStarted = false;
    private AudioManager mAudioManager;
    private int mPreferedLoudspeakerStatus = -1;
    private boolean mbPreferedLoudspeakerStatusLoaded = false;
    private boolean mIsUseA2dpMode;
    private int mStartScoCountDown = 0;
    private static final int TRY_START_SCO_TIMES = 4;
    private static final long INTERVAL_CHECK_SCO_STATUS = 3000L;
    private Handler mHandler = new Handler();
    private int mScoUnexpectedDisconnectTimes = 0;
    private Runnable mRunnableStartSco = new Runnable(){

        @Override
        public void run() {
            if (!HeadsetUtil.getInstance().isBluetoothHeadsetOn()) {
                if (AudioSessionMgr.this.mBluetoothScoStarted) {
                    HeadsetUtil.getInstance().stopBluetoothSco();
                    AudioSessionMgr.this.mBluetoothScoStarted = false;
                }
                AudioSessionMgr.this.mStartScoCountDown = 0;
                return;
            }
            if (HeadsetUtil.getInstance().isBluetoothScoAudioOn()) {
                AudioSessionMgr.this.mBluetoothScoStarted = true;
                AudioSessionMgr.this.mStartScoCountDown = 0;
                AudioSessionMgr.this.notifyVoiceSwitchedToHeadsetOrEarSpeaker(true);
                return;
            }
            if (--AudioSessionMgr.this.mStartScoCountDown < 0) {
                HeadsetUtil.getInstance().stopBluetoothSco();
                VoiceEngineCompat.blacklistBluetoothSco(true);
                AudioSessionMgr.this.startBluetoothHeadset();
                return;
            }
            if (!AudioSessionMgr.this.mBluetoothScoStarted) {
                HeadsetUtil.getInstance().startBluetoothSco();
            }
            AudioSessionMgr.this.mHandler.postDelayed(AudioSessionMgr.this.mRunnableStartSco, 3000L);
        }
    };

    public AudioSessionMgr(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public boolean startAudio() {
        return this.startAudioImpl(this.mNativeHandle);
    }

    public boolean stopAudio() {
        return this.stopAudioImpl(this.mNativeHandle);
    }

    public int getAudioSessionType() {
        return this.getAudioSessionTypeImpl(this.mNativeHandle);
    }

    public boolean turnOnOffAudioSession(boolean on) {
        return this.turnOnOffAudioSessionImpl(this.mNativeHandle, on);
    }

    public int setLoudSpeakerStatus(boolean loudSpeakerOn, boolean affectProximity) {
        if (affectProximity) {
            if (!(loudSpeakerOn || HeadsetUtil.getInstance().isBluetoothHeadsetOn() || HeadsetUtil.getInstance().isWiredHeadsetOn())) {
                UIUtil.startProximityScreenOffWakeLock((Context)VideoBoxApplication.getInstance());
            } else {
                UIUtil.stopProximityScreenOffWakeLock();
            }
        }
        int ret = 0;
        if (ConfMgr.getInstance().isConfConnected()) {
            if (this.getLoudSpeakerStatus() != loudSpeakerOn) {
                ret = this.setLoudSpeakerStatusImpl(this.mNativeHandle, loudSpeakerOn);
            }
        } else {
            if (this.mAudioManager == null) {
                this.mAudioManager = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
            }
            if (this.mAudioManager != null && this.mAudioManager.isSpeakerphoneOn() != loudSpeakerOn) {
                this.mAudioManager.setSpeakerphoneOn(loudSpeakerOn);
            }
        }
        if (VoiceEnginContext.getSelectedPlayerStreamType() == 3) {
            if (HeadsetUtil.getInstance().isWiredHeadsetOn()) {
                this.notifyVoiceSwitchedToHeadsetOrEarSpeaker(true);
            } else {
                this.notifyVoiceSwitchedToHeadsetOrEarSpeaker(false);
            }
        } else {
            this.notifyVoiceSwitchedToHeadsetOrEarSpeaker(!loudSpeakerOn);
        }
        return ret;
    }

    public boolean ismIsUseA2dpMode() {
        return this.mIsUseA2dpMode;
    }

    public int setLoudSpeakerStatus(boolean loudSpeakerOn) {
        return this.setLoudSpeakerStatus(loudSpeakerOn, true);
    }

    public boolean getLoudSpeakerStatus() {
        if (ConfMgr.getInstance().isConfConnected()) {
            return this.getLoudSpeakerStatusImpl(this.mNativeHandle);
        }
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
        }
        if (this.mAudioManager != null) {
            return this.mAudioManager.isSpeakerphoneOn();
        }
        return false;
    }

    public void setPreferedLoudSpeakerStatus(int status) {
        CmmConfContext confContext;
        this.mPreferedLoudspeakerStatus = status;
        if (-1 != status) {
            this.setLoudSpeakerStatus(status == 1);
        }
        if ((confContext = ConfMgr.getInstance().getConfContext()) != null && ConfUI.getInstance().isLaunchConfParamReady()) {
            ParamsList params = confContext.getAppContextParams();
            params.putInt("AudioSessionMgr.PreferedLoudspeakerStatus", this.mPreferedLoudspeakerStatus);
            confContext.setAppContextParams(params);
        }
    }

    public int getPreferedLoudSpeakerStatus() {
        CmmConfContext confContext;
        if (!this.mbPreferedLoudspeakerStatusLoaded && (confContext = ConfMgr.getInstance().getConfContext()) != null && ConfUI.getInstance().isLaunchConfParamReady()) {
            ParamsList params = confContext.getAppContextParams();
            this.mPreferedLoudspeakerStatus = params.getInt("AudioSessionMgr.PreferedLoudspeakerStatus", this.mPreferedLoudspeakerStatus);
            this.mbPreferedLoudspeakerStatusLoaded = true;
        }
        return this.mPreferedLoudspeakerStatus;
    }

    public void stopPlayout() {
        this.stopPlayoutImpl(this.mNativeHandle);
    }

    public void startPlayout() {
        this.startPlayoutImpl(this.mNativeHandle);
    }

    public void notifyHeadsetStatusChanged(boolean bluetoothConnected, boolean headsetConneccted) {
        boolean connected;
        if (!bluetoothConnected) {
            this.mIsUseA2dpMode = false;
            VoiceEngineCompat.blacklistBluetoothSco(false);
            this.mHandler.removeCallbacks(this.mRunnableStartSco);
        }
        boolean bl = connected = bluetoothConnected || headsetConneccted;
        if (!this.getLoudSpeakerStatus() && !connected) {
            UIUtil.startProximityScreenOffWakeLock((Context)VideoBoxApplication.getInstance());
        } else {
            UIUtil.stopProximityScreenOffWakeLock();
        }
    }

    public void notifyVolumeChanged(boolean up, int percent) {
        this.notifyVolumeChangedImpl(this.mNativeHandle, up, percent);
    }

    public void notifyChipAECEnabled(boolean enabled) {
        this.notifyChipAECEnabledImpl(this.mNativeHandle, enabled);
    }

    public void notifyIsTablet(boolean isTablet) {
        this.notifyIsTabletImpl(this.mNativeHandle, isTablet);
    }

    public void notifyBluetoothScoAudioStatus(boolean on, boolean isCallOffHook) {
        boolean oldScoStatus = this.mBluetoothScoStarted;
        this.mBluetoothScoStarted = on;
        if (!isCallOffHook && oldScoStatus && !on && this.mStartScoCountDown == 0 && this.getPreferedLoudSpeakerStatus() != 1 && HeadsetUtil.getInstance().isBluetoothHeadsetOn()) {
            ++this.mScoUnexpectedDisconnectTimes;
            if (this.mScoUnexpectedDisconnectTimes > 2) {
                ZMLog.i((String)TAG, (String)"notifyBluetoothScoAudioStatus, fallback to A2DP mode", (Object[])new Object[0]);
                VoiceEngineCompat.blacklistBluetoothSco(true);
            }
            this.startBluetoothHeadset();
        }
    }

    private void notifyVoiceSwitchedToHeadsetOrEarSpeaker(boolean headsetOrEarSpeaker) {
        this.notifyHeadsetStatusChangedImpl(this.mNativeHandle, headsetOrEarSpeaker);
    }

    public boolean isStarttingSco() {
        return this.mStartScoCountDown > 0;
    }

    public void startWiredHeadset() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
        }
        if (this.mAudioManager == null) {
            return;
        }
        this.mIsUseA2dpMode = false;
        this.notifyVoiceSwitchedToHeadsetOrEarSpeaker(HeadsetUtil.getInstance().isWiredHeadsetOn());
    }

    public void startBluetoothHeadset() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
        }
        if (this.mAudioManager == null) {
            return;
        }
        if (HeadsetUtil.getInstance().isBluetoothHeadsetOn()) {
            if (this.isBluetoothScoSupported()) {
                if (this.mStartScoCountDown > 0 || this.mBluetoothScoStarted) {
                    return;
                }
                this.mStartScoCountDown = 4;
                this.mIsUseA2dpMode = false;
                this.mHandler.removeCallbacks(this.mRunnableStartSco);
                this.mHandler.post(this.mRunnableStartSco);
            } else {
                this.mIsUseA2dpMode = true;
                HeadsetUtil.getInstance().enterA2dpMode();
                if (this.mDefaultAudioMode < 0) {
                    this.mDefaultAudioMode = this.mAudioManager.getMode();
                }
                this.mAudioManager.setMode(0);
                this.notifyVoiceSwitchedToHeadsetOrEarSpeaker(true);
            }
        }
    }

    public void stopBluetoothHeadset() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
        }
        if (this.mAudioManager == null) {
            return;
        }
        this.mHandler.removeCallbacks(this.mRunnableStartSco);
        this.mStartScoCountDown = 0;
        if (this.isBluetoothScoSupported()) {
            if (this.mBluetoothScoStarted) {
                if (HeadsetUtil.getInstance().isBluetoothScoAudioOn()) {
                    HeadsetUtil.getInstance().stopBluetoothSco();
                }
                this.mBluetoothScoStarted = false;
            }
        } else if (this.mDefaultAudioMode >= 0) {
            this.mAudioManager.setMode(this.mDefaultAudioMode);
            this.mDefaultAudioMode = -1;
        }
        this.notifyVoiceSwitchedToHeadsetOrEarSpeaker(false);
    }

    public boolean isBluetoothHeadsetStarted() {
        return this.isBluetoothScoSupported() && this.mBluetoothScoStarted || !this.isBluetoothScoSupported() && this.mDefaultAudioMode >= 0;
    }

    private boolean isBluetoothScoSupported() {
        return VoiceEngineCompat.isBluetoothScoSupported();
    }

    public void setMuteOnEntry(boolean bOn) {
        this.setMuteOnEntryImpl(this.mNativeHandle, bOn);
    }

    public boolean isMuteOnEntryOn() {
        return this.isMuteOnEntryOnImpl(this.mNativeHandle);
    }

    public void unSelectMicrophone() {
        this.unSelectMicrophoneImpl(this.mNativeHandle);
    }

    public boolean selectDefaultMicrophone(boolean bFromUI) {
        return this.selectDefaultMicrophoneImpl(this.mNativeHandle, bFromUI);
    }

    public boolean setMutebySelfFlag(boolean bOn) {
        return this.setMutebySelfFlagImpl(this.mNativeHandle, bOn);
    }

    private native boolean startAudioImpl(long var1);

    private native boolean stopAudioImpl(long var1);

    private native boolean startVoIPImpl(long var1);

    private native boolean stopVoIPImpl(long var1);

    private native int getAudioSessionTypeImpl(long var1);

    private native boolean turnOnOffAudioSessionImpl(long var1, boolean var3);

    private native int setLoudSpeakerStatusImpl(long var1, boolean var3);

    private native boolean getLoudSpeakerStatusImpl(long var1);

    private native int startPlayoutImpl(long var1);

    private native int stopPlayoutImpl(long var1);

    private native boolean notifyHeadsetStatusChangedImpl(long var1, boolean var3);

    private native boolean notifyVolumeChangedImpl(long var1, boolean var3, int var4);

    private native boolean notifyChipAECEnabledImpl(long var1, boolean var3);

    private native boolean notifyIsTabletImpl(long var1, boolean var3);

    private native void setMuteOnEntryImpl(long var1, boolean var3);

    private native boolean isMuteOnEntryOnImpl(long var1);

    private native boolean setMutebySelfFlagImpl(long var1, boolean var3);

    private native void unSelectMicrophoneImpl(long var1);

    private native boolean selectDefaultMicrophoneImpl(long var1, boolean var3);
}

