/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.box;

import android.content.Context;
import android.content.SharedPreferences;
import com.zipow.videobox.box.Box;
import com.zipow.videobox.util.ZMAuthUtil;
import us.zoom.androidlib.util.StringUtil;

public class BoxMgr
implements Box.BoxChangeListener {
    public static final String ROOT_FOLDER_ID = "0";
    private static BoxMgr INSTANCE = null;
    private static final String ZOOM_BOX_APP_REDIRECT_URL = "http://localhost";
    private static final String BOX_PREFERENCE_NAME = "box_preference_name";
    private static final String BOX_APP_KEY = "box_app_key";
    private static final String BOX_APP_SECRET = "box_app_secret";
    private static final String BOX_APP_REDIRECT_URL = "box_app_redirect_url";
    private static String mAppKey;
    private static String mAppSecret;
    private static String mAppRedirectUrl;
    private Box mBox;

    public static synchronized BoxMgr getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BoxMgr();
        }
        return INSTANCE;
    }

    public static synchronized void release() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    private void close() {
        if (this.mBox != null) {
            this.mBox.logout();
        }
    }

    public static boolean setAppKeyPair(Context context, String appKey, String appSecret, String redirectUrl) {
        if (context == null) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)appSecret) || StringUtil.isEmptyOrNull((String)appKey)) {
            mAppKey = null;
            mAppSecret = null;
            mAppRedirectUrl = null;
            SharedPreferences prefs = context.getSharedPreferences(BOX_PREFERENCE_NAME, 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.clear();
            editor.commit();
            return false;
        }
        mAppKey = appKey;
        mAppSecret = appSecret;
        mAppRedirectUrl = redirectUrl;
        SharedPreferences prefs = context.getSharedPreferences(BOX_PREFERENCE_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(BOX_APP_KEY, appKey);
        editor.putString(BOX_APP_SECRET, appSecret);
        editor.putString(BOX_APP_REDIRECT_URL, redirectUrl);
        editor.commit();
        return true;
    }

    public static String getAppKey(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return ZMAuthUtil.getBoxkey();
        }
        if (mAppKey == null) {
            SharedPreferences prefs = context.getSharedPreferences(BOX_PREFERENCE_NAME, 0);
            mAppKey = prefs.getString(BOX_APP_KEY, null);
        }
        return mAppKey;
    }

    public static String getAppRedirectUrl(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return ZOOM_BOX_APP_REDIRECT_URL;
        }
        if (mAppRedirectUrl == null) {
            SharedPreferences prefs = context.getSharedPreferences(BOX_PREFERENCE_NAME, 0);
            mAppRedirectUrl = prefs.getString(BOX_APP_REDIRECT_URL, null);
        }
        return mAppRedirectUrl;
    }

    public static String getAppSecret(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return ZMAuthUtil.getBoxSecret();
        }
        if (mAppSecret == null) {
            SharedPreferences prefs = context.getSharedPreferences(BOX_PREFERENCE_NAME, 0);
            mAppSecret = prefs.getString(BOX_APP_SECRET, null);
        }
        return mAppSecret;
    }

    public Box getBox() {
        if (this.mBox == null) {
            this.mBox = new Box(this);
        }
        return this.mBox;
    }

    @Override
    public void onLogout(Box box) {
        if (this.mBox == box) {
            this.mBox = null;
        }
    }
}

