/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.box;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.box.Box;
import com.zipow.videobox.box.BoxAsyncDownloadFile;
import com.zipow.videobox.box.BoxAsyncLoadFolder;
import com.zipow.videobox.box.BoxFileListEntry;
import com.zipow.videobox.box.BoxFileObject;
import com.zipow.videobox.box.BoxMgr;
import com.zipow.videobox.box.IBoxFileDownloadListener;
import com.zipow.videobox.box.IBoxLoadFolderListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFileListBaseAdapter;
import us.zoom.androidlib.app.ZMFileListEntry;
import us.zoom.androidlib.app.ZMFileListListener;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class BoxFileListAdapter
extends ZMFileListBaseAdapter
implements Box.BoxListener {
    private ZMFileListListener mListener;
    private Box mBox;
    private String mCurrentDir;
    private HashMap<String, BoxFileObject> mDirCached = new HashMap();
    private String mCachedDir;
    private IBoxLoadFolderListener mLoadFolderListener = new IBoxLoadFolderListener(){

        @Override
        public void onCompeleted(BoxAsyncLoadFolder task, boolean byPath, String dirPath, BoxFileObject dirObj, List<BoxFileObject> contents) {
            BoxFileListAdapter.this.dismissWaitingDialog();
            BoxFileListAdapter.this.mBox.loadFolderTaskCompeleted(task);
            if (byPath) {
                BoxFileListAdapter.this.mCurrentDir = dirPath;
            } else if (dirObj == null) {
                BoxFileListAdapter.this.mCurrentDir = File.separator;
            } else {
                BoxFileListAdapter.this.mCurrentDir = dirObj.getPath();
                BoxFileListAdapter.this.mDirCached.put(dirPath, dirObj);
            }
            BoxFileListAdapter.this.mFileList.clear();
            for (BoxFileObject obj : contents) {
                if (obj == null || !obj.isDir() && !BoxFileListAdapter.this.acceptFileType(obj.getPath())) continue;
                BoxFileListEntry entry = new BoxFileListEntry(obj, dirObj);
                BoxFileListAdapter.this.mFileList.add(entry);
            }
            BoxFileListAdapter.this.sortFileList();
            BoxFileListAdapter.this.notifyDataSetChanged();
            if (BoxFileListAdapter.this.mListener != null) {
                BoxFileListAdapter.this.mListener.onRefresh();
            }
        }

        @Override
        public void onError(BoxAsyncLoadFolder task, String path, Exception e) {
            BoxFileListAdapter.this.dismissWaitingDialog();
            BoxFileListAdapter.this.mBox.loadFolderTaskCompeleted(task);
            if (BoxFileListAdapter.this.mListener != null) {
                String message;
                String string2 = message = e == null ? null : e.getMessage();
                if (StringUtil.isEmptyOrNull((String)message)) {
                    message = BoxFileListAdapter.this.mActivity.getString(R.string.zm_msg_load_dir_fail, new Object[]{path});
                }
                BoxFileListAdapter.this.mListener.onOpenDirFailed(message);
            }
        }

        @Override
        public void onCancel(BoxAsyncLoadFolder task, String path) {
            BoxFileListAdapter.this.dismissWaitingDialog();
            BoxFileListAdapter.this.mBox.loadFolderTaskCompeleted(task);
        }
    };
    private IBoxFileDownloadListener mFileDownloadListener = new IBoxFileDownloadListener(){

        @Override
        public void onDownloadFileCompeleted(BoxAsyncDownloadFile task, BoxFileObject file, String outPath) {
            BoxFileListAdapter.this.dismissWaitingDialog();
            BoxFileListAdapter.this.mBox.downloadFileTaskCompeleted(task);
            if (BoxFileListAdapter.this.mListener != null) {
                BoxFileListAdapter.this.mListener.onSelectedFile(outPath, file.getName());
            }
        }

        @Override
        public void onError(BoxAsyncDownloadFile task, BoxFileObject file, Exception e) {
            BoxFileListAdapter.this.dismissWaitingDialog();
            BoxFileListAdapter.this.mBox.downloadFileTaskCompeleted(task);
            if (file == null) {
                return;
            }
            if (BoxFileListAdapter.this.mListener != null) {
                String message = e != null ? e.getMessage() : BoxFileListAdapter.this.mActivity.getString(R.string.zm_msg_load_file_fail, new Object[]{file.getPath()});
                BoxFileListAdapter.this.mListener.onOpenFileFailed(message);
            }
        }

        @Override
        public void onCancel(BoxAsyncDownloadFile task, BoxFileObject file) {
            BoxFileListAdapter.this.dismissWaitingDialog();
            BoxFileListAdapter.this.mBox.downloadFileTaskCompeleted(task);
        }

        @Override
        public void onProgress(BoxAsyncDownloadFile task, BoxFileObject file, long totalSize, long readBytes) {
            if (totalSize > 0L) {
                long progress = readBytes * 100L / totalSize;
                BoxFileListAdapter.this.updateProgressWaitingDialog(BoxFileListAdapter.this.mActivity.getString(R.string.zm_msg_download_file_progress, new Object[]{progress}));
            } else {
                BoxFileListAdapter.this.updateProgressWaitingDialog(BoxFileListAdapter.this.mActivity.getString(R.string.zm_msg_download_file_size, new Object[]{FileUtils.toFileSizeString((Context)BoxFileListAdapter.this.mActivity, (long)readBytes)}));
            }
        }
    };
    private DialogInterface.OnCancelListener mWaitingDialogCancelListener = new DialogInterface.OnCancelListener(){

        public void onCancel(DialogInterface dialog) {
            BoxFileListAdapter.this.mBox.cancel();
        }
    };

    public void init(ZMActivity activity, ZMFileListListener l) {
        super.init(activity, l);
        this.mListener = l;
        this.mCachedDir = AppUtil.getCachePath();
        this.mBox = BoxMgr.getInstance().getBox();
        this.mBox.setListener(this);
    }

    public void login() {
        if (!this.mBox.hasAuthenticated()) {
            this.mBox.login(this.mActivity);
            if (this.mListener != null) {
                this.mListener.onStarting();
            }
        } else if (this.mListener != null) {
            this.mListener.onStarted(true, null);
        }
    }

    public void logout() {
        this.mBox.logout();
    }

    public void onDestroy() {
        if (this.mActivity.isFinishing()) {
            this.mBox.stopAuth(this.mActivity);
        }
    }

    public void onResume() {
        this.login();
    }

    public void onPause() {
        this.cancel();
    }

    public boolean isNeedAuth() {
        return true;
    }

    public boolean onBackPressed() {
        this.cancel();
        return super.onBackPressed();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mBox.handleActivityResult(requestCode, resultCode, data);
    }

    public boolean openDir(String dir) {
        boolean ret;
        if (StringUtil.isEmptyOrNull((String)dir)) {
            dir = File.separator;
        }
        BoxFileObject obj = null;
        if (this.mDirCached.containsKey(dir)) {
            obj = this.mDirCached.get(dir);
        }
        if (ret = obj == null ? this.mBox.asyncLoadDir(dir, this.mLoadFolderListener) : this.mBox.asyncLoadDir(obj, this.mLoadFolderListener)) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
        return true;
    }

    protected void openDir(ZMFileListEntry dir) {
        if (dir == null || !dir.isDir()) {
            return;
        }
        if (!(dir instanceof BoxFileListEntry)) {
            return;
        }
        BoxFileListEntry entry = (BoxFileListEntry)dir;
        BoxFileObject folderObj = entry.getObject();
        if (folderObj == null) {
            return;
        }
        boolean ret = this.mBox.asyncLoadDir(folderObj, this.mLoadFolderListener);
        if (ret) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
    }

    protected void openFile(ZMFileListEntry file) {
        if (file == null || file.isDir()) {
            return;
        }
        long size = file.getBytes();
        if (size <= 0L) {
            size = 0x3200000L;
        }
        if (!AppUtil.hasEnoughDiskSpace(this.mCachedDir, size)) {
            this.alertMemoryNotEnough(this.mActivity.getString(R.string.zm_title_error), this.mActivity.getString(R.string.zm_msg_memory_size_insufficient));
            return;
        }
        if (!(file instanceof BoxFileListEntry)) {
            return;
        }
        BoxFileObject fileObj = ((BoxFileListEntry)file).getObject();
        if (fileObj == null) {
            return;
        }
        if (!this.acceptFileType(fileObj.getPath())) {
            return;
        }
        boolean ret = this.mBox.asyncDownloadFile(fileObj, this.mCachedDir, this.mFileDownloadListener);
        if (ret) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_download_file_progress, new Object[]{0}), this.mWaitingDialogCancelListener);
        }
    }

    public boolean isRootDir() {
        return this.mCurrentDir == null || this.mCurrentDir.equals(File.separator);
    }

    public String getCurrentDirName() {
        if (StringUtil.isEmptyOrNull((String)this.mCurrentDir)) {
            return "";
        }
        return AndroidAppUtil.getPathLastName((String)this.mCurrentDir);
    }

    public String getCurrentDirPath() {
        if (StringUtil.isEmptyOrNull((String)this.mCurrentDir)) {
            return "";
        }
        return this.mCurrentDir;
    }

    protected void gotoParentDir() {
        boolean ret;
        int last;
        if (this.isRootDir() || this.mCurrentDir == null) {
            return;
        }
        if (!this.mBox.hasAuthenticated()) {
            return;
        }
        StringBuilder builder = new StringBuilder(this.getCurrentDirPath());
        String dir = builder.toString();
        if (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.lastIndexOf(File.separator));
        }
        if ((dir = dir.substring(0, (last = dir.lastIndexOf(File.separator)) + 1)).equals(this.getCurrentDirName())) {
            return;
        }
        if (!dir.equals(File.separator) && dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        BoxFileObject obj = null;
        if (this.mDirCached.containsKey(dir)) {
            obj = this.mDirCached.get(dir);
        }
        if (ret = obj == null ? this.mBox.asyncLoadDir(dir, this.mLoadFolderListener) : this.mBox.asyncLoadDir(obj, this.mLoadFolderListener)) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
    }

    @Override
    public void onAuthStarting() {
        if (this.mListener != null) {
            this.mListener.onStarting();
        }
    }

    @Override
    public void onAuthSuccess() {
        if (this.mListener != null) {
            this.mListener.onStarted(true, null);
        }
    }

    @Override
    public void onAuthError(String errMsg) {
        if (this.mListener != null) {
            if (StringUtil.isEmptyOrNull((String)errMsg)) {
                this.mListener.onStarted(false, this.mActivity.getString(R.string.zm_alert_auth_token_failed_msg));
            } else {
                this.mListener.onStarted(false, errMsg);
            }
        }
    }

    @Override
    public void onAuthUnknowError() {
        if (this.mListener != null) {
            this.mListener.onStarted(false, this.mActivity.getString(R.string.zm_alert_auth_token_failed_msg));
        }
    }

    private void cancel() {
        this.mBox.cancel();
    }
}

