/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.box;

import com.box.androidsdk.content.BoxApiFile;
import com.box.androidsdk.content.listeners.ProgressListener;
import com.box.androidsdk.content.requests.BoxRequestsFile;
import com.zipow.videobox.box.BoxFileObject;
import com.zipow.videobox.box.IBoxFileDownloadListener;
import java.io.File;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncTask;

public class BoxAsyncDownloadFile
extends ZMAsyncTask<Void, Long, Runnable> {
    private BoxApiFile mApiFile;
    private BoxFileObject mFile;
    private String mOutPath;
    private Exception mException;
    private IBoxFileDownloadListener mListener;
    private long mFileSize;

    public BoxAsyncDownloadFile(BoxApiFile apiFile, BoxFileObject file, String out, IBoxFileDownloadListener l) {
        this.mApiFile = apiFile;
        this.mFile = file;
        this.mOutPath = out;
        this.mListener = l;
        if (this.mFile != null) {
            this.mFileSize = this.mFile.getSize();
        }
    }

    protected Runnable doInBackground(Void ... params) {
        this.mException = null;
        if (this.mApiFile == null || this.mFile == null || !this.mFile.isFileObject() || this.mFile.isDir() || StringUtil.isEmptyOrNull((String)this.mOutPath)) {
            this.mException = null;
            return new onErrorRunnable();
        }
        File outFile = new File(this.mOutPath);
        if (this.isCancelled()) {
            return new onCancelRunnable();
        }
        try {
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            BoxRequestsFile.DownloadFile downFile = this.mApiFile.getDownloadRequest(outFile, this.mFile.getId());
            downFile.setProgressListener(new ProgressListener(){

                public void onProgressChanged(long numBytes, long totalBytes) {
                    BoxAsyncDownloadFile.this.publishProgress(new Long[]{numBytes});
                }
            });
            downFile.send();
        }
        catch (Exception e) {
            if (this.isCancelled()) {
                return new onCancelRunnable();
            }
            this.mException = e;
            return new onErrorRunnable();
        }
        if (this.isCancelled()) {
            return new onCancelRunnable();
        }
        return new onCompletedRunnable();
    }

    protected void onPostExecute(Runnable result) {
        result.run();
    }

    protected void onProgressUpdate(Long ... values) {
        long readBytes = values[0];
        if (this.mListener != null) {
            this.mListener.onProgress(this, this.mFile, this.mFileSize, readBytes);
        }
    }

    private class onCancelRunnable
    implements Runnable {
        private onCancelRunnable() {
        }

        @Override
        public void run() {
            if (BoxAsyncDownloadFile.this.mListener != null) {
                BoxAsyncDownloadFile.this.mListener.onCancel(BoxAsyncDownloadFile.this, BoxAsyncDownloadFile.this.mFile);
            }
        }
    }

    private class onErrorRunnable
    implements Runnable {
        private onErrorRunnable() {
        }

        @Override
        public void run() {
            if (BoxAsyncDownloadFile.this.mListener != null) {
                BoxAsyncDownloadFile.this.mListener.onError(BoxAsyncDownloadFile.this, BoxAsyncDownloadFile.this.mFile, BoxAsyncDownloadFile.this.mException);
            }
        }
    }

    private class onCompletedRunnable
    implements Runnable {
        private onCompletedRunnable() {
        }

        @Override
        public void run() {
            if (BoxAsyncDownloadFile.this.mListener != null) {
                BoxAsyncDownloadFile.this.mListener.onDownloadFileCompeleted(BoxAsyncDownloadFile.this, BoxAsyncDownloadFile.this.mFile, BoxAsyncDownloadFile.this.mOutPath);
            }
        }
    }
}

