/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.box;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import com.box.androidsdk.content.BoxApiFile;
import com.box.androidsdk.content.BoxApiFolder;
import com.box.androidsdk.content.BoxConfig;
import com.box.androidsdk.content.auth.BoxAuthentication;
import com.box.androidsdk.content.models.BoxSession;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.box.BoxAsyncDownloadFile;
import com.zipow.videobox.box.BoxAsyncLoadFolder;
import com.zipow.videobox.box.BoxFileObject;
import com.zipow.videobox.box.BoxMgr;
import com.zipow.videobox.box.IBoxFileDownloadListener;
import com.zipow.videobox.box.IBoxLoadFolderListener;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;

public class Box
implements BoxAuthentication.AuthListener {
    private static final int BOX_AUTHENTICATE_REQUEST = 9000;
    private BoxChangeListener mChangeListener;
    private BoxSession mBoxSession;
    private BoxApiFolder mFolderApi;
    private BoxApiFile mFileApi;
    private String mAuthKey;
    private String mAuthSecret;
    private String mAuthRedirectUrl;
    private BoxListener mListener;
    private List<BoxAsyncDownloadFile> mFileDownloadTasks = new ArrayList<BoxAsyncDownloadFile>();
    private List<BoxAsyncLoadFolder> mLoadFolderTasks = new ArrayList<BoxAsyncLoadFolder>();
    private Handler mHandler;

    public Box(BoxChangeListener l) {
        this.mChangeListener = l;
        this.mHandler = new Handler();
    }

    public void setListener(BoxListener l) {
        this.mListener = l;
    }

    public void login(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        this.startAuth(activity);
    }

    public void logout() {
        if (this.mBoxSession != null) {
            this.mBoxSession.logout();
        }
        this.mBoxSession = null;
        this.mAuthKey = null;
        this.mAuthSecret = null;
        this.mFolderApi = null;
        this.mFileApi = null;
    }

    public void stopAuth(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        activity.finishActivity(9000);
    }

    public boolean cancel() {
        for (BoxAsyncLoadFolder task : this.mLoadFolderTasks) {
            task.cancel(true);
        }
        this.mLoadFolderTasks.clear();
        for (BoxAsyncDownloadFile filetask : this.mFileDownloadTasks) {
            filetask.cancel(true);
        }
        this.mFileDownloadTasks.clear();
        return true;
    }

    public boolean asyncDownloadFile(BoxFileObject file, String outPath, IBoxFileDownloadListener l) {
        if (!this.hasAuthenticated() || file == null || !file.isFileObject() || file.isDir() || StringUtil.isEmptyOrNull((String)outPath)) {
            return false;
        }
        String outfilePath = AppUtil.getShareCachePathByExtension(outPath, file.getName());
        BoxAsyncDownloadFile task = new BoxAsyncDownloadFile(this.mFileApi, file, outfilePath, l);
        this.mFileDownloadTasks.add(task);
        task.execute(new Void[0]);
        return true;
    }

    public boolean asyncLoadDir(BoxFileObject folder, IBoxLoadFolderListener l) {
        if (!(this.hasAuthenticated() && folder != null && folder.isFileObject() && folder.isDir())) {
            return false;
        }
        if (this.checkFolderTask(folder.getPath())) {
            return false;
        }
        BoxAsyncLoadFolder task = new BoxAsyncLoadFolder(this.mFolderApi, folder, l);
        this.mLoadFolderTasks.add(task);
        task.execute(new Void[0]);
        return true;
    }

    public boolean asyncLoadDir(String path, IBoxLoadFolderListener l) {
        if (!this.hasAuthenticated() || StringUtil.isEmptyOrNull((String)path)) {
            return false;
        }
        if (this.checkFolderTask(path)) {
            return false;
        }
        BoxAsyncLoadFolder task = new BoxAsyncLoadFolder(this.mFolderApi, path, l);
        this.mLoadFolderTasks.add(task);
        task.execute(new Void[0]);
        return true;
    }

    private boolean checkFolderTask(String path) {
        if (StringUtil.isEmptyOrNull((String)path)) {
            return false;
        }
        for (BoxAsyncLoadFolder task : this.mLoadFolderTasks) {
            if (task.isCancelled() || !path.equals(task.getPath())) continue;
            return true;
        }
        return false;
    }

    public void loadFolderTaskCompeleted(BoxAsyncLoadFolder task) {
        if (task == null) {
            return;
        }
        this.mLoadFolderTasks.remove((Object)task);
    }

    public void downloadFileTaskCompeleted(BoxAsyncDownloadFile task) {
        if (task == null) {
            return;
        }
        this.mFileDownloadTasks.remove((Object)task);
    }

    private void startAuth(ZMActivity activity) {
        this.mAuthKey = BoxMgr.getAppKey((Context)activity);
        this.mAuthSecret = BoxMgr.getAppSecret((Context)activity);
        this.mAuthRedirectUrl = BoxMgr.getAppRedirectUrl((Context)activity);
        if (StringUtil.isEmptyOrNull((String)this.mAuthKey) || StringUtil.isEmptyOrNull((String)this.mAuthSecret) || StringUtil.isEmptyOrNull((String)this.mAuthRedirectUrl)) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onAuthStarting();
        }
        BoxConfig.CLIENT_ID = this.mAuthKey;
        BoxConfig.CLIENT_SECRET = this.mAuthSecret;
        BoxConfig.REDIRECT_URL = this.mAuthRedirectUrl;
        this.mBoxSession = new BoxSession((Context)activity);
        this.mBoxSession.setSessionAuthListener((BoxAuthentication.AuthListener)this);
        this.mBoxSession.authenticate();
    }

    public boolean hasAuthenticated() {
        if (this.mBoxSession == null) {
            return false;
        }
        return this.mFileApi != null && this.mFolderApi != null;
    }

    public void handleActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void onRefreshed(BoxAuthentication.BoxAuthenticationInfo info) {
        this.mFolderApi = new BoxApiFolder(this.mBoxSession);
        this.mFileApi = new BoxApiFile(this.mBoxSession);
    }

    public void onAuthCreated(BoxAuthentication.BoxAuthenticationInfo info) {
        this.mFolderApi = new BoxApiFolder(this.mBoxSession);
        this.mFileApi = new BoxApiFile(this.mBoxSession);
        if (this.mListener != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Box.this.mListener.onAuthSuccess();
                }
            });
        }
    }

    public void onAuthFailure(BoxAuthentication.BoxAuthenticationInfo info, Exception ex) {
        this.mFileApi = null;
        this.mFolderApi = null;
        if (this.mListener != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Box.this.mListener.onAuthError(null);
                }
            });
        }
        if (this.mBoxSession != null) {
            this.mBoxSession.logout();
            this.mBoxSession = null;
        }
    }

    public void onLoggedOut(BoxAuthentication.BoxAuthenticationInfo info, Exception ex) {
        this.mFileApi = null;
        this.mFolderApi = null;
        if (this.mChangeListener != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Box.this.mChangeListener.onLogout(Box.this);
                }
            });
        }
    }

    public static interface BoxListener {
        public void onAuthStarting();

        public void onAuthSuccess();

        public void onAuthError(String var1);

        public void onAuthUnknowError();
    }

    public static interface BoxChangeListener {
        public void onLogout(Box var1);
    }
}

