/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.Button;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.JoinConfActivity;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.MMShareActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.dialog.DialogActionCallBack;
import com.zipow.videobox.dialog.ZMGDPRConfirmDialog;
import com.zipow.videobox.fragment.JoinConfFragment;
import com.zipow.videobox.fragment.SettingFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.LogoutHandler;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.util.LoginUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.LoginView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;
import us.zoom.videomeetings.ZMBuildConfig;

public class WelcomeActivity
extends ZMActivity
implements PTUI.IPTUIListener,
View.OnClickListener,
PTUI.IGDPRListener,
DialogActionCallBack {
    private static final String TAG = WelcomeActivity.class.getSimpleName();
    private static final String ARG_AUTO_LOGIN = "autoLogin";
    private static final String ARG_ACTION_FOR_IM_ACTIVITY = "actionForIMActivity";
    private static final String ARG_EXTRAS_FOR_IM_ACTIVITY = "extrasForIMActivity";
    private static final String ARG_IS_SHOWN_FOR_ACTION_SEND = "isShownForActionSend";
    private static final String ARG_ACTION_SEND_INTENT = LauncherActivity.class.getName() + ".extra.ACTION_SEND_INTENT";
    private static final int REQUEST_DIALOG_GDPR = 1000;
    private Button mBtnLogin;
    private Button mBtnJoinConf;
    private Button mBtnReturnToConf;
    private View mBtnSignup;
    private View mBtnLoginInternational;
    private View mPanelConnecting;
    private View mPanelActions;
    private View mBtnSettings;
    private boolean mLoginFailed = false;
    private boolean mbNeedBlockNextTimeAutoLogin = false;
    private boolean mNewVersionReady = false;
    private static WelcomeActivity sCurrentInstance = null;

    public static WelcomeActivity getCurrentInstance() {
        return sCurrentInstance;
    }

    public static void show(Context context, boolean reorderToFront, boolean autoLogin) {
        WelcomeActivity.show(context, reorderToFront, autoLogin, null, null);
    }

    public static void show(Context context, boolean reorderToFront, boolean autoLogin, String actionForIMActivity, Bundle extrasForIMActivity) {
        if (context == null) {
            return;
        }
        Intent i = new Intent(context, WelcomeActivity.class);
        if (!(context instanceof Activity)) {
            i.addFlags(0x10000000);
        }
        if (reorderToFront) {
            i.addFlags(131072);
        }
        i.putExtra(ARG_AUTO_LOGIN, autoLogin);
        i.putExtra(ARG_ACTION_FOR_IM_ACTIVITY, actionForIMActivity);
        i.putExtra(ARG_EXTRAS_FOR_IM_ACTIVITY, extrasForIMActivity);
        context.startActivity(i);
    }

    public static void showForActionSend(Context context, Intent actionSendIntent) {
        if (context == null) {
            return;
        }
        Intent i = new Intent(context, WelcomeActivity.class);
        if (!(context instanceof Activity)) {
            i.addFlags(0x10000000);
        }
        i.putExtra(ARG_AUTO_LOGIN, true);
        i.putExtra(ARG_IS_SHOWN_FOR_ACTION_SEND, true);
        i.putExtra(ARG_ACTION_SEND_INTENT, (Parcelable)actionSendIntent);
        context.startActivity(i);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.disableFinishActivityByGesture(true);
        if (UIUtil.getDisplayMinWidthInDip((Context)this) < 500.0f) {
            this.setRequestedOrientation(1);
        }
        if (PTApp.getInstance().isWebSignedOn()) {
            IMActivity.show((Context)this);
            this.finish();
            return;
        }
        this.setContentView(R.layout.zm_welcome);
        this.mBtnLogin = (Button)this.findViewById(R.id.btnLogin);
        this.mBtnJoinConf = (Button)this.findViewById(R.id.btnJoinConf);
        this.mBtnReturnToConf = (Button)this.findViewById(R.id.btnReturnToConf);
        this.mBtnLoginInternational = this.findViewById(R.id.loginInternational);
        this.mPanelConnecting = this.findViewById(R.id.panelConnecting);
        this.mPanelActions = this.findViewById(R.id.panelActions);
        this.mBtnSignup = this.findViewById(R.id.btnSignup);
        this.mBtnSettings = this.findViewById(R.id.btnSettings);
        this.mPanelActions.setVisibility(8);
        this.mPanelConnecting.setVisibility(8);
        this.mBtnLogin.setOnClickListener((View.OnClickListener)this);
        this.mBtnJoinConf.setOnClickListener((View.OnClickListener)this);
        this.mBtnReturnToConf.setOnClickListener((View.OnClickListener)this);
        this.mBtnSettings.setOnClickListener((View.OnClickListener)this);
        if (this.mBtnSignup != null) {
            this.mBtnSignup.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mBtnLoginInternational != null) {
            this.mBtnLoginInternational.setOnClickListener((View.OnClickListener)this);
        }
        PTUI.getInstance().addPTUIListener(this);
        PTUI.getInstance().addGDPRListener(this);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null) {
            this.finish();
            return;
        }
        if (!mainboard.isInitialized()) {
            this.showLauncherActivity();
        }
        if (PTApp.getInstance().isWebSignedOn()) {
            this.showMainActivityAfterLogin();
            return;
        }
        if (savedInstanceState == null) {
            this.checkAutoLogin();
        } else {
            this.mLoginFailed = savedInstanceState.getBoolean("mLoginFailed", this.mLoginFailed);
        }
    }

    public void checkAutoLogin() {
        boolean autoLogin;
        Intent intent = this.getIntent();
        if (intent != null && (autoLogin = intent.getBooleanExtra(ARG_AUTO_LOGIN, true)) && PTApp.getInstance().getPTLoginType() != 102 && PTApp.getInstance().getPTLoginType() != 97) {
            this.autoLogin();
        }
        if (PTUI.getInstance().NeedGDPRConfirm()) {
            this.showConnecting(false);
        } else {
            this.showConnecting(PTApp.getInstance().isAuthenticating());
        }
        this.updateButtons();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("mLoginFailed", this.mLoginFailed);
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this);
        PTUI.getInstance().removeGDPRListener(this);
        sCurrentInstance = null;
    }

    public void onResume() {
        super.onResume();
        sCurrentInstance = this;
        if (PTApp.getInstance().isWebSignedOn()) {
            this.showMainActivityAfterLogin();
        } else {
            this.checkAutoLogin();
        }
    }

    private void updateButtons() {
        if (PTApp.getInstance().hasActiveCall() && VideoBoxApplication.getInstance().isConfProcessRunning()) {
            this.mBtnJoinConf.setVisibility(8);
            this.mBtnReturnToConf.setVisibility(0);
        } else {
            this.mBtnJoinConf.setVisibility(0);
            this.mBtnReturnToConf.setVisibility(8);
        }
        if (ZMBuildConfig.BUILD_TARGET == 0) {
            if (this.getDefaultVendor() == 1) {
                if (this.mBtnSignup != null) {
                    this.mBtnSignup.setVisibility(8);
                }
                if (this.mBtnLoginInternational != null) {
                    this.mBtnLoginInternational.setVisibility(0);
                }
            } else {
                if (this.mBtnSignup != null) {
                    this.mBtnSignup.setVisibility(0);
                }
                if (this.mBtnLoginInternational != null) {
                    this.mBtnLoginInternational.setVisibility(8);
                }
            }
        }
    }

    private void showLauncherActivity() {
        LauncherActivity.showLauncherActivity(this);
        this.finish();
    }

    private boolean needBlockNextTimeAutoLogin() {
        return this.mbNeedBlockNextTimeAutoLogin;
    }

    public void setNeedBlockNextTimeAutoLogin(boolean b) {
        this.mbNeedBlockNextTimeAutoLogin = b;
    }

    private void autoLogin() {
        if (!this.needBlockNextTimeAutoLogin() && PTApp.getInstance().autoSignin()) {
            this.showConnecting(true);
        }
        this.setNeedBlockNextTimeAutoLogin(false);
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 22: {
                this.sinkCallStatusChanged(result);
                break;
            }
            case 35: {
                this.sinkWebAccessFail();
                break;
            }
            case 0: {
                this.sinkWebLogin(result);
                break;
            }
            case 25: {
                this.sinkNewVersionReady();
            }
        }
    }

    public void sinkNewVersionReady() {
        this.mNewVersionReady = true;
    }

    public void sinkWebLogin(final long result) {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkWebLogin", new EventAction("sinkWebLogin"){

            public void run(IUIElement ui) {
                ((WelcomeActivity)ui).handleOnWebLogin(result);
            }
        });
    }

    private void handleOnWebLogin(long result) {
        this.onWebLogin(result);
    }

    private void sinkCallStatusChanged(final long result) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("handleOnCallStatusChanged"){

            public void run(IUIElement ui) {
                ((WelcomeActivity)ui).handleOnCallStatusChanged(result);
            }
        });
    }

    private void handleOnCallStatusChanged(long result) {
        this.onCallStatusChanged(result);
    }

    private void sinkWebAccessFail() {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkWebAccessFail", new EventAction("sinkWebAccessFail"){

            public void run(IUIElement ui) {
                ((WelcomeActivity)ui).handleOnWebAccessFail();
            }
        });
    }

    private void handleOnWebAccessFail() {
        this.onWebAccessFail();
    }

    private void onWebLogin(long result) {
        if (result == 0L) {
            this.showMainActivityAfterLogin();
            this.mLoginFailed = false;
        } else if (result == 1006L) {
            PTApp.getInstance().setRencentJid("");
            this.showConnecting(false);
            if (!this.mLoginFailed) {
                this.mLoginFailed = true;
                this.showLoginExpired();
            }
        } else {
            PTApp.getInstance().setRencentJid("");
            this.showConnecting(false);
            String message = this.getLoginErrorMessage(result);
            if (!this.mLoginFailed) {
                this.mLoginFailed = true;
                LoginView.AuthFailedDialog.show(this, message);
            }
        }
    }

    private void showMainActivityAfterLogin() {
        Intent intent = this.getIntent();
        if (intent != null) {
            boolean isShownForActionSend = intent.getBooleanExtra(ARG_IS_SHOWN_FOR_ACTION_SEND, false);
            Intent actionSendIntent = (Intent)intent.getParcelableExtra(ARG_ACTION_SEND_INTENT);
            if (isShownForActionSend && actionSendIntent != null) {
                Intent shareIntent = new Intent((Context)this, MMShareActivity.class);
                shareIntent.setAction(actionSendIntent.getAction());
                shareIntent.addCategory("android.intent.category.DEFAULT");
                shareIntent.setType(actionSendIntent.getType());
                shareIntent.putExtras(actionSendIntent);
                this.startActivity(shareIntent);
                this.finish();
                return;
            }
        }
        this.showIMActivity();
    }

    private void onCallStatusChanged(long result) {
        switch ((int)result) {
            case 1: 
            case 2: {
                this.mBtnJoinConf.setVisibility(8);
                this.mBtnReturnToConf.setVisibility(0);
                break;
            }
            default: {
                this.mBtnJoinConf.setVisibility(0);
                this.mBtnReturnToConf.setVisibility(8);
            }
        }
    }

    private String getLoginErrorMessage(long result) {
        switch ((int)result) {
            case 1000: 
            case 1001: 
            case 1002: {
                return this.getResources().getString(R.string.zm_alert_auth_zoom_failed_msg);
            }
            case 1006: {
                return this.getResources().getString(R.string.zm_alert_auth_token_failed_msg);
            }
            case 2006: {
                return this.getResources().getString(R.string.zm_rc_alert_meetings_feature_is_not_enabled);
            }
        }
        return this.getResources().getString(R.string.zm_alert_auth_error_code_msg, new Object[]{result});
    }

    public void onWebAccessFail() {
        this.showConnecting(false);
        int strId = R.string.zm_alert_connect_zoomus_failed_msg;
        if (!this.mLoginFailed && strId != 0) {
            this.mLoginFailed = true;
            String message = this.getResources().getString(strId);
            LoginView.AuthFailedDialog.show(this, message);
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
        if (connected && this.isActive()) {
            this.checkAutoLogin();
        }
    }

    public void onClick(View v) {
        if (v == this.mBtnLogin) {
            this.onClickBtnLogin();
            this.mLoginFailed = false;
        } else if (v == this.mBtnJoinConf) {
            this.onClickBtnJoinConf();
        } else if (v == this.mBtnReturnToConf) {
            this.onClickBtnReturnToConf();
        } else if (v == this.mBtnLoginInternational) {
            this.onClickBtnLoginInternational();
            this.mLoginFailed = false;
        } else if (v == this.mBtnSignup) {
            this.onClickBtnSignup();
        } else if (v == this.mBtnSettings) {
            this.onClickBtnSettings();
        }
    }

    private void onClickBtnSettings() {
        SettingFragment.showAsActivity(this, 0, false);
    }

    private int getDefaultVendor() {
        return LoginUtil.getDefaultVendor();
    }

    private void onClickBtnLogin() {
        this.showLoginUI(this.getDefaultVendor());
    }

    private void onClickBtnLoginInternational() {
        this.showLoginUI(0);
    }

    private void onClickBtnSignup() {
        if (ZMBuildConfig.BUILD_TARGET == 0) {
            UIUtil.openURL((Context)this, (String)(this.getZoomScheme() + "://client/signup"));
        } else {
            String url = PTApp.getInstance().getURLByType(6);
            if (!StringUtil.isEmptyOrNull((String)url)) {
                UIUtil.openURL((Context)this, (String)url);
            }
        }
    }

    private String getZoomScheme() {
        return this.getString(R.string.zm_zoom_scheme);
    }

    private void showLoginUI(int vendor) {
        if (LoginUtil.showLoginUI((Context)this, false, vendor)) {
            this.finish();
        }
    }

    private void showIMActivity() {
        String action = null;
        Bundle extras = null;
        Intent intent = this.getIntent();
        if (intent != null) {
            action = intent.getStringExtra(ARG_ACTION_FOR_IM_ACTIVITY);
            extras = intent.getBundleExtra(ARG_EXTRAS_FOR_IM_ACTIVITY);
        }
        if (this.mNewVersionReady) {
            if (extras == null) {
                extras = new Bundle();
            }
            extras.putBoolean("ARG_NEW_VERSIONS", true);
        }
        IMActivity.show((Context)this, false, action, extras);
        this.finish();
    }

    private void showConnecting(boolean connecting) {
        this.mPanelActions.setVisibility(connecting ? 8 : 0);
        this.mPanelConnecting.setVisibility(connecting ? 0 : 8);
    }

    private void onClickBtnJoinConf() {
        if (UIMgr.isLargeMode((Context)this)) {
            JoinConfFragment.showJoinByNumber(this.getSupportFragmentManager(), null, null);
        } else {
            JoinConfActivity.showJoinByNumber((Context)this, null, null);
        }
    }

    private void onClickBtnReturnToConf() {
        ConfActivity.returnToConf((Context)this);
    }

    private void showLoginExpired() {
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)this).setTitle(R.string.zm_msg_login_expired_title).setMessage(R.string.zm_msg_login_expired).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WelcomeActivity.this.showLoginUI(-999);
            }
        }).create();
        dlg.show();
    }

    @Override
    public void OnShowPrivacyDialog(String privacyUrl, String tosUrl) {
        this.showGDPRConfirmDialog(privacyUrl, tosUrl);
    }

    @Override
    public void NotifyUIToLogOut() {
        LogoutHandler.getInstance().startLogout();
        PTUI.getInstance().ClearGDPRConfirmFlag();
        this.showConnecting(false);
        this.setNeedBlockNextTimeAutoLogin(false);
    }

    private void showGDPRConfirmDialog(String privacyUrl, String tosUrl) {
        if (StringUtil.isEmptyOrNull((String)privacyUrl) || StringUtil.isEmptyOrNull((String)tosUrl)) {
            return;
        }
        ZMGDPRConfirmDialog.checkShowDialog(this, 1000, 1, tosUrl, privacyUrl);
    }

    @Override
    public void performDialogAction(int requestCode, int action, Bundle args) {
        if (requestCode == 1000) {
            if (action == -1) {
                PTUI.getInstance().ClearGDPRConfirmFlag();
                PTApp.getInstance().confirmGDPR(true);
            } else if (action == -2) {
                PTApp.getInstance().confirmGDPR(false);
            } else if (action == 1) {
                PTApp.getInstance().confirmGDPR(false);
                ZMGDPRConfirmDialog.dismiss(this.getSupportFragmentManager());
            }
        }
    }
}

