/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.zipow.videobox.fragment.ScheduleFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.videomeetings.R;

public class ScheduleActivity
extends ZMActivity {
    private static final String ARG_IS_EDIT_MEETING = "isEditMeeting";
    private static final String ARG_MEETING_ITEM = "meetingItem";
    public static final int REQUEST_SELECT_END_REPEAT = 100;

    public static void show(ZMActivity activity, int requestCode) {
        Intent intent = new Intent((Context)activity, ScheduleActivity.class);
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_bottom, R.anim.zm_fade_out);
    }

    public static void show(Fragment fragment, int requestCode) {
        if (fragment == null) {
            return;
        }
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, ScheduleActivity.class);
        fragment.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_bottom, R.anim.zm_fade_out);
    }

    public static void showEditMeeting(ZMActivity activity, int requestCode, ScheduledMeetingItem mi) {
        Intent intent = new Intent((Context)activity, ScheduleActivity.class);
        intent.putExtra(ARG_IS_EDIT_MEETING, true);
        intent.putExtra(ARG_MEETING_ITEM, (Serializable)mi);
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_bottom, R.anim.zm_fade_out);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_fade_in, R.anim.zm_slide_out_bottom);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            Intent intent = this.getIntent();
            boolean isEditMeeting = intent.getBooleanExtra(ARG_IS_EDIT_MEETING, false);
            ScheduledMeetingItem mi = (ScheduledMeetingItem)intent.getSerializableExtra(ARG_MEETING_ITEM);
            if (isEditMeeting) {
                ScheduleFragment.showEditMeetingInActivity(this, mi);
            } else {
                ScheduleFragment.showInActivity(this);
            }
        }
    }
}

