/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.ISIPService;
import com.zipow.videobox.PTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ZMBaseService;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.sip.client.AssistantAppClientMgr;
import com.zipow.videobox.sip.client.SIPIPCPort;

public class SIPService
extends ZMBaseService {
    private static final String TAG = SIPService.class.getSimpleName();
    private ServiceConnection mPTServiceConnection;
    private IPTService mPTService;
    public static final String ACTION_DEAMON = SIPService.class.getName() + ".ACTION_DEAMON";

    public IBinder onBind(Intent intent) {
        return new ServiceBinder();
    }

    @TargetApi(value=14)
    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        this.disconnectPTService();
        this.stopSelf();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        int ret = 2;
        if (intent == null) {
            return ret;
        }
        this.connectPTService();
        return ret;
    }

    @Override
    public void onCreate() {
        Mainboard mainboard;
        super.onCreate();
        VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
        if (videoBoxApplication == null) {
            VideoBoxApplication.initialize(this.getApplicationContext(), false, 3);
        }
        if ((mainboard = Mainboard.getMainboard()) == null || !mainboard.isInitialized()) {
            VideoBoxApplication.getInstance().initSipMainborad();
        }
        AssistantAppClientMgr.getInstance().onAssistantClientStart();
    }

    public void onDestroy() {
        AssistantAppClientMgr.getInstance().onAssistantClientStop();
        super.onDestroy();
        this.disconnectPTService();
        VideoBoxApplication.getInstance().killSipProcess();
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
    }

    private void connectPTService() {
        if (this.mPTServiceConnection == null) {
            this.mPTServiceConnection = new ServiceConnection(){

                public void onServiceConnected(ComponentName name, IBinder service) {
                    IPTService ptService = IPTService.Stub.asInterface(service);
                    SIPService.this.onPTServiceConnected(ptService);
                }

                public void onServiceDisconnected(ComponentName name) {
                    SIPService.this.onPTServiceDisconnected();
                }
            };
        }
        int flag = 0;
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), PTService.class.getName());
        this.bindService(i, this.mPTServiceConnection, flag);
    }

    private void disconnectPTService() {
        if (this.mPTServiceConnection != null) {
            try {
                this.unbindService(this.mPTServiceConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPTServiceConnection = null;
            this.mPTService = null;
        }
    }

    protected void onPTServiceConnected(IPTService service) {
        this.mPTService = service;
    }

    protected void onPTServiceDisconnected() {
        this.mPTService = null;
        Process.killProcess((int)Process.myPid());
    }

    private static class ServiceBinder
    extends ISIPService.Stub {
        @Override
        public void sendMessage(byte[] message) throws RemoteException {
            SIPIPCPort.getInstance().onMessageReceived(message);
        }

        @Override
        public boolean toggleSpeakerPhone(boolean on) throws RemoteException {
            return AssistantAppClientMgr.getInstance().toggleSpeakerPhone(on);
        }

        @Override
        public boolean isSpeakerPhoneOn() throws RemoteException {
            return AssistantAppClientMgr.getInstance().isSpeakerPhoneOn();
        }

        @Override
        public void startPlayout() throws RemoteException {
            AssistantAppClientMgr.getInstance().startPlayout();
        }

        @Override
        public void stopPlayout() throws RemoteException {
            AssistantAppClientMgr.getInstance().stopPlayout();
        }
    }
}

