/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.WelcomeActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.LoginView;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;
import us.zoom.videomeetings.ZMBuildConfig;

public class RCLoginActivity
extends ZMActivity
implements View.OnClickListener,
TextView.OnEditorActionListener,
PTUI.IPTUIListener {
    private static final String TAG = RCLoginActivity.class.getSimpleName();
    private Button mBtnBack;
    private Button mBtnLoginZoom;
    private Button mBtnSignup;
    private TextView mLinkForgetPassword;
    private EditText mEdtPhoneNumber;
    private EditText mEdtExtension;
    private EditText mEdtPsw;
    private View mOptionCountry;
    private TextView mTxtCountry;
    private boolean mIsCachedAccount = false;
    private boolean mLoginFailed = false;
    private int mSelectedCountry = 0;

    public static boolean show(Context context) {
        if (context == null) {
            return false;
        }
        Intent i = new Intent(context, RCLoginActivity.class);
        if (!(context instanceof Activity)) {
            i.addFlags(0x10000000);
        }
        context.startActivity(i);
        if (context instanceof Activity) {
            ((Activity)context).overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        }
        return true;
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (UIUtil.getDisplayMinWidthInDip((Context)this) < 500.0f) {
            this.setRequestedOrientation(1);
        }
        if (PTApp.getInstance().isWebSignedOn()) {
            IMActivity.show((Context)this);
            this.finish();
            return;
        }
        this.setContentView(R.layout.zm_rc_login);
        this.mBtnBack = (Button)this.findViewById(R.id.btnBack);
        this.mBtnLoginZoom = (Button)this.findViewById(R.id.btnLoginZoom);
        this.mBtnSignup = (Button)this.findViewById(R.id.btnSignup);
        this.mLinkForgetPassword = (TextView)this.findViewById(R.id.linkForgetPassword);
        this.mEdtPhoneNumber = (EditText)this.findViewById(R.id.edtPhoneNumber);
        this.mEdtExtension = (EditText)this.findViewById(R.id.edtExtension);
        this.mEdtPsw = (EditText)this.findViewById(R.id.edtPassword);
        this.mOptionCountry = this.findViewById(R.id.optionCountry);
        this.mTxtCountry = (TextView)this.findViewById(R.id.txtCountry);
        this.mEdtPsw.setImeOptions(2);
        this.mEdtPsw.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnLoginZoom.setOnClickListener((View.OnClickListener)this);
        if (this.mBtnSignup != null) {
            this.mBtnSignup.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mOptionCountry != null) {
            this.mOptionCountry.setOnClickListener((View.OnClickListener)this);
        }
        this.mLinkForgetPassword.setMovementMethod(LinkMovementMethod.getInstance());
        if (savedInstanceState == null) {
            this.loadCachedAccount();
            this.mSelectedCountry = this.getDefaultSelectedCountry();
        } else {
            this.mIsCachedAccount = savedInstanceState.getBoolean("mIsCachedAccount");
            this.mSelectedCountry = savedInstanceState.getInt("mSelectedCountry");
        }
        TextWatcher userNameValidator = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                RCLoginActivity.this.updateLoginZoomButton();
                if (RCLoginActivity.this.mIsCachedAccount) {
                    RCLoginActivity.this.mEdtPsw.setText((CharSequence)"");
                }
                RCLoginActivity.this.mIsCachedAccount = false;
            }
        };
        TextWatcher pwdValidator = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                RCLoginActivity.this.updateLoginZoomButton();
                RCLoginActivity.this.mIsCachedAccount = false;
            }
        };
        this.mEdtPhoneNumber.addTextChangedListener(userNameValidator);
        this.mEdtPsw.addTextChangedListener(pwdValidator);
        PTUI.getInstance().addPTUIListener(this);
        if (ZMBuildConfig.BUILD_TARGET == 4) {
            this.mSelectedCountry = 2;
        } else if (ZMBuildConfig.BUILD_TARGET == 5) {
            this.mSelectedCountry = 1;
        }
    }

    private int getDefaultSelectedCountry() {
        String countryCode = CompatUtils.getLocalDefault().getCountry().toLowerCase(Locale.US);
        int type = PTApp.getInstance().RC_getDefaultCountryTypeByName(countryCode);
        if (type != -1) {
            return type;
        }
        return 0;
    }

    private void loadCachedAccount() {
        String[] phoneNumber = new String[1];
        String[] ext = new String[1];
        PTApp.getInstance().getSavedRingCentralPhoneNumberAndExt(phoneNumber, ext);
        if (!StringUtil.isEmptyOrNull((String)phoneNumber[0])) {
            this.mEdtPhoneNumber.setText((CharSequence)phoneNumber[0]);
            if (ext[0] != null) {
                this.mEdtExtension.setText((CharSequence)ext[0]);
            }
            this.mEdtPsw.setText((CharSequence)"$$$$$$$$$$");
            this.mEdtPhoneNumber.setSelection(this.mEdtPhoneNumber.getText().length(), this.mEdtPhoneNumber.getText().length());
            this.mEdtExtension.setSelection(this.mEdtExtension.getText().length(), this.mEdtExtension.getText().length());
            this.mEdtPsw.setSelection(this.mEdtPsw.getText().length(), this.mEdtPsw.getText().length());
            this.mIsCachedAccount = true;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onResume() {
        super.onResume();
        this.updateLoginZoomButton();
        this.updateSelectedCountry();
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putBoolean("mIsCachedAccount", this.mIsCachedAccount);
        outState.putInt("mSelectedCountry", this.mSelectedCountry);
        super.onSaveInstanceState(outState);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnLoginZoom) {
            this.onClickBtnLoginZoom();
        } else if (id2 == R.id.btnSignup) {
            this.onClickBtnSignup();
        } else if (id2 == R.id.optionCountry) {
            this.onClickOptionCountry();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.isConnecting()) {
            return;
        }
        WelcomeActivity.show((Context)this, true, false);
        this.finish();
    }

    private void onClickBtnBack() {
        this.onBackPressed();
    }

    private void onClickBtnLoginZoom() {
        UIUtil.closeSoftKeyboard((Context)this, (View)this.mEdtPhoneNumber);
        String phoneNumber = this.mEdtPhoneNumber.getText().toString().trim();
        phoneNumber = this.formatPhoneNumber(phoneNumber);
        String extension = this.mEdtExtension.getText().toString().trim();
        String password = this.mEdtPsw.getText().toString();
        if (!this.isValidPhoneNumber(phoneNumber)) {
            this.mEdtPhoneNumber.requestFocus();
            return;
        }
        if (StringUtil.isEmptyOrNull((String)password)) {
            this.mEdtPsw.requestFocus();
            return;
        }
        this.loginZoom(phoneNumber, extension, password, true, this.mIsCachedAccount, true);
    }

    private String formatPhoneNumber(String phoneNumber) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < phoneNumber.length(); ++i) {
            char c = phoneNumber.charAt(i);
            if (c < '0' || c > '9') continue;
            builder.append(c);
        }
        String formattedNumber = builder.toString();
        return formattedNumber;
    }

    private boolean isValidPhoneNumber(String phoneNumber) {
        return phoneNumber.length() >= 1;
    }

    private void onClickBtnSignup() {
        String url = PTApp.getInstance().getURLByType(6);
        if (!StringUtil.isEmptyOrNull((String)url)) {
            UIUtil.openURL((Context)this, (String)url);
        }
    }

    private void onClickOptionCountry() {
        final ZMMenuAdapter adapter = new ZMMenuAdapter((Context)this, false);
        ZMSimpleMenuItem item = new ZMSimpleMenuItem(0, Locale.US.getDisplayCountry());
        adapter.addItem((IZMMenuItem)item);
        item = new ZMSimpleMenuItem(1, Locale.CANADA.getDisplayCountry());
        adapter.addItem((IZMMenuItem)item);
        item = new ZMSimpleMenuItem(2, Locale.UK.getDisplayCountry());
        adapter.addItem((IZMMenuItem)item);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this).setTitle(R.string.zm_title_select_country).setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ZMSimpleMenuItem item = (ZMSimpleMenuItem)adapter.getItem(which);
                if (item != null) {
                    RCLoginActivity.this.onSelectCountryType(item.getAction());
                }
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectCountryType(int countryType) {
        this.mSelectedCountry = countryType;
        this.updateSelectedCountry();
    }

    private void updateLoginZoomButton() {
        this.mBtnLoginZoom.setEnabled(this.validateZoomAccount());
    }

    private void updateSelectedCountry() {
        if (this.mTxtCountry != null) {
            PTApp.getInstance().RC_setCountryType(this.mSelectedCountry);
            switch (this.mSelectedCountry) {
                case 1: {
                    this.mTxtCountry.setText((CharSequence)Locale.CANADA.getDisplayCountry());
                    break;
                }
                case 2: {
                    this.mTxtCountry.setText((CharSequence)Locale.UK.getDisplayCountry());
                    break;
                }
                default: {
                    this.mTxtCountry.setText((CharSequence)Locale.US.getDisplayCountry());
                }
            }
        }
        this.updateLinkForgotPassword();
    }

    private void updateLinkForgotPassword() {
        String url = PTApp.getInstance().getURLByType(7);
        if (!StringUtil.isEmptyOrNull((String)url)) {
            String strHTML = this.getString(R.string.zm_lbl_forget_password_link, new Object[]{url});
            this.mLinkForgetPassword.setText((CharSequence)Html.fromHtml((String)strHTML));
        }
    }

    private boolean validateZoomAccount() {
        String phoneNumber = this.mEdtPhoneNumber.getText().toString();
        phoneNumber = this.formatPhoneNumber(phoneNumber);
        String password = this.mEdtPsw.getText().toString();
        if (!this.isValidPhoneNumber(phoneNumber)) {
            return false;
        }
        return password.length() != 0;
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 2: {
                this.onClickBtnLoginZoom();
                return true;
            }
        }
        return false;
    }

    private void loginZoom(String phoneNumber, String extension, String password, boolean keepLogin, boolean useCachedAccount, boolean returnToLoginWithIfFailed) {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            LoginView.AuthFailedDialog.show(this, message);
            return;
        }
        this.showConnecting(true);
        PTApp ptApp = PTApp.getInstance();
        if (useCachedAccount) {
            int res = ptApp.loginRingCentralWithLocalToken();
            if (res != 0) {
                this.showConnecting(false);
                return;
            }
        } else {
            ptApp.loginWithRingCentral(phoneNumber, extension, password, this.mSelectedCountry, keepLogin);
        }
        this.mLoginFailed = false;
    }

    private void showConnecting(boolean waiting) {
        if (this.isConnecting() == waiting) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        if (waiting) {
            WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_connecting, !UIMgr.isLargeMode((Context)this));
            dialog.show(fm, "ConnectingDialog");
        } else {
            WaitingDialog dialog = (WaitingDialog)fm.findFragmentByTag("ConnectingDialog");
            if (dialog != null) {
                dialog.dismiss();
            }
        }
    }

    public boolean isConnecting() {
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm == null) {
            return false;
        }
        WaitingDialog dialog = (WaitingDialog)fm.findFragmentByTag("ConnectingDialog");
        return dialog != null;
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 35: {
                this.sinkWebAccessFail();
                break;
            }
            case 0: {
                this.sinkWebLogin(result);
            }
        }
    }

    public void sinkWebLogin(final long result) {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkWebLogin", new EventAction("sinkWebLogin"){

            public void run(IUIElement ui) {
                ((RCLoginActivity)ui).handleOnWebLogin(result);
            }
        });
    }

    private void handleOnWebLogin(long result) {
        this.onWebLogin(result);
    }

    private void sinkWebAccessFail() {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkWebAccessFail", new EventAction("sinkWebAccessFail"){

            public void run(IUIElement ui) {
                ((RCLoginActivity)ui).handleOnWebAccessFail();
            }
        });
    }

    private void handleOnWebAccessFail() {
        this.onWebAccessFail();
    }

    private void onWebLogin(long result) {
        if (result == 0L) {
            this.showIMActivity();
        } else {
            PTApp.getInstance().setRencentJid("");
            this.showConnecting(false);
            String message = this.getLoginErrorMessage(result);
            if (!this.mLoginFailed) {
                this.mLoginFailed = true;
                LoginView.AuthFailedDialog.show(this, message);
            }
        }
    }

    private String getLoginErrorMessage(long result) {
        switch ((int)result) {
            case 1000: 
            case 1001: 
            case 1002: {
                return this.getResources().getString(R.string.zm_alert_auth_zoom_failed_msg);
            }
            case 1006: {
                return this.getResources().getString(R.string.zm_alert_auth_token_failed_msg);
            }
            case 2006: {
                return this.getResources().getString(R.string.zm_rc_alert_meetings_feature_is_not_enabled);
            }
        }
        return this.getResources().getString(R.string.zm_alert_auth_error_code_msg, new Object[]{result});
    }

    public void onWebAccessFail() {
        this.showConnecting(false);
        int strId = R.string.zm_alert_connect_zoomus_failed_msg;
        if (!this.mLoginFailed && strId != 0) {
            this.mLoginFailed = true;
            String message = this.getResources().getString(strId);
            LoginView.AuthFailedDialog.show(this, message);
        }
    }

    private void showIMActivity() {
        this.finish();
        IMActivity.show((Context)this);
        this.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }
}

