/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.Window;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.PListFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.view.NormalMessageTip;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.videomeetings.R;

public class PListActivity
extends ZMActivity {
    private Handler mHandler = new Handler();

    public static void show(ZMActivity activity, int requestCode) {
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, PListActivity.class);
        intent.setFlags(131072);
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (VideoBoxApplication.getInstance() == null || VideoBoxApplication.getInstance().isSDKMode() && !mainboard.isSDKConfAppCreated()) {
            this.finish();
            return;
        }
        Window window = this.getWindow();
        if (window != null) {
            window.setSoftInputMode(19);
        }
        if (savedInstanceState == null) {
            PListFragment f = new PListFragment();
            this.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, PListFragment.class.getName()).commit();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.isFinishing()) {
            this.finishActivity(1000);
        }
    }

    public boolean onSearchRequested() {
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm == null) {
            return super.onSearchRequested();
        }
        PListFragment f = PListFragment.getPListFragment(fm);
        if (f != null) {
            return f.onSearchRequested();
        }
        return super.onSearchRequested();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 1001: {
                if (resultCode != -1) break;
                this.onSentInvitationDone(data);
            }
        }
    }

    private void onSentInvitationDone(Intent data) {
        if (data == null) {
            return;
        }
        final int count = data.getIntExtra("invitations_count", 0);
        if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this)) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PListActivity.this.showTipInvitationsSent(count);
                }
            }, 1000L);
        } else {
            this.showTipInvitationsSent(count);
        }
    }

    private void showTipInvitationsSent(int count) {
        String message = this.getResources().getQuantityString(R.plurals.zm_msg_invitations_sent, count, new Object[]{count});
        NormalMessageTip.show(this.getSupportFragmentManager(), "tip_invitations_sent", null, message, R.drawable.zm_ic_tick, 0, 0, 3000L);
    }
}

