/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.MyProfileFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.videomeetings.R;

public class MyProfileActivity
extends ZMActivity {
    private PTUI.IPTUIListener mPTUIListener = new PTUI.SimplePTUIListener(){

        @Override
        public void onPTAppEvent(int event, final long result) {
            if (event == 0) {
                MyProfileActivity.this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onWebLogin"){

                    public void run(IUIElement ui) {
                        ((MyProfileActivity)ui).onWebLogin(result);
                    }
                });
            }
        }
    };

    public static void show(ZMActivity activity, int requestCode) {
        Intent intent = new Intent((Context)activity, MyProfileActivity.class);
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            if (VideoBoxApplication.getInstance() == null) {
                VideoBoxApplication.initialize(this.getApplicationContext(), false, 0);
            }
            VideoBoxApplication.getInstance().initPTMainboard();
            PTUI.getInstance().addPTUIListener(this.mPTUIListener);
            PTApp.getInstance().autoSignin();
        }
        if (savedInstanceState == null) {
            MyProfileFragment.showInActivity(this);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this.mPTUIListener);
    }

    private void onWebLogin(long result) {
        if (result != 0L) {
            this.finish();
            return;
        }
        MyProfileFragment f = MyProfileFragment.findMyProfileFragment(this.getSupportFragmentManager());
        if (f != null) {
            f.onWebLogin();
        }
    }
}

