/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.MMSelectSessionFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.util.ImageUtil;
import us.zoom.androidlib.app.ZMActivity;

public class MMShareActivity
extends ZMActivity {
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onResume() {
        Mainboard mainboard;
        super.onResume();
        Intent intent = this.getIntent();
        if (intent == null) {
            this.finish();
            return;
        }
        if (VideoBoxApplication.getInstance() == null) {
            VideoBoxApplication.initialize(this.getApplicationContext(), false, 0);
        }
        if ((mainboard = Mainboard.getMainboard()) == null) {
            this.finish();
            return;
        }
        Uri contentToSend = null;
        if ("android.intent.action.VIEW".equals(intent.getAction())) {
            intent.setAction("android.intent.action.SEND");
            contentToSend = intent.getData();
        } else {
            Parcelable stream = intent.getParcelableExtra("android.intent.extra.STREAM");
            if (stream instanceof Uri) {
                contentToSend = (Uri)stream;
            }
        }
        if (contentToSend != null) {
            boolean isLocalFile;
            String origFile = ImageUtil.getPathFromUri((Context)VideoBoxApplication.getInstance(), contentToSend);
            boolean bl = isLocalFile = origFile != null && origFile.startsWith("/");
            if (isLocalFile) {
                contentToSend = Uri.parse((String)("file://" + origFile));
            }
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)contentToSend);
        }
        if (!mainboard.isInitialized()) {
            this.finish();
            LauncherActivity.showLauncherActivityForActionSend(this, intent);
            return;
        }
        MMSelectSessionFragment.showSendTo(this, intent);
        this.finish();
    }
}

