/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.zipow.videobox.fragment.MMChatInfoFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import java.io.Serializable;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.videomeetings.R;

public class MMChatInfoActivity
extends ZMActivity {
    public static final int REQUEST_SELECT_CONTACTS = 100;
    private static final int REQUEST_CHAT_INFO = 102;
    public static final String RESULT_ARG_IS_QUIT_GROUP = "isQuitGroup";
    public static final String RESULT_ARG_IS_HISTORY_CLEARED = "isHistoryCleared";
    private static final String ARG_CONTACT = "contact";
    private static final String ARG_IS_GROUP = "isGroup";
    private static final String ARG_GROUP_ID = "groupId";
    private static final String ARG_BUDDY_ID = "buddyId";
    private boolean mIsHistoryCleared = false;

    public static void showAsOneToOneChat(ZMActivity activity, IMAddrBookItem contact, String buddyId, int requestId) {
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, MMChatInfoActivity.class);
        intent.putExtra(ARG_IS_GROUP, false);
        intent.putExtra(ARG_CONTACT, (Serializable)contact);
        intent.putExtra(ARG_BUDDY_ID, buddyId);
        activity.startActivityForResult(intent, requestId);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public static void showAsGroupChat(ZMActivity activity, String groupId, int requestId) {
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, MMChatInfoActivity.class);
        intent.putExtra(ARG_IS_GROUP, true);
        intent.putExtra(ARG_GROUP_ID, groupId);
        activity.startActivityForResult(intent, requestId);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        MMChatInfoActivity.freshGroupInfo(groupId);
    }

    public static void showAsGroupChat(Fragment f, String groupId, int requestId) {
        if (f == null) {
            return;
        }
        FragmentActivity activity = f.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, MMChatInfoActivity.class);
        intent.putExtra(ARG_IS_GROUP, true);
        intent.putExtra(ARG_GROUP_ID, groupId);
        f.startActivityForResult(intent, requestId);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        MMChatInfoActivity.freshGroupInfo(groupId);
    }

    private static void freshGroupInfo(String groupId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            messenger.refreshGroupInfo(groupId);
        }
    }

    public void finish() {
        this.finish(false);
    }

    private void finish(boolean resultSetted) {
        if (!resultSetted) {
            Intent data = new Intent();
            data.putExtra(RESULT_ARG_IS_HISTORY_CLEARED, this.mIsHistoryCleared);
            this.setResult(-1, data);
        }
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            Intent intent = this.getIntent();
            IMAddrBookItem contact = (IMAddrBookItem)intent.getSerializableExtra(ARG_CONTACT);
            String buddyId = intent.getStringExtra(ARG_BUDDY_ID);
            String groupId = intent.getStringExtra(ARG_GROUP_ID);
            boolean isGroup = intent.getBooleanExtra(ARG_IS_GROUP, false);
            if (isGroup) {
                MMChatInfoFragment.showAsGroupChatInActivity(this, groupId);
            } else {
                MMChatInfoFragment.showAsOneToOneInActivity(this, contact, buddyId);
            }
        }
    }

    public void onResume() {
        super.onResume();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putBoolean(RESULT_ARG_IS_HISTORY_CLEARED, this.mIsHistoryCleared);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState != null) {
            this.mIsHistoryCleared = savedInstanceState.getBoolean(RESULT_ARG_IS_HISTORY_CLEARED);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100) {
            if (resultCode == -1 && data != null) {
                ArrayList abItems = (ArrayList)data.getSerializableExtra("selectedItems");
                if (abItems == null) {
                    return;
                }
                MMChatInfoFragment f = MMChatInfoFragment.findMMChatInfoFragment(this.getSupportFragmentManager());
                if (f != null) {
                    f.onContactsSelected(abItems);
                }
            }
        } else if (requestCode == 102 && resultCode == -1 && data != null && data.getBooleanExtra(RESULT_ARG_IS_QUIT_GROUP, false)) {
            this.onQuitGroup();
        }
    }

    public void onQuitGroup() {
        Intent data = new Intent();
        data.putExtra(RESULT_ARG_IS_QUIT_GROUP, true);
        this.setResult(-1, data);
        this.finish(true);
    }

    public void onHistoryCleared() {
        this.mIsHistoryCleared = true;
    }
}

