/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.MMChatFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.IMAddrBookItem;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMChatActivity
extends ZMActivity {
    private static final String TAG = MMChatActivity.class.getSimpleName();
    private static final String ARG_CONTACT = "contact";
    private static final String ARG_IS_GROUP = "isGroup";
    private static final String ARG_GROUP_ID = "groupId";
    private static final String ARG_BUDDY_ID = "buddyId";
    private static final String ARG_SEND_INTENT = "sendIntent";
    private PTUI.IPTUIListener mPTUIListener = new PTUI.SimplePTUIListener(){

        @Override
        public void onPTAppEvent(int event, final long result) {
            if (event == 0) {
                MMChatActivity.this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onWebLogin"){

                    public void run(IUIElement ui) {
                        ((MMChatActivity)ui).onWebLogin(result);
                    }
                });
            }
        }
    };

    private static boolean isIMDisable() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        return messenger == null || messenger.imChatGetOption() == 2;
    }

    public static boolean showAsOneToOneChatWithPhoneNumber(ZMActivity activity, IMAddrBookItem contact, String phoneNumber, boolean finishSelfActivityOnSuccess) {
        if (activity == null || contact == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        String buddyId = contact.getJid();
        if (StringUtil.isEmptyOrNull((String)buddyId)) {
            return false;
        }
        if (finishSelfActivityOnSuccess) {
            activity.finish();
        }
        IMAddrBookItem abItem = new IMAddrBookItem();
        abItem.setContactId(contact.getContactId());
        abItem.setScreenName(contact.getScreenName());
        abItem.setSortKey(contact.getSortKey());
        abItem.setIsZoomUser(contact.getIsZoomUser());
        abItem.addPhoneNumber(phoneNumber, phoneNumber);
        abItem.setJid(buddyId);
        abItem.setIsZoomUser(true);
        MMChatActivity.showAsOneToOneChat(activity, abItem, buddyId);
        return true;
    }

    public static void showAsOneToOneChat(ZMActivity activity, IMAddrBookItem contact, String buddyId) {
        if (activity == null || contact == null || buddyId == null || MMChatActivity.isIMDisable()) {
            return;
        }
        Intent intent = new Intent((Context)activity, MMChatActivity.class);
        intent.addFlags(0x20000000);
        intent.putExtra(ARG_IS_GROUP, false);
        intent.putExtra(ARG_CONTACT, (Serializable)contact);
        intent.putExtra(ARG_BUDDY_ID, buddyId);
        activity.startActivity(intent);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public static void showAsOneToOneChat(ZMActivity activity, ZoomBuddy buddy) {
        MMChatActivity.showAsOneToOneChat(activity, buddy, null);
    }

    public static void showAsOneToOneChat(ZMActivity activity, ZoomBuddy buddy, Intent sendIntent) {
        if (activity == null || buddy == null || MMChatActivity.isIMDisable()) {
            return;
        }
        IMAddrBookItem abItem = IMAddrBookItem.fromZoomBuddy(buddy);
        String buddyId = buddy.getJid();
        Intent intent = new Intent((Context)activity, MMChatActivity.class);
        intent.addFlags(0x20000000);
        intent.putExtra(ARG_IS_GROUP, false);
        intent.putExtra(ARG_CONTACT, (Serializable)abItem);
        intent.putExtra(ARG_BUDDY_ID, buddyId);
        intent.putExtra(ARG_SEND_INTENT, (Parcelable)sendIntent);
        activity.startActivity(intent);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        MMChatActivity.forceRefreshVcard(buddyId);
    }

    private static void forceRefreshVcard(String buddyId) {
        MMChatActivity.forceRefreshVcard(buddyId, true);
    }

    private static void forceRefreshVcard(String buddyId, boolean rightNow) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            messenger.refreshBuddyVCard(buddyId, true);
        }
    }

    public static void showAsGroupChat(ZMActivity activity, String groupId) {
        ZoomGroup group;
        MMChatActivity.showAsGroupChat(activity, groupId, null);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && (group = messenger.getGroupById(groupId)) != null) {
            int count = group.getBuddyCount();
            for (int i = 0; i < count; ++i) {
                ZoomBuddy buddy = group.getBuddyAt(i);
                if (buddy == null) continue;
                MMChatActivity.forceRefreshVcard(buddy.getJid(), false);
            }
        }
    }

    public static void showAsGroupChat(ZMActivity activity, String groupId, Intent sendIntent) {
        if (MMChatActivity.isIMDisable()) {
            return;
        }
        Intent intent = new Intent((Context)activity, MMChatActivity.class);
        intent.addFlags(0x20000000);
        intent.putExtra(ARG_IS_GROUP, true);
        intent.putExtra(ARG_GROUP_ID, groupId);
        intent.putExtra(ARG_SEND_INTENT, (Parcelable)sendIntent);
        activity.startActivity(intent);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            if (VideoBoxApplication.getInstance() == null) {
                VideoBoxApplication.initialize(this.getApplicationContext(), false, 0);
            }
            VideoBoxApplication.getInstance().initPTMainboard();
            PTUI.getInstance().addPTUIListener(this.mPTUIListener);
            PTApp.getInstance().autoSignin();
        }
        if (UIMgr.isLargeMode((Context)this) && !UIMgr.isDualPaneSupportedInPortraitMode((Context)this)) {
            this.setRequestedOrientation(0);
        } else if (UIUtil.isTablet((Context)this)) {
            this.setRequestedOrientation(4);
        } else if (PTApp.getInstance().hasMessenger()) {
            this.setRequestedOrientation(1);
        }
        if (savedInstanceState == null) {
            Intent intent = this.getIntent();
            IMAddrBookItem contact = (IMAddrBookItem)intent.getSerializableExtra(ARG_CONTACT);
            String buddyId = intent.getStringExtra(ARG_BUDDY_ID);
            String groupId = intent.getStringExtra(ARG_GROUP_ID);
            boolean isGroup = intent.getBooleanExtra(ARG_IS_GROUP, false);
            Intent sendIntent = (Intent)intent.getParcelableExtra(ARG_SEND_INTENT);
            if (isGroup) {
                MMChatFragment.showAsGroupChatInActivity(this, groupId, sendIntent);
            } else {
                MMChatFragment.showAsOneToOneInActivity(this, contact, buddyId, sendIntent);
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this.mPTUIListener);
    }

    private void onWebLogin(long result) {
        if (result != 0L) {
            this.finish();
        } else {
            MMChatFragment f = MMChatFragment.findMMChatFragment(this.getSupportFragmentManager());
            if (f != null) {
                f.onWebLogin();
            }
        }
    }

    public void onBackPressed() {
        MMChatFragment f = MMChatFragment.findMMChatFragment(this.getSupportFragmentManager());
        if (f != null && f.onBackPressed()) {
            return;
        }
        super.onBackPressed();
    }

    protected void onNewIntent(Intent intent) {
        String newSessionId;
        super.onNewIntent(intent);
        Intent oldIntent = this.getIntent();
        if (intent == null || oldIntent == null) {
            return;
        }
        String oldSessionId = oldIntent.getStringExtra(ARG_GROUP_ID);
        if (oldSessionId == null) {
            oldSessionId = oldIntent.getStringExtra(ARG_BUDDY_ID);
        }
        if ((newSessionId = intent.getStringExtra(ARG_GROUP_ID)) == null) {
            newSessionId = intent.getStringExtra(ARG_BUDDY_ID);
        }
        if (!StringUtil.isSameString((String)oldSessionId, (String)newSessionId)) {
            IMAddrBookItem contact = (IMAddrBookItem)intent.getSerializableExtra(ARG_CONTACT);
            boolean isGroup = intent.getBooleanExtra(ARG_IS_GROUP, false);
            String buddyId = intent.getStringExtra(ARG_BUDDY_ID);
            String groupId = intent.getStringExtra(ARG_GROUP_ID);
            Intent newIntent = new Intent((Context)this, MMChatActivity.class);
            newIntent.putExtra(ARG_IS_GROUP, isGroup);
            newIntent.putExtra(ARG_CONTACT, (Serializable)contact);
            newIntent.putExtra(ARG_BUDDY_ID, buddyId);
            newIntent.putExtra(ARG_GROUP_ID, groupId);
            this.startActivity(newIntent);
            this.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        }
    }
}

