/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ConfigurationInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import com.zipow.videobox.JoinByURLActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.WelcomeActivity;
import com.zipow.videobox.ZoomApplication;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.thirdparty.login.facebook.AuthToken;
import us.zoom.thirdparty.login.facebook.FBSessionStore;
import us.zoom.videomeetings.R;

public class LauncherActivity
extends ZMActivity
implements PTUI.IPTUIListener {
    private static final String TAG = LauncherActivity.class.getSimpleName();
    private static final String ACTION_HANDLE_URI = LauncherActivity.class.getName() + ".action.ACTION_HANDLE_URI";
    private static final String ACTION_HANDLE_ACTION_SEND = LauncherActivity.class.getName() + ".action.ACTION_HANDLE_ACTION_SEND";
    private static final String ARG_ACTION_FOR_IM_ACTIVITY = "actionForIMActivity";
    private static final String ARG_EXTRAS_FOR_IM_ACTIVITY = "extrasForIMActivity";
    private static final String ARG_LAUNCHED_FROM_ZOOM = "launchedFromZoom";
    private static final String EXTRA_URI = LauncherActivity.class.getName() + ".extra.URI";
    private static final String EXTRA_ACTION_SEND_INTENT = LauncherActivity.class.getName() + ".extra.ACTION_SEND_INTENT";
    private static final int SPLASH_TIME = 2000;
    private static final int DELAY_WAIT_LOGIN = 5000;
    private Handler mHandler = new Handler();
    private Runnable mRunnableShowMainUILater = new Runnable(){

        @Override
        public void run() {
            if (!LauncherActivity.this.showMainUIIfActive()) {
                LauncherActivity.this.showMainUILaterIfPossible();
            }
        }
    };
    private Runnable mCheckHandlerUrlRunnable = new Runnable(){

        @Override
        public void run() {
            LauncherActivity.this.mHandler.removeCallbacksAndMessages(null);
            LauncherActivity.this.handleActionURI(LauncherActivity.this.getIntent());
            PTUI.getInstance().removePTUIListener(LauncherActivity.this);
            LauncherActivity.this.finish();
        }
    };

    public static void showLauncherActivity(ZMActivity activity) {
        LauncherActivity.showLauncherActivity(activity, null, null);
    }

    public static void showLauncherActivity(ZMActivity activity, String actionForIMActivity, Bundle extrasForIMActivity) {
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, LauncherActivity.class);
        intent.addFlags(0x4000000);
        intent.putExtra(ARG_LAUNCHED_FROM_ZOOM, true);
        if (actionForIMActivity != null) {
            intent.putExtra(ARG_ACTION_FOR_IM_ACTIVITY, actionForIMActivity);
        }
        if (extrasForIMActivity != null) {
            intent.putExtra(ARG_EXTRAS_FOR_IM_ACTIVITY, extrasForIMActivity);
        }
        activity.startActivity(intent);
    }

    public static void showLauncherActivityForUri(ZMActivity activity, String uri) {
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, LauncherActivity.class);
        intent.setAction(ACTION_HANDLE_URI);
        intent.addFlags(0x4000000);
        intent.putExtra(EXTRA_URI, uri);
        intent.putExtra(ARG_LAUNCHED_FROM_ZOOM, true);
        activity.startActivity(intent);
    }

    public static void showLauncherActivityForActionSend(ZMActivity activity, Intent actionSendIntent) {
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, LauncherActivity.class);
        intent.setAction(ACTION_HANDLE_ACTION_SEND);
        intent.addFlags(0x4000000);
        intent.putExtra(EXTRA_ACTION_SEND_INTENT, (Parcelable)actionSendIntent);
        intent.putExtra(ARG_LAUNCHED_FROM_ZOOM, true);
        activity.startActivity(intent);
    }

    public static void showLauncherActivityAsFromHome(Context context) {
        if (context == null) {
            return;
        }
        Intent intent = new Intent(context, LauncherActivity.class);
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.addFlags(0x10200000);
        context.startActivity(intent);
    }

    public void onCreate(Bundle savedInstanceState) {
        Mainboard mainboard;
        super.onCreate(savedInstanceState);
        if (!this.isLaunchedFromHome() && !this.isLaunchedFromZoom()) {
            this.finish();
            LauncherActivity.showLauncherActivityAsFromHome((Context)this);
            return;
        }
        if (UIUtil.getDisplayMinWidthInDip((Context)this) < 520.0f) {
            this.setRequestedOrientation(1);
        }
        if (VideoBoxApplication.getInstance() == null) {
            Context appContext = this.getApplicationContext();
            VideoBoxApplication.initialize(this.getApplicationContext(), false, 0, null);
            if (!"us.zoom.videomeetings".equals(this.getPackageName()) && appContext instanceof ZoomApplication) {
                ((ZoomApplication)appContext).checkShareCloudFileClientInfo();
            }
        }
        if ((mainboard = Mainboard.getMainboard()) == null) {
            return;
        }
        if (!mainboard.isInitialized()) {
            this.setContentView(R.layout.zm_splash);
        }
    }

    private boolean isLaunchedFromHome() {
        Intent intent = this.getIntent();
        int flags = intent.getFlags();
        return (flags & 0x10000000) != 0 && (flags & 0x200000) != 0;
    }

    private boolean isLaunchedFromZoom() {
        Intent intent = this.getIntent();
        return intent.getBooleanExtra(ARG_LAUNCHED_FROM_ZOOM, false);
    }

    public void onResume() {
        super.onResume();
        if (!this.checkSupported()) {
            return;
        }
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null) {
            return;
        }
        if (mainboard.isInitialized()) {
            this.showMainUIImediately();
        } else {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Mainboard mainboard = Mainboard.getMainboard();
                    if (mainboard == null) {
                        return;
                    }
                    if (!mainboard.isInitialized()) {
                        long timeStart = System.currentTimeMillis();
                        VideoBoxApplication.getInstance().initPTMainboard();
                        long timeUsed = System.currentTimeMillis() - timeStart;
                        LauncherActivity.this.autoLoginIfPossible();
                        long delay = 2000L - timeUsed;
                        if (delay < 0L) {
                            delay = 0L;
                        }
                        LauncherActivity.this.showMainUIDelayed(delay);
                    }
                }
            }, 200L);
            this.showMainUILaterIfPossible();
        }
    }

    private void showMainUILaterIfPossible() {
        this.mHandler.postDelayed(this.mRunnableShowMainUILater, 1000L);
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this);
        this.mHandler.removeCallbacks(this.mCheckHandlerUrlRunnable);
        this.mHandler.removeCallbacks(this.mRunnableShowMainUILater);
    }

    private void showMainUIDelayed(long delay) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LauncherActivity.this.showMainUIIfActive();
            }
        };
        this.mHandler.postDelayed(runnable, delay);
    }

    private boolean showMainUIIfActive() {
        if (this.isActive()) {
            this.showMainUIImediately();
            return true;
        }
        return false;
    }

    private void runOnLogin(final Runnable runnable, final long timeout) {
        if (timeout <= 0L || !PTApp.getInstance().isAuthenticating()) {
            runnable.run();
        } else {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LauncherActivity.this.runOnLogin(runnable, timeout - 200L);
                }
            }, 200L);
        }
    }

    private void showMainUIImediately() {
        Bundle extrasForIMActivity;
        Intent intent = this.getIntent();
        String actionForIMActivity = intent != null ? intent.getStringExtra(ARG_ACTION_FOR_IM_ACTIVITY) : null;
        Bundle bundle = extrasForIMActivity = intent != null ? intent.getBundleExtra(ARG_EXTRAS_FOR_IM_ACTIVITY) : null;
        if (intent == null) {
            return;
        }
        String myAction = intent.getAction();
        if (ACTION_HANDLE_URI.equals(myAction)) {
            this.runOnLogin(this.mCheckHandlerUrlRunnable, 5000L);
        } else if (ACTION_HANDLE_ACTION_SEND.equals(myAction)) {
            this.handleActionSend(intent);
            this.finish();
        } else {
            WelcomeActivity.show((Context)this, false, true, actionForIMActivity, extrasForIMActivity);
            this.overridePendingTransition(0, 0);
            this.finish();
        }
    }

    private void handleActionURI(Intent intent) {
        PTUI.getInstance().removePTUIListener(this);
        String sUri = intent.getStringExtra(EXTRA_URI);
        if (sUri == null) {
            return;
        }
        Intent uriIntent = new Intent((Context)this, JoinByURLActivity.class);
        uriIntent.setData(Uri.parse((String)sUri));
        this.startActivity(uriIntent);
        intent.removeExtra(EXTRA_URI);
    }

    private void handleActionSend(Intent intent) {
        Intent actionSendIntent = (Intent)intent.getParcelableExtra(EXTRA_ACTION_SEND_INTENT);
        if (actionSendIntent == null) {
            return;
        }
        WelcomeActivity.showForActionSend((Context)this, actionSendIntent);
        intent.removeExtra(EXTRA_ACTION_SEND_INTENT);
    }

    private boolean autoLoginIfPossible() {
        AuthToken authToken;
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            return false;
        }
        PTUI.getInstance().addPTUIListener(this);
        if (PTApp.getInstance().getPTLoginType() == 0 ? (authToken = FBSessionStore.getSession((Context)this, (String)"facebook-session")).isSessionValid() && !authToken.shouldExtendAccessToken() : PTApp.getInstance().getPTLoginType() != 102 && PTApp.getInstance().getPTLoginType() != 97) {
            return PTApp.getInstance().autoSignin();
        }
        return false;
    }

    private boolean checkSupported() {
        boolean glversionSupported;
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        boolean bl = glversionSupported = configurationInfo.reqGlEsVersion >= 131072;
        if (!glversionSupported || Build.CPU_ABI.equals("armeabi") || Build.CPU_ABI.startsWith("armeabi-v6")) {
            new ZMAlertDialog.Builder((Context)this).setTitle(R.string.zm_app_name).setMessage(R.string.zm_msg_devices_not_supported).setCancelable(false).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                    LauncherActivity.this.finish();
                }
            }).show();
            return false;
        }
        return true;
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 0: 
            case 35: {
                this.sinkWebLoginResult();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void sinkWebLoginResult() {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkWebLoginResult", new EventAction("sinkWebLoginResult"){

            public void run(IUIElement ui) {
                ((LauncherActivity)ui).showMainUIIfActive();
            }
        });
    }
}

