/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import com.zipow.videobox.fragment.InviteFragment;
import com.zipow.videobox.mainboard.Mainboard;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.videomeetings.R;

public class InviteActivity
extends ZMActivity {
    public static final String RESULT_INVITATIONS_COUNT = "invitations_count";

    public static void show(Context context, String meetingId, long meetingNumber) {
        InviteActivity.show(context, meetingId, meetingNumber, false);
    }

    public static void show(Context context, String meetingId, long meetingNumber, boolean inviteAddrBook) {
        Intent intent = new Intent(context, InviteActivity.class);
        intent.putExtra("meetingNumber", meetingNumber);
        intent.putExtra("meetingId", meetingId);
        intent.putExtra("inviteAddrBook", inviteAddrBook);
        context.startActivity(intent);
        if (context instanceof Activity) {
            ((Activity)context).overridePendingTransition(R.anim.zm_slide_in_bottom, R.anim.zm_fade_out);
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, R.anim.zm_slide_out_bottom);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        this.getWindow().addFlags(0x200080);
        if (savedInstanceState == null) {
            InviteFragment f = new InviteFragment();
            Intent intent = this.getIntent();
            if (intent != null) {
                long hangoutNumber = intent.getLongExtra("meetingNumber", 0L);
                String hangoutId = intent.getStringExtra("meetingId");
                boolean inviteAddrBook = intent.getBooleanExtra("inviteAddrBook", false);
                boolean inviteZoomRooms = intent.getBooleanExtra("inviteZoomRooms", false);
                Bundle bundle = new Bundle();
                bundle.putLong("meetingNumber", hangoutNumber);
                bundle.putString("meetingId", hangoutId);
                bundle.putBoolean("inviteAddrBook", inviteAddrBook);
                bundle.putBoolean("inviteZoomRooms", inviteZoomRooms);
                f.setArguments(bundle);
            }
            this.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, InviteFragment.class.getName()).commit();
        }
    }

    public void onSentInvitationDone(int invitationsCount) {
        Intent data = new Intent();
        data.putExtra(RESULT_INVITATIONS_COUNT, invitationsCount);
        this.setResult(-1, data);
        this.finish();
    }

    public boolean onSearchRequested() {
        InviteFragment f = (InviteFragment)this.getSupportFragmentManager().findFragmentByTag(InviteFragment.class.getName());
        if (f != null) {
            return f.onSearchRequested();
        }
        return true;
    }
}

