/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.IMChatActivity;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.ErrorMsgDialog;
import com.zipow.videobox.fragment.ServerNamePasswordDialog;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.fragment.SystemNotificationFragment;
import com.zipow.videobox.fragment.VerifyCertFailureDialog;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.IMSession;
import com.zipow.videobox.ptapp.IncomingCallManager;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTBuddyHelper;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.VerifyCertEvent;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.LoginUtil;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.IMBuddyItem;
import com.zipow.videobox.view.sip.SipInCallActivity;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class IntegrationActivity
extends ZMActivity {
    private static final String TAG = IntegrationActivity.class.getSimpleName();
    public static final String ACTION_RETURN_TO_CONF = IntegrationActivity.class.getName() + ".action.RETURN_TO_CONF";
    public static final String ACTION_SHOW_UNREAD_MESSAGE = IntegrationActivity.class.getName() + ".action.SHOW_UNREAD_MESSAGE";
    public static final String ACTION_SHOW_UNREAD_MESSAGE_MM = IntegrationActivity.class.getName() + ".action.SHOW_UNREAD_MESSAGE_MM";
    public static final String ACTION_NEW_INCOMING_CALL = IntegrationActivity.class.getName() + ".action.ACTION_NEW_INCOMING_CALL";
    public static final String ACTION_ACCEPT_CALL = IntegrationActivity.class.getName() + ".action.ACTION_ACCEPT_CALL";
    public static final String ACTION_DECLINE_CALL = IntegrationActivity.class.getName() + ".action.ACTION_DECLINE_CALL";
    public static final String ACTION_INPUT_PROXY_NAME_PASS = IntegrationActivity.class.getName() + ".action.ACTION_INPUT_PROXY_NAME_PASS";
    public static final String ACTION_SHOW_CALL_NOT_ANSWERED_MESSAGE = IntegrationActivity.class.getName() + ".action.ACTION_SHOW_CALL_NOT_ANSWERED_MESSAGE";
    public static final String ACTION_LOGIN_EXPIRED = IntegrationActivity.class.getName() + ".action.ACTION_TOKEN_EXPIRED";
    public static final String ACTION_CONFIRM_VERIFY_CERT_FAILURE = IntegrationActivity.class.getName() + ".action.ACTION_CONFIRM_VERIFY_CERT_FAILURE";
    public static final String ACTION_RECEIVE_IM_ERROR_MSG = IntegrationActivity.class.getName() + ".action.ACTION_RECEIVE_IM_ERROR_MSG";
    public static final String ACTION_RETURN_TO_SIP = IntegrationActivity.class.getName() + ".action.RETURN_TO_SIP";
    public static final String ACTION_NOS_CALL = IntegrationActivity.class.getName() + ".action.ACTION_NOS_CALL";
    public static final String ARG_INVITATION = "invitation";
    public static final String ARG_SERVER = "server";
    public static final String ARG_PORT = "port";
    public static final String ARG_ENDMEETING_REASON = "endMeetingReason";
    public static final String ARG_USERNAME = "userName";
    public static final String ARG_LOGIN_TYPE = "loginType";
    public static final String ARG_VERIFY_CERT_EVENT = "verifyCertEvent";
    public static final String ARG_IM_ERROR_MSG = "imErrorMsg";
    public static final String ARG_IM_ERROR_CODE = "imErrorCode";
    public static final String ARG_UNREAD_MESSAGE_SESSION = "unreadMsgSession";
    public static final String ARG_CALL_BODY = "callBody";
    public static final String ARG_CALL_CAPTION = "callCaption";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        String action = intent.getAction();
        boolean needFinish = true;
        if (ACTION_RETURN_TO_CONF.equals(action)) {
            needFinish = this.handleActionReturnToConf();
        } else if (ACTION_SHOW_UNREAD_MESSAGE.equals(action)) {
            needFinish = this.handleActionShowUnreadMessage();
        } else if (ACTION_SHOW_UNREAD_MESSAGE_MM.equals(action)) {
            needFinish = this.handleActionShowUnreadMessageMM();
        } else if (ACTION_NEW_INCOMING_CALL.equals(action)) {
            needFinish = this.handleActionNewIncomingCall(intent);
        } else if (ACTION_ACCEPT_CALL.equals(action)) {
            needFinish = this.handleActionAcceptCall();
        } else if (ACTION_DECLINE_CALL.equals(action)) {
            needFinish = this.handleActionDeclineCall();
        } else if (ACTION_INPUT_PROXY_NAME_PASS.equals(action)) {
            needFinish = this.handleActionInputProxyNamePass(intent);
        } else if (ACTION_SHOW_CALL_NOT_ANSWERED_MESSAGE.equals(action)) {
            needFinish = this.handleActionShowCallNotAnswered(intent);
        } else if (ACTION_LOGIN_EXPIRED.equals(action)) {
            needFinish = this.handleActionLoginExpired(intent);
        } else if (ACTION_CONFIRM_VERIFY_CERT_FAILURE.equals(action)) {
            needFinish = this.handleActionConfirmVerifyCertFailure(intent);
        } else if (ACTION_RECEIVE_IM_ERROR_MSG.equals(action)) {
            needFinish = this.handleIMErrorMsg(intent);
        } else if (ACTION_RETURN_TO_SIP.equals(action)) {
            needFinish = this.handleActionReturnToSIP();
        } else if (ACTION_NOS_CALL.equals(action)) {
            needFinish = this.handleActionNosIncomingCall(intent);
        }
        if (needFinish) {
            this.finish();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if (ACTION_CONFIRM_VERIFY_CERT_FAILURE.equals(action)) {
            this.handleNewIntentActionConfirmVerifyCertFailure(intent);
        } else if (ACTION_RECEIVE_IM_ERROR_MSG.equals(action)) {
            this.handleNewIntentActionErrorMsg(intent);
        }
    }

    private boolean handleActionReturnToConf() {
        ConfActivity.returnToConf((Context)this);
        return true;
    }

    private boolean handleActionReturnToSIP() {
        SipInCallActivity.returnToSip((Context)this);
        return true;
    }

    private boolean handleActionShowUnreadMessage() {
        Intent i = new Intent((Context)this, IMActivity.class);
        i.setFlags(0x4000000);
        i.setAction(IMActivity.ACTION_SHOW_UNREAD_MESSAGE);
        this.startActivity(i);
        return true;
    }

    private boolean handleActionShowUnreadMessageMM() {
        Intent intent;
        IMHelper imHelper;
        this.finish();
        if (VideoBoxApplication.getInstance() == null) {
            VideoBoxApplication.initialize(this.getApplicationContext(), false, 0);
            this.showIMActivityForUnreadMessage();
            return false;
        }
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null) {
            return false;
        }
        if (!mainboard.isInitialized()) {
            this.showIMActivityForUnreadMessage();
            return false;
        }
        if (UIMgr.isLargeMode((Context)this)) {
            this.showIMActivityForUnreadMessage();
            return false;
        }
        NotificationMgr.removeMessageNotificationMM((Context)this);
        int countOfZoomMessenger = 0;
        int countOfThirdPartyIM = 0;
        int countOfSystemNotification = 0;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            countOfZoomMessenger = messenger.getTotalUnreadMessageCount();
            countOfSystemNotification = messenger.getUnreadRequestCount();
        }
        if ((imHelper = PTApp.getInstance().getIMHelper()) != null) {
            countOfThirdPartyIM = imHelper.getUnreadMsgCount();
        }
        if ((intent = this.getIntent()) != null && !StringUtil.isEmptyOrNull((String)intent.getStringExtra(ARG_UNREAD_MESSAGE_SESSION))) {
            this.showIMActivityForUnreadMessage();
            return false;
        }
        if (countOfSystemNotification == 0 && countOfZoomMessenger == 0 && countOfThirdPartyIM > 0) {
            this.showUnreadMessageThirdPartyIM();
        } else if (countOfSystemNotification == 0 && countOfZoomMessenger > 0 && countOfThirdPartyIM == 0) {
            int cntSessions = messenger.getChatSessionCount();
            for (int i = 0; i < cntSessions; ++i) {
                ZoomChatSession session = messenger.getSessionAt(i);
                if (session == null) continue;
                int countUnreadOfSession = session.getUnreadMessageCount();
                if (countOfZoomMessenger == countUnreadOfSession) {
                    if (session.isGroup()) {
                        ZoomGroup group = session.getSessionGroup();
                        if (group == null) {
                            this.showIMActivityForUnreadMessage();
                            return false;
                        }
                        String groupId = group.getGroupID();
                        if (StringUtil.isEmptyOrNull((String)groupId)) {
                            this.showIMActivityForUnreadMessage();
                            return false;
                        }
                        this.startGroupChat(groupId);
                    } else {
                        ZoomBuddy buddy = session.getSessionBuddy();
                        if (buddy == null) {
                            this.showIMActivityForUnreadMessage();
                            return false;
                        }
                        this.startOneToOneChat(buddy);
                    }
                    return false;
                }
                if (countUnreadOfSession <= 0 || countUnreadOfSession >= countOfZoomMessenger) continue;
                this.showIMActivityForUnreadMessage();
                return false;
            }
        } else if (countOfSystemNotification > 0 && countOfZoomMessenger == 0 && countOfThirdPartyIM == 0) {
            this.showSystemNotification();
        } else {
            this.showIMActivityForUnreadMessage();
            return false;
        }
        return false;
    }

    private void showIMActivityForUnreadMessage() {
        int activityCount = ZMActivity.getInProcessActivityCountInStack();
        if (activityCount > 0) {
            for (int i = activityCount - 1; i >= 0; --i) {
                ZMActivity activity = ZMActivity.getInProcessActivityInStackAt((int)i);
                if (activity instanceof IMActivity || activity instanceof IntegrationActivity || activity == null) continue;
                activity.finish();
            }
        }
        Intent i = new Intent((Context)this, IMActivity.class);
        i.setFlags(131072);
        i.setAction(IMActivity.ACTION_SHOW_UNREAD_MESSAGE_MM);
        Intent intent = this.getIntent();
        if (intent != null) {
            i.putExtra(ARG_UNREAD_MESSAGE_SESSION, intent.getStringExtra(ARG_UNREAD_MESSAGE_SESSION));
        }
        this.startActivity(i);
    }

    private void startOneToOneChat(ZoomBuddy buddy) {
        MMChatActivity.showAsOneToOneChat(this, buddy);
    }

    private void showSystemNotification() {
        SystemNotificationFragment.showAsActivity(this, 0);
    }

    private void startGroupChat(String groupId) {
        MMChatActivity.showAsGroupChat(this, groupId);
    }

    private void showUnreadMessageThirdPartyIM() {
        PTAppProtos.BuddyItem proto;
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null) {
            return;
        }
        PTBuddyHelper buddyHelper = PTApp.getInstance().getBuddyHelper();
        if (buddyHelper == null) {
            return;
        }
        int cntBuddy = buddyHelper.getBuddyItemCount();
        String buddyHasMsg = null;
        for (int i = 0; i < cntBuddy; ++i) {
            String jid = buddyHelper.getBuddyItemJid(i);
            IMSession session = imHelper.getSessionBySessionName(jid);
            if (session == null || session.getUnreadMessageCount() <= 0) continue;
            if (buddyHasMsg != null) {
                this.showIMActivityForUnreadMessage();
                return;
            }
            buddyHasMsg = jid;
        }
        if (buddyHasMsg != null && (proto = buddyHelper.getBuddyItemByJid(buddyHasMsg)) != null) {
            IMBuddyItem item = new IMBuddyItem().parseFromProtoItem(proto);
            this.showChatUI(item);
        }
    }

    private void showChatUI(IMBuddyItem buddyItem) {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        if (buddyItem == null) {
            return;
        }
        Intent i = new Intent((Context)this, IMChatActivity.class);
        i.setFlags(131072);
        i.putExtra("buddyItem", (Serializable)buddyItem);
        i.putExtra("myName", profile.getUserName());
        this.startActivity(i);
    }

    private boolean handleActionNosIncomingCall(Intent intent) {
        String callBody = intent.getStringExtra(ARG_CALL_BODY);
        String caption = intent.getStringExtra(ARG_CALL_CAPTION);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            if (VideoBoxApplication.getInstance() == null) {
                VideoBoxApplication.initialize(this.getApplicationContext(), false, 0);
            }
            VideoBoxApplication.getInstance().initPTMainboard();
            PTApp.getInstance().autoSignin();
        }
        PTApp.getInstance().nos_NotificationReceived(caption, callBody);
        return true;
    }

    private boolean handleActionNewIncomingCall(Intent intent) {
        PTAppProtos.InvitationItem invitation = (PTAppProtos.InvitationItem)((Object)intent.getSerializableExtra(ARG_INVITATION));
        if (invitation != null) {
            ConfActivity.onNewIncomingCall(this, invitation);
        }
        return true;
    }

    private boolean handleActionAcceptCall() {
        IncomingCallManager.getInstance().acceptCall((Context)this, false);
        return true;
    }

    private boolean handlerActionSystemNotification() {
        SystemNotificationFragment.showAsActivity(this, 0);
        return true;
    }

    private boolean handleActionDeclineCall() {
        IncomingCallManager.getInstance().declineCall();
        return true;
    }

    private boolean handleActionInputProxyNamePass(Intent intent) {
        String server = intent.getStringExtra(ARG_SERVER);
        int port = intent.getIntExtra(ARG_PORT, 0);
        ServerNamePasswordDialog dialog = ServerNamePasswordDialog.newInstance(server, port, true, true);
        dialog.show(this.getSupportFragmentManager(), ServerNamePasswordDialog.class.getName());
        return false;
    }

    private boolean handleActionShowCallNotAnswered(Intent intent) {
        String userName = intent.getStringExtra(ARG_USERNAME);
        this.showCallNotAnsweredDialog(userName);
        return false;
    }

    private boolean handleActionLoginExpired(Intent intent) {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null) {
            return false;
        }
        if (!mainboard.isInitialized()) {
            VideoBoxApplication.getInstance().initPTMainboard();
        }
        PTApp.getInstance().setTokenExpired(true);
        LoginUtil.showLoginUI((Context)this, true, -999);
        return true;
    }

    private boolean handleActionConfirmVerifyCertFailure(Intent intent) {
        VerifyCertEvent event = (VerifyCertEvent)intent.getSerializableExtra(ARG_VERIFY_CERT_EVENT);
        VerifyCertFailureDialog dialog = VerifyCertFailureDialog.newInstance(event, true);
        dialog.show(this.getSupportFragmentManager(), VerifyCertFailureDialog.class.getName());
        return false;
    }

    private void handleNewIntentActionConfirmVerifyCertFailure(Intent intent) {
        VerifyCertEvent event = (VerifyCertEvent)intent.getSerializableExtra(ARG_VERIFY_CERT_EVENT);
        if (event != null) {
            FragmentManager fm = this.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            VerifyCertFailureDialog dlg = (VerifyCertFailureDialog)fm.findFragmentByTag(VerifyCertFailureDialog.class.getName());
            if (dlg != null) {
                dlg.onNewVerifyCertFailure(event);
            }
        }
    }

    private boolean handleIMErrorMsg(Intent intent) {
        String msg = intent.getStringExtra(ARG_IM_ERROR_MSG);
        if (StringUtil.isEmptyOrNull((String)msg)) {
            return true;
        }
        int code = intent.getIntExtra(ARG_IM_ERROR_CODE, -1);
        ErrorMsgDialog.newInstance(msg, code, true).show(this.getSupportFragmentManager(), ErrorMsgDialog.class.getName());
        return false;
    }

    private void handleNewIntentActionErrorMsg(Intent intent) {
        String msg = intent.getStringExtra(ARG_IM_ERROR_MSG);
        if (StringUtil.isEmptyOrNull((String)msg)) {
            return;
        }
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        int code = intent.getIntExtra(ARG_IM_ERROR_CODE, -1);
        ErrorMsgDialog dlg = (ErrorMsgDialog)fm.findFragmentByTag(ErrorMsgDialog.class.getName());
        if (dlg != null) {
            dlg.onNewErrorMsg(msg, code);
        }
    }

    public static void onNewIncomingCall(Context context, PTAppProtos.InvitationItem invitation) {
        Intent intent = new Intent(context, IntegrationActivity.class);
        intent.addFlags(0x10020000);
        intent.setAction(ACTION_NEW_INCOMING_CALL);
        intent.putExtra(ARG_INVITATION, (Serializable)((Object)invitation));
        context.startActivity(intent);
    }

    public static void acceptNewIncomingCall(Context context, PTAppProtos.InvitationItem invitation) {
        Intent intent = new Intent(context, IntegrationActivity.class);
        intent.setFlags(0x10000000);
        intent.setAction(ACTION_ACCEPT_CALL);
        intent.putExtra(ARG_INVITATION, (Serializable)((Object)invitation));
        context.startActivity(intent);
    }

    public static void declineNewIncomingCall(Context context, PTAppProtos.InvitationItem invitation) {
        Intent intent = new Intent(context, IntegrationActivity.class);
        intent.setFlags(0x10000000);
        intent.setAction(ACTION_DECLINE_CALL);
        intent.putExtra(ARG_INVITATION, (Serializable)((Object)invitation));
        context.startActivity(intent);
    }

    public static void promptToInputUserNamePasswordForProxyServer(Context context, String server, int port) {
        Intent intent = new Intent(context, IntegrationActivity.class);
        intent.setFlags(0x10000000);
        intent.setAction(ACTION_INPUT_PROXY_NAME_PASS);
        intent.putExtra(ARG_SERVER, server);
        intent.putExtra(ARG_PORT, port);
        context.startActivity(intent);
    }

    public static void showCallNotAnsweredMessage(Context context, String userName) {
        Intent intent = new Intent(context, IntegrationActivity.class);
        intent.setFlags(0x10000000);
        intent.setAction(ACTION_SHOW_CALL_NOT_ANSWERED_MESSAGE);
        intent.putExtra(ARG_USERNAME, userName);
        context.startActivity(intent);
    }

    private void showCallNotAnsweredDialog(String userName) {
        if (userName == null) {
            return;
        }
        String message = this.getString(R.string.zm_msg_xxx_did_not_answer, new Object[]{userName});
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(message, true);
        dialog.show(this.getSupportFragmentManager(), SimpleMessageDialog.class.getSimpleName());
    }

    public static void promptVerifyCertFailureConfirmation(VideoBoxApplication context, VerifyCertEvent event) {
        Intent intent = new Intent((Context)context, IntegrationActivity.class);
        intent.setFlags(0x10000000);
        intent.setAction(ACTION_CONFIRM_VERIFY_CERT_FAILURE);
        intent.putExtra(ARG_VERIFY_CERT_EVENT, (Serializable)event);
        context.startActivity(intent);
    }

    public static void promptIMErrorMsg(VideoBoxApplication context, String errorMsg, int errorCode) {
        if (context == null || StringUtil.isEmptyOrNull((String)errorMsg)) {
            return;
        }
        Intent intent = new Intent((Context)context, IntegrationActivity.class);
        intent.setFlags(0x10000000);
        intent.setAction(ACTION_RECEIVE_IM_ERROR_MSG);
        intent.putExtra(ARG_IM_ERROR_MSG, errorMsg);
        intent.putExtra(ARG_IM_ERROR_CODE, errorCode);
        context.startActivity(intent);
    }
}

