/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import com.zipow.videobox.fragment.IMChatFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.view.IMBuddyItem;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;

public class IMChatActivity
extends ZMActivity
implements PTUI.IPTUIListener,
PTUI.IIMListener {
    public static final String INTENT_EXTRA_BUDDYITEM = "buddyItem";
    public static final String INTENT_EXTRA_MYNAME = "myName";
    private static final String TAG = IMChatActivity.class.getSimpleName();
    private IMBuddyItem mBuddyItem;
    private String mMyName;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null || !imHelper.isIMSignedOn()) {
            this.finish();
            return;
        }
        Intent intent = this.getIntent();
        this.mBuddyItem = (IMBuddyItem)intent.getSerializableExtra(INTENT_EXTRA_BUDDYITEM);
        this.mMyName = intent.getStringExtra(INTENT_EXTRA_MYNAME);
        if (this.mBuddyItem == null || this.mBuddyItem.userId == null || this.mBuddyItem.screenName == null || this.mMyName == null) {
            if (this.mBuddyItem == null) {
                // empty if block
            }
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            IMChatFragment f = new IMChatFragment();
            Bundle args = new Bundle();
            args.putSerializable(INTENT_EXTRA_BUDDYITEM, (Serializable)this.mBuddyItem);
            args.putString(INTENT_EXTRA_MYNAME, this.mMyName);
            f.setArguments(args);
            this.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, IMChatFragment.class.getName()).commit();
        }
        PTUI.getInstance().addPTUIListener(this);
        PTUI.getInstance().addIMListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.isFinishing()) {
            PTUI.getInstance().removePTUIListener(this);
            PTUI.getInstance().removeIMListener(this);
        }
    }

    public void onResume() {
        super.onResume();
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null || imHelper.getIMLocalStatus() == 0) {
            this.finish();
            return;
        }
    }

    private IMChatFragment getChatFragment() {
        IMChatFragment f = (IMChatFragment)this.getSupportFragmentManager().findFragmentByTag(IMChatFragment.class.getName());
        return f;
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 14: {
                this.sinkIMLogout(result);
                break;
            }
            case 22: {
                this.sinkCallStatusChanged(result);
                break;
            }
            case 23: {
                this.sinkCallPlistChanged();
                break;
            }
            case 0: {
                this.sinkWebLogin(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void sinkCallPlistChanged() {
        IMChatFragment f;
        if (this.isActive() && (f = this.getChatFragment()) != null) {
            f.onCallPlistChanged();
        }
    }

    private void sinkCallStatusChanged(long result) {
        IMChatFragment f;
        if (this.isActive() && (f = this.getChatFragment()) != null) {
            f.onCallStatusChanged(result);
        }
    }

    private void sinkIMLogout(long result) {
        if (this.isActive() && result == 0L) {
            this.finish();
        }
    }

    private void sinkWebLogin(long result) {
        IMChatFragment f;
        if (this.isActive() && result == 0L && (f = this.getChatFragment()) != null) {
            f.onWebLogin(result);
        }
    }

    @Override
    public void onIMReceived(PTAppProtos.IMMessage message) {
        IMChatFragment f;
        if (this.isActive() && (f = this.getChatFragment()) != null) {
            f.onIMReceived(message);
        }
    }

    @Override
    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
        IMChatFragment f;
        if (this.isActive() && (f = this.getChatFragment()) != null) {
            f.onIMBuddyPresence(item);
        }
    }

    @Override
    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
        IMChatFragment f;
        if (this.isActive() && (f = this.getChatFragment()) != null) {
            f.onIMBuddyPic(item);
        }
    }

    @Override
    public void onIMLocalStatusChanged(int status) {
    }

    @Override
    public void onIMBuddySort() {
    }

    @Override
    public void onSubscriptionRequest() {
    }

    @Override
    public void onSubscriptionUpdate() {
    }

    @Override
    public void onQuerySSOVanityURL(String reqId, int result, String url) {
    }

    @Override
    public void onQueryIPLocation(int result, PTAppProtos.IPLocationInfo ipInfo) {
    }
}

