/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ZMBaseService;
import com.zipow.videobox.ZoomApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfIPCPort;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.delegate.PTUIDelegation;
import com.zipow.videobox.util.AppStateMonitor;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import us.zoom.androidlib.app.ForegroundTaskManager;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.preference.ZMPreferencesStoreUtils;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.ZMLog;

public class ConfService
extends ZMBaseService {
    private static final String TAG = ConfService.class.getSimpleName();
    public static final int COMMAND_JOIN_BY_ID = 1;
    public static final int COMMAND_JOIN_BY_URL = 2;
    public static final String ARGS_EXTRA = "args";
    public static final String ARG_COMMAND_LINE = "commandLine";
    public static final String ARG_COMMAND_TYPE = "commandType";
    public static final String ARG_CONF_NUMBER = "confno";
    public static final String ARG_URL_ACTION = "urlAction";
    public static final String ARG_CONF_ID = "confid";
    public static final String ARG_SCREEN_NAME = "screenName";
    private boolean mIsCommandLineExecuted = false;

    public IBinder onBind(Intent intent) {
        return new ServiceBinder();
    }

    protected void doJoinById(Bundle args) {
        long confNumber = args.getLong(ARG_CONF_NUMBER);
        String screenName = args.getString(ARG_SCREEN_NAME);
        if (screenName == null) {
            screenName = "";
        }
    }

    protected void doJoinByUrl(Bundle args) {
        String screenName = args.getString(ARG_SCREEN_NAME);
        if (screenName == null) {
            screenName = "";
        }
        ConfMgr.getInstance().onUserConfirmToJoin(true, screenName);
    }

    private void doCommandLine(String commandLine) {
        if (this.mIsCommandLineExecuted) {
            return;
        }
        Mainboard mainboard = Mainboard.getMainboard();
        if (!VideoBoxApplication.getInstance().isSDKMode()) {
            if (mainboard != null && !mainboard.isInitialized()) {
                VideoBoxApplication.getInstance().initConfMainboard(commandLine);
                this.mIsCommandLineExecuted = true;
            }
        } else if (mainboard != null && !mainboard.isSDKConfAppCreated()) {
            VideoBoxApplication.getInstance().initConfAppForSDK(commandLine);
            this.mIsCommandLineExecuted = true;
        }
    }

    @Override
    public void onCreate() {
        Context appContext;
        super.onCreate();
        VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
        if (videoBoxApplication == null && (appContext = this.getApplicationContext()) instanceof ZoomApplication) {
            VideoBoxApplication.initialize(appContext, false, 1, null);
        }
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        this.doCommand(intent);
        return 2;
    }

    private void doCommand(Intent intent) {
        if (intent == null) {
            return;
        }
        Bundle args = intent.getBundleExtra(ARGS_EXTRA);
        if (args != null) {
            String commandLine = args.getString(ARG_COMMAND_LINE);
            if (commandLine != null) {
                this.doCommandLine(commandLine);
            } else if (args.getInt(ARG_COMMAND_TYPE) == 1) {
                this.doJoinById(args);
            } else if (args.getInt(ARG_COMMAND_TYPE) == 2) {
                this.doJoinByUrl(args);
            }
        }
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    @Override
    protected void checkStartService() {
        if (OsUtil.isAtLeastO()) {
            VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
            if (ZMPreferencesStoreUtils.getBoolean((Context)this, (String)"PREFERENCE_PROVIDER_DEFAULT_SP_NAME", (String)((Object)((Object)this)).getClass().getName(), (boolean)true, (boolean)(videoBoxApplication == null ? true : videoBoxApplication.isMultiProcess()))) {
                this.showConfNotification();
            }
        }
    }

    private static class ServiceBinder
    extends IConfService.Stub {
        private Handler mHandler = new Handler();

        @Override
        public void sendMessage(byte[] message) throws RemoteException {
            ConfIPCPort.getInstance().onMessageReceived(message);
        }

        @Override
        public boolean isConfAppAtFront() throws RemoteException {
            ZMActivity activity = ZMActivity.getFrontActivity();
            return activity != null && activity.isActive();
        }

        @Override
        public void sinkPTAppEvent(final int event, final long result) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PTUIDelegation.getInstance().dispatchPTAppEvent(event, result);
                }
            });
        }

        @Override
        public void sinkDataNetworkStatusChanged(final boolean connected) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PTUIDelegation.getInstance().sinkNetworkState(connected);
                }
            });
        }

        @Override
        public void sinkIMLocalStatusChanged(final int status) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PTUIDelegation.getInstance().sinkIMLocalStatusChanged(status);
                }
            });
        }

        @Override
        public void sinkIMReceived(final byte[] content) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PTUIDelegation.getInstance().sinkIMReceived(content);
                }
            });
        }

        @Override
        public void sinkIMBuddyPresence(final byte[] content) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PTUIDelegation.getInstance().sinkIMBuddyPresence(content);
                }
            });
        }

        @Override
        public void sinkIMBuddyPic(final byte[] content) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PTUIDelegation.getInstance().sinkIMBuddyPic(content);
                }
            });
        }

        @Override
        public void sinkIMBuddySort() throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PTUIDelegation.getInstance().sinkIMBuddySort();
                }
            });
        }

        @Override
        public void onPTUIMoveToFront(final String activityClass) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ForegroundTaskManager.getInstance().onAnotherProcessMoveToFront(activityClass);
                    AppStateMonitor.getInstance().onPTUIMoveToFront();
                }
            });
        }

        @Override
        public void onPTUIMoveToBackground() throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AppStateMonitor.getInstance().onPTUIMoveToBackground();
                }
            });
        }

        @Override
        public void leaveCurrentMeeting(final boolean endIfPossible) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ConfMgr confMgr = ConfMgr.getInstance();
                    CmmConfStatus status = confMgr.getConfStatusObj();
                    if (status != null && endIfPossible && status.isHost()) {
                        confMgr.endConference();
                    } else {
                        confMgr.leaveConference();
                    }
                }
            });
        }

        @Override
        public void pauseCurrentMeeting() throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ConfUI.getInstance().pauseAudio();
                }
            });
        }

        @Override
        public void resumeCurrentMeeting() throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ConfUI.getInstance().resumeAudio();
                }
            });
        }

        @Override
        public boolean isCurrentMeetingLocked() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ConfMgr confMgr = ConfMgr.getInstance();
                    CmmConfStatus status = confMgr.getConfStatusObj();
                    if (status != null && status.isConfLocked()) {
                        return true;
                    }
                    return false;
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean isCurrentMeetingHost() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    CmmUser myself = ConfMgr.getInstance().getMyself();
                    if (myself != null && myself.isHost()) {
                        return true;
                    }
                    return false;
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean startCallOut(final String number) throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ConfMgr confMgr = ConfMgr.getInstance();
                    CmmConfStatus status = confMgr.getConfStatusObj();
                    if (status != null && status.startCallOut(number)) {
                        return true;
                    }
                    return false;
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean hangUpCallOut() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ConfMgr confMgr = ConfMgr.getInstance();
                    CmmConfStatus status = confMgr.getConfStatusObj();
                    if (status != null && status.hangUp()) {
                        return true;
                    }
                    return false;
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean isCallOutInProgress() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ConfMgr confMgr = ConfMgr.getInstance();
                    CmmConfStatus status = confMgr.getConfStatusObj();
                    return status != null && status.isCallOutInProgress();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public int getCallMeStatus() throws RemoteException {
            FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    ConfMgr confMgr = ConfMgr.getInstance();
                    CmmConfStatus status = confMgr.getConfStatusObj();
                    if (status != null) {
                        return status.getCallMeStatus();
                    }
                    return 0;
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return 0;
            }
        }

        @Override
        public boolean isCallOutSupported() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                    if (confContext == null) {
                        return false;
                    }
                    MeetingInfo meetingItem = confContext.getMeetingItem();
                    if (meetingItem == null) {
                        return false;
                    }
                    int supportCallOutType = meetingItem.getSupportCallOutType();
                    return 0 != supportCallOutType && !meetingItem.getTelephonyOff();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean isInviteRoomSystemSupported() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                    if (confContext == null) {
                        return false;
                    }
                    MeetingInfo info = confContext.getMeetingItem();
                    if (info == null) {
                        return false;
                    }
                    return info.getIsH323Enabled();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public void onRoomCallEvent(final int event, final long result, final boolean isActiveMeeting) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ConfUI.getInstance().onRoomSystemCallStatus(event, result, isActiveMeeting);
                }
            });
        }

        @Override
        public boolean tryRetrieveMicrophone() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ConfUI.getInstance().tryRetrieveMicrophone();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public void onSipCallEvent(int status, String callId) throws RemoteException {
        }

        @Override
        public void onSipStatusEvent(boolean isAvailable) throws RemoteException {
        }
    }
}

