/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.ConfChatFragmentOld;
import com.zipow.videobox.mainboard.Mainboard;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ConfChatActivityOld
extends ZMActivity {
    public static final String ARG_USERID = "userId";

    public static void show(ZMActivity activity, long userId, int requestCode) {
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, ConfChatActivityOld.class);
        intent.setFlags(131072);
        intent.putExtra(ARG_USERID, userId);
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (VideoBoxApplication.getInstance() == null || VideoBoxApplication.getInstance().isSDKMode() && !mainboard.isSDKConfAppCreated()) {
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            Intent intent = this.getIntent();
            long userId = intent.getLongExtra(ARG_USERID, 0L);
            ConfChatFragmentOld.showActivity(this, userId);
        }
    }

    public void onDestroy() {
        if (this.isFinishing()) {
            UIUtil.closeSoftKeyboard((Context)this, (View)this.getWindow().getDecorView());
        }
        super.onDestroy();
    }
}

