/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentManager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.annotate.ZoomShareData;
import com.zipow.nydus.KUBIDeviceController;
import com.zipow.nydus.VideoCapturer;
import com.zipow.videobox.ConfAccessibilityActivity;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.PListActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmFeedbackMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.TipMessageType;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.confapp.ZoomRaiseHandInWebinar;
import com.zipow.videobox.confapp.ZoomShareUI;
import com.zipow.videobox.confapp.bo.BOLeaveFragment;
import com.zipow.videobox.confapp.bo.BOMeetingEndDialogFragment;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.confapp.bo.BOObject;
import com.zipow.videobox.confapp.bo.BOUI;
import com.zipow.videobox.confapp.bo.BOUpdatedUser;
import com.zipow.videobox.confapp.meeting.confhelper.CameraComponent;
import com.zipow.videobox.confapp.meeting.confhelper.FeccComponent;
import com.zipow.videobox.confapp.meeting.confhelper.LiveStreamComponent;
import com.zipow.videobox.confapp.meeting.confhelper.ShareComponent;
import com.zipow.videobox.confapp.poll.PollingMgr;
import com.zipow.videobox.confapp.poll.PollingUI;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.dialog.ConfAllowTalkDialog;
import com.zipow.videobox.dialog.ShareAlertDialog;
import com.zipow.videobox.dialog.SharePermissionAlertDialog;
import com.zipow.videobox.fragment.ConfChatFragment;
import com.zipow.videobox.fragment.HostKeyEnterDialog;
import com.zipow.videobox.fragment.HostKeyErrorDialog;
import com.zipow.videobox.fragment.InviteFragment;
import com.zipow.videobox.fragment.MeetingRunningInfoFragment;
import com.zipow.videobox.fragment.NonVerbalFeedbackIndicatorTip;
import com.zipow.videobox.fragment.NonVerbalFeedbackPromptTip;
import com.zipow.videobox.fragment.PListFragment;
import com.zipow.videobox.fragment.QAWebinarAttendeeListFragment;
import com.zipow.videobox.fragment.RecordControlDialog;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.kubi.KubiChoiceFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.poll.IPollingDoc;
import com.zipow.videobox.poll.WebinarPollingActivity;
import com.zipow.videobox.poll.WebinarPollingResultActivity;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.ptapp.delegate.PTUIDelegation;
import com.zipow.videobox.share.ScreenShareMgr;
import com.zipow.videobox.share.ShareView;
import com.zipow.videobox.util.AppStateMonitor;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ConfShareLocalHelper;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.TimeFormatUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.AudioClip;
import com.zipow.videobox.view.AudioTip;
import com.zipow.videobox.view.CallConnectingView;
import com.zipow.videobox.view.ChatTip;
import com.zipow.videobox.view.ConfChatItem;
import com.zipow.videobox.view.ConfToolbar;
import com.zipow.videobox.view.ConfToolsPanel;
import com.zipow.videobox.view.JoinLeaveTip;
import com.zipow.videobox.view.MessageTip;
import com.zipow.videobox.view.MoreTip;
import com.zipow.videobox.view.NormalMessageButtonTip;
import com.zipow.videobox.view.NormalMessageTip;
import com.zipow.videobox.view.OnSilentView;
import com.zipow.videobox.view.RaiseHandTip;
import com.zipow.videobox.view.ShareTip;
import com.zipow.videobox.view.VideoTip;
import com.zipow.videobox.view.WaitingJoinView;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.DriverModeVideoScene;
import com.zipow.videobox.view.video.GalleryVideoScene;
import com.zipow.videobox.view.video.NormalVideoScene;
import com.zipow.videobox.view.video.RCFloatView;
import com.zipow.videobox.view.video.RCMouseView;
import com.zipow.videobox.view.video.ShareVideoScene;
import com.zipow.videobox.view.video.VideoRenderer;
import com.zipow.videobox.view.video.VideoSceneMgr;
import com.zipow.videobox.view.video.VideoSceneMgrLarge;
import com.zipow.videobox.view.video.VideoView;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.microedition.khronos.opengles.GL10;
import org.webrtc.voiceengine.VoiceEnginContext;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.HardwareUtil;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.IDownloadFileListener;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.ParamsList;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.UiModeUtil;
import us.zoom.androidlib.util.ViewPressEffectHelper;
import us.zoom.androidlib.util.ZMAsyncTask;
import us.zoom.androidlib.util.ZMAsyncURLDownloadFile;
import us.zoom.androidlib.widget.CaptionView;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMTipLayer;
import us.zoom.videomeetings.R;

public class ConfActivityNormal
extends ConfAccessibilityActivity
implements ConfUI.IConfUIListener,
ConfToolbar.Listener,
View.OnClickListener,
SurfaceHolder.Callback,
VideoView.Listener,
ConfToolsPanel.Listener,
AppStateMonitor.IAppStateListener,
ScreenShareMgr.Listener,
RCFloatView.IRemoteControlButtonStatusListener,
ShareComponent.ShareActionCallBack {
    private static final int RENDERER_FPS = 25;
    private static final int RENDERER_FPS_LOW_PERFORMANCE = 15;
    private static final int TOOLBAR_TIMEOUT = 5000;
    private static final int TIMER_REFRESH_DURATION = 1000;
    private static final String PREF_SHARE_STATUS = "share_status";
    private static final String PREF_CLOSED_CAPTION_CONTENT = "closed_caption_content";
    private static final String PREF_SCREEN_INFO_DATA = "screen_info_data";
    private static final String TAG = ConfActivityNormal.class.getSimpleName();
    private static final String BO_MEETING_LEAVE_BO_TAG = "bo_leave_bo_tag";
    private static final String BO_MEETING_END_ALL_BO_IN_BO_TAG = "bo_end_all_bo_in_bo_tag";
    private static final String BO_MEETING_END_ALL_BO_IN_MASTER_TAG = "bo_end_all_bo_in_master_tag";
    private static final String BO_NEW_ATTENDEE_UNASSIGNED_TAG = "bo_new_attendee_unassigned_tag";
    private View mConfView;
    private LiveStreamComponent mLiveStreamComponent;
    private WaitingJoinView mWaitingJoinView;
    private View mVerifyingMeetingIDView;
    private View mPanelConnecting;
    private VideoView mVideoView;
    private ConfToolbar mToolbar;
    private View mTopbar;
    private SurfaceView mSvPreview;
    private ConfToolsPanel mPanelTools;
    private TextView mTxtMeetingNumber;
    private TextView mTxtTimer;
    private TextView mTxtPassword;
    private View mPanelSwitchSceneButtons;
    private View mPanelRecording;
    private View mPanelCurUserRecording;
    private View mPanelStartingRecord;
    private TextView mTxtStartingRecrod;
    private View mPanelAudioSharing;
    private CallConnectingView mCallConnectingView;
    private OnSilentView mOnSilentView;
    private ImageView mImgAudioSource;
    private View mBtnSwitchToShare;
    private View mQaView;
    private TextView mTxtQAOpenNumber;
    private View mBtnBOHelp;
    private View mBtnBO;
    private View mBtnKubi;
    private ImageView mImgKubi;
    private TextView mTxtKubiStatus;
    private ImageView mImgRecording;
    private View mProgressStartingRecord;
    private TextView mTxtRecordStatus;
    private ImageView mImgRecordControlArrow;
    private RCFloatView mRCFloatView;
    private RCMouseView mRCMouseView;
    private ImageView mImgE2EMeetingView;
    private Button mBtnPoll;
    private View mPanelRejoinMsg;
    private boolean mbBOInRequestHelp = false;
    private View mPanelBOStatusChange;
    private ZMAlertDialog mBOHelpDialog = null;
    private ZMAlertDialog mBOCannotForHelpDialog = null;
    private ZMAlertDialog mBOControllerHasEndedDialog = null;
    private boolean mBOControllerStopTickStarted = false;
    private PTUI.IPTUIListener mPTUIListener;
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private BOUI.IBOUIListener mBOUIListener;
    private KUBIDeviceController.IKubiListener mKubiListener;
    private VideoRenderer mRenderer;
    private ZMTipLayer mTipLayer;
    private Button mBtnBack;
    private Button mBtnLeave;
    private static Handler g_handler = new Handler();
    private Handler mHandler = new Handler();
    private boolean mbLeaveComplete = false;
    private transient int mToolbarHeight = 0;
    private transient int mTopbarHeight = 0;
    private View mPracticeModeView;
    private View mBroadcastingView;
    private Button mBtnBroadcast;
    private ProgressBar mProgressBarBroadcasting;
    private FeccComponent mFeccComponent;
    private CameraComponent mCameraComponent;
    private ShareView shareView;
    private long mCurSharerUserId = 0L;
    private boolean mbReceiveShareData = false;
    private boolean mbPresenter = false;
    private boolean mbEditStatus = false;
    private boolean mBSharePaused = false;
    private boolean mbShareScreen = false;
    private int mShareStatus = 0;
    private ShareComponent mShareComponent;
    private PollingUI.IPollingUIListener mPollingUIListener = null;
    private ZMAsyncTask<Uri, Void, Bitmap> mTaskLoadImageToShare;
    private ZMAsyncURLDownloadFile mTaskDownloadFile;
    private ProgressDialog mDlgWaitingLoadImageToShare;
    private ProgressDialog mDownloadFileWaitingDialog = null;
    private boolean mbHasSurface;
    private ProgressDialog mVerifyHostKeyWaitingDialog = null;
    private CaptionView mClosedCaptionView;
    private String mClosedCaptionContent;
    private static int CLOSECAPTION_DURATION = 10000;
    private ZMAlertDialog mJoinWaitingListDlg;
    private Intent mScreenInfoData;
    Runnable mTimerRunnable = new Runnable(){

        @Override
        public void run() {
            ConfActivityNormal.this.mTxtTimer.setVisibility(ConfMgr.getInstance().isShowClockEnable() ? 0 : 8);
            CmmConfStatus cmmConfStatus = ConfMgr.getInstance().getConfStatusObj();
            if (cmmConfStatus != null) {
                ConfActivityNormal.this.mTxtTimer.setText((CharSequence)TimeUtil.formateDuration((long)cmmConfStatus.getMeetingElapsedTimeInSecs()));
            }
            ConfActivityNormal.this.mHandler.postDelayed((Runnable)this, 1000L);
        }
    };
    private ZoomShareUI.IZoomShareUIListener mZoomShareUIListener = new ZoomShareUI.SimpleZoomShareUIListener(){

        @Override
        public void OnShareSourceAnnotationSupportPropertyChanged(long nShareSourceID, boolean bSupportAnnotation) {
            boolean isStartingShare;
            boolean bl = isStartingShare = ConfActivityNormal.this.mShareStatus == 2 || ConfActivityNormal.this.mShareStatus == 1;
            if (isStartingShare && ConfActivityNormal.this.mbPresenter) {
                return;
            }
            bSupportAnnotation = ConfActivityNormal.this.checkConfSupportOrEnableAnnotate();
            if (ConfActivityNormal.this.isInShareVideoScene()) {
                ConfActivityNormal.this.setShareViewVisible();
            }
        }

        @Override
        public void OnShareSourceSendStatusChanged(long nShareSourceUserID, boolean bPaused) {
            ConfActivityNormal.this.mBSharePaused = bPaused;
            if (null != ConfActivityNormal.this.shareView) {
                ConfActivityNormal.this.shareView.setSharePauseStatuChanged(bPaused);
            }
        }

        @Override
        public void OnStartViewPureComputerAudio(long nShareSourceID) {
            ConfActivityNormal.this.OnViewPureComputerAudioStatusChanged(nShareSourceID, true);
        }

        @Override
        public void OnStopViewPureComputerAudio(long nShareSourceID) {
            ConfActivityNormal.this.OnViewPureComputerAudioStatusChanged(nShareSourceID, false);
        }
    };
    private AudioClip mDuduVoiceClip;
    Runnable mAttendeeRaiseLowerHandRunnalbe = new Runnable(){

        @Override
        public void run() {
            ConfActivityNormal.this.updateRaiseHandStatus();
        }
    };
    private Runnable mUnmuteMyselfRunnable = new Runnable(){

        @Override
        public void run() {
            ConfLocalHelper.hostAskUnmute();
        }
    };
    private static Runnable g_hideToolbarRunnable;
    private Runnable mClosedCaptionTimeoutRunnable = new Runnable(){

        @Override
        @SuppressLint(value={"NewApi"})
        public void run() {
            if (ConfActivityNormal.this.isDestroyed()) {
                return;
            }
            ConfActivityNormal.this.mClosedCaptionView.setVisibility(8);
            ConfActivityNormal.this.mClosedCaptionContent = null;
        }
    };

    protected int getLayout() {
        int layout2 = 0;
        layout2 = UIMgr.isLargeMode((Context)this) ? R.layout.zm_conf_main_screen_large : R.layout.zm_conf_main_screen;
        return layout2;
    }

    @Override
    public FeccComponent getmFeccComponent() {
        return this.mFeccComponent;
    }

    @Override
    public CameraComponent getmCameraComponent() {
        return this.mCameraComponent;
    }

    @Override
    public ShareComponent getmShareComponent() {
        return this.mShareComponent;
    }

    protected boolean isSensorOrientationEnabled() {
        return true;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.isImmersedModeEnabled()) {
            UIUtil.setTranslucentStatus((Activity)this, (boolean)true);
        } else if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.setStatusBarColor(this.getResources().getColor(R.color.zm_black));
        }
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return;
        }
        if (VideoBoxApplication.getInstance() == null || VideoBoxApplication.getInstance().isSDKMode() && !mainboard.isSDKConfAppCreated()) {
            this.finish();
            return;
        }
        this.initUIOrientation();
        this.getWindow().addFlags(0x600080);
        this.updateSystemStatusBar();
        this.setContentView(this.getLayout());
        this.mConfView = this.findViewById(R.id.confView);
        this.mWaitingJoinView = (WaitingJoinView)this.findViewById(R.id.waitingJoinView);
        this.mVerifyingMeetingIDView = this.findViewById(R.id.verifyingMeetingId);
        this.mTipLayer = (ZMTipLayer)this.findViewById(R.id.tipLayer);
        this.mPanelConnecting = this.mConfView.findViewById(R.id.panelConnecting);
        this.mToolbar = (ConfToolbar)this.findViewById(R.id.confToolbar);
        if (PreferenceUtil.readBooleanValue("large_share_video_scene_mode", false)) {
            this.mToolbar.setBackgroundColor(this.getResources().getColor(R.color.zm_sdk_conf_toolbar_bg));
        }
        this.mTopbar = this.findViewById(R.id.panelTop);
        this.mVideoView = (VideoView)this.findViewById(R.id.videoView);
        this.mSvPreview = (SurfaceView)this.findViewById(R.id.svPreview);
        this.mPanelTools = (ConfToolsPanel)this.findViewById(R.id.panelTools);
        this.mTxtMeetingNumber = (TextView)this.mConfView.findViewById(R.id.txtMeetingNumber);
        this.mTxtTimer = (TextView)this.mConfView.findViewById(R.id.txtTimer);
        this.mTxtPassword = (TextView)this.mConfView.findViewById(R.id.txtPassword);
        this.mBtnBack = (Button)this.mConfView.findViewById(R.id.btnBack);
        this.mPanelRecording = this.findViewById(R.id.panelRecording);
        this.mPanelCurUserRecording = this.findViewById(R.id.panelCurUserRecording);
        this.mImgRecording = (ImageView)this.mPanelCurUserRecording.findViewById(R.id.imgRecording);
        this.mProgressStartingRecord = this.mPanelCurUserRecording.findViewById(R.id.progressStartingRecord);
        this.mImgRecordControlArrow = (ImageView)this.mPanelCurUserRecording.findViewById(R.id.imgRecordControlArrow);
        this.mTxtRecordStatus = (TextView)this.mPanelCurUserRecording.findViewById(R.id.txtRecordStatus);
        this.mPanelStartingRecord = this.findViewById(R.id.panelStartingRecord);
        this.mTxtStartingRecrod = (TextView)this.findViewById(R.id.txtStartingRecord);
        this.mCallConnectingView = (CallConnectingView)this.findViewById(R.id.callconnectingView);
        this.mOnSilentView = (OnSilentView)this.findViewById(R.id.onHoldView);
        this.mImgAudioSource = (ImageView)this.findViewById(R.id.imgAudioSource);
        this.mBtnSwitchToShare = this.findViewById(R.id.btnSwitchToShare);
        this.mCameraComponent = new CameraComponent(this);
        this.mQaView = this.findViewById(R.id.rlQa);
        this.mTxtQAOpenNumber = (TextView)this.findViewById(R.id.txtQAOpenNumber);
        this.mBtnPoll = (Button)this.findViewById(R.id.btnPoll);
        this.mPanelRejoinMsg = this.findViewById(R.id.panelRejoinMsg);
        this.mPanelAudioSharing = this.findViewById(R.id.panelAudioShare);
        this.mPracticeModeView = this.findViewById(R.id.praticeModeView);
        this.mBroadcastingView = this.findViewById(R.id.broadcastingView);
        this.mBtnBroadcast = (Button)this.findViewById(R.id.btnBroadcast);
        this.mProgressBarBroadcasting = (ProgressBar)this.findViewById(R.id.progressBarBroadcasting);
        this.mBtnBOHelp = this.findViewById(R.id.btnBOHelp);
        this.mBtnBO = this.findViewById(R.id.btnBreakout);
        this.mPanelBOStatusChange = this.findViewById(R.id.panelBOStatusChange);
        this.mBtnKubi = this.findViewById(R.id.btnKubi);
        this.mImgKubi = (ImageView)this.findViewById(R.id.imgKubi);
        this.mTxtKubiStatus = (TextView)this.findViewById(R.id.txtKubiStatus);
        this.mClosedCaptionView = (CaptionView)this.findViewById(R.id.txtClosedCaption);
        this.mClosedCaptionView.setVisibility(8);
        this.mBtnBOHelp.setVisibility(8);
        this.mBtnBO.setVisibility(8);
        this.mPanelStartingRecord.setVisibility(8);
        this.mShareComponent = new ShareComponent(this);
        this.shareView = (ShareView)this.mConfView.findViewById(R.id.sharingView);
        this.mRCFloatView = (RCFloatView)this.findViewById(R.id.rc_float_view);
        if (this.mRCFloatView != null) {
            this.mRCFloatView.setRemoteControlButtonStatusListener(this);
        }
        this.mRCMouseView = (RCMouseView)this.findViewById(R.id.rc_mouse);
        this.mFeccComponent = new FeccComponent(this);
        this.mLiveStreamComponent = new LiveStreamComponent(this, this.mConfView);
        this.mbHasSurface = false;
        this.mImgE2EMeetingView = (ImageView)this.findViewById(R.id.imgE2EIcon);
        this.setPaddingsForTranslucentStatus();
        this.shareView.setShareListener(new ShareView.ShareViewListener(){

            @Override
            public void onStopEdit() {
                ConfActivityNormal.this.mbEditStatus = false;
                if (!ConfActivityNormal.this.mConfParams.isBottomBarDisabled() && !ConfActivityNormal.this.isInDriveModeScence()) {
                    ConfActivityNormal.this.showBottomToolbar(true);
                }
            }

            @Override
            public void onStartEdit() {
                ConfActivityNormal.this.onAnnotationStarted();
                ConfActivityNormal.this.mbEditStatus = true;
                ConfActivityNormal.this.showTopToolbar(false);
                ConfActivityNormal.this.showBottomToolbar(false);
                if (null != ConfActivityNormal.this.mVideoSceneMgr && ConfActivityNormal.this.mVideoSceneMgr.getActiveScene() instanceof ShareVideoScene) {
                    ((ShareVideoScene)ConfActivityNormal.this.mVideoSceneMgr.getActiveScene()).hideTitleAndSwitchScenePanel();
                }
            }

            @Override
            public void onShareError() {
                ConfActivityNormal.this.stopShare();
            }
        });
        if (savedInstanceState != null) {
            this.mShareStatus = savedInstanceState.getInt(PREF_SHARE_STATUS, 0);
            this.mClosedCaptionContent = savedInstanceState.getString(PREF_CLOSED_CAPTION_CONTENT);
            this.mScreenInfoData = (Intent)savedInstanceState.getParcelable(PREF_SCREEN_INFO_DATA);
        }
        this.initTipLayer();
        this.initSurfaceView();
        this.initPanelTools();
        this.initVideoView();
        this.initPanelWaitingShare();
        this.initPanelSharingTitle();
        this.initPanelSwitchScene();
        this.initPTListener();
        this.initUIStatus();
        this.initVideoSceneMgr();
        this.initBOSession();
        VideoUnit.initDefaultResources();
        ConfUI.getInstance().addListener(this);
        AppStateMonitor.getInstance().addListener(this);
        this.registerPollingUIListener();
        this.registerQAListener();
        ScreenShareMgr.getInstance().initialize(this);
        this.registerKubiListener();
        ZoomShareUI.getInstance().addListener(this.mZoomShareUIListener);
        if (this.mBtnBack != null) {
            this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mImgAudioSource != null) {
            ViewPressEffectHelper.attach((View)this.mImgAudioSource);
            this.mImgAudioSource.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mBtnSwitchToShare != null) {
            this.mBtnSwitchToShare.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mQaView != null) {
            this.findViewById(R.id.btnQA).setOnClickListener((View.OnClickListener)this);
        }
        if (this.mBtnBOHelp != null) {
            this.mBtnBOHelp.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mBtnBO != null) {
            this.mBtnBO.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mBtnPoll != null) {
            this.mBtnPoll.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mBtnKubi != null) {
            this.mBtnKubi.setOnClickListener((View.OnClickListener)this);
        }
        VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr.isConfConnected()) {
            if (this.mVideoSceneMgr != null) {
                this.mVideoSceneMgr.onConfReady();
            }
            if (!this.checkStartDrivingModeOnConfReady()) {
                CmmAudioStatus audioStatus;
                boolean hasShown = false;
                CmmUser myself = confMgr.getMyself();
                if (myself != null && (audioStatus = myself.getAudioStatusObj()) != null && 2L == audioStatus.getAudiotype()) {
                    this.showToolbar(true, false);
                    hasShown = true;
                }
                if (!hasShown && confMgr.getUnreadChatMessageIndexes().length > 0) {
                    this.showToolbar(true, false);
                    hasShown = true;
                }
            }
        }
        this.mConfView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (ConfActivityNormal.this.mRCFloatView != null) {
                    ConfActivityNormal.this.mRCFloatView.onConfLayoutChanged(left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom);
                }
            }
        });
    }

    @Override
    public AbsVideoSceneMgr getVideoSceneMgr() {
        return this.mVideoSceneMgr;
    }

    @Override
    protected void attendeeVideoControlChanged(long videoControlMode) {
        super.attendeeVideoControlChanged(videoControlMode);
        if (this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.attendeeVideoControlChange(videoControlMode);
        }
    }

    @Override
    protected void attendeeVideoLayoutChanged(long videoLayout) {
        super.attendeeVideoLayoutChanged(videoLayout);
        if (this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.attendeeVideoLayoutChange(videoLayout);
        }
    }

    private void setPaddingsForTranslucentStatus() {
        if (this.isImmersedModeEnabled()) {
            if (this.mConfView == null) {
                return;
            }
            int paddingAdd = 0;
            if (UIUtil.isPortraitMode((Context)this)) {
                paddingAdd = UIUtil.getStatusBarHeight((Context)this);
            }
            int paddingLeft = UIUtil.dip2px((Context)this, (float)3.0f);
            int paddingTop = paddingAdd + UIUtil.dip2px((Context)this, (float)5.0f);
            int paddingRight = paddingLeft;
            int paddingBottom = UIUtil.dip2px((Context)this, (float)5.0f);
            View titleBar = this.mConfView.findViewById(R.id.titleBar);
            titleBar.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            this.mPanelConnecting.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            View connectingView = this.mVerifyingMeetingIDView.findViewById(R.id.panelConnecting);
            connectingView.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            if (this.mOnSilentView != null) {
                this.mOnSilentView.setTitlePadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            }
            if (this.mWaitingJoinView != null) {
                this.mWaitingJoinView.setTitlePadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            }
        }
    }

    private void registerPollingUIListener() {
        if (this.mPollingUIListener == null) {
            this.mPollingUIListener = new PollingUI.SimplePollingUIListener(){

                @Override
                public void onPollingStatusChanged(int pollstate, String strPID) {
                    ConfActivityNormal.this.onPollingStatusChangedImpl(pollstate, strPID);
                }

                @Override
                public void onPollingActionResult(int cmd, String strPID, int ret) {
                    ConfActivityNormal.this.onPollingActionResult(cmd, strPID, ret);
                }
            };
        }
        PollingUI.getInstance().addListener(this.mPollingUIListener);
    }

    private void unregisterPollingUIListener() {
        PollingUI.getInstance().removeListener(this.mPollingUIListener);
    }

    private void initUIOrientation() {
        if (UIMgr.isLargeMode((Context)this)) {
            this.setRequestedOrientation(0);
        }
    }

    private void initTipLayer() {
        this.mTipLayer.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean inToolbarRect = ConfActivityNormal.this.isInToolbarRect(event.getX(), event.getY());
                boolean bHasTips = ConfActivityNormal.this.dismissTempTips();
                boolean bHasMenus = ConfActivityNormal.this.hideToolbarMenus();
                if (!inToolbarRect) {
                    return bHasTips || bHasMenus;
                }
                return bHasMenus;
            }
        });
    }

    protected boolean isInToolbarRect(float x, float y) {
        if (!this.isToolbarShowing()) {
            return false;
        }
        int toolbarTop = this.mPanelTools.getTop();
        int toolbarBottom = this.mPanelTools.getBottom();
        int toolbarLeft = this.mPanelTools.getLeft();
        int toolbarRight = this.mPanelTools.getRight();
        return x >= (float)toolbarLeft && x <= (float)toolbarRight && y >= (float)toolbarTop && y <= (float)toolbarBottom;
    }

    private void initToolbar() {
        this.mToolbar.setListener(this);
        this.mToolbar.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){
            int lastToolbarTop = 0;
            int lastToolbarWidth = 0;

            public void onGlobalLayout() {
                int toolbarTop = ConfActivityNormal.this.mToolbar.getTop();
                int toolbarWidth = ConfActivityNormal.this.mToolbar.getWidth();
                if (toolbarTop != this.lastToolbarTop || toolbarWidth != this.lastToolbarWidth) {
                    this.lastToolbarTop = toolbarTop;
                    this.lastToolbarWidth = toolbarWidth;
                    ConfActivityNormal.this.mTipLayer.requestLayout();
                }
            }
        });
    }

    private void initSurfaceView() {
        SurfaceHolder holder = this.mSvPreview.getHolder();
        holder.setType(3);
    }

    @SuppressLint(value={"NewApi"})
    private void initVideoView() {
        this.mRenderer = this.createVideoRenderer();
        if (Build.VERSION.SDK_INT >= 11) {
            this.mVideoView.setPreserveEGLContextOnPause(true);
        }
        this.mVideoView.setRenderer(this.mRenderer);
        this.mVideoView.setListener(this);
    }

    private void initPanelWaitingShare() {
        View panelWaitingShare = this.findViewById(R.id.panelWaitingShare);
        panelWaitingShare.setVisibility(8);
        panelWaitingShare.setOnClickListener((View.OnClickListener)this);
    }

    private void initPanelSharingTitle() {
        View panelSharingTitle = this.findViewById(R.id.panelSharingTitle);
        if (panelSharingTitle != null) {
            panelSharingTitle.setVisibility(8);
        }
    }

    private void initPanelTools() {
        if (!UIMgr.isLargeMode((Context)this)) {
            View panelTop = this.mPanelTools.findViewById(R.id.panelTop);
            this.showTopToolbar(false);
            panelTop.setOnClickListener((View.OnClickListener)this);
            this.mBtnLeave = (Button)panelTop.findViewById(R.id.btnLeave);
            this.mBtnLeave.setOnClickListener((View.OnClickListener)this);
        }
        this.mPanelTools.setListener(this);
        this.initToolbar();
    }

    private void initPanelSwitchScene() {
        if (!UIMgr.isLargeMode((Context)this)) {
            View panelSwitchScene = this.findViewById(R.id.panelSwitchScene);
            panelSwitchScene.setVisibility(8);
            this.mPanelSwitchSceneButtons = this.findViewById(R.id.panelSwitchSceneButtons);
            this.mPanelSwitchSceneButtons.setVisibility(0);
        }
    }

    private void initPTListener() {
        this.mPTUIListener = new PTUI.IPTUIListener(){

            @Override
            public void onPTAppEvent(int ptEvent, long result) {
                switch (ptEvent) {
                    case 0: 
                    case 8: {
                        ConfActivityNormal.this.onIMLogin(result);
                        break;
                    }
                    case 1: 
                    case 14: {
                        ConfActivityNormal.this.onIMLogout();
                    }
                }
            }

            @Override
            public void onDataNetworkStatusChanged(boolean connected) {
            }
        };
        PTUIDelegation.getInstance().addPTUIListener(this.mPTUIListener);
    }

    private void OnViewPureComputerAudioStatusChanged(long sourceId, boolean start) {
        this.doAccessiblityForViewAudioSharingStatus(this.mConfView, sourceId, start);
        this.refreshAudioSharing(true);
    }

    private void onIMLogout() {
        this.refreshBtnBack();
    }

    private void onIMLogin(long result) {
        this.refreshBtnBack();
    }

    private void uninitPTUIListener() {
        if (this.mPTUIListener != null) {
            PTUIDelegation.getInstance().removePTUIListener(this.mPTUIListener);
        }
    }

    private void initVideoSceneMgr() {
        ConfActivity.RetainedFragment f = this.getRetainedFragment();
        this.mVideoSceneMgr = f.restoreVideoSceneMgr();
        if (this.mVideoSceneMgr == null) {
            this.mVideoSceneMgr = UIMgr.isLargeMode((Context)this) ? new VideoSceneMgrLarge() : new VideoSceneMgr();
            f.saveVideoSceneMgr(this.mVideoSceneMgr);
        }
        this.mVideoSceneMgr.setVideoView((View)this.mVideoView);
        this.mVideoSceneMgr.onConfActivityCreated(this);
        this.mVideoSceneMgr.onGLRendererCreated(this.mRenderer);
    }

    private VideoRenderer createVideoRenderer() {
        VideoRenderer render = new VideoRenderer((View)this.mVideoView){
            long lastIdleTaskTime;
            private Runnable idleTask;
            {
                this.lastIdleTaskTime = 0L;
                this.idleTask = new Runnable(){

                    @Override
                    public void run() {
                        if (ConfActivityNormal.this.mVideoSceneMgr != null) {
                            ConfActivityNormal.this.mVideoSceneMgr.onIdle();
                        }
                    }
                };
            }

            @Override
            public void onDrawFrame(GL10 gl, VideoRenderer renderer) {
                long curTime;
                if (ConfActivityNormal.this.isActive() && !ConfActivityNormal.this.mbLeaveComplete && ((curTime = System.currentTimeMillis()) < this.lastIdleTaskTime || curTime - this.lastIdleTaskTime > 500L)) {
                    this.lastIdleTaskTime = curTime;
                    ConfActivityNormal.this.runOnUiThread(this.idleTask);
                }
            }

            private float getProperFPS() {
                float fps = 25.0f;
                if (HardwareUtil.getCPUKernalNumbers() < 2 && HardwareUtil.getCPUKernelFrequency((int)0, (int)2) < 1400000) {
                    fps = 15.0f;
                }
                return fps;
            }

            @Override
            protected void onGLSurfaceCreated() {
                this.startRenderer(this.getProperFPS());
            }

            @Override
            protected void onGLSurfaceChanged(final int width, final int height) {
                if (!this.isRunning()) {
                    this.startRenderer(this.getProperFPS());
                }
                final 9 renderer = this;
                ConfActivityNormal.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ShareSessionMgr shareMgr;
                        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
                        if (videoMgr != null) {
                            videoMgr.setGLViewSize(width, height);
                        }
                        if ((shareMgr = ConfMgr.getInstance().getShareObj()) != null) {
                            shareMgr.setGLViewSize(width, height);
                        }
                        if (!this.isInitialized()) {
                            this.initialize();
                        }
                        if (ConfActivityNormal.this.mVideoSceneMgr != null) {
                            ConfActivityNormal.this.mVideoSceneMgr.onGLRendererChanged(renderer, width, height);
                        }
                        if (null != ConfActivityNormal.this.shareView && ConfActivityNormal.this.isInMultiWindowMode()) {
                            ConfActivityNormal.this.shareView.onAnnotateViewSizeChanged();
                        }
                    }
                });
            }

            @Override
            protected void onSurfaceNeedDestroy() {
                ConfActivityNormal.this.onGLRendererDestroyed();
                super.onSurfaceNeedDestroy();
            }
        };
        return render;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 82) {
            this.switchToolbar();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void beforeSurfaceDestroyed() {
        this.mVideoSceneMgr.stopAllScenes();
    }

    @Override
    public void beforeGLContextDestroyed() {
        if (this.mRenderer != null) {
            this.mRenderer.beforeGLContextDestroyed();
            if (this.mRenderer.isRunning()) {
                this.mRenderer.stopRenderer();
            }
        }
    }

    @Override
    public void onVideoViewDoubleTap(MotionEvent e) {
        this.mVideoSceneMgr.onDoubleTap(e);
    }

    @Override
    public void onVideoViewScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (!this.mbEditStatus) {
            this.mVideoSceneMgr.onScroll(e1, e2, distanceX, distanceY);
        }
    }

    @Override
    public void onVideoViewFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        this.mVideoSceneMgr.onFling(e1, e2, velocityX, velocityY);
    }

    @Override
    public void onVideoViewSingleTapConfirmed(MotionEvent e) {
        if (ConfMgr.getInstance().isConfConnected() && !this.mVideoSceneMgr.onVideoViewSingleTapConfirmed(e)) {
            this.switchToolbar();
        }
    }

    @Override
    public void onVideoViewDown(MotionEvent e) {
        this.mVideoSceneMgr.onDown(e);
    }

    @Override
    public boolean onVideoViewHoverEvent(MotionEvent e) {
        return this.mVideoSceneMgr.onHoverEvent(e);
    }

    @Override
    public boolean onVideoViewTouchEvent(MotionEvent e) {
        if (this.isToolbarShowing()) {
            if (e.getAction() == 0) {
                if (g_hideToolbarRunnable != null) {
                    g_handler.removeCallbacks(g_hideToolbarRunnable);
                }
            } else if (e.getAction() == 1) {
                this.hideToolbarDelayed(5000L);
            }
        }
        return this.mVideoSceneMgr.onTouchEvent(e);
    }

    @Override
    public void onVideoViewDetachedFromWindow() {
        if (this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.onGLRendererNeedDestroy();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
        if (videoBoxApplication == null) {
            return;
        }
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            return;
        }
        if (VideoBoxApplication.getInstance().isSDKMode() && !mainboard.isSDKConfAppCreated()) {
            return;
        }
        if (this.mFeccComponent != null) {
            this.mFeccComponent.removeVideoFECCCmdListener();
        }
        ScreenShareMgr.getInstance().unInitialize();
        if (!ScreenShareMgr.getInstance().isSharing()) {
            this.stopShare();
        } else if (videoBoxApplication.isSDKMode() && ConfUI.getInstance().isLeavingConference()) {
            this.stopShare();
        }
        this.mHandler.removeCallbacks(this.mAttendeeRaiseLowerHandRunnalbe);
        this.mHandler.removeCallbacks(this.mClosedCaptionTimeoutRunnable);
        this.mHandler.removeCallbacks(this.mUnmuteMyselfRunnable);
        this.mHandler.removeCallbacks(g_hideToolbarRunnable);
        ConfUI.getInstance().removeListener(this);
        this.uninitPTUIListener();
        this.uninitialBOSession();
        this.unregisterPollingUIListener();
        this.unregisterQAListener();
        this.unregisterKubiListener();
        this.unregisterAnnotateListener();
        if (ConfUI.getInstance().isLeavingConference()) {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
            VideoBoxApplication.getInstance().clearConfAppContext();
        }
        this.stopPlayDuduVoice();
        if (g_hideToolbarRunnable != null) {
            g_handler.removeCallbacks(g_hideToolbarRunnable);
        }
        AppStateMonitor.getInstance().removeListener(this);
        this.dismissVerifyHostKeyDialog();
        this.dismissDownloadFileWaitingDialog();
        this.dismissWaitingLoadImageToShareDialog();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(PREF_SHARE_STATUS, this.mShareStatus);
        if (!StringUtil.isEmptyOrNull((String)this.mClosedCaptionContent)) {
            outState.putString(PREF_CLOSED_CAPTION_CONTENT, this.mClosedCaptionContent);
        }
        if (this.mScreenInfoData != null) {
            outState.putParcelable(PREF_SCREEN_INFO_DATA, (Parcelable)this.mScreenInfoData);
        }
    }

    private void onGLRendererDestroyed() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ConfActivityNormal.this.mbLeaveComplete) {
                    ConfMgr.getInstance().cleanupConf();
                    VideoBoxApplication.getInstance().stopConfService();
                }
                if (null != ConfActivityNormal.this.shareView && ConfActivityNormal.this.isInMultiWindowMode()) {
                    ConfActivityNormal.this.shareView.onAnnotateViewSizeChanged();
                }
            }
        });
    }

    @Override
    public void onAppActivated() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.setMobileAppActiveStatus(true);
    }

    @Override
    public void onAppInactivated() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.setMobileAppActiveStatus(false);
    }

    public void onMultiWindowModeChanged(boolean isInMultiWindowMode) {
        super.onMultiWindowModeChanged(isInMultiWindowMode);
    }

    protected void onPause() {
        super.onPause();
        if (!UiModeUtil.isInDesktopMode((Context)this) && !this.isInMultiWindowMode()) {
            this.stopVideo();
        }
        if (this.mTaskLoadImageToShare != null && !this.mTaskLoadImageToShare.isCancelled()) {
            this.mTaskLoadImageToShare.cancel(true);
        }
        this.mTaskLoadImageToShare = null;
        this.dismissWaitingLoadImageToShareDialog();
        this.stopDownloadFileTask();
    }

    private void stopVideo() {
        this.shareView.pause();
        this.mVideoSceneMgr.onConfActivityPause(this);
        this.mVideoView.onPause();
        if (this.mRenderer != null) {
            this.mRenderer.pauseRenderer();
        }
        this.onVideoCaptureSurfaceInvalidated();
        if (!this.mbHasSurface) {
            SurfaceHolder surfaceHolder = this.mSvPreview.getHolder();
            surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
    }

    private void resumeVideo() {
        this.mVideoView.onResume();
        if (this.mRenderer != null) {
            this.mRenderer.resumeRenderer();
        }
        this.getWindow().getDecorView().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!ConfActivityNormal.this.isActive() || ConfActivityNormal.this.mbLeaveComplete) {
                    return;
                }
                if (ConfActivityNormal.this.mVideoView.getVisibility() == 0) {
                    ConfActivityNormal.this.checkStartVideo();
                    ConfActivityNormal.this.mVideoSceneMgr.onConfActivityResume(ConfActivityNormal.this);
                }
                if (ConfActivityNormal.this.mVideoSceneMgr.isInDriveModeScence()) {
                    boolean isGlobalEnableDriveMode = PreferenceUtil.readBooleanValue("drive_mode_enabled", true);
                    if (!isGlobalEnableDriveMode && ConfActivityNormal.this.mVideoSceneMgr != null && ConfActivityNormal.this.mVideoSceneMgr instanceof VideoSceneMgr) {
                        ((VideoSceneMgr)ConfActivityNormal.this.mVideoSceneMgr).switchToDefaultScene();
                    }
                    UIMgr.setGlobalDriverModeEnabled(isGlobalEnableDriveMode);
                }
            }
        }, 300L);
        SurfaceHolder surfaceHolder = this.mSvPreview.getHolder();
        if (this.mbHasSurface) {
            this.onVideoCaptureSurfaceReady(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
    }

    protected void onStart() {
        super.onStart();
        this.checkShowTimer();
        if (this.mVideoSceneMgr == null || !this.mVideoSceneMgr.isInDriveModeScence()) {
            UIMgr.setGlobalDriverModeEnabled(PreferenceUtil.readBooleanValue("drive_mode_enabled", true));
        }
        if (UiModeUtil.isInDesktopMode((Context)this) || this.isInMultiWindowMode()) {
            this.resumeVideo();
        }
    }

    protected void onStop() {
        super.onStop();
        if (UiModeUtil.isInDesktopMode((Context)this) || this.isInMultiWindowMode()) {
            this.stopVideo();
        }
        this.mHandler.removeCallbacks(this.mTimerRunnable);
    }

    @Override
    protected void onResume() {
        ShareSessionMgr shareMgr;
        super.onResume();
        if (this.isSharingOut() && !ScreenShareMgr.getInstance().isSharing()) {
            this.shareView.resume();
        }
        if ((shareMgr = ConfMgr.getInstance().getShareObj()) != null) {
            int status = shareMgr.getShareStatus();
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus != null && status == 3) {
                if (this.checkRemoteControlPrivilege()) {
                    this.mRCFloatView.showRCFloatView(true, false);
                } else {
                    this.mRCFloatView.showRCFloatView(false, false);
                }
            }
        }
        this.initUIStatus(true);
        this.refreshToolbar();
        this.refreshBtnBack();
        this.refreshPanelRecording();
        this.refreshAudioSharing(false);
        this.checkBOStatus();
        this.updateBOButton();
        this.checkClosedCaption();
        this.mLiveStreamComponent.onLiveStreamStatusChange();
        this.refreshFeedback();
        int reason = ConfUI.getInstance().getPTAskToLeaveReason();
        if (reason >= 0) {
            this.onPTAskToLeave(reason);
            ConfUI.getInstance().clearPTAskToLeaveReason();
        }
        this.updateQAButton();
        this.updatePollButton();
        this.resumeVideo();
        if (this.isLaunchReasonByBO()) {
            this.overridePendingTransition(0, 0);
        }
        this.updatePracticeModeView();
        this.onAttendeeLeft();
    }

    private void registerQAListener() {
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onRefreshQAUI() {
                    ConfActivityNormal.this.updateQAButton();
                }

                @Override
                public void onReceiveQuestion(String questionID) {
                    ConfActivityNormal.this.updateQAButton();
                    ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
                    if (qacomponent != null && (qacomponent.isWebinarHost() || qacomponent.isWebinarPanelist())) {
                        ConfActivityNormal.this.showToolbar(true, false);
                        ConfActivityNormal.this.disableToolbarAutoHide();
                    }
                }

                @Override
                public void onReceiveAnswer(String answerID) {
                    ConfActivityNormal.this.updateQAButton();
                    if (ConfMgr.getInstance().isViewOnlyMeeting()) {
                        ConfActivityNormal.this.updateAttendeeQAButton();
                        ConfActivityNormal.this.showToolbar(true, false);
                        ConfActivityNormal.this.disableToolbarAutoHide();
                    }
                }

                @Override
                public void onQuestionMarkedAsAnswered(String questionID) {
                    ConfActivityNormal.this.updateQAButton();
                }

                @Override
                public void onWebinarAttendeeRaisedHand(long nodeID) {
                    if (ConfMgr.getInstance().isViewOnlyMeeting()) {
                        ConfActivityNormal.this.updateAttendeeRaiseHandButton();
                    }
                    ConfActivityNormal.this.handleAttendeeRaiseLowerHand(nodeID);
                }

                @Override
                public void onWebinarAttendeeLowerHand(long nodeID) {
                    if (ConfMgr.getInstance().isViewOnlyMeeting()) {
                        ConfActivityNormal.this.updateAttendeeRaiseHandButton();
                    }
                    ConfActivityNormal.this.handleAttendeeRaiseLowerHand(nodeID);
                }

                @Override
                public void onUserRemoved(String jid) {
                    if (ConfMgr.getInstance().isViewOnlyMeeting()) {
                        ConfActivityNormal.this.updateAttendeeRaiseHandButton();
                    }
                    ConfActivityNormal.this.handleAttendeeLeft();
                }
            };
        }
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
    }

    private void unregisterQAListener() {
        if (this.mQAUIListener != null) {
            ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
        }
    }

    private void updateQAButton() {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            if (this.mQaView != null) {
                this.mQaView.setVisibility(8);
            }
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        if (!confContext.isQANDAOFF() && (qacomponent.isWebinarHost() || qacomponent.isWebinarPanelist())) {
            int count = qacomponent.getOpenQuestionCount();
            if (count <= 0) {
                this.mTxtQAOpenNumber.setVisibility(8);
            } else {
                this.mTxtQAOpenNumber.setVisibility(0);
                this.mTxtQAOpenNumber.setText((CharSequence)String.valueOf(count));
            }
        } else {
            this.mTxtQAOpenNumber.setVisibility(8);
        }
    }

    private void updateAttendeeQAButton() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (confContext == null || qacomponent == null || this.mToolbar == null) {
            return;
        }
        if (!confContext.isQANDAOFF()) {
            int count = qacomponent.getAnsweredQuestionCount();
            this.mToolbar.setQANoteMsgButton(count);
        } else {
            this.mToolbar.setQANoteMsgButton(0);
        }
    }

    private void updatePollButton() {
        int count;
        boolean hasActivePoll = false;
        PollingMgr pollMgr = ConfMgr.getInstance().getPollObj();
        if (pollMgr != null && (count = pollMgr.getPollingCount()) > 0) {
            for (int i = 0; i < count; ++i) {
                IPollingDoc doc = pollMgr.getPollingAtIdx(i);
                if (doc == null) continue;
                int state = doc.getPollingState();
                int myState = doc.getMyPollingState();
                if (state == 1 && myState != 2) {
                    hasActivePoll = true;
                    this.mBtnPoll.setText(R.string.zm_polling_btn_return_to_poll);
                    continue;
                }
                if (state != 3) continue;
                hasActivePoll = true;
                this.mBtnPoll.setText(R.string.zm_polling_btn_view_poll_result);
            }
        }
        this.mBtnPoll.setVisibility(hasActivePoll ? 0 : 8);
    }

    private void updateAttendeeRaiseHandButton() {
        ZoomQAComponent qaComponent = ConfMgr.getInstance().getQAComponent();
        if (qaComponent == null || qaComponent.getMyJID() == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && !confStatus.isAllowRaiseHand()) {
            return;
        }
        if (this.isWebinarAttendeeRaiseHand(qaComponent.getMyJID())) {
            this.mToolbar.showLowerHand();
        } else {
            this.mToolbar.showRaiseHand();
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateSystemStatusBar();
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void onAudioSourceTypeChanged(int type) {
        if (!this.isActive()) {
            return;
        }
        if (this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.updateVisibleScenes();
        }
        this.refreshAudioSourceBtn();
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.getSystemService("accessibility");
        if (null != accessibilityManager && accessibilityManager.isEnabled() && null != this.mImgAudioSource) {
            if (Build.VERSION.SDK_INT < 16) {
                this.mImgAudioSource.sendAccessibilityEvent(8);
            } else {
                this.mImgAudioSource.sendAccessibilityEvent(32768);
            }
        }
        if (this.mCallConnectingView != null && this.mCallConnectingView.getVisibility() == 0) {
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext == null) {
                return;
            }
            int confType = this.getZoomConfType(confContext);
            this.mCallConnectingView.updateUIForCallType(confType);
        }
        this.onMyAudioSourceTypeChanged();
    }

    private void updateSystemStatusBar() {
        if (UIUtil.isLandscapeMode((Context)this.getApplicationContext())) {
            this.getWindow().setFlags(1024, 1024);
        } else {
            this.getWindow().setFlags(-1025, 1024);
        }
        this.setPaddingsForTranslucentStatus();
    }

    private void refreshBtnBack() {
        boolean isSignedIn = PTAppDelegation.getInstance().isWebSignedOn();
        if (this.mBtnBack != null) {
            this.mBtnBack.setVisibility(isSignedIn ? 0 : 8);
        }
    }

    @Override
    public boolean isToolbarShowing() {
        return this.mPanelTools.isVisible();
    }

    @Override
    public int getToolbarHeight() {
        if (this.isToolbarShowing()) {
            return this.mToolbarHeight;
        }
        return 0;
    }

    public boolean isTopbarShowing() {
        return this.mPanelTools.isVisible() && this.mTopbar.getVisibility() == 0;
    }

    public boolean isBottombarShowing() {
        return this.mPanelTools.isVisible() && this.mToolbar.getVisibility() == 0;
    }

    @Override
    public int getTopbarHeight() {
        if (this.isTopbarShowing()) {
            return this.mTopbarHeight;
        }
        return 0;
    }

    @Override
    public int getVideoViewLocationonScrennY() {
        if (this.mVideoView != null) {
            int[] location = new int[2];
            this.mVideoView.getLocationOnScreen(location);
            return location[1];
        }
        return 0;
    }

    @Override
    public void refreshUnreadChatCount() {
        PListFragment plist;
        ConfMgr confMgr = ConfMgr.getInstance();
        if (this.mToolbar != null) {
            int[] indexes = confMgr.getUnreadChatMessageIndexes();
            this.mToolbar.setChatsButton(indexes.length);
        }
        if ((plist = PListFragment.getPListFragment(this.getSupportFragmentManager())) != null) {
            plist.refresh();
        }
    }

    private void startPlayDuduVoice() {
        if (this.mDuduVoiceClip == null) {
            this.mDuduVoiceClip = new AudioClip(R.raw.zm_dudu, VoiceEnginContext.getSelectedPlayerStreamType());
            this.mDuduVoiceClip.startPlay();
            ConfUI.getInstance().checkOpenLoudSpeaker();
        }
    }

    private void stopPlayDuduVoice() {
        if (this.mDuduVoiceClip != null) {
            this.mDuduVoiceClip.stopPlay();
            this.mDuduVoiceClip = null;
        }
    }

    private void initUIStatus() {
        this.initUIStatus(false);
    }

    private void initUIStatus(boolean keepToolbarStatus) {
        NotificationMgr.showConfNotification((Context)VideoBoxApplication.getInstance());
        if (ConfMgr.getInstance().isConfConnected()) {
            this.mPanelConnecting.setVisibility(8);
            this.mCallConnectingView.setVisibility(8);
            this.mOnSilentView.setVisibility(8);
            this.mWaitingJoinView.setVisibility(8);
            this.mPanelRejoinMsg.setVisibility(8);
            if (this.isCallingOut()) {
                this.switchViewTo((View)this.mCallConnectingView, false);
                return;
            }
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null && confContext.inSilentMode()) {
                this.switchViewTo((View)this.mOnSilentView, false);
                return;
            }
            CmmUser user = ConfMgr.getInstance().getMyself();
            if (user == null) {
                return;
            }
            CmmAudioStatus audioStatus = user.getAudioStatusObj();
            if (audioStatus != null) {
                this.mToolbar.setAudioMuted(audioStatus.getIsMuted());
            }
            this.mToolbar.setVideoMuted(!this.getIsVideoStarted());
            if (this.mCameraComponent != null) {
                this.mCameraComponent.updateSwitchCameraButton();
            }
            this.switchViewTo(this.mConfView, false);
        } else {
            View panelConnectingOnVerifyIdView;
            this.mPanelConnecting.setVisibility(0);
            ConfUI confUI = ConfUI.getInstance();
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext == null) {
                return;
            }
            boolean isDirectStart = confContext.isDirectStart();
            int launchReason = confContext.getLaunchReason();
            TextView txtRejoinMsgTitle = (TextView)this.mPanelRejoinMsg.findViewById(R.id.txtRejoinMsgTitle);
            TextView txtRejoinMsgMessage = (TextView)this.mPanelRejoinMsg.findViewById(R.id.txtRejoinMsgMessage);
            if (launchReason == 7) {
                this.mPanelRejoinMsg.setVisibility(0);
                this.mPanelConnecting.setVisibility(8);
                panelConnectingOnVerifyIdView = this.mVerifyingMeetingIDView.findViewById(R.id.panelConnecting);
                if (panelConnectingOnVerifyIdView != null) {
                    panelConnectingOnVerifyIdView.setVisibility(8);
                }
                txtRejoinMsgTitle.setText(R.string.zm_webinar_msg_host_change_you_to_panelist);
                txtRejoinMsgMessage.setText(R.string.zm_webinar_msg_connecting_as_panelist);
            } else if (launchReason == 8) {
                this.mPanelRejoinMsg.setVisibility(0);
                this.mPanelConnecting.setVisibility(8);
                panelConnectingOnVerifyIdView = this.mVerifyingMeetingIDView.findViewById(R.id.panelConnecting);
                if (panelConnectingOnVerifyIdView != null) {
                    panelConnectingOnVerifyIdView.setVisibility(8);
                }
                txtRejoinMsgTitle.setText(R.string.zm_webinar_msg_host_change_you_to_attendee);
                txtRejoinMsgMessage.setText(R.string.zm_webinar_msg_connecting_as_attendee);
            } else if (launchReason == 10) {
                this.showBOStatusChangeUI(true, confContext.getBOJoinReason());
                this.mPanelRejoinMsg.setVisibility(8);
            } else if (launchReason == 11) {
                this.showBOStatusChangeUI(false, 0);
                this.mPanelRejoinMsg.setVisibility(8);
            } else {
                this.mPanelRejoinMsg.setVisibility(8);
            }
            if (!(isDirectStart || launchReason != 2 && launchReason != 4 && launchReason != 3)) {
                if (confUI.isLaunchConfParamReady()) {
                    this.mCallConnectingView.setVisibility(8);
                    int confStatus = ConfMgr.getInstance().getConfStatus();
                    if (!(confContext.isCall() || confStatus != 3 && confStatus != 4 && confStatus != 5)) {
                        this.switchViewTo(this.mVerifyingMeetingIDView, false);
                    } else if (confStatus == 8 || confStatus == 9) {
                        if (this.hasCustomJBHActivity()) {
                            this.showCustomJBHActivity();
                        } else {
                            this.switchViewTo((View)this.mWaitingJoinView, false);
                        }
                    } else {
                        this.switchViewTo(this.mConfView, false);
                    }
                } else {
                    this.switchViewTo(this.mVerifyingMeetingIDView, false);
                }
            } else if (confUI.isLaunchConfParamReady()) {
                int confStatus = ConfMgr.getInstance().getConfStatus();
                if (confContext.isCall() && launchReason == 1) {
                    this.mPanelConnecting.setVisibility(8);
                    this.switchViewTo((View)this.mCallConnectingView, false);
                } else if (confStatus == 8 || confStatus == 9) {
                    this.switchViewTo((View)this.mWaitingJoinView, false);
                } else if (launchReason == 1) {
                    if (confContext.getConfNumber() <= 0L) {
                        this.switchViewTo(this.mConfView, false);
                    } else {
                        this.switchViewTo(this.mVerifyingMeetingIDView, false);
                    }
                } else if (ConfUI.getInstance().isMeetingInfoReady()) {
                    this.switchViewTo(this.mConfView, false);
                } else {
                    this.switchViewTo(this.mVerifyingMeetingIDView, false);
                }
            } else {
                this.switchViewTo(this.mVerifyingMeetingIDView, false);
            }
        }
        if (!keepToolbarStatus) {
            this.showToolbar(false, false);
        }
    }

    private int getZoomConfType(CmmConfContext confContext) {
        boolean isAudioOnlyMeeting = confContext.isAudioOnlyMeeting();
        boolean isShareOnlyMeeting = confContext.isShareOnlyMeeting();
        boolean isCall = confContext.isCall();
        if (isAudioOnlyMeeting) {
            if (isCall) {
                return 0;
            }
            return 3;
        }
        if (isShareOnlyMeeting) {
            if (isCall) {
                return 2;
            }
            return 4;
        }
        if (isCall) {
            return 1;
        }
        return 3;
    }

    @Override
    public void switchViewToConfView() {
        this.switchViewTo(this.mConfView, true);
    }

    @Override
    public void switchViewToWaitingJoinView() {
        if (this.hasCustomJBHActivity()) {
            this.showCustomJBHActivity();
        } else {
            this.switchViewTo((View)this.mWaitingJoinView, true);
        }
    }

    private void switchViewTo(View view, boolean animation) {
        if (view == null) {
            return;
        }
        if (view == this.mWaitingJoinView) {
            this.mWaitingJoinView.setCustomMeetingId(this.mConfParams.getCustomMeetingId());
            this.mWaitingJoinView.updateData();
        }
        if (view == this.mConfView) {
            if (this.isSensorOrientationEnabled()) {
                this.setRequestedOrientation(4);
            }
            this.mVerifyingMeetingIDView.setVisibility(8);
            this.mWaitingJoinView.setVisibility(8);
            this.mCallConnectingView.setVisibility(8);
            this.mOnSilentView.setVisibility(8);
            this.getWindow().getDecorView().setBackgroundColor(-16777216);
        } else if (view == this.mVerifyingMeetingIDView) {
            if (this.isSensorOrientationEnabled()) {
                this.setRequestedOrientation(4);
            }
            this.mConfView.setVisibility(8);
            this.mWaitingJoinView.setVisibility(8);
            this.mCallConnectingView.setVisibility(8);
            this.mOnSilentView.setVisibility(8);
        } else if (view == this.mWaitingJoinView) {
            if (this.isSensorOrientationEnabled()) {
                this.setRequestedOrientation(4);
            }
            this.mConfView.setVisibility(8);
            this.mVerifyingMeetingIDView.setVisibility(8);
            this.mCallConnectingView.setVisibility(8);
            this.mOnSilentView.setVisibility(8);
        } else if (view == this.mCallConnectingView) {
            CmmConfContext confContext;
            int abCallType;
            if (UIUtil.getDisplayMinWidthInDip((Context)this) < 500.0f && this.isSensorOrientationEnabled()) {
                this.setRequestedOrientation(1);
            }
            if ((abCallType = this.getZoomConfType(confContext = ConfMgr.getInstance().getConfContext())) == 1 || abCallType == 3) {
                this.mConfView.setVisibility(0);
            } else {
                this.mConfView.setVisibility(8);
            }
            this.mVerifyingMeetingIDView.setVisibility(8);
            this.mWaitingJoinView.setVisibility(8);
            this.mOnSilentView.setVisibility(8);
            this.startPlayDuduVoice();
            this.mCallConnectingView.updateUIForCallType(abCallType);
        } else if (view == this.mOnSilentView) {
            if (this.mShareStatus == 2) {
                this.onMyShareStopped();
                this.mShareStatus = 0;
            }
            if (this.isSensorOrientationEnabled()) {
                this.setRequestedOrientation(4);
            }
            this.mWaitingJoinView.setVisibility(8);
            this.mConfView.setVisibility(8);
            this.mVerifyingMeetingIDView.setVisibility(8);
            this.mCallConnectingView.setVisibility(8);
            this.mOnSilentView.updateData();
        }
        view.setVisibility(0);
    }

    private boolean hasCustomJBHActivity() {
        Intent intent = new Intent(this.getPackageName() + ".intent.action.JoinBeforeHost");
        return AndroidAppUtil.hasActivityForIntent((Context)this, (Intent)intent);
    }

    private void showCustomJBHActivity() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        MeetingInfo meetingInfo = confContext.getMeetingItem();
        if (meetingInfo == null) {
            return;
        }
        Intent intent = new Intent(this.getPackageName() + ".intent.action.JoinBeforeHost");
        intent.putExtra(AndroidAppUtil.EXTRA_TOPIC, meetingInfo.getTopic());
        intent.putExtra(AndroidAppUtil.EXTRA_MEETING_ID, meetingInfo.getMeetingNumber());
        intent.putExtra(AndroidAppUtil.EXTRA_IS_REPEAT, meetingInfo.getType() == MeetingInfo.MeetingType.REPEAT);
        intent.putExtra(AndroidAppUtil.EXTRA_DATE, TimeFormatUtil.formatDate((Context)this, meetingInfo.getStartTime() * 1000L, false));
        intent.putExtra(AndroidAppUtil.EXTRA_TIME, TimeFormatUtil.formatTime((Context)this, meetingInfo.getStartTime() * 1000L));
        try {
            this.startActivityForResult(intent, 1019);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isInShareVideoScene() {
        return this.mVideoSceneMgr != null && this.mVideoSceneMgr.isInShareVideoScene();
    }

    private boolean isInNormalVideoScene() {
        return this.mVideoSceneMgr != null && this.mVideoSceneMgr.isInNormalVideoScene();
    }

    private boolean isInDriveModeScence() {
        return this.mVideoSceneMgr != null && this.mVideoSceneMgr.isInDriveModeScence();
    }

    private void onConfReady(long status) {
        boolean drivingMode;
        boolean hasTips;
        if (this.isCallingOut()) {
            return;
        }
        this.hideBOStatusChangeUI();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.inSilentMode()) {
            this.switchViewTo((View)this.mOnSilentView, false);
            this.onMeetingConnected();
            return;
        }
        this.switchViewTo(this.mConfView, false);
        this.mPanelConnecting.setVisibility(8);
        this.mPanelRejoinMsg.setVisibility(8);
        this.refreshToolbar();
        if (this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.onConfReady();
        }
        if (!(hasTips = this.showConfReadyTips(drivingMode = this.checkStartDrivingModeOnConfReady()))) {
            this.hideToolbarDelayed(5000L);
        }
        this.onMeetingConnected();
    }

    private void onConfReadyCmd(long ret) {
        this.boCheckShowNewAttendeeWaitUnassignedDialog();
        this.updatePracticeModeView();
        this.updateSilentModeView();
    }

    private boolean getEnabledDrivingMode() {
        return false;
    }

    private boolean checkStartDrivingModeOnConfReady() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return false;
        }
        if (this.isCallingOut()) {
            return false;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return false;
        }
        if (confMgr.isViewOnlyMeeting()) {
            return false;
        }
        if (this.mConfParams.isDriverModeDisabled()) {
            return false;
        }
        ParamsList params = confContext.getAppContextParams();
        int drivingMode = params.getInt("drivingMode", -1);
        if (this.mVideoSceneMgr instanceof VideoSceneMgr) {
            boolean enableDrvingModeByDefault;
            if (drivingMode == 1) {
                ((VideoSceneMgr)this.mVideoSceneMgr).restoreDriverModeSceneOnFailoverSuccess();
                return true;
            }
            if (drivingMode == -1 && (enableDrvingModeByDefault = this.getEnabledDrivingMode())) {
                ((VideoSceneMgr)this.mVideoSceneMgr).switchToDriverModeSceneAsDefaultScene();
                return true;
            }
        }
        return false;
    }

    private void refreshToolbar() {
        CmmAudioStatus audioStatus;
        ConfMgr confMgr = ConfMgr.getInstance();
        if (this.isCallingOut() || !confMgr.isConfConnected()) {
            this.showToolbar(false, false);
        }
        CmmUser myself = confMgr.getMyself();
        boolean isViewOnly = confMgr.isViewOnlyMeeting();
        if (isViewOnly) {
            ConfLocalHelper.refreshViewOnlyToolbar(this.mToolbar, myself);
        } else {
            CmmConfContext confContext;
            VideoSessionMgr videoMgr;
            int btns = 255;
            btns &= 0xFFFFFFBF;
            btns &= 0xFFFFFF7F;
            int[] indexes = confMgr.getUnreadChatMessageIndexes();
            if (indexes != null) {
                this.mToolbar.setChatsButton(indexes.length);
            }
            if (CameraComponent.getNumberOfCameras() <= 0 || this.mConfParams.isVideoButtonDisabled()) {
                btns &= 0xFFFFFFFE;
            }
            this.mToolbar.setVideoMuted((videoMgr = confMgr.getVideoObj()) == null || !videoMgr.isVideoStarted());
            if (myself != null) {
                boolean isCurUserHost = myself.isHost();
                boolean isCurUserCoHost = myself.isCoHost();
                this.mToolbar.setHostRole(isCurUserHost || isCurUserCoHost);
                if (isCurUserHost) {
                    this.mBtnLeave.setText(R.string.zm_btn_end_meeting);
                } else {
                    this.mBtnLeave.setText(R.string.zm_btn_leave_meeting);
                }
            }
            if (!MoreTip.hasItemsToShow() || this.mConfParams.isMoreButtonDisabled()) {
                btns &= 0xFFFFFFDF;
            }
            if ((confContext = ConfMgr.getInstance().getConfContext()) != null && confContext.isScreenShareDisabled() || this.mConfParams.isShareButtonDisabled()) {
                btns &= 0xFFFFFFFB;
            }
            if (this.mConfParams.isPlistButtonDisabled()) {
                btns &= 0xFFFFFFF7;
            }
            if (this.mConfParams.isAudioButtonDisabled()) {
                btns &= 0xFFFFFFFD;
            }
            this.mToolbar.setButtons(btns);
        }
        if (myself != null && this.mToolbar.hasEnableBUtton(2) && (audioStatus = myself.getAudioStatusObj()) != null) {
            boolean isMuted = audioStatus.getIsMuted();
            if (!isMuted) {
                ConfAllowTalkDialog.dismiss(this.getSupportFragmentManager());
            }
            this.mToolbar.setAudioMuted(isMuted);
            this.mToolbar.setAudioType(audioStatus.getAudiotype());
        }
        if (this.mConfParams.isLeaveButtonDisabled()) {
            this.mBtnLeave.setVisibility(8);
        } else {
            this.mBtnLeave.setVisibility(0);
        }
        if (this.mTxtMeetingNumber != null) {
            this.updateTitleBar();
        }
        if (isViewOnly) {
            this.updateAttendeeRaiseHandButton();
            if (this.mQaView != null) {
                this.mQaView.setVisibility(8);
            }
            this.refreshAudioSourceBtn();
        } else {
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (ConfMgr.getInstance().isConfConnected()) {
                if (confContext != null && confContext.isWebinar() && !confContext.isQANDAOFF()) {
                    if (this.mQaView != null) {
                        this.mQaView.setVisibility(0);
                    }
                } else if (this.isInBOMeeting()) {
                    if (this.mQaView != null) {
                        this.mQaView.setVisibility(8);
                        this.mTxtQAOpenNumber.setVisibility(8);
                    }
                } else if (this.mQaView != null) {
                    this.mQaView.setVisibility(8);
                    this.mTxtQAOpenNumber.setVisibility(8);
                }
                this.refreshAudioSourceBtn();
            }
            if (this.mCameraComponent != null) {
                this.mCameraComponent.updateSwitchCameraButton();
            }
        }
        this.updateBOButton();
        this.updateKubiButton();
        this.updateSwitchToShareButton();
    }

    private void updateTitleBar() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            String password;
            if (this.mConfParams.isMeetingIdTextDisabled()) {
                this.mTxtMeetingNumber.setVisibility(8);
            } else {
                this.mTxtMeetingNumber.setVisibility(0);
                if (!this.isInBOMeeting()) {
                    if (StringUtil.isEmptyOrNull((String)this.mConfParams.getCustomMeetingId())) {
                        this.mTxtMeetingNumber.setText((CharSequence)this.getResources().getString(UIUtil.isLargeScreen((Context)this) ? R.string.zm_title_conf_long : R.string.zm_title_conf, new Object[]{StringUtil.formatConfNumber((long)confContext.getConfNumber())}));
                        this.mTxtMeetingNumber.setContentDescription((CharSequence)this.getString(R.string.zm_title_conf_long, new Object[]{String.valueOf(confContext.getConfNumber())}));
                    } else {
                        this.mTxtMeetingNumber.setText((CharSequence)this.mConfParams.getCustomMeetingId());
                        this.mTxtMeetingNumber.setContentDescription((CharSequence)this.getString(R.string.zm_title_conf_long, new Object[]{this.mConfParams.getCustomMeetingId()}));
                    }
                } else {
                    this.mTxtMeetingNumber.setText((CharSequence)this.getMyBOMeetingName(2));
                }
            }
            if (this.mImgE2EMeetingView != null) {
                if (confContext.isE2EMeeting()) {
                    this.mImgE2EMeetingView.setVisibility(0);
                } else {
                    this.mImgE2EMeetingView.setVisibility(8);
                }
            }
            if (!(StringUtil.isEmptyOrNull((String)(password = confContext.getRawMeetingPassword())) || this.isInBOMeeting() || this.mConfParams.isPasswordTextDisabled())) {
                String text = this.getResources().getString(R.string.zm_lbl_password_xxx, new Object[]{password});
                this.mTxtPassword.setText((CharSequence)text);
                this.mTxtPassword.setVisibility(0);
            } else {
                this.mTxtPassword.setVisibility(8);
            }
        }
    }

    private void refreshAudioSourceBtn() {
        if (this.mImgAudioSource != null) {
            if (this.canSwitchAudioSource() && !this.mConfParams.isSwitchAudioSourceButtonDisabled()) {
                this.mImgAudioSource.setVisibility(0);
            } else {
                this.mImgAudioSource.setVisibility(8);
            }
            int audioSourceType = ConfUI.getInstance().getCurrentAudioSourceType();
            int resId = R.drawable.zm_ic_speaker_off;
            String strContentDescription = this.getString(R.string.zm_description_btn_audio_source_speaker_phone);
            switch (audioSourceType) {
                case 0: {
                    resId = R.drawable.zm_ic_speaker_on;
                    strContentDescription = this.getString(R.string.zm_description_btn_audio_source_speaker_phone);
                    break;
                }
                case 3: {
                    resId = R.drawable.zm_ic_current_bluetooth;
                    strContentDescription = this.getString(R.string.zm_description_btn_audio_source_bluetooth);
                    break;
                }
                case 1: {
                    resId = R.drawable.zm_ic_speaker_off;
                    strContentDescription = this.getString(R.string.zm_description_btn_audio_source_ear_phone);
                    break;
                }
                case 2: {
                    resId = R.drawable.zm_ic_current_headset;
                    strContentDescription = this.getString(R.string.zm_description_btn_audio_source_wired);
                }
            }
            if (this.mImgAudioSource != null) {
                this.mImgAudioSource.setImageResource(resId);
                this.mImgAudioSource.setContentDescription((CharSequence)strContentDescription);
            }
        }
    }

    private void refreshAudioSharing(boolean animate) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (shareMgr == null || sceneMgr == null) {
            this.showAudioSharingPrompt(false, false);
            return;
        }
        long audioSharingUserId = shareMgr.getPureComputerAudioSharingUserID();
        CmmUser audioSharingUser = ConfMgr.getInstance().getUserById(audioSharingUserId);
        if (audioSharingUser == null) {
            this.showAudioSharingPrompt(false, false);
            return;
        }
        TextView info = (TextView)this.findViewById(R.id.txtAudioShareInfo);
        if (info == null) {
            return;
        }
        if (!shareMgr.isViewingPureComputerAudio()) {
            this.showAudioSharingPrompt(false, false);
            return;
        }
        AbsVideoScene activeScene = sceneMgr.getActiveScene();
        if (activeScene == null) {
            return;
        }
        if (activeScene instanceof NormalVideoScene && ConfShareLocalHelper.isOtherPureAudioSharing() && !this.isToolbarShowing()) {
            this.showAudioSharingPrompt(true, animate);
            String screenName = audioSharingUser.getScreenName();
            if (StringUtil.isEmptyOrNull((String)screenName)) {
                info.setText((CharSequence)audioSharingUser.getEmail());
            } else {
                info.setText((CharSequence)this.getResources().getString(R.string.zm_lbl_someone_is_sharing_audio_41468, new Object[]{screenName}));
            }
        } else {
            this.showAudioSharingPrompt(false, animate);
        }
    }

    private void showAudioSharingPrompt(boolean show, boolean anim2) {
        if (this.mPanelAudioSharing == null) {
            return;
        }
        if (show && this.mPanelAudioSharing.getVisibility() != 0) {
            this.mPanelAudioSharing.setVisibility(0);
            if (anim2) {
                Animation fadeIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.zm_fade_in);
                this.mPanelAudioSharing.startAnimation(fadeIn);
            }
        } else if (!show && this.mPanelAudioSharing.getVisibility() == 0) {
            this.mPanelAudioSharing.setVisibility(8);
            if (anim2) {
                Animation fadeOut = AnimationUtils.loadAnimation((Context)this, (int)R.anim.zm_fade_out);
                this.mPanelAudioSharing.startAnimation(fadeOut);
            }
        }
    }

    private void refreshPanelRecording() {
        ConfActivity.RetainedFragment f;
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        boolean isOthersRecording = recordMgr.theMeetingisBeingRecording();
        boolean isCurUserRecording = recordMgr.isRecordingInProgress();
        boolean isInDrivingMode = this.isInDivveMode();
        if (isCurUserRecording) {
            this.mPanelRecording.setVisibility(8);
            this.mPanelCurUserRecording.setVisibility(!isInDrivingMode ? 0 : 8);
            if (confStatus.isCMRInConnecting()) {
                this.mPanelCurUserRecording.setOnClickListener(null);
                this.mImgRecording.setVisibility(8);
                this.mImgRecordControlArrow.setVisibility(8);
                this.mProgressStartingRecord.setVisibility(0);
                this.mTxtRecordStatus.setText(R.string.zm_record_status_preparing);
            } else {
                this.mPanelCurUserRecording.setOnClickListener((View.OnClickListener)this);
                if (recordMgr.isCMRPaused()) {
                    this.mImgRecording.setVisibility(8);
                    this.mTxtRecordStatus.setText(R.string.zm_record_status_paused);
                } else {
                    this.mImgRecording.setVisibility(0);
                    this.mTxtRecordStatus.setText(R.string.zm_record_status_recording);
                }
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext != null && confContext.isAutoCMRForbidManualStop() && !recordMgr.isCMRPaused()) {
                    this.mImgRecordControlArrow.setVisibility(8);
                } else {
                    this.mImgRecordControlArrow.setVisibility(0);
                }
                this.mProgressStartingRecord.setVisibility(8);
            }
        } else {
            this.mPanelCurUserRecording.setVisibility(8);
            this.mPanelRecording.setVisibility(isOthersRecording && !isInDrivingMode ? 0 : 8);
            AccessibilityManager accessibilityManager = (AccessibilityManager)this.getSystemService("accessibility");
            if (accessibilityManager != null && accessibilityManager.isEnabled()) {
                this.mPanelRecording.setFocusable(true);
            }
        }
        if (!isOthersRecording && (f = this.getRetainedFragment()) != null) {
            f.setHasPopupStartingRecord(false);
        }
        this.mPanelStartingRecord.setVisibility(4);
        MoreTip.updateRecordIfExists(this.getSupportFragmentManager(), isCurUserRecording, isInDrivingMode);
    }

    private void startRecordingAnimation() {
        String userName = null;
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            this.refreshPanelRecording();
            return;
        }
        for (int i = 0; i < userList.getUserCount(); ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user == null || !user.isRecording()) continue;
            userName = user.getScreenName();
            break;
        }
        if (StringUtil.isEmptyOrNull(userName)) {
            this.refreshPanelRecording();
            return;
        }
        if (!ConfMgr.getInstance().isViewOnlyMeeting() || ConfLocalHelper.isViewOnlyButSpeakAttendee()) {
            String msg = this.getString(R.string.zm_lbl_starting_record, new Object[]{userName});
            this.mTxtStartingRecrod.setText((CharSequence)msg);
            this.mPanelStartingRecord.setVisibility(0);
        } else {
            this.mPanelStartingRecord.setVisibility(4);
        }
        ConfActivity.RetainedFragment f = this.getRetainedFragment();
        if (f != null) {
            if (f.hasPopupStartingRecord()) {
                this.refreshPanelRecording();
                return;
            }
            f.setHasPopupStartingRecord(true);
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (ConfActivityNormal.this.isActive()) {
                    ConfActivityNormal.this.mPanelStartingRecord.setVisibility(4);
                    ConfActivityNormal.this.refreshPanelRecording();
                    if (ConfActivityNormal.this.mPanelRecording.getVisibility() == 0 || ConfActivityNormal.this.mPanelCurUserRecording.getVisibility() == 0) {
                        ConfActivityNormal.this.hideToolbarDelayed(0L);
                    }
                }
            }
        }, 3000L);
    }

    private void sinkConfReady(final long status) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onConfReady"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onConfReady(status);
            }
        });
    }

    private void sinkConfReadyCmd(final long ret) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("sinkConfReadyCmd"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onConfReadyCmd(ret);
            }
        });
    }

    private void sinkConfLeaving(long status) {
        if (this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.onConfLeaving();
        }
    }

    private void sinkConfRecordStatus() {
        if (!this.isActive()) {
            return;
        }
        if (this.isInDivveMode()) {
            return;
        }
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return;
        }
        boolean isRecording = recordMgr.theMeetingisBeingRecording();
        if (!isRecording) {
            this.refreshPanelRecording();
            return;
        }
        this.startRecordingAnimation();
    }

    private void sinkAudioSharingStatusChanged() {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkAudioSharingStatusChanged", new EventAction("sinkAudioSharingStatusChanged"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onAudioSharingStatusChanged();
            }
        });
    }

    private void onAudioSharingStatusChanged() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        boolean isSharingAudio = shareMgr.presenterIsSharingAudio();
        if (isSharingAudio) {
            this.showTipMutedForSharingAudioStarted();
        } else {
            this.showTipUnmutedForSharingAudioStopped();
        }
    }

    private void sinkLeaderShipModeChanged() {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkLeaderShipModeChanged", new EventAction("sinkLeaderShipModeChanged"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onLeaderShipModeChanged();
            }
        });
    }

    private void onLeaderShipModeChanged() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.isLeadShipMode()) {
            this.showTipMutedForLeaderShipModeStarted();
        } else {
            this.showTipUnmutedForLeaderShipModeStopped();
        }
    }

    private void sinkConfMeetingUpgraded(final long ret) {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkConfMeetingUpgraded", new EventAction("sinkConfMeetingUpgraded"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onConfMeetingUpgraded(ret);
            }
        });
    }

    private void onConfMeetingUpgraded(long ret) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.canUpgradeThisFreeMeeting()) {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_upgrade_free_meeting_success_15609, R.string.zm_msg_host_paid_title);
            dialog.show(this.getSupportFragmentManager(), "SimpleMessageDialog.msg_conf_free_meeting_start_reminder");
        } else if (ret == 1L) {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_conf_paid_meeting_start_reminder, R.string.zm_msg_host_paid_title);
            dialog.show(this.getSupportFragmentManager(), "SimpleMessageDialog.msg_conf_paid_meeting_start_reminder");
        } else {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_conf_host_paid_reminder, R.string.zm_msg_host_paid_title);
            dialog.show(this.getSupportFragmentManager(), "SimpleMessageDialog.msg_conf_host_paid_reminder");
        }
    }

    private void sinkConfVideoSendingStatusChanged() {
        if (this.isActive()) {
            this.mVideoSceneMgr.onConfVideoSendingStatusChanged();
        }
    }

    private void sinkConfAllowRaiseHandStatusChanged() {
        if (this.isActive()) {
            this.refreshToolbar();
            this.handleAttendeeRaiseLowerHand(0L);
        }
    }

    private void sinkUserJoinRing() {
    }

    private void sinkCmdAutoShowAudioSelectionDlg() {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ConfActivityNormal confActivity = (ConfActivityNormal)ui;
                confActivity.handleCmdAudioShowAudioSelectionDlg();
            }
        });
    }

    private void handleCmdAudioShowAudioSelectionDlg() {
        g_handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!ConfActivityNormal.this.isActive()) {
                    return;
                }
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext == null) {
                    return;
                }
                MeetingInfo info = confContext.getMeetingItem();
                if (info == null) {
                    return;
                }
                if (info.getIsSelfTelephonyOn()) {
                    ConfActivityNormal.this.showSelfTelephoneInfo(info.getOtherTeleConfInfo());
                } else if (ConfActivityNormal.this.isInDivveMode()) {
                    AudioTip.show(ConfActivityNormal.this.getSupportFragmentManager(), 0);
                } else {
                    ConfActivityNormal.this.showToolbar(true, false);
                    ConfActivityNormal.this.disableToolbarAutoHide();
                    AudioTip.show(ConfActivityNormal.this.getSupportFragmentManager(), ConfActivityNormal.this.isBottombarShowing() ? R.id.btnAudio : 0);
                }
            }
        }, 500L);
    }

    private void sinkConfSilentModeChanged(boolean inSilent) {
        if (inSilent) {
            this.finishSubActivities();
            if (ScreenShareMgr.getInstance().isSharing()) {
                ConfActivityNormal.returnToConf((Context)this);
            }
        }
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ConfActivityNormal confActivity = (ConfActivityNormal)ui;
                confActivity.handleCmdConfSilentModeChanged();
            }
        });
    }

    private void handleCmdConfSilentModeChanged() {
        boolean inSilentMode = ConfLocalHelper.isInSilentMode();
        if (inSilentMode) {
            this.dismissTempTips();
            this.clearAllBOUI();
            this.switchViewTo((View)this.mOnSilentView, false);
        } else if (!this.isCallingOut() && ConfMgr.getInstance().isConfConnected()) {
            this.switchViewTo(this.mConfView, false);
            if (ConfShareLocalHelper.isOtherScreenSharing()) {
                ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
                long userId = shareMgr.getActiveUserID();
                if (userId > 0L) {
                    if (!this.handleActiveUserForScreenShare(userId)) {
                        this.onShareActiveUser(userId);
                    }
                    this.onShareUserReceivingStatus(userId);
                }
            } else {
                VideoSessionMgr videMgr = ConfMgr.getInstance().getVideoObj();
                long activeUserId = 0L;
                if (videMgr != null) {
                    activeUserId = videMgr.getActiveUserID();
                }
                if (activeUserId > 0L) {
                    this.onUserActiveVideo(activeUserId);
                }
            }
        }
        if (this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.onConfSilentModeChanged();
        }
        this.boCheckShowNewAttendeeWaitUnassignedDialog();
        this.onSilentModeChanged(inSilentMode);
    }

    private void sinkCMRStartTimeOut() {
        this.getNonNullEventTaskManagerOrThrowException().push("handleCMRStartTimeOut", new EventAction("handleCMRStartTimeOut"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).handleCMRStartTimeOut();
            }
        });
    }

    private void handleCMRStartTimeOut() {
        this.showCMRTimeOutMessage();
    }

    private void showCMRTimeOutMessage() {
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this).setTitle(R.string.zm_record_msg_start_cmr_timeout).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
    }

    @Override
    protected boolean onConfLeaveComplete(long ret) {
        this.mbLeaveComplete = true;
        return super.onConfLeaveComplete(ret) && this.mVideoSceneMgr.isDestroyed();
    }

    private void sinkAudioReady() {
        AudioSessionMgr audioSessionMgr = ConfMgr.getInstance().getAudioObj();
        if (audioSessionMgr != null) {
            AudioManager audioManager = (AudioManager)this.getSystemService("audio");
            int streamType = VoiceEnginContext.getSelectedPlayerStreamType();
            if (streamType < 0 || audioManager == null) {
                return;
            }
            ConfActivityNormal.notifyVolumeChanged(false, audioManager.getStreamVolume(streamType), streamType);
            audioSessionMgr.notifyHeadsetStatusChanged(HeadsetUtil.getInstance().isBluetoothHeadsetOn(), HeadsetUtil.getInstance().isWiredHeadsetOn());
            audioSessionMgr.notifyChipAECEnabled(VoiceEngineCompat.isChipAECSupported((Context)this));
            audioSessionMgr.notifyIsTablet(VoiceEngineCompat.isTablet((Context)this));
        }
        if (this.checkNeedMuteAudioByDefault() && audioSessionMgr != null) {
            audioSessionMgr.stopAudio();
        }
    }

    private boolean checkNeedMuteAudioByDefault() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return false;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return false;
        }
        ParamsList params = confContext.getAppContextParams();
        int drivingMode = params.getInt("drivingMode", -1);
        if (this.mVideoSceneMgr instanceof VideoSceneMgr) {
            boolean enableDrvingModeByDefault;
            boolean bNeedMuteAudio = false;
            if (drivingMode == 1) {
                bNeedMuteAudio = true;
            } else if (drivingMode == -1 && (enableDrvingModeByDefault = this.getEnabledDrivingMode())) {
                bNeedMuteAudio = true;
            }
            return bNeedMuteAudio;
        }
        return false;
    }

    private void sinkAutoStartVideo(final long ret) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater(new EventAction("onAutoStartVideo"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onAutoStartVideo(ret);
            }
        });
    }

    private void onAutoStartVideo(long ret) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        if (confContext.isVideoOn() && !this.checkNeedMuteVideoByDefault()) {
            this.startMyVideo();
        } else {
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr == null) {
                return;
            }
            if (videoMgr.isPreviewing()) {
                videoMgr.stopPreviewDevice(this.mVideoSceneMgr.getPreviewRenderInfo());
            }
        }
        this.mVideoSceneMgr.onAutoStartVideo();
    }

    private boolean checkNeedMuteVideoByDefault() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return false;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return false;
        }
        ParamsList params = confContext.getAppContextParams();
        int drivingMode = params.getInt("drivingMode", -1);
        if (this.mVideoSceneMgr instanceof VideoSceneMgr) {
            boolean enableDrvingModeByDefault;
            boolean bNeedMuteVideo = false;
            if (drivingMode == 1) {
                bNeedMuteVideo = true;
            } else if (drivingMode == -1 && (enableDrvingModeByDefault = this.getEnabledDrivingMode()) && !this.isCallingOut()) {
                bNeedMuteVideo = true;
            }
            return bNeedMuteVideo;
        }
        return false;
    }

    private boolean showConfReadyTips(boolean drivingMode) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return false;
        }
        boolean hasTip = false;
        boolean isDirectShareClient = confContext.isDirectShareClient();
        if (isDirectShareClient) {
            this.showToolbar(true, false);
            this.showShareTip();
            hasTip = true;
        } else if (ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() < 2 && !this.isCallingOut() && confContext.getOrginalHost()) {
            this.showToolbar(true, false);
            String buddyName = confContext.get1On1BuddyScreeName();
            boolean isInstantMeeting = confContext.isInstantMeeting();
            if (StringUtil.isEmptyOrNull((String)buddyName)) {
                if (isInstantMeeting && !this.mConfParams.isInviteDisabled() && !drivingMode) {
                    this.showTipWaitingToInvite();
                    hasTip = true;
                }
            } else {
                this.showTipWaitingToJoin(buddyName);
                hasTip = true;
            }
        }
        return hasTip;
    }

    private void sinkUserActiveVideo(final long userId) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onUserActiveVideo", new EventAction("onUserActiveVideo"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onUserActiveVideo(userId);
            }
        });
    }

    private void onUserActiveVideo(final long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null && user.inSilentMode()) {
            return;
        }
        this.mVideoView.post(new Runnable(){

            @Override
            public void run() {
                if (ConfActivityNormal.this.isActive()) {
                    ConfActivityNormal.this.mVideoSceneMgr.onActiveVideoChanged(userId);
                }
            }
        });
    }

    private void sinkUserActiveVideoForDeck(final long userId) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onUserActiveVideoForDeck", new EventAction("onUserActiveVideoForDeck"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onUserActiveVideoForDeck(userId);
            }
        });
    }

    private void sinkUserTalkingVideo(final long userId) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onUserTalkingVideo", new EventAction("onUserTalkingVideo"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onUserTalkingVideo(userId);
            }
        });
    }

    private void onUserActiveVideoForDeck(final long userId) {
        VideoSessionMgr videoMgr;
        if (this.mFeccComponent != null) {
            this.mFeccComponent.refreshFeccUI();
        }
        if ((videoMgr = ConfMgr.getInstance().getVideoObj()) != null && !videoMgr.isManualMode() && ConfShareLocalHelper.isOtherScreenSharing() && this.isInNormalVideoScene()) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    VideoSceneMgr sceneMgr = (VideoSceneMgr)ConfActivityNormal.this.getVideoSceneMgr();
                    if (sceneMgr != null) {
                        sceneMgr.switchToDefaultScene();
                    }
                }
            }, 1000L);
        } else {
            this.mVideoView.post(new Runnable(){

                @Override
                public void run() {
                    if (ConfActivityNormal.this.isActive()) {
                        ConfActivityNormal.this.mVideoSceneMgr.onUserActiveVideoForDeck(userId);
                    }
                }
            });
        }
    }

    private void onUserTalkingVideo(final long userId) {
        this.mVideoView.post(new Runnable(){

            @Override
            public void run() {
                if (ConfActivityNormal.this.isActive()) {
                    ConfActivityNormal.this.mVideoSceneMgr.onUserTalkingVideo(userId);
                }
            }
        });
    }

    private void sinkShareActiveUser(final long userId) {
        if (this.handleActiveUserForScreenShare(userId)) {
            return;
        }
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onShareActiveUser", new EventAction("onShareActiveUser"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onShareActiveUser(userId);
            }
        });
    }

    private boolean handleActiveUserForScreenShare(long userId) {
        if (!ScreenShareMgr.getInstance().isSharing()) {
            return false;
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return false;
        }
        int status = shareMgr.getShareStatus();
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return false;
        }
        boolean isMySelf = confStatus.isMyself(userId);
        if (status == 2) {
            if (isMySelf) {
                this.onMyShareStarted();
                this.mShareStatus = status;
                return true;
            }
        } else if (status == 3) {
            if (!isMySelf && this.mShareStatus == 2) {
                ConfActivityNormal.returnToConf((Context)this);
            }
        } else if (status == 0 && this.mShareStatus == 2) {
            ConfActivityNormal.returnToConf((Context)this);
        }
        return false;
    }

    private void onShareActiveUser(long userId) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        int status = shareMgr.getShareStatus();
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        boolean isMySelf = confStatus.isMyself(userId);
        if (status == 2) {
            if (isMySelf) {
                this.onMyShareStarted();
            } else {
                this.mVideoSceneMgr.onShareActiveUser(userId);
            }
        } else if (status == 3) {
            if (!isMySelf) {
                if (this.mShareStatus == 2) {
                    this.onMyShareStopped();
                }
                this.onOtherStartShare(userId);
            }
        } else if (status != 1) {
            if (status == 0) {
                if (this.mShareStatus == 2) {
                    this.onMyShareStopped();
                }
                if (!isMySelf) {
                    this.onOtherStopShare();
                }
                if (this.isInRemoteControlMode()) {
                    this.mRCFloatView.enableRC(false);
                }
                this.mRCFloatView.showRCFloatView(false, false);
                this.mVideoSceneMgr.onShareActiveUser(userId);
            } else {
                this.mVideoSceneMgr.onShareActiveUser(userId);
            }
        }
        this.mShareStatus = status;
        if (this.checkRemoteControlPrivilege()) {
            this.mRCFloatView.showRCFloatView(true, false);
        } else {
            this.mRCFloatView.showRCFloatView(false, false);
        }
    }

    protected void onStartShare() {
    }

    protected void onStopShare() {
    }

    protected void onAudioStatusChanged() {
    }

    protected void onMeetingConnected() {
    }

    protected void onSilentModeChanged(boolean inSilentMode) {
    }

    protected void onMyAudioTypeChanged() {
    }

    protected void onMyAudioSourceTypeChanged() {
    }

    protected void onMyVideoStatusChanged() {
    }

    protected void onMyRaiseLowerHandStatusChanged(boolean isRaiseHand) {
    }

    private void onMyShareStarted() {
        this.mCurSharerUserId = 0L;
        this.setIsVideoOnBeforeShare(false);
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null && videoMgr.isVideoStarted()) {
            this.muteVideo(true);
            this.setIsVideoOnBeforeShare(true);
        }
        this.setShareCaptureObject();
        if (ScreenShareMgr.getInstance().isSharing()) {
            ScreenShareMgr.getInstance().startShare();
        } else {
            this.disableToolbarAutoHide();
            this.showToolbar(true, false);
            this.showTopToolbar(false);
            if (!this.mConfParams.isBottomBarDisabled()) {
                this.showBottomToolbar(true);
            }
            this.mVideoView.setVisibility(8);
            this.shareView.start();
            this.mbPresenter = true;
        }
        if (this.isActive()) {
            this.refreshToolbar();
        }
        this.mbReceiveShareData = true;
        this.onStartShare();
        this.checkShareViewIsCanVisible();
        if (!this.mbShareScreen) {
            this.shareView.showAnnotateOnMyShareStart();
        }
    }

    private void onMyShareStopped() {
        this.mbShareScreen = false;
        this.mbEditStatus = false;
        if (this.shareView != null) {
            this.mbPresenter = false;
            this.shareView.stop();
            this.setShareViewVisible();
        }
        this.showTopToolbar(true);
        if (!this.mConfParams.isBottomBarDisabled()) {
            this.showBottomToolbar(true);
        }
        this.refreshToolbar();
        this.mVideoView.setVisibility(0);
        if (this.mRenderer != null) {
            this.mRenderer.resumeRenderer();
        }
        this.mVideoSceneMgr.startActiveScene();
        ConfLocalHelper.shouldSwitchActiveSpeakerView(this.mVideoSceneMgr);
        if (this.getIsVideoOnBeforeShare()) {
            this.muteVideo(false);
        }
        if (ScreenShareMgr.getInstance().isSharing()) {
            ScreenShareMgr.getInstance().stopShare();
        }
        this.mCurSharerUserId = 0L;
        this.mbReceiveShareData = false;
        this.onStopShare();
    }

    private void onOtherStartShare(long userId) {
        this.mVideoSceneMgr.onShareActiveUser(userId);
        this.refreshToolbar();
        if (null != this.shareView) {
            this.shareView.otherStartShare();
        }
    }

    private void onOtherStopShare() {
        this.mCurSharerUserId = 0L;
        this.mbEditStatus = false;
        this.mbReceiveShareData = false;
        if (this.shareView != null) {
            this.shareView.stop();
            this.shareView.setVisibility(8);
        }
    }

    private void sinkShareUserReceivingStatus(long userId) {
        if (this.isActive()) {
            this.onShareUserReceivingStatus(userId);
        }
    }

    private void onShareUserReceivingStatus(long userId) {
        this.mVideoSceneMgr.onShareUserReceivingStatus(userId);
        this.mCurSharerUserId = userId;
        this.mbReceiveShareData = true;
        this.mBSharePaused = false;
        if (null != this.shareView) {
            this.shareView.setSharePauseStatuChanged(false);
        }
        this.showAnnotateViewWhenSceneChanged(true);
    }

    private void sinkShareDataSizeChanged(long userId) {
        if (this.isActive()) {
            this.onShareDataSizeChanged(userId);
        }
    }

    private void onShareDataSizeChanged(long userId) {
        this.mVideoSceneMgr.onShareDataSizeChanged(userId);
    }

    private void sinkUserVideoStatus(long userId) {
        this.onUserVideoStatus(userId);
    }

    private void onUserVideoStatus(long userId) {
        boolean isMyself = false;
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmConfStatus status = ConfMgr.getInstance().getConfStatusObj();
        boolean bl = isMyself = status != null && status.isMyself(userId);
        if (isMyself) {
            CmmVideoStatus videoStatus;
            CmmUser user = ConfMgr.getInstance().getMyself();
            if (user != null && (videoStatus = user.getVideoStatusObj()) != null) {
                boolean bSendingVideo = videoStatus.getIsSending();
                if (this.isSharingOut() && this.getIsVideoOnBeforeShare() && !bSendingVideo) {
                    String message = this.getString(R.string.zm_msg_share_video_stopped_promt);
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)message, (int)1).show();
                }
            }
        } else if (confMgr.getConfContext().isMeetingSupportCameraControl() && this.mFeccComponent != null) {
            this.mFeccComponent.refreshFeccUI();
        }
        if (!this.isActive()) {
            return;
        }
        this.mVideoSceneMgr.onUserVideoStatus(userId);
        ConfLocalHelper.shouldSwitchActiveSpeakerView(this.mVideoSceneMgr);
        if (isMyself) {
            this.refreshToolbar();
            this.onMyVideoStatusChanged();
        }
    }

    private void sinkUserVideoDataSizeChanged(long userId) {
        if (this.isActive()) {
            this.onUserVideoDataSizeChanged(userId);
        }
    }

    private void onUserVideoDataSizeChanged(long userId) {
        this.mVideoSceneMgr.onUserVideoDataSizeChanged(userId);
    }

    private void sinkUserAudioStatus(long userId, final int userAction) {
        if (this.isActive()) {
            this.onUserAudioStatus(userId);
        }
        this.onAudioStatusChanged();
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null || !confStatus.isMyself(userId)) {
            return;
        }
        EventTaskManager eventTaskManager = this.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.pushLater("sinkUserAudioStatus", new EventAction("sinkUserAudioStatus"){

                public void run(IUIElement ui) {
                    ConfActivity confActivity = (ConfActivity)ui;
                    if (confActivity != null) {
                        ConfLocalHelper.showTipForUserAction(confActivity, userAction);
                    }
                }
            });
        }
    }

    private void onUserAudioStatus(long userId) {
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmUser user = confMgr.getUserById(userId);
        if (user == null) {
            return;
        }
        CmmConfStatus confStatus = confMgr.getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        boolean bMyself = confStatus.isMyself(userId);
        if (bMyself) {
            if (this.isActive()) {
                this.refreshToolbar();
            }
            AudioTip.updateIfExists(this.getSupportFragmentManager());
        }
        this.mVideoSceneMgr.onUserAudioStatus(userId);
    }

    private void sinkUserActiveAudio(long userId) {
        if (this.isActive()) {
            this.onUserActiveAudio(userId);
        }
    }

    private void onUserActiveAudio(long userId) {
        this.mVideoSceneMgr.onUserActiveAudio(userId);
    }

    private void sinkUserVideoMutedByHost(final long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (!videoMgr.isVideoStarted()) {
            return;
        }
        if (!this.isActive()) {
            videoMgr.stopMyVideo(0L);
        }
        this.getNonNullEventTaskManagerOrThrowException().pushLater("sinkUserVideoMuteByHost", new EventAction("sinkUserVideoMuteByHost"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onUserVideoMutedByHost(userId);
            }
        });
    }

    private void onUserVideoMutedByHost(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        this.muteVideo(true);
        String message = this.getString(R.string.zm_msg_video_muted_by_host);
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null && user.isCoHost()) {
            message = this.getString(R.string.zm_msg_video_muted_by_cohost);
        }
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_VIDEO_MUTED_BY_HOST.name(), null, message, 3000L);
    }

    private void sinkUserVideoRequestUnmuteByHost(final long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.isVideoStarted()) {
            return;
        }
        this.getNonNullEventTaskManagerOrThrowException().pushLater("sinkUserVideoRequestUnmuteByHost", new EventAction("sinkUserVideoRequestUnmuteByHost"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onUserVideoRequestUnmuteByHost(userId);
            }
        });
    }

    private void onUserVideoRequestUnmuteByHost(long userId) {
        int titleId = R.string.zm_msg_video_host_ask_to_start_video;
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null && user.isCoHost()) {
            titleId = R.string.zm_msg_video_cohost_ask_to_start_video;
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)this).setTitle(titleId).setCancelable(false).setPositiveButton(R.string.zm_btn_start_my_video, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConfActivityNormal.this.muteVideo(false);
            }
        }).setNegativeButton(R.string.zm_btn_start_my_video_later, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConfActivityNormal.this.notifyHostCurUserWillStartVideoLater();
            }
        }).create();
        dlg.show();
    }

    private void sinkUserVideoParticipantUnmuteLater(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        String name = user.getScreenName();
        if (name == null) {
            name = "";
        }
        String msg = this.getString(R.string.zm_msg_video_xxx_will_start_video_later, new Object[]{name});
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)msg, (int)1).show();
    }

    private void notifyHostCurUserWillStartVideoLater() {
        ConfMgr.getInstance().handleUserCmd(63, 0L);
    }

    private void sinkUserRaiseLowerHand(final long userId, final boolean raiseHand) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onUserRaiseLowerHand", new EventAction("onUserRaiseLowerHand"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onUserRaiseLowerHand(userId, raiseHand);
            }
        });
    }

    private int getAllRaiseHandCount() {
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return 0;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null || !confStatus.isAllowRaiseHand()) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < userList.getUserCount(); ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user == null || !user.getRaiseHandState()) continue;
            ++count;
        }
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar == null) {
            return count;
        }
        return count += raiseHandInWebinar.getRaisedHandCount();
    }

    private String getFirstRaiseHandName() {
        ZoomQABuddy buddy;
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return null;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return null;
        }
        for (int i = 0; i < userList.getUserCount(); ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user == null || !user.getRaiseHandState() || confStatus.isMyself(user.getNodeId())) continue;
            return user.getScreenName();
        }
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar == null) {
            return null;
        }
        List<ZoomQABuddy> buddies = raiseHandInWebinar.getRaisedHandAttendees();
        if (buddies != null && (buddy = buddies.get(0)) != null) {
            return buddy.getName();
        }
        return null;
    }

    private void onUserRaiseLowerHand(long userId, boolean raiseHand) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isMyself(userId)) {
            this.onMyRaiseLowerHandStatusChanged(raiseHand);
        }
        this.updateRaiseHandStatus();
    }

    private void updateRaiseHandStatus() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.isFeedbackEnable()) {
            this.refreshFeedback();
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null || !myself.isHost() && !myself.isCoHost()) {
            return;
        }
        int count = this.getAllRaiseHandCount();
        String message = this.getFirstRaiseHandName();
        FragmentManager fm = this.getSupportFragmentManager();
        if (count == 0) {
            if (fm != null && RaiseHandTip.isShown(fm)) {
                RaiseHandTip.dismiss(fm);
            }
            return;
        }
        if (count == 1 && message == null) {
            return;
        }
        if (count != 1) {
            message = "(" + String.valueOf(count) + ")";
        }
        this.showRaiseHandTip(message);
    }

    private void handleAttendeeLeft() {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onAttendeeLeft", new EventAction("onAttendeeLeft"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onAttendeeLeft();
            }
        });
    }

    private void handleAttendeeRaiseLowerHand(final long nodeID) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onAttendeeRaiseLowerHand", new EventAction("onAttendeeRaiseLowerHand"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onAttendeeRaiseLowerHand(nodeID);
            }
        });
    }

    private void onAttendeeLeft() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null || !myself.isHost() && !myself.isCoHost()) {
            return;
        }
        this.mHandler.removeCallbacks(this.mAttendeeRaiseLowerHandRunnalbe);
        this.mHandler.postDelayed(this.mAttendeeRaiseLowerHandRunnalbe, 400L);
    }

    private void onAttendeeRaiseLowerHand(long nodeID) {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null || !myself.isHost() && !myself.isCoHost()) {
            return;
        }
        this.mHandler.removeCallbacks(this.mAttendeeRaiseLowerHandRunnalbe);
        this.mHandler.postDelayed(this.mAttendeeRaiseLowerHandRunnalbe, nodeID == 0L ? 0L : 1000L);
    }

    private void sinkBOModeratorChanged(final long userId) {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkBOModeratorChanged", new EventAction("sinkBOModeratorChanged"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).handleBOModeratorChanged(userId);
            }
        });
    }

    private void handleBOModeratorChanged(long userId) {
        if (MoreTip.hasItemsToShow()) {
            MoreTip.updateIfExists(this.getSupportFragmentManager());
        } else {
            MoreTip.dismiss(this.getSupportFragmentManager());
        }
        this.refreshToolbar();
    }

    private void showRaiseHandTip(String meessage) {
        int anchorId = 0;
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm != null) {
            if (RaiseHandTip.isShown(fm)) {
                RaiseHandTip.dismiss(fm);
            }
            RaiseHandTip.showTip(fm, meessage, anchorId);
        }
    }

    private void sinkConfOne2One(final long ret) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onConfOne2One", new EventAction("onConfOne2One"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onConfOne2One(ret);
            }
        });
    }

    private void onConfOne2One(long ret) {
        this.mVideoSceneMgr.onConfOne2One();
    }

    private void sinkUserVideoQualityChanged(long userId) {
        if (this.isActive()) {
            this.mVideoSceneMgr.onUserVideoQualityChanged(userId);
        }
    }

    private void sinkHostChanged(final long userId) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onHostChange", new EventAction("onHostChange"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onHostChange(userId);
            }
        });
    }

    private void onHostChange(long userId) {
        boolean isCurUserCoHost;
        if (!ConfMgr.getInstance().isConfConnected()) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        boolean isCurUserHost = myself != null && myself.isHost();
        boolean bl = isCurUserCoHost = myself != null && myself.isCoHost();
        if (ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() >= 2 && isCurUserHost) {
            this.showTipYourAreHost();
        }
        if (isCurUserHost) {
            this.mBtnLeave.setText(R.string.zm_btn_end_meeting);
        } else {
            this.mBtnLeave.setText(R.string.zm_btn_leave_meeting);
        }
        this.updateBOButton();
        this.mToolbar.setHostRole(isCurUserHost || isCurUserCoHost);
        if (!isCurUserHost && !isCurUserCoHost) {
            RaiseHandTip.dismiss(this.getSupportFragmentManager());
        }
        NormalMessageTip.dismiss(this.getSupportFragmentManager(), TipMessageType.TIP_LOGIN_AS_HOST.name());
        this.mVideoSceneMgr.onHostChanged(userId, isCurUserHost);
        this.refreshPanelRecording();
        this.updatePracticeModeView();
        this.refreshFeedback();
        if (this.mLiveStreamComponent != null) {
            this.mLiveStreamComponent.onHostCohostChanged(this);
        }
    }

    private void sinkCoHostChanged(final long userId) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onCoHostChange", new EventAction("onHostChange"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onCoHostChange(userId);
            }
        });
    }

    private void onCoHostChange(long userId) {
        boolean isCurUserCoHost;
        if (!ConfMgr.getInstance().isConfConnected()) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        boolean isCurUserHost = myself != null && myself.isHost();
        boolean bl = isCurUserCoHost = myself != null && myself.isCoHost();
        if (isCurUserCoHost) {
            this.showTipYouAreCoHost();
            this.handleAttendeeRaiseLowerHand(0L);
        } else {
            CmmUser user = ConfMgr.getInstance().getUserById(userId);
            if (user != null && user.isCoHost()) {
                this.showTipXXXAreCoHost(user.getScreenName());
            }
            RaiseHandTip.dismiss(this.getSupportFragmentManager());
        }
        this.mToolbar.setHostRole(isCurUserHost || isCurUserCoHost);
        this.refreshPanelRecording();
        this.updatePracticeModeView();
        this.refreshFeedback();
        if (this.mLiveStreamComponent != null) {
            this.mLiveStreamComponent.onHostCohostChanged(this);
        }
    }

    private void sinkAudioTypeChanged(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isMyself(userId)) {
            CmmUser myself = ConfMgr.getInstance().getMyself();
            if (myself == null) {
                return;
            }
            CmmAudioStatus audioStatus = myself.getAudioStatusObj();
            if (audioStatus == null) {
                return;
            }
            long myAudioType = audioStatus.getAudiotype();
            if (this.isActive()) {
                this.refreshToolbar();
                this.onMyAudioTypeChanged();
            }
            if (this.isActive()) {
                if (!this.isCallingOut()) {
                    if (myAudioType == 0L) {
                        String message = this.getString(R.string.zm_msg_audio_changed_to_voip);
                        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_AUDIO_TYPE_CHANGED.name(), null, message, 3000L);
                    } else if (myAudioType == 1L) {
                        String message = this.getString(R.string.zm_msg_audio_changed_to_phone);
                        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_AUDIO_TYPE_CHANGED.name(), null, message, 3000L);
                    }
                }
                if (myAudioType != 2L) {
                    AudioTip.dismiss(this.getSupportFragmentManager());
                    this.hideToolbarDelayed(5000L);
                }
            }
        }
        if (this.isActive() && this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.onAudioTypeChanged(userId);
        }
    }

    private void sinkUserPicReady(long userId) {
        if (this.isActive() && this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.onUserPicReady(userId);
        }
    }

    private void sinkConfVerifyHostKeyStatus(final long ret) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater(new EventAction("onVerifyHostKeyStatus"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onConfVerifyHostKeyStatus(ret);
            }
        });
    }

    private void onConfVerifyHostKeyStatus(long ret) {
        this.dismissVerifyHostKeyDialog();
        if (ret != 0L) {
            HostKeyErrorDialog.show(this.getSupportFragmentManager());
        }
    }

    private void sinkNotSupportAnnotationJoined() {
        this.getNonNullEventTaskManagerOrThrowException().pushLater(new EventAction("onNotSupportAnnotationJoined"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onNotSupportAnnotationJoined();
            }
        });
    }

    private void onNotSupportAnnotationJoined() {
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)this).setCancelable(true).setMessage(R.string.zm_alert_non_annotation_joined).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    @Override
    public boolean onConfStatusChanged(int status) {
        switch (status) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                this.sinkConfReady(status);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                this.sinkConfLeaving(status);
                break;
            }
            case 20: {
                this.sinkConfReconnect(status);
            }
        }
        return true;
    }

    @Override
    public boolean onConfStatusChanged2(int cmd, long ret) {
        this.processSpokenAccessibilityForConfCmd((View)this.mVideoView, cmd, ret);
        switch (cmd) {
            case 8: {
                this.sinkConfReadyCmd(ret);
                break;
            }
            case 9: {
                this.sinkConfOne2One(ret);
                break;
            }
            case 5: {
                this.sinkAudioReady();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.sinkAutoStartVideo(ret);
                break;
            }
            case 0: {
                break;
            }
            case 65: {
                break;
            }
            case 60: {
                break;
            }
            case 74: {
                this.sinkConfRecordStatus();
                break;
            }
            case 19: {
                this.sinkAudioSharingStatusChanged();
                break;
            }
            case 20: {
                this.sinkLeaderShipModeChanged();
                break;
            }
            case 72: {
                this.sinkConfMeetingUpgraded(ret);
                break;
            }
            case 17: {
                this.sinkConfVideoSendingStatusChanged();
                break;
            }
            case 75: {
                this.sinkUserJoinRing();
                break;
            }
            case 35: {
                this.sinkCmdAutoShowAudioSelectionDlg();
                break;
            }
            case 39: {
                this.sinkConfSilentModeChanged(ret == 1L);
                break;
            }
            case 45: {
                this.sinkCMRStartTimeOut();
                break;
            }
            case 31: {
                this.sinkConfAllowRaiseHandStatusChanged();
                break;
            }
            case 27: {
                this.sinkConfPracticeSessionStatusChanged(ret == 1L);
                break;
            }
            case 2: {
                this.hideBOStatusChangeUI();
                break;
            }
            case 96: {
                this.sinkConfVerifyHostKeyStatus(ret);
                break;
            }
            case 24: {
                this.sinkNotSupportAnnotationJoined();
                break;
            }
            case 47: 
            case 48: {
                if (this.mLiveStreamComponent == null) break;
                this.mLiveStreamComponent.onConfStatusChanged2(cmd, ret);
                break;
            }
            case 92: {
                this.sinkFeedbackAllCleared();
                break;
            }
            case 124: {
                this.sinkWaitingRoomDataReady();
            }
        }
        return true;
    }

    @Override
    public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
        this.processSpokenAccessibilityForUserCmd((View)this.mVideoView, cmd, userId, userAction);
        switch (cmd) {
            case 4: {
                this.sinkUserVideoStatus(userId);
                break;
            }
            case 10: {
                this.sinkUserActiveVideo(userId);
                break;
            }
            case 6: {
                this.sinkUserActiveVideoForDeck(userId);
                break;
            }
            case 18: {
                this.sinkUserTalkingVideo(userId);
                break;
            }
            case 51: {
                this.sinkShareActiveUser(userId);
                break;
            }
            case 14: 
            case 15: {
                this.sinkUserPicReady(userId);
                break;
            }
            case 8: {
                break;
            }
            case 52: {
                this.sinkShareUserReceivingStatus(userId);
                break;
            }
            case 53: {
                this.sinkShareUserSendingStatus(userId);
                break;
            }
            case 54: {
                this.sinkShareDataSizeChanged(userId);
                break;
            }
            case 9: {
                this.sinkUserAudioStatus(userId, userAction);
                break;
            }
            case 17: {
                this.sinkUserVideoDataSizeChanged(userId);
                break;
            }
            case 16: {
                this.sinkUserVideoQualityChanged(userId);
                break;
            }
            case 1: {
                this.sinkHostChanged(userId);
                break;
            }
            case 43: {
                this.sinkCoHostChanged(userId);
                break;
            }
            case 21: {
                this.sinkAudioTypeChanged(userId);
                break;
            }
            case 12: {
                this.sinkUserActiveAudio(userId);
                break;
            }
            case 35: {
                this.sinkUserRaiseLowerHand(userId, true);
                break;
            }
            case 36: {
                this.sinkUserRaiseLowerHand(userId, false);
                break;
            }
            case 22: {
                this.sinkUserVideoMutedByHost(userId);
                break;
            }
            case 23: {
                this.sinkUserVideoRequestUnmuteByHost(userId);
                break;
            }
            case 63: {
                this.sinkUserVideoParticipantUnmuteLater(userId);
                break;
            }
            case 24: {
                this.sinkBOModeratorChanged(userId);
                break;
            }
            case 64: {
                this.sinkInControlCameraTypeChanged(userId);
                break;
            }
            case 55: {
                this.onUserGetRemoteControlPrivilege(userId);
                break;
            }
            case 56: {
                this.remoteControlStarted(userId);
                break;
            }
            case 39: {
                this.sinkFeedbackChanged(userId);
                break;
            }
            case 27: 
            case 28: {
                this.sinkViewOnlyTalkChange(cmd, userId);
                break;
            }
            case 50: {
                this.sinkHostAskUnmute(userId);
                break;
            }
        }
        return true;
    }

    private void sinkFeedbackAllCleared() {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onFeedbackAllCleared", new EventAction("onFeedbackAllCleared"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onFeedbackAllCleared();
            }
        });
    }

    private void onFeedbackAllCleared() {
        NonVerbalFeedbackPromptTip.dismiss(this.getSupportFragmentManager());
        NonVerbalFeedbackIndicatorTip.dismiss(this.getSupportFragmentManager());
    }

    private void sinkWaitingRoomDataReady() {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("updateSilentStatus", new EventAction("updateSilentStatus"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).updateSilentModeView();
            }
        });
    }

    private void updateSilentModeView() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.inSilentMode() && this.mOnSilentView != null) {
            this.mOnSilentView.updateData();
        }
    }

    private void sinkFeedbackChanged(final long userId) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onFeedbackChanged", new EventAction("onFeedbackChanged"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onFeedbackChanged(userId);
            }
        });
    }

    private void sinkViewOnlyTalkChange(final int cmd, final long userId) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("sinkViewOnlyTalkChange", new EventAction("sinkViewOnlyTalkChange"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onViewOnlyTalkChange(cmd, userId);
            }
        });
    }

    private void onViewOnlyTalkChange(int cmd, long userId) {
        CmmConfStatus confStatus;
        CmmUser cmmUser = ConfMgr.getInstance().getMyself();
        if (cmmUser != null && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null && confStatus.isSameUser(cmmUser.getNodeId(), userId)) {
            if (cmd == 27) {
                ConfAllowTalkDialog.dismiss(this.getSupportFragmentManager());
                ConfAllowTalkDialog.showConfAllowTalkDialog(this);
            } else {
                ConfAllowTalkDialog.dismiss(this.getSupportFragmentManager());
            }
            this.refreshToolbar();
            this.refreshPanelRecording();
        }
    }

    private void sinkHostAskUnmute(final long userId) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("sinkHostAskUnmute", new EventAction("sinkHostAskUnmute"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onHostAskUnmute(userId);
            }
        });
    }

    private void onHostAskUnmute(long userId) {
        CmmAudioStatus cmmAudioStatus;
        CmmConfStatus confStatus;
        CmmUser cmmUser = ConfMgr.getInstance().getMyself();
        if (cmmUser != null && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null && confStatus.isSameUser(cmmUser.getNodeId(), userId) && (cmmAudioStatus = cmmUser.getAudioStatusObj()) != null && cmmAudioStatus.getIsMuted()) {
            ConfAllowTalkDialog.dismiss(this.getSupportFragmentManager());
            ConfAllowTalkDialog.showConfAllowTalkDialog(this);
            this.refreshToolbar();
            this.refreshPanelRecording();
        }
    }

    private void onFeedbackChanged(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null && user.getFeedback() == 1) {
            return;
        }
        this.refreshFeedback();
    }

    private void refreshFeedback() {
        CmmFeedbackMgr feedbackMgr = ConfMgr.getInstance().getFeedbackMgr();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (feedbackMgr == null || confContext == null || myself == null || !confContext.isFeedbackEnable()) {
            return;
        }
        if (myself.isHost() || myself.isCoHost() || myself.isBOModerator()) {
            NonVerbalFeedbackPromptTip tip;
            NonVerbalFeedbackIndicatorTip.dismiss(this.getSupportFragmentManager());
            int count = feedbackMgr.getAllFeedbackCount();
            if (count > 0 && (tip = NonVerbalFeedbackPromptTip.getTip(this.getSupportFragmentManager())) == null) {
                NonVerbalFeedbackPromptTip.show(this.getSupportFragmentManager(), 0L);
            }
        } else {
            NonVerbalFeedbackIndicatorTip fragment;
            NonVerbalFeedbackPromptTip.dismiss(this.getSupportFragmentManager());
            if (myself.getFeedback() != 0 && (fragment = NonVerbalFeedbackIndicatorTip.getFragment(this.getSupportFragmentManager())) == null) {
                NonVerbalFeedbackIndicatorTip.show(this.getSupportFragmentManager(), myself.getNodeId());
            }
        }
    }

    private void remoteControlStarted(long userId) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return;
        }
        if (shareSession.getShareStatus() != 3) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        long myUserId = confMgr.getMyself().getNodeId();
        CmmConfStatus confStatus = confMgr.getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        boolean isMe = confStatus.isSameUser(myUserId, userId);
        if (isMe) {
            shareSession.startRemoteControl();
            this.mRCFloatView.enableRC(true);
        } else {
            this.mRCFloatView.enableRC(false);
        }
    }

    private void onUserGetRemoteControlPrivilege(long userId) {
        boolean hasPriv = this.checkRemoteControlPrivilege();
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null || confMgr.getMyself() == null) {
            return;
        }
        long myUserId = confMgr.getMyself().getNodeId();
        CmmConfStatus confStatus = confMgr.getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        boolean isMe = confStatus.isSameUser(myUserId, userId);
        if (hasPriv && isMe) {
            this.mRCFloatView.showRCFloatView(true, true);
        } else {
            this.mRCFloatView.showRCFloatView(false, false);
        }
    }

    private boolean checkRemoteControlPrivilege() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        if (shareSession.getShareStatus() != 3) {
            return false;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null || confMgr.getMyself() == null) {
            return false;
        }
        long myUserId = confMgr.getMyself().getNodeId();
        return shareSession.hasRemoteControlPrivilegeWithUserId(myUserId);
    }

    private void sinkInControlCameraTypeChanged(long userId) {
        if (this.mFeccComponent != null) {
            this.mFeccComponent.refreshFeccUI();
        }
    }

    @Override
    public boolean onUserEvent(final int eventType, final long userId, final int flag) {
        int clientUserCount;
        if (eventType == 0 && (clientUserCount = ConfMgr.getInstance().getClientUserCount()) >= 2) {
            this.stopPlayDuduVoice();
        }
        this.getNonNullEventTaskManagerOrThrowException().pushLater("onUserEvent", new EventAction("onUserEvent"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).handleOnUserEvent(eventType, userId, flag);
            }
        });
        return true;
    }

    @Override
    public boolean onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
        this.refreshToolbar();
        if (this.isInDivveMode()) {
            return true;
        }
        if (ConfLocalHelper.shouldExcludeMsgSender(this, sender)) {
            return true;
        }
        if (!this.isActive()) {
            if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this)) {
                AccessibilityUtil.announceForAccessibilityCompat((View)this.mVideoView, (CharSequence)ConfActivityNormal.getConfChatAccessibilityDescription((Context)this, ConfChatItem.getConfChatItemFromMsgID(msgID, false)), (boolean)true);
            }
            return true;
        }
        String msg = content;
        if (msg.length() > 128) {
            msg = msg.substring(0, 128) + "...";
        }
        int anchorId = 0;
        if (this.mToolbar.getVisibility() == 0) {
            ZoomQAComponent qAComponent;
            boolean showInChat = false;
            if (ConfMgr.getInstance().isConfConnected() && ConfLocalHelper.isWebinar() && (qAComponent = ConfMgr.getInstance().getQAComponent()) != null) {
                showInChat = qAComponent.isWebinarAttendee();
            }
            anchorId = showInChat ? R.id.btnChats : R.id.btnPList;
        }
        ChatTip.show(this.getSupportFragmentManager(), null, senderDisplayName, msg, sender, receiver, anchorId, msgID);
        return true;
    }

    @Override
    public void onPTAskToLeave(int reason) {
    }

    @Override
    public void onJoinConfConfirmMeetingInfo(boolean success, boolean hasPassword, boolean hasScreenName) {
    }

    @Override
    public void onJoinConfConfirmPasswordValidateResult(boolean success, boolean needWait) {
    }

    @Override
    public void onJoinConfConfirmMeetingStatus(boolean canJoinNow, boolean hasScreenName) {
    }

    @Override
    public void onCallTimeOut() {
    }

    @Override
    public void onLaunchConfParamReady() {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onLaunchConfParamReady"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).handleOnLaunchConfParamReady();
            }
        });
    }

    @Override
    public void onDeviceStatusChanged(int cmd, int ret) {
    }

    @Override
    public void onCameraStatusEvent(int event) {
        this.refreshToolbar();
        VideoTip.updateIfExists(this.getSupportFragmentManager());
    }

    @Override
    public void onWebinarNeedRegister(boolean bNeedApproval) {
    }

    @Override
    public void onUpgradeThisFreeMeeting(int ret) {
    }

    @Override
    public void onCheckCMRPrivilege(int result, boolean canStartNow) {
    }

    @Override
    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.requestPendingPermission();
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    private void handleRequestPermissionResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if ("android.permission.RECORD_AUDIO".equals(permissions[i])) {
                if (grantResults[i] != 0) continue;
                if (requestCode == 1016) {
                    this.toggleAudioStatus();
                    continue;
                }
                if (requestCode == 1015) {
                    this.muteAudio(false);
                    continue;
                }
                if (requestCode != 1021) continue;
                this.hostAskUnmute();
                continue;
            }
            if ("android.permission.CAMERA".equals(permissions[i])) {
                if (grantResults[i] != 0) continue;
                if (requestCode == 1016) {
                    this.toggleVideoStatus();
                    continue;
                }
                if (requestCode != 1015) continue;
                this.startMyVideo();
                continue;
            }
            if (1018 != requestCode || !"android.permission.ACCESS_FINE_LOCATION".equals(permissions[i]) || grantResults[i] != 0) continue;
            this.chooseKubi(true);
        }
    }

    private void handleOnLaunchConfParamReady() {
        this.initUIStatus();
        if (this.mVideoSceneMgr != null) {
            this.mVideoSceneMgr.onLaunchConfParamReady();
        }
    }

    private void handleOnUserEvent(int eventType, long userId, int flag) {
        this.refreshToolbar();
        this.hideToolbarDelayed(5000L);
        NormalMessageTip.dismiss(this.getSupportFragmentManager(), TipMessageType.TIP_WAITING_TO_JOIN.name());
        NormalMessageTip.dismiss(this.getSupportFragmentManager(), TipMessageType.TIP_WAITING_TO_INVITE.name());
        int anchorId = 0;
        if (this.mToolbar.getVisibility() == 0 && (this.mToolbar.getButtons() & 8) != 0 && ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() >= 2) {
            anchorId = R.id.btnPList;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        CmmUser myself = ConfMgr.getInstance().getMyself();
        switch (eventType) {
            case 0: {
                CmmConfContext confContext;
                if (flag == 0) {
                    if (user == null || user.isFailoverUser()) {
                        return;
                    }
                    if (!user.isViewOnlyUserCanTalk() && !this.isUserJoinOrLeaveTipDisabled()) {
                        JoinLeaveTip.dismiss(this.getSupportFragmentManager());
                        String name = user.getScreenName();
                        String avatar = user.getSmallPicPath();
                        JoinLeaveTip.show(this.getSupportFragmentManager(), avatar, name, 0, anchorId);
                    }
                }
                if ((confContext = ConfMgr.getInstance().getConfContext()) != null && confContext.inSilentMode()) {
                    this.switchViewTo((View)this.mOnSilentView, false);
                } else {
                    this.switchViewTo(this.mConfView, false);
                }
                if (myself != null && (myself.isHost() || myself.isCoHost()) && !myself.inSilentMode() && user != null && user.inSilentMode()) {
                    this.showUserJoinWaitingListDialog();
                }
                this.mPanelConnecting.setVisibility(8);
                if (ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() != 2) break;
                this.checkStartDrivingModeOnConfReady();
                break;
            }
            case 1: {
                this.handleAttendeeLeft();
                CmmUserList userList = ConfMgr.getInstance().getUserList();
                if (userList == null) {
                    return;
                }
                user = userList.getLeftUserById(userId);
                if (user == null || user.isFailoverUser()) {
                    return;
                }
                if (this.mFeccComponent != null) {
                    this.mFeccComponent.refreshFeccUI();
                }
                if (user.isViewOnlyUserCanTalk() || this.isUserJoinOrLeaveTipDisabled()) break;
                JoinLeaveTip.dismiss(this.getSupportFragmentManager());
                String name = user.getScreenName();
                String avatar = user.getSmallPicPath();
                JoinLeaveTip.show(this.getSupportFragmentManager(), avatar, name, 1, anchorId);
                if (myself == null || !myself.isHost() && !myself.isCoHost() || myself.inSilentMode() || !user.inSilentMode()) break;
                this.updateJoinWaitingList();
            }
        }
        this.mVideoSceneMgr.onUserEvent(eventType, userId, flag);
        this.onUserEventForBO(eventType, userId, flag);
    }

    private void sinkConfReconnect(final long status) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onConfReconnect"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).onConfReconnect(status);
            }
        });
    }

    private void onConfReconnect(long status) {
    }

    @Override
    public void muteAudio(boolean mute) {
        super.muteAudio(mute);
        this.hideToolbarDelayed(5000L);
    }

    @Override
    public void onClickBtnAudio() {
        if (!ConfMgr.getInstance().isConfConnected()) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23 && audioStatus.getAudiotype() == 0L && this.zm_checkSelfPermission("android.permission.RECORD_AUDIO") != 0) {
            this.requestPermission("android.permission.RECORD_AUDIO", 1016, 0L);
            return;
        }
        this.toggleAudioStatus();
    }

    @Override
    public void onHostAskUnmute() {
        CmmAudioStatus audioStatus = ConfLocalHelper.getMySelfAudioStatus();
        if (audioStatus != null) {
            if (Build.VERSION.SDK_INT >= 23 && audioStatus.getAudiotype() == 0L && this.zm_checkSelfPermission("android.permission.RECORD_AUDIO") != 0) {
                this.requestPermission("android.permission.RECORD_AUDIO", 1021, 0L);
                return;
            }
            this.hostAskUnmute();
        }
    }

    @Override
    protected void hostAskUnmute() {
        CmmAudioStatus audioStatus = ConfLocalHelper.getMySelfAudioStatus();
        if (audioStatus != null) {
            long type = audioStatus.getAudiotype();
            if (type != 2L) {
                super.hostAskUnmute();
                return;
            }
            this.showAudioOptions();
            this.mHandler.removeCallbacks(this.mUnmuteMyselfRunnable);
            this.mHandler.postDelayed(this.mUnmuteMyselfRunnable, 200L);
        }
    }

    private void toggleAudioStatus() {
        CmmAudioStatus audioStatus = ConfLocalHelper.getMySelfAudioStatus();
        if (audioStatus != null) {
            long type = audioStatus.getAudiotype();
            if (type != 2L) {
                this.muteAudio(!audioStatus.getIsMuted());
                return;
            }
            this.showAudioOptions();
        }
    }

    public void showAudioOptions() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        MeetingInfo info = confContext.getMeetingItem();
        if (info == null) {
            return;
        }
        if (info.getIsSelfTelephonyOn()) {
            this.showSelfTelephoneInfo(info.getOtherTeleConfInfo());
        } else {
            if (ConfMgr.getInstance().isViewOnlyMeeting()) {
                ConfLocalHelper.connectVoIP();
            } else {
                AudioTip.show(this.getSupportFragmentManager(), this.isBottombarShowing() ? R.id.btnAudio : 0);
            }
            this.disableToolbarAutoHide();
        }
    }

    private void showSelfTelephoneInfo(String info) {
        if (info == null) {
            return;
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this).setTitle(R.string.zm_title_audio_conference).setMessage(info).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.show();
    }

    @Override
    public void muteVideo(boolean mute) {
        super.muteVideo(mute);
        this.mToolbar.setVideoMuted(!this.getIsVideoStarted());
        if (this.mCameraComponent != null) {
            this.mCameraComponent.updateSwitchCameraButton();
        }
        this.hideToolbarDelayed(5000L);
    }

    @Override
    public void hideToolbarDefaultDelayed() {
        this.hideToolbarDelayed(5000L);
    }

    @Override
    public void onClickBtnVideo() {
        if (Build.VERSION.SDK_INT >= 23 && this.zm_checkSelfPermission("android.permission.CAMERA") != 0) {
            this.requestPermission("android.permission.CAMERA", 1016, 0L);
            return;
        }
        this.toggleVideoStatus();
    }

    public void toggleVideoStatus() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.isVideoStarted()) {
            this.muteVideo(true);
        } else {
            this.muteVideo(false);
        }
    }

    @Override
    public void onClickParticipants() {
        this.showPList();
    }

    @Override
    public void onClickChats() {
        CmmConfContext confContext;
        if (ConfMgr.getInstance().isConfConnected() && (confContext = ConfMgr.getInstance().getConfContext()) != null && confContext.isWebinar()) {
            if (UIMgr.isLargeMode((Context)this)) {
                ConfChatFragment.showAsFragment(this.getSupportFragmentManager(), 0L);
            } else {
                ConfChatFragment.showAsActivity((ZMActivity)this, 0, null);
                this.hideToolbarDelayed(5000L);
            }
        }
    }

    @Override
    public void onClickSwitchCamera() {
        if (this.mCameraComponent != null) {
            this.mCameraComponent.onClickSwitchCamera();
        }
    }

    @Override
    public void onClickMore() {
        MoreTip.show(this.getSupportFragmentManager(), this.isBottombarShowing() ? R.id.btnMore : 0);
    }

    private void onClickSwitchToShare() {
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        if (sceneMgr.isViewingSharing()) {
            return;
        }
        sceneMgr.switchToDefaultScene();
    }

    private void onSwitchToDriverMode() {
        this.showToolbar(false, false);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ConfActivityNormal.this.isActive()) {
                    ConfActivityNormal.this.dismissTempTips();
                }
            }
        });
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return;
        }
        ParamsList params = confContext.getAppContextParams();
        params.putInt("drivingMode", 1);
        confContext.setAppContextParams(params);
        this.refreshPanelRecording();
        this.refreshAudioSharing(false);
        if (this.mLiveStreamComponent != null) {
            this.mLiveStreamComponent.onLiveStreamStatusChange();
        }
    }

    private void onSwitchOutDriverMode() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return;
        }
        if (confContext.isAlwaysShowMeetingToolbar()) {
            this.showToolbar(true, false);
        }
        ParamsList params = confContext.getAppContextParams();
        params.putInt("drivingMode", 0);
        confContext.setAppContextParams(params);
        this.refreshAudioSharing(false);
        this.refreshPanelRecording();
        if (this.mLiveStreamComponent != null) {
            this.mLiveStreamComponent.onLiveStreamStatusChange();
        }
    }

    @Override
    public void showPList() {
        if (UIMgr.isLargeMode((Context)this)) {
            PListFragment.show(this.getSupportFragmentManager(), R.id.btnPList);
            if (g_hideToolbarRunnable != null) {
                g_handler.removeCallbacks(g_hideToolbarRunnable);
            }
        } else {
            PListActivity.show(this, 1001);
            this.hideToolbarDelayed(5000L);
        }
    }

    @Override
    public void showAttendeeList() {
        QAWebinarAttendeeListFragment.showAsActivity(this, 0);
        this.hideToolbarDelayed(5000L);
    }

    private void onClickBtnAudioSource() {
        ConfLocalHelper.switchAudio(this, this.getMyAudioType());
    }

    private void onClickBtnQA() {
        ConfLocalHelper.showQA(this);
    }

    private void onClickPanelCurUserRecording() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null || confContext.isAutoCMRForbidManualStop() && !recordMgr.isCMRPaused()) {
            return;
        }
        RecordControlDialog.show(this.getSupportFragmentManager());
        this.showCMRNotification();
    }

    private void showCMRNotification() {
    }

    private void onClickBtnPoll() {
        int count;
        PollingMgr pollMgr = ConfMgr.getInstance().getPollObj();
        if (pollMgr != null && (count = pollMgr.getPollingCount()) > 0) {
            for (int i = 0; i < count; ++i) {
                IPollingDoc doc = pollMgr.getPollingAtIdx(i);
                if (doc == null) continue;
                int state = doc.getPollingState();
                int myState = doc.getMyPollingState();
                String pollId = doc.getPollingId();
                if (state == 1 && myState != 2) {
                    this.handlePollingOpened(pollId);
                    break;
                }
                if (state != 3) continue;
                this.handlePollingShareResult(pollId);
                break;
            }
        }
    }

    @Override
    public void onToolbarVisiblilyChanged(boolean visible) {
        if (visible) {
            int height;
            if (this.mToolbar.getVisibility() != 0) {
                this.mToolbarHeight = 0;
            } else {
                height = this.mToolbar.getHeight();
                if (height == 0) {
                    this.mToolbar.measure(View.MeasureSpec.makeMeasureSpec((int)Integer.MAX_VALUE, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)Integer.MAX_VALUE, (int)Integer.MIN_VALUE));
                    height = this.mToolbar.getMeasuredHeight();
                }
                this.mToolbarHeight = height;
            }
            if (this.mTopbar.getVisibility() != 0) {
                this.mTopbarHeight = 0;
            } else {
                height = this.mTopbar.getHeight();
                if (height == 0) {
                    this.mTopbar.measure(View.MeasureSpec.makeMeasureSpec((int)Integer.MAX_VALUE, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)Integer.MAX_VALUE, (int)Integer.MIN_VALUE));
                    height = this.mTopbar.getMeasuredHeight();
                }
                this.mTopbarHeight = height;
            }
        } else {
            this.mToolbarHeight = 0;
            this.mTopbarHeight = 0;
        }
        if (this.mVideoSceneMgr != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ConfActivityNormal.this.mVideoSceneMgr.onConfUIRelayout(ConfActivityNormal.this);
                }
            });
        }
        if (!UIMgr.isLargeMode((Context)this)) {
            this.mPanelSwitchSceneButtons.setVisibility(visible ? 4 : 0);
        }
        if (this.mVideoSceneMgr != null && this.mVideoSceneMgr.getActiveScene() != null) {
            this.mVideoSceneMgr.getActiveScene().updateAccessibilitySceneDescription();
            this.mVideoSceneMgr.announceAccessibilityAtActiveScene();
        }
        this.updateSwitchToShareButton();
        this.refreshAudioSharing(true);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.panelWaitingShare || id2 == R.id.panelSharingTitle || id2 == R.id.panelTop) {
            this.switchToolbar();
        } else if (id2 == R.id.btnLeave) {
            this.onClickLeave();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.imgAudioSource) {
            this.onClickBtnAudioSource();
        } else if (id2 == R.id.btnQA) {
            this.onClickBtnQA();
        } else if (id2 == R.id.panelCurUserRecording) {
            this.onClickPanelCurUserRecording();
        } else if (id2 == R.id.btnPoll) {
            this.onClickBtnPoll();
        } else if (id2 == R.id.btnSwitchToShare) {
            this.onClickSwitchToShare();
        } else if (id2 == R.id.btnBreakout) {
            this.onClickJoinBO();
        } else if (id2 == R.id.btnBOHelp) {
            this.onClickBOHelp();
        } else if (id2 == R.id.btnBroadcast) {
            this.onClickBroadcast();
        } else if (id2 == R.id.btnKubi) {
            this.onClickBtnKubi();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.mbHasSurface) {
            this.mbHasSurface = true;
            this.onVideoCaptureSurfaceReady(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mbHasSurface = false;
    }

    private void onVideoCaptureSurfaceReady(SurfaceHolder holder) {
        VideoCapturer.getInstance().setSurfaceHolder(holder);
    }

    private void onVideoCaptureSurfaceInvalidated() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null && videoMgr.isPreviewing()) {
            videoMgr.stopPreviewDevice(this.mVideoSceneMgr.getPreviewRenderInfo());
        }
        VideoCapturer.getInstance().onSurfaceInvalidated();
    }

    private void updateSwitchToShareButton() {
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        AbsVideoScene activeScene = sceneMgr.getActiveScene();
        if (activeScene == null) {
            return;
        }
        if (activeScene instanceof NormalVideoScene && ConfShareLocalHelper.isOtherScreenSharing() && this.isToolbarShowing()) {
            this.mBtnSwitchToShare.setVisibility(0);
        } else {
            this.mBtnSwitchToShare.setVisibility(8);
        }
    }

    @Override
    public void onVideoSceneChanged(AbsVideoScene fromScene, AbsVideoScene toScene) {
        this.refreshToolbar();
        this.refreshAudioSharing(false);
        this.refreshPanelRecording();
        if (this.mFeccComponent != null) {
            this.mFeccComponent.refreshFeccUI();
        }
        this.checkClosedCaption();
        boolean isSwitchOutDriverMode = fromScene instanceof DriverModeVideoScene;
        boolean isSwitchToDriverMode = toScene instanceof DriverModeVideoScene;
        if (isSwitchToDriverMode) {
            this.onSwitchToDriverMode();
        } else if (isSwitchOutDriverMode) {
            this.onSwitchOutDriverMode();
        }
        if (toScene instanceof ShareVideoScene) {
            if (this.checkRemoteControlPrivilege()) {
                this.mRCFloatView.showRCFloatView(true, false);
            }
        } else if (fromScene instanceof ShareVideoScene) {
            this.mRCFloatView.showRCFloatView(false, false);
        }
        this.updateLayoutMode(fromScene, toScene);
        this.showAnnotateViewWhenSceneChanged(this.isInShareVideoScene());
    }

    @Override
    public void onDraggingVideoScene() {
        this.mPanelRecording.setVisibility(8);
        this.mPanelCurUserRecording.setVisibility(8);
        if (this.isToolbarShowing()) {
            this.showToolbar(false, false);
        }
    }

    @Override
    public void onDropVideoScene(boolean activeSceneChanged) {
        this.refreshPanelRecording();
    }

    private void switchToolbar() {
        if (this.isInDivveMode()) {
            this.showToolbar(false, false);
            return;
        }
        if (ConfMgr.getInstance().isConfConnected() && !this.isCallingOut()) {
            boolean bShow = !this.isToolbarShowing();
            this.showToolbar(bShow, true);
            if (bShow) {
                this.refreshToolbar();
                this.hideToolbarDelayed(5000L);
                this.mToolbar.focusFirstVisibleButton();
            }
        } else {
            this.showToolbar(false, false);
            this.disableToolbarAutoHide();
        }
    }

    public void focusConfToolbarButton(int type) {
        this.mToolbar.focus(type);
    }

    private void showToolbar(boolean show, boolean animation) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (!ConfMgr.getInstance().isConfConnected() || this.isInDivveMode()) {
            show = false;
            animation = false;
        } else {
            if (this.isSharingOut() && !ScreenShareMgr.getInstance().isSharing()) {
                show = false;
                animation = false;
            }
            if (confContext != null && confContext.isAlwaysShowMeetingToolbar()) {
                show = true;
            }
        }
        this.refreshBtnBack();
        if (confContext != null) {
            this.mPanelTools.setConfNumber(confContext.getConfNumber());
        }
        if (this.isSharingOut() && !show && !ScreenShareMgr.getInstance().isSharing() || this.mbEditStatus) {
            return;
        }
        this.mPanelTools.showToolbar(show, animation);
        if (this.mConfParams.isTitleBarDisabled()) {
            this.showTitlebar(false);
        }
        if (this.mConfParams.isBottomBarDisabled() || this.mbEditStatus) {
            this.showBottomToolbar(false);
        }
    }

    private void showTitlebar(boolean show) {
        View titleBar = this.mPanelTools.findViewById(R.id.titleBar);
        if (titleBar != null) {
            titleBar.setVisibility(show ? 0 : 8);
        }
    }

    private void showTopToolbar(boolean show) {
        this.mPanelTools.setVisibilityForTopToolbar(show ? 0 : 8);
    }

    private void showBottomToolbar(boolean show) {
        this.mToolbar.setVisibility(show ? 0 : 8);
    }

    private void hideToolbarDelayed(final long delay) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.getSystemService("accessibility");
        if (accessibilityManager != null && accessibilityManager.isEnabled()) {
            return;
        }
        if (this.isSharingOut()) {
            return;
        }
        if (this.canShowBroadcastButton()) {
            return;
        }
        if (g_hideToolbarRunnable != null) {
            g_handler.removeCallbacks(g_hideToolbarRunnable);
        }
        g_hideToolbarRunnable = new Runnable(){

            @Override
            public void run() {
                if (ConfActivityNormal.this.isActive()) {
                    if (ConfActivityNormal.this.hasTipPointToToolbar()) {
                        return;
                    }
                    ConfActivityNormal.this.showToolbar(false, true);
                    g_handler.removeCallbacks(g_hideToolbarRunnable);
                    g_hideToolbarRunnable = null;
                } else {
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("hideToolbarDelayed"){

                        public void run(IUIElement ui) {
                            ((ConfActivityNormal)ui).hideToolbarDelayed(delay);
                        }
                    });
                }
            }
        };
        g_handler.postDelayed(g_hideToolbarRunnable, delay);
    }

    private void disableToolbarAutoHide() {
        if (g_hideToolbarRunnable != null) {
            g_handler.removeCallbacks(g_hideToolbarRunnable);
        }
    }

    private boolean hideToolbarMenus() {
        boolean ret = false;
        if (PListFragment.hide(this.getSupportFragmentManager())) {
            ret = true;
        }
        if (InviteFragment.hide(this.getSupportFragmentManager())) {
            UIUtil.closeSoftKeyboard((Context)this, (View)this.getWindow().getDecorView());
            ret = true;
        }
        if (MeetingRunningInfoFragment.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void onPListTipClosed() {
        this.hideToolbarDelayed(5000L);
    }

    public void onInviteTipClosed() {
        this.hideToolbarDelayed(5000L);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.isSharingOut() && this.shareView.onActivityResult(requestCode, resultCode, data)) {
            return;
        }
        if (this.mShareComponent != null && this.mShareComponent.processShareRequest(requestCode, resultCode, data)) {
            return;
        }
        switch (requestCode) {
            case 1011: {
                if (resultCode != -1) break;
                this.showPollingSubmitedMessage();
                break;
            }
            case 1017: {
                if (resultCode != -1) break;
                this.chooseKubi(false);
                break;
            }
            case 1020: {
                if (OsUtil.isAtLeastN() && !Settings.canDrawOverlays((Context)this)) {
                    return;
                }
                this.shareScreen(this.mScreenInfoData);
            }
        }
    }

    private String getMeetingHostName() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return "";
        }
        MeetingInfo meetingInfo = confContext.getMeetingItem();
        String hostName = meetingInfo.getMeetingHostName();
        if (hostName == null) {
            hostName = "";
        }
        return hostName;
    }

    private void showTipWaitingToJoin(String buddyName) {
        String message = this.getString(R.string.zm_msg_conf_waiting_to_join, new Object[]{buddyName});
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_WAITING_TO_JOIN.name(), null, message);
    }

    private void showTipWaitingToInvite() {
        this.showToolbar(true, false);
        String title = this.getString(R.string.zm_msg_conf_waiting_to_invite_title);
        String message = this.getString(R.string.zm_msg_conf_waiting_to_invite);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_WAITING_TO_INVITE.name(), title, message, R.id.btnPList, UIMgr.isLargeMode((Context)this) ? 1 : 3);
    }

    private void showTipYourAreHost() {
        String message = this.getString(R.string.zm_msg_meeting_youarehost);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_YOU_ARE_HOST.name(), null, message, 3000L);
    }

    private void showTipYouAreCoHost() {
        String message = this.getString(R.string.zm_msg_meeting_you_are_cohost);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_YOU_ARE_HOST.name(), null, message, 3000L);
    }

    private void showTipXXXAreCoHost(String name) {
        String message = this.getString(R.string.zm_msg_meeting_xxx_are_cohost, new Object[]{name});
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_YOU_ARE_HOST.name(), null, message, 3000L);
    }

    private void showTipMutedForSharingAudioStarted() {
        String message = this.getString(R.string.zm_msg_muted_for_sharing_audio_started);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_MUTED_FOR_SHARING_AUDIO_STARTED.name(), null, message, 3000L);
    }

    private void showTipUnmutedForSharingAudioStopped() {
        String message = this.getString(R.string.zm_msg_unmuted_for_sharing_audio_stopped);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_UNMUTED_FOR_SHARING_AUDIO_STOPPED.name(), null, message, 3000L);
    }

    private void showTipMutedForLeaderShipModeStarted() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        long activeUserId = videoMgr.getActiveUserID();
        CmmUser user = ConfMgr.getInstance().getUserById(activeUserId);
        if (user == null) {
            return;
        }
        String message = this.getString(R.string.zm_msg_muted_for_leadership_mode_started, new Object[]{user.getScreenName()});
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_MUTED_FOR_LEADERSHIP_MODE_STARTED.name(), null, message, 3000L);
    }

    private void showTipUnmutedForLeaderShipModeStopped() {
        String message = this.getString(R.string.zm_msg_unmuted_for_leadership_mode_stopped);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_UNMUTED_FOR_LEADERSHIP_MODE_STOPPED.name(), null, message, 3000L);
    }

    @Override
    public void showTipMicEchoDetected() {
        this.showToolbar(true, false);
        String message = this.getString(R.string.zm_msg_voip_disconnected_for_echo_detected);
        int anchorId = this.isBottombarShowing() ? R.id.btnAudio : 0;
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_MIC_ECHO_DETECTED.name(), null, message, anchorId, UIMgr.isLargeMode((Context)this) ? 1 : 3);
    }

    private void showPollingSubmitedMessage() {
        String message = this.getResources().getString(R.string.zm_polling_msg_vote_submited);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_VOTE_SUBMITTED.name(), null, message, R.drawable.zm_ic_tick, 0, 0, 3000L);
    }

    private void onPollingStatusChangedImpl(int pollstate, final String strPID) {
        CmmConfContext confContext;
        if (this.isActive()) {
            this.updatePollButton();
        }
        if ((confContext = ConfMgr.getInstance().getConfContext()) == null || confContext.inSilentMode()) {
            return;
        }
        if (pollstate == 1) {
            this.getNonNullEventTaskManagerOrThrowException().push("handlePollingOpened", new EventAction("handlePollingOpened"){

                public void run(IUIElement ui) {
                    ((ConfActivityNormal)ui).handlePollingOpened(strPID);
                }
            });
        } else if (pollstate == 3) {
            this.getNonNullEventTaskManagerOrThrowException().push("handlePollingShareResult", new EventAction("handlePollingShareResult"){

                public void run(IUIElement ui) {
                    ((ConfActivityNormal)ui).handlePollingShareResult(strPID);
                }
            });
        }
    }

    private void handlePollingOpened(String pollingID) {
        PollingMgr pollingMgr = ConfMgr.getInstance().getPollObj();
        if (pollingMgr == null) {
            return;
        }
        IPollingDoc doc = pollingMgr.getPollingDocById(pollingID);
        if (doc == null || doc.getPollingState() != 1) {
            return;
        }
        ZoomQAComponent qaComponent = ConfMgr.getInstance().getQAComponent();
        if (qaComponent == null) {
            return;
        }
        int role = 0;
        if (pollingMgr.isPanelistofPolling()) {
            role = 1;
        } else if (pollingMgr.isHostofPolling()) {
            role = 2;
        }
        WebinarPollingActivity.show((Activity)this, pollingID, role, 1011);
    }

    private void handlePollingShareResult(String pollingID) {
        PollingMgr pollingMgr = ConfMgr.getInstance().getPollObj();
        if (pollingMgr == null) {
            return;
        }
        IPollingDoc doc = pollingMgr.getPollingDocById(pollingID);
        if (doc == null || doc.getPollingState() != 3) {
            return;
        }
        WebinarPollingResultActivity.show((Activity)this, pollingID, 1012);
    }

    private void onPollingActionResult(int cmd, final String strPID, final int ret) {
        if (cmd == 0 && ret != 0) {
            this.getNonNullEventTaskManagerOrThrowException().push("handlePollingRetrieveDocFailed", new EventAction("handlePollingRetrieveDocFailed"){

                public void run(IUIElement ui) {
                    ((ConfActivityNormal)ui).handlePollingRetrieveDocFailed(strPID, ret);
                }
            });
        }
    }

    private void handlePollingRetrieveDocFailed(String strPID, int ret) {
        String message = this.getString(R.string.zm_polling_msg_failed_to_fetch_poll, new Object[]{ret});
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)message).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.show();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        ShareVideoScene shareVideoScence;
        if (this.isInRemoteControlMode() && this.mRCFloatView.isControlling() && (shareVideoScence = this.getShareVideoScene()) != null) {
            switch (keyCode) {
                case 67: {
                    shareVideoScence.remoteControlKeyInput(0);
                    break;
                }
                case 66: {
                    shareVideoScence.remoteControlKeyInput(1);
                }
            }
            return true;
        }
        if (this.isSharingOut()) {
            if (this.shareView != null && this.shareView.onKeyDown(keyCode, event)) {
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }
        if (this.isToolbarShowing()) {
            this.hideToolbarDelayed(5000L);
        }
        switch (keyCode) {
            case 19: 
            case 20: {
                if (this.isArrowAcceleratorDisabled()) {
                    return super.onKeyDown(keyCode, event);
                }
                if (NormalMessageTip.hasTip(this.getSupportFragmentManager(), TipMessageType.TIP_WAITING_TO_INVITE.name())) {
                    NormalMessageTip.dismiss(this.getSupportFragmentManager(), TipMessageType.TIP_WAITING_TO_INVITE.name());
                    this.mToolbar.focus(8);
                } else if (NormalMessageTip.hasTip(this.getSupportFragmentManager(), TipMessageType.TIP_MIC_ECHO_DETECTED.name())) {
                    NormalMessageTip.dismiss(this.getSupportFragmentManager(), TipMessageType.TIP_MIC_ECHO_DETECTED.name());
                    this.mToolbar.focus(2);
                }
                if (!this.isToolbarShowing()) {
                    this.switchToolbar();
                    return true;
                }
                return super.onKeyDown(keyCode, event);
            }
            case 4: {
                if (this.hasTipPointToToolbar()) {
                    this.dismissTempTips();
                    return true;
                }
                if (this.isToolbarShowing()) {
                    this.switchToolbar();
                    return true;
                }
                return super.onKeyDown(keyCode, event);
            }
            case 21: {
                if (this.isArrowAcceleratorDisabled()) {
                    return super.onKeyDown(keyCode, event);
                }
                if (!this.isToolbarShowing()) {
                    this.mVideoSceneMgr.scrollHorizontal(true);
                    return true;
                }
                return super.onKeyDown(keyCode, event);
            }
            case 22: {
                if (this.isArrowAcceleratorDisabled()) {
                    return super.onKeyDown(keyCode, event);
                }
                if (!this.isToolbarShowing()) {
                    this.mVideoSceneMgr.scrollHorizontal(false);
                    return true;
                }
                return super.onKeyDown(keyCode, event);
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onClickShare() {
        if (this.mShareComponent == null) {
            return;
        }
        SharePermissionAlertDialog dialog = this.mShareComponent.buildShareAlertDialogIfNeed();
        if (dialog != null) {
            dialog.show(this.getSupportFragmentManager());
        } else {
            this.showShareTip();
        }
    }

    public void showShareTip() {
        ShareTip.show(this.getSupportFragmentManager(), this.isBottombarShowing() ? R.id.btnShare : 0);
    }

    public boolean startShareSession() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        return shareSession.startShare();
    }

    public boolean setShareCaptureObject() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        return shareSession.setCaptureObject();
    }

    public boolean stopShareSession() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        return shareSession.stopShare();
    }

    private String getHostPackageName() {
        String hostPackageName = ResourcesUtil.getString((Context)this, (int)R.string.zm_config_sdk_host_app_package_name);
        if (StringUtil.isEmptyOrNull((String)hostPackageName)) {
            return this.getPackageName();
        }
        return hostPackageName;
    }

    private void shareScreen(Intent data) {
        if (data == null) {
            return;
        }
        boolean success = this.startShareSession();
        if (success) {
            this.mbShareScreen = true;
            ScreenShareMgr.getInstance().prepare(data);
        } else {
            this.alertStartShareFailed();
        }
    }

    @Override
    public void onClickStopShare() {
        this.stopShare();
    }

    @Override
    public void onAnnoStatusChanged() {
        MoreTip.updateIfExists(this.getSupportFragmentManager());
    }

    public void setShareViewVisible() {
        if (this.mbReceiveShareData && !this.mbShareScreen && (this.mbPresenter || this.isInShareVideoScene())) {
            this.shareView.setVisibility(0);
            this.shareView.setDrawingCacheEnabled(true);
            this.checkConfSupportOrEnableAnnotate();
        } else {
            this.shareView.setVisibility(8);
        }
    }

    private void sinkShareUserSendingStatus(long userId) {
        int status = ConfMgr.getInstance().getShareObj().getShareStatus();
        if (status == 2) {
            this.onShareOutReady();
        } else if (this.isActive()) {
            this.mVideoSceneMgr.onShareUserSendingStatus(userId);
        }
        this.checkShareViewIsCanVisible();
    }

    private void onShareOutReady() {
        this.mVideoSceneMgr.stopAllScenes();
        if (this.mRenderer != null) {
            this.mRenderer.pauseRenderer();
        }
    }

    private void alertUnsupporttedFormat() {
        String message = this.getString(R.string.zm_alert_unsupported_format);
        ShareAlertDialog.showDialog(this.getSupportFragmentManager(), message, true);
    }

    private void alertImageInvalid() {
        String message = this.getString(R.string.zm_alert_invalid_image);
        ShareAlertDialog.showDialog(this.getSupportFragmentManager(), message, true);
    }

    private void alertStartShareFailed() {
        String message = this.getString(R.string.zm_alert_start_share_fail);
        ShareAlertDialog.showDialog(this.getSupportFragmentManager(), message, true);
    }

    private void alertPdfInvalid() {
        String message = this.getString(R.string.zm_alert_invalid_pdf);
        ShareAlertDialog.showDialog(this.getSupportFragmentManager(), message, true);
    }

    private void alertUrlInvalid() {
        String message = this.getString(R.string.zm_alert_invlid_url);
        ShareAlertDialog.showDialog(this.getSupportFragmentManager(), message, true);
    }

    @Override
    public void startShareWhiteboard() {
        this.shareView.setWhiteboardBackground();
        this.startShare();
    }

    @Override
    public void startShareImage(Uri uri, boolean isLocalFile) {
        if (!isLocalFile) {
            this.loadImageToShare(uri);
            return;
        }
        boolean ret = this.shareView.setImageUri(uri);
        if (!ret) {
            this.alertImageInvalid();
            return;
        }
        this.startShare();
    }

    @Override
    public void shareByPathExtension(String path) {
        if (StringUtil.isEmptyOrNull((String)path)) {
            return;
        }
        String lowerPath = path.toLowerCase(Locale.US);
        if (lowerPath.endsWith(".pdf")) {
            this.startSharePdf(path);
        } else if (lowerPath.endsWith(".gif") || lowerPath.endsWith(".bmp") || lowerPath.endsWith(".jpg") || lowerPath.endsWith(".png")) {
            File imageFile = new File(path);
            Uri image = Uri.fromFile((File)imageFile);
            this.startShareImage(image, true);
        } else {
            this.alertUnsupporttedFormat();
        }
    }

    @Override
    public void startShareWebview(String url) {
        boolean success = this.startShareSession();
        if (!success) {
            this.alertStartShareFailed();
            return;
        }
        this.setShareViewVisible();
        this.mVideoSceneMgr.stopAllScenes();
        this.shareView.setUrl(url);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void startShareScreen(Intent data) {
        if (data == null) {
            return;
        }
        if (OsUtil.isAtLeastN() && !Settings.canDrawOverlays((Context)this)) {
            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + this.getHostPackageName())));
            this.mScreenInfoData = data;
            this.startActivityForResult(intent, 1020);
        } else {
            this.shareScreen(data);
        }
    }

    private void startShareImage(Bitmap bmp) {
        boolean ret = this.shareView.setImageBitmap(bmp);
        if (!ret) {
            this.alertImageInvalid();
            return;
        }
        this.startShare();
    }

    private void showDownloadFileWaitingDialog(String message) {
        if (this.mDownloadFileWaitingDialog != null) {
            return;
        }
        this.mDownloadFileWaitingDialog = new ProgressDialog((Context)this);
        this.mDownloadFileWaitingDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (ConfActivityNormal.this.mTaskDownloadFile != null && !ConfActivityNormal.this.mTaskDownloadFile.isCancelled()) {
                    ConfActivityNormal.this.mTaskDownloadFile.cancel(true);
                }
                ConfActivityNormal.this.mTaskDownloadFile = null;
                ConfActivityNormal.this.mDownloadFileWaitingDialog = null;
            }
        });
        this.mDownloadFileWaitingDialog.requestWindowFeature(1);
        this.mDownloadFileWaitingDialog.setMessage((CharSequence)message);
        this.mDownloadFileWaitingDialog.setCanceledOnTouchOutside(false);
        this.mDownloadFileWaitingDialog.setCancelable(true);
        this.mDownloadFileWaitingDialog.show();
    }

    private void dismissDownloadFileWaitingDialog() {
        if (this.mDownloadFileWaitingDialog == null) {
            return;
        }
        this.mDownloadFileWaitingDialog.dismiss();
        this.mDownloadFileWaitingDialog = null;
    }

    private void updateProgressWaitingDialog(long totalBytes, long bytes) {
        if (this.mDownloadFileWaitingDialog == null) {
            return;
        }
        if (totalBytes > 0L) {
            long progress = bytes * 100L / totalBytes;
            this.mDownloadFileWaitingDialog.setMessage((CharSequence)this.getString(R.string.zm_msg_download_file_progress, new Object[]{progress}));
        } else {
            this.mDownloadFileWaitingDialog.setMessage((CharSequence)this.getString(R.string.zm_msg_download_file_size, new Object[]{FileUtils.toFileSizeString((Context)this, (long)bytes)}));
        }
    }

    @Override
    public void asyncDownloadFile(Uri uri, long totalBytes, String outPath) {
        if (this.mTaskDownloadFile != null) {
            this.mTaskDownloadFile.cancel(true);
            this.mTaskDownloadFile = null;
        }
        this.mTaskDownloadFile = new ZMAsyncURLDownloadFile(uri, totalBytes, outPath, (IDownloadFileListener)new DownloadFileListener(uri, totalBytes, outPath));
        this.showDownloadFileWaitingDialog(this.getString(R.string.zm_msg_download_file_size, new Object[]{FileUtils.toFileSizeString((Context)this, (long)0L)}));
        this.mTaskDownloadFile.execute((Object[])new Void[0]);
    }

    private void stopDownloadFileTask() {
        if (this.mTaskDownloadFile != null && !this.mTaskDownloadFile.isCancelled()) {
            this.mTaskDownloadFile.cancel(true);
        }
        this.dismissDownloadFileWaitingDialog();
        this.mTaskDownloadFile = null;
    }

    private void loadImageToShare(Uri uri) {
        this.mTaskLoadImageToShare = new ZMAsyncTask<Uri, Void, Bitmap>(){

            protected Bitmap doInBackground(Uri ... params) {
                Uri uri = params[0];
                Bitmap bmp = null;
                try {
                    bmp = ImageUtil.translateImageAsSmallBitmap(ConfActivityNormal.this.getApplicationContext(), uri, 0x190000, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.isCancelled()) {
                    return null;
                }
                return bmp;
            }

            protected void onPostExecute(Bitmap result) {
                ConfActivityNormal.this.mTaskLoadImageToShare = null;
                ConfActivityNormal.this.dismissWaitingLoadImageToShareDialog();
                if (result != null) {
                    ConfActivityNormal.this.startShareImage(result);
                }
            }
        };
        this.showWaitingLoadImageToShareDialog();
        this.mTaskLoadImageToShare.execute((Object[])new Uri[]{uri});
    }

    private void showWaitingLoadImageToShareDialog() {
        this.mDlgWaitingLoadImageToShare = new ProgressDialog((Context)this);
        this.mDlgWaitingLoadImageToShare.setIndeterminate(true);
        this.mDlgWaitingLoadImageToShare.setMessage((CharSequence)this.getString(R.string.zm_msg_loading_image_to_share));
        this.mDlgWaitingLoadImageToShare.show();
    }

    private void dismissWaitingLoadImageToShareDialog() {
        if (this.mDlgWaitingLoadImageToShare != null) {
            this.mDlgWaitingLoadImageToShare.dismiss();
        }
        this.mDlgWaitingLoadImageToShare = null;
    }

    private void startSharePdf(String file) {
        if (StringUtil.isEmptyOrNull((String)file)) {
            return;
        }
        boolean ret = this.shareView.setPdf(file, null);
        if (!ret) {
            this.alertPdfInvalid();
            return;
        }
        this.startShare();
    }

    private boolean startShare() {
        boolean ret = this.startShareSession();
        if (!ret) {
            this.alertStartShareFailed();
            return false;
        }
        this.setShareViewVisible();
        this.mVideoSceneMgr.stopAllScenes();
        return true;
    }

    private void stopShare() {
        if (this.shareView != null) {
            this.shareView.stop();
            this.setShareViewVisible();
        }
        this.stopShareSession();
        if (ScreenShareMgr.getInstance().isSharing()) {
            this.onAnnoStatusChanged();
            ScreenShareMgr.getInstance().stopShare();
            ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
            if (null != shareMgr) {
                boolean isShareLocked = ZoomShareData.getInstance().getAttendeeAnnotateDisable();
                ZoomShareData.getInstance().setAttendeeAnnotateDisable(isShareLocked);
            }
        }
        this.mbReceiveShareData = false;
    }

    @Override
    public void onClickStopScreenShare() {
        this.stopShare();
        Intent clickIntent = new Intent((Context)this, IntegrationActivity.class);
        clickIntent.setAction(IntegrationActivity.ACTION_RETURN_TO_CONF);
        this.startActivity(clickIntent);
    }

    @Override
    public void onClickAttendeeRaiseHand() {
        boolean ret;
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar != null && (ret = raiseHandInWebinar.raiseHand())) {
            this.updateAttendeeRaiseHandButton();
            this.focusConfToolbarButton(64);
        }
    }

    @Override
    public void onClickAttendeeLowerHand() {
        boolean ret;
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar != null && (ret = raiseHandInWebinar.lowerHand(""))) {
            this.updateAttendeeRaiseHandButton();
            this.focusConfToolbarButton(64);
        }
    }

    @Override
    public void onClickQA() {
        ConfLocalHelper.showQA(this);
    }

    @Override
    public boolean dismissTempTips() {
        if (NormalMessageTip.hasTip(this.getSupportFragmentManager(), TipMessageType.TIP_BO_JOIN_BREAKOUT_SESSION.name())) {
            this.hideToolbarDelayed(5000L);
        }
        return super.dismissTempTips();
    }

    private void initBOSession() {
        if (this.mBOUIListener == null) {
            this.mBOUIListener = new BOUI.SimpleBOUIListener(){

                @Override
                public void onBOUserUpdated(final BOObject boObject, final List<BOUpdatedUser> updatedUserList) {
                    if (boObject == null) {
                        return;
                    }
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().pushLater("onBOUserUpdated", new EventAction("onBOUserUpdated"){

                        public void run(IUIElement ui) {
                            ConfActivityNormal activity = (ConfActivityNormal)ui;
                            if (activity.isInBOMeeting() || activity.isInBOController()) {
                                return;
                            }
                            activity.updateBOUserList(boObject, updatedUserList);
                        }
                    });
                }

                @Override
                public void onMasterConfUserListUpdated(List<String> addedUsers, List<String> removedUsers, List<String> modifiedUsers) {
                }

                @Override
                public void onMasterConfHostChanged(String hostGUID, boolean gotHost) {
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().pushLater("onMasterConfHostChanged", new EventAction("onMasterConfHostChanged"){

                        public void run(IUIElement ui) {
                            ConfActivityNormal activity = (ConfActivityNormal)ui;
                            if (activity != null) {
                                activity.boCheckHideNewAttendeeWaitUnasignedDialog();
                            }
                        }
                    });
                }

                @Override
                public void onBOControlStatusChanged(int status) {
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().pushLater("onBOControlStatusChanged", new EventAction("onBOControlStatusChanged"){

                        public void run(IUIElement ui) {
                            ConfActivityNormal activity = (ConfActivityNormal)ui;
                            if (activity != null) {
                                activity.boCheckHideNewAttendeeWaitUnasignedDialog();
                            }
                        }
                    });
                }

                @Override
                public void onBOTokenReady() {
                }

                @Override
                public void onBOStoppingTick(final int leftSeconds) {
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().pushLater("onBOStoppingTick", new EventAction("onBOStoppingTick"){

                        public void run(IUIElement ui) {
                            ConfActivityNormal activity = (ConfActivityNormal)ui;
                            if (!activity.isInBOMeeting() || !activity.isInBOController()) {
                                return;
                            }
                            activity.sinkBOStoppingTick(leftSeconds);
                        }
                    });
                }

                @Override
                public void onHelpRequestReceived(String userGUID) {
                    if (!ConfActivityNormal.this.isInBOController()) {
                        return;
                    }
                    BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
                    if (boMgr == null) {
                        return;
                    }
                    boMgr.notifyHelpRequestHandled(userGUID, 1);
                }

                @Override
                public void onBOStartRequestReceived(final BOObject boSession) {
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().pushLater("onBOStartRequestReceived", new EventAction("onBOStartRequestReceived"){

                        public void run(IUIElement ui) {
                            ConfActivityNormal activity = (ConfActivityNormal)ui;
                            activity.sinkBOStartRequest(boSession);
                        }
                    });
                }

                @Override
                public void onBOStopRequestReceived(final int waitSeconds) {
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().pushLater("onBOStopRequestReceived", new EventAction("onBOStopRequestReceived"){

                        public void run(IUIElement ui) {
                            ConfActivityNormal activity = (ConfActivityNormal)ui;
                            activity.sinkBOStopRequestRecieved(waitSeconds);
                        }
                    });
                }

                @Override
                public void onHelpRequestHandleResultReceived(final int result) {
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().pushLater("onHelpRequestHandleResultReceived", new EventAction("onHelpRequestHandleResultReceived"){

                        public void run(IUIElement ui) {
                            ConfActivityNormal activity = (ConfActivityNormal)ui;
                            if (!activity.isInBOMeeting() || activity.isInBOController()) {
                                return;
                            }
                            activity.sinkBOHelpRequestHandleResult(result);
                        }
                    });
                }

                @Override
                public void OnBONewBroadcastMessageReceived(final String message, final long senderId) {
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().pushLater(new EventAction("OnBONewBroadcastMessageReceived"){

                        public void run(IUIElement ui) {
                            ConfActivityNormal activity = (ConfActivityNormal)ui;
                            if (activity == null) {
                                return;
                            }
                            activity.sinkBONewBroadcastMessageReceived(message, senderId);
                        }
                    });
                }

                @Override
                public void onBOSwitchRequestReceived(final BOObject object) {
                    ConfActivityNormal.this.getNonNullEventTaskManagerOrThrowException().pushLater("onBOSwitchRequestReceived", new EventAction("onBOSwitchRequestReceived"){

                        public void run(IUIElement ui) {
                            ConfActivityNormal activity = (ConfActivityNormal)ui;
                            if (activity == null) {
                                return;
                            }
                            activity.sinkBOSwitchRequested(object);
                        }
                    });
                }
            };
        }
        BOUI.getInstance().addListener(this.mBOUIListener);
    }

    private void uninitialBOSession() {
        if (this.mBOUIListener != null) {
            BOUI.getInstance().removeListener(this.mBOUIListener);
            this.mBOUIListener = null;
        }
    }

    private void updateBOUserList(BOObject boObject, List<BOUpdatedUser> updatedUserList) {
        if (this.isHostInThisBoMeeting()) {
            this.mbBOInRequestHelp = false;
        }
        this.updateBOButton();
    }

    private void pendingBOStartRequest() {
        this.updateBOButton();
        this.showToolbar(true, false);
        this.disableToolbarAutoHide();
        AbsVideoScene videoScene = this.mVideoSceneMgr.getActiveScene();
        if (this.mBtnBO != null && this.isBOJoinButtonNeedShow() && !this.isSharingOut() && !(videoScene instanceof DriverModeVideoScene)) {
            String message = this.getString(R.string.zm_bo_lbl_join_bo);
            NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_BO_JOIN_BREAKOUT_SESSION.name(), null, message, R.id.btnBreakout, 1);
        }
    }

    private void onClickJoinBO() {
        this.updateBOButton();
        BOObject myObject = this.getMyBOMeeting(1);
        if (myObject == null) {
            return;
        }
        this.joinBO(myObject.getBID(), 0);
    }

    public boolean joinBO(String bid) {
        int controlStatus = this.getBOControlStatus();
        if (controlStatus == 3 || controlStatus == 4) {
            this.showBOMeetingHasEndedDialog();
            return false;
        }
        return super.joinBO(bid, 0);
    }

    private void onUserEventForBO(int eventType, long userId, int flag) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        switch (eventType) {
            case 0: {
                CmmUser hostUser = this.getBOHostUser();
                if (hostUser == null) break;
                String hostGUID = hostUser.getUserGUID();
                String userGuid = user.getUserGUID();
                if (hostGUID.isEmpty() || !hostGUID.equals(userGuid)) break;
                this.mbBOInRequestHelp = false;
                break;
            }
        }
        this.updateBOButton();
    }

    private void boCheckShowNewAttendeeWaitUnassignedDialog() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null || myself.inSilentMode()) {
            return;
        }
        if (this.isBOStartedAndUnassigned() && !NormalMessageButtonTip.hasTip(this.getSupportFragmentManager(), BO_NEW_ATTENDEE_UNASSIGNED_TAG)) {
            String message = this.getString(R.string.zm_bo_lbl_wait_assigned);
            String button = this.getString(R.string.zm_btn_ok);
            NormalMessageButtonTip.show(this.getSupportFragmentManager(), BO_NEW_ATTENDEE_UNASSIGNED_TAG, message, button);
        }
    }

    private void boCheckHideNewAttendeeWaitUnasignedDialog() {
        if (!this.isBOStartedAndUnassigned()) {
            NormalMessageButtonTip.dismiss(this.getSupportFragmentManager(), BO_NEW_ATTENDEE_UNASSIGNED_TAG);
        }
    }

    @Override
    public void requestBOForHelp() {
        if (this.isHostInThisBoMeeting()) {
            this.showTipBoHostInCurrentMeeting();
            return;
        }
        super.requestBOForHelp();
    }

    private void onClickBOHelp() {
        if (this.isHostInThisBoMeeting()) {
            this.showTipBoHostInCurrentMeeting();
            return;
        }
        this.onBORequestHelpDialog();
    }

    private boolean isLaunchReasonByBO() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        int launchReason = confContext.getLaunchReason();
        return launchReason == 10 || launchReason == 11;
    }

    private boolean isBOJoinButtonNeedShow() {
        boolean boShow = false;
        BOObject myObject = this.getMyBOMeeting(1);
        if (!this.isInBOController()) {
            boShow = this.getBOControlStatus() == 2 && !this.isInBOMeeting() && myObject != null;
        }
        return boShow;
    }

    private void updateBOButton() {
        boolean hasJoinBOTip;
        boolean isInBOMeeting = this.isInBOMeeting();
        if (this.mBtnBOHelp != null) {
            boolean show = !this.isInBOController() && !this.isHostInThisBoMeeting() && isInBOMeeting && this.getBOControlStatus() == 2 && !this.mbBOInRequestHelp;
            this.mBtnBOHelp.setVisibility(show ? 0 : 8);
        }
        boolean joinBtnShow = this.isBOJoinButtonNeedShow();
        if (this.mBtnBO != null) {
            this.mBtnBO.setVisibility(joinBtnShow ? 0 : 8);
        }
        if (hasJoinBOTip = NormalMessageTip.hasTip(this.getSupportFragmentManager(), TipMessageType.TIP_BO_JOIN_BREAKOUT_SESSION.name())) {
            if (joinBtnShow) {
                this.mTipLayer.requestLayout();
            } else {
                NormalMessageTip.dismiss(this.getSupportFragmentManager(), TipMessageType.TIP_BO_JOIN_BREAKOUT_SESSION.name());
                this.hideToolbarDelayed(5000L);
            }
        }
        this.updateTitleBar();
    }

    private void updateKubiButton() {
        if (this.mBtnKubi == null || this.mImgKubi == null || this.mTxtKubiStatus == null) {
            return;
        }
        this.mBtnKubi.setVisibility(8);
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        if (!ConfMgr.getInstance().isConfConnected() || !confContext.isKubiEnabled()) {
            return;
        }
        KUBIDeviceController kubiDeviceController = KUBIDeviceController.getInstance();
        if (kubiDeviceController == null) {
            return;
        }
        this.mBtnKubi.setVisibility(0);
        int kubiStatus = kubiDeviceController.getKubiStatus();
        switch (kubiStatus) {
            case 4: {
                this.mImgKubi.setImageResource(R.drawable.zm_ic_kubi_connected);
                this.mTxtKubiStatus.setText(R.string.zm_kubi_status_connected);
                break;
            }
            case 0: {
                this.mImgKubi.setImageResource(R.drawable.zm_ic_kubi_disconnected);
                this.mTxtKubiStatus.setText(R.string.zm_kubi_status_disconnected);
                break;
            }
            case 1: {
                this.mImgKubi.setImageResource(R.drawable.zm_ic_kubi_connected);
                this.mTxtKubiStatus.setText(R.string.zm_kubi_status_disconnecting);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.mImgKubi.setImageResource(R.drawable.zm_ic_kubi_disconnected);
                this.mTxtKubiStatus.setText(R.string.zm_kubi_status_connecting);
            }
        }
        this.mImgKubi.setDuplicateParentStateEnabled(true);
        this.mTxtKubiStatus.setDuplicateParentStateEnabled(true);
    }

    private void registerKubiListener() {
        KUBIDeviceController kubiDeviceController = KUBIDeviceController.getInstance();
        if (kubiDeviceController != null) {
            if (this.mKubiListener == null) {
                this.mKubiListener = new KUBIDeviceController.SimpleKubiListener(){

                    @Override
                    public void onKubiManagerStatusChanged(int oldStatus, int newStatus) {
                        ConfActivityNormal.this.onKubiManagerStatusChanged(oldStatus, newStatus);
                    }
                };
            }
            kubiDeviceController.addKubiListener(this.mKubiListener);
        }
    }

    private void unregisterKubiListener() {
        KUBIDeviceController kubiDeviceController = KUBIDeviceController.getInstance();
        if (kubiDeviceController != null && this.mKubiListener != null) {
            kubiDeviceController.removeKubiListener(this.mKubiListener);
        }
    }

    private void unregisterAnnotateListener() {
        this.shareView.unregisterAnnotateListener();
    }

    private void onKubiManagerStatusChanged(int oldStatus, int newStatus) {
        this.updateKubiButton();
        if (oldStatus != 4 && newStatus == 4) {
            ConfMgr.getInstance().handleConfCmd(58);
        } else if (oldStatus == 4 && newStatus != 4) {
            ConfMgr.getInstance().handleConfCmd(59);
        }
    }

    private void onClickBtnKubi() {
        this.chooseKubi(true);
    }

    private void chooseKubi(boolean bCheckBluetoothStatus) {
        if (!bCheckBluetoothStatus || this.checkBluetoothStatus()) {
            if (this.checkLocationPermissionForKubi()) {
                this.showKubiChoiceFragment();
            } else {
                this.requestLocationPermissionForKubi();
            }
        } else {
            this.turnOnBluetoothForKubi();
        }
    }

    public void onKubiChoiceFragmentClosed() {
        this.hideToolbarDelayed(5000L);
    }

    private boolean checkBluetoothStatus() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return false;
        }
        boolean isEnabled = bluetoothAdapter.isEnabled();
        return isEnabled;
    }

    private boolean checkLocationPermissionForKubi() {
        if (Build.VERSION.SDK_INT <= 22) {
            return true;
        }
        return 0 == this.zm_checkSelfPermission("android.permission.ACCESS_FINE_LOCATION");
    }

    private void requestLocationPermissionForKubi() {
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)this).setMessage(R.string.zm_kubi_request_location_permission).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConfActivityNormal.this.requestPermission("android.permission.ACCESS_FINE_LOCATION", 1018, 0L);
            }
        }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    private void turnOnBluetoothForKubi() {
        PackageManager pm = this.getPackageManager();
        if (pm != null && 0 == pm.checkPermission("android.permission.BLUETOOTH_ADMIN", this.getPackageName())) {
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this).setTitle(R.string.zm_kubi_bluetooth_turn_on_request).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivityNormal.this.turnOnBluetooth();
                    ConfActivityNormal.this.chooseKubi(false);
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            dialog.show();
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            this.startActivityForResult(enableBtIntent, 1017);
        }
    }

    private void turnOnBluetooth() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter != null && !bluetoothAdapter.isEnabled()) {
            bluetoothAdapter.enable();
        }
    }

    private void showKubiChoiceFragment() {
        this.disableToolbarAutoHide();
        KubiChoiceFragment.showDialog(this.getSupportFragmentManager());
    }

    private void sinkBOStoppingTick(int leftSeconds) {
        if (this.getBOControlStatus() != 3) {
            return;
        }
        BOMeetingEndDialogFragment f = (BOMeetingEndDialogFragment)this.getSupportFragmentManager().findFragmentByTag(BO_MEETING_END_ALL_BO_IN_BO_TAG);
        if (f == null) {
            if (!this.mBOControllerStopTickStarted) {
                BOMeetingEndDialogFragment.showDialogFragment(this.getSupportFragmentManager(), leftSeconds, false, 0, BO_MEETING_END_ALL_BO_IN_BO_TAG);
            }
        } else {
            f.updateWaitingSeconds(leftSeconds);
        }
        this.mBOControllerStopTickStarted = true;
    }

    private void sinkBOStartRequest(BOObject boSession) {
        this.boCheckHideNewAttendeeWaitUnasignedDialog();
        if (this.isInBOMeeting() || this.isInBOController() || !this.isBOControllerStarted()) {
            return;
        }
        BOStartRequestDialog.showDialog(this.getSupportFragmentManager(), boSession.getBID());
    }

    private void sinkBOStopRequestRecieved(int waitSeconds) {
        if (NormalMessageTip.hasTip(this.getSupportFragmentManager(), TipMessageType.TIP_BO_JOIN_BREAKOUT_SESSION.name())) {
            this.hideToolbarDelayed(5000L);
        }
        this.refreshToolbar();
        this.clearAllBOUI();
        this.mbBOInRequestHelp = false;
        if (!this.isInBOMeeting()) {
            return;
        }
        if (waitSeconds <= 0) {
            this.leaveBO();
            return;
        }
        BOMeetingEndDialogFragment leaveFragment = (BOMeetingEndDialogFragment)this.getSupportFragmentManager().findFragmentByTag(BO_MEETING_LEAVE_BO_TAG);
        if (leaveFragment == null) {
            BOMeetingEndDialogFragment.showDialogFragment(this.getSupportFragmentManager(), waitSeconds, true, 0, BO_MEETING_LEAVE_BO_TAG);
        }
    }

    private void sinkBOHelpRequestHandleResult(int result) {
        if (result == 0) {
            this.showTipBoHelpRequestNotified();
        } else if (result == 1 || result == 2) {
            this.mbBOInRequestHelp = false;
            this.updateBOButton();
            this.hostCannotForHelpDialog();
        }
    }

    private void sinkBONewBroadcastMessageReceived(String message, long senderId) {
        if (StringUtil.isEmptyOrNull((String)message)) {
            return;
        }
        if (this.isInDivveMode()) {
            return;
        }
        String name = "";
        String picPath = null;
        CmmUser user = this.getBOUser(senderId);
        if (user != null) {
            name = user.getScreenName();
            picPath = user.getSmallPicPath();
        }
        String title = this.getString(R.string.zm_bo_msg_to_everyone, new Object[]{name});
        MessageTip.show(this.getSupportFragmentManager(), picPath, title, message, 0);
    }

    private void sinkBOSwitchRequested(BOObject object) {
        if (object == null) {
            return;
        }
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return;
        }
        if (this.isInBOMeeting()) {
            this.joinBO(object.getBID(), 1);
        } else {
            this.updateBOSwitchRequestedUI(object);
        }
    }

    private void updateBOSwitchRequestedUI(BOObject object) {
        if (object == null) {
            return;
        }
        BOStartRequestDialog dialog = (BOStartRequestDialog)this.getSupportFragmentManager().findFragmentByTag(BOStartRequestDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
        BOStartRequestDialog.showDialog(this.getSupportFragmentManager(), object.getBID());
    }

    private void onBORequestHelpDialog() {
        if (this.mBOHelpDialog != null && this.mBOHelpDialog.isShowing()) {
            this.mBOHelpDialog.dismiss();
        }
        this.mBOHelpDialog = new ZMAlertDialog.Builder((Context)this).setMessage(R.string.zm_bo_msg_ask_for_help).setCancelable(false).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConfActivityNormal.this.mBOHelpDialog = null;
            }
        }).setPositiveButton(R.string.zm_bo_btn_ask_for_help, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConfActivityNormal.this.requestBOForHelp();
                ConfActivityNormal.this.mbBOInRequestHelp = true;
                ConfActivityNormal.this.updateBOButton();
                ConfActivityNormal.this.mBOHelpDialog = null;
            }
        }).create();
        this.mBOHelpDialog.show();
    }

    private void hostCannotForHelpDialog() {
        if (this.mBOCannotForHelpDialog != null && this.mBOCannotForHelpDialog.isShowing()) {
            this.mBOCannotForHelpDialog.dismiss();
        }
        this.mBOCannotForHelpDialog = new ZMAlertDialog.Builder((Context)this).setMessage(R.string.zm_bo_msg_host_cannot_help).setCancelable(false).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConfActivityNormal.this.mBOCannotForHelpDialog = null;
            }
        }).create();
        this.mBOCannotForHelpDialog.show();
    }

    private void showBOMeetingHasEndedDialog() {
        if (this.mBOControllerHasEndedDialog != null && this.mBOControllerHasEndedDialog.isShowing()) {
            this.mBOControllerHasEndedDialog.dismiss();
        }
        this.mBOControllerHasEndedDialog = new ZMAlertDialog.Builder((Context)this).setMessage(R.string.zm_bo_msg_been_ended).setCancelable(false).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConfActivityNormal.this.mBOControllerHasEndedDialog = null;
            }
        }).create();
        this.mBOControllerHasEndedDialog.show();
    }

    private void showTipBoHelpRequestNotified() {
        String message = this.getString(R.string.zm_bo_msg_host_notified);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_BO_HELP_REQUEST_NOTIFIED.name(), null, message, 6000L);
    }

    private void showTipBoHostInCurrentMeeting() {
        String message = this.getString(R.string.zm_bo_msg_host_been_in_session);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_BO_HOST_IN_CURRENT_MEETING.name(), null, message, 6000L);
    }

    private void showBOStatusChange(boolean join, int joinReason) {
        ViewStub viewStub = (ViewStub)this.findViewById(R.id.vBOStatusChange);
        if (viewStub == null) {
            return;
        }
        viewStub.inflate();
        ImageView joinIcon = (ImageView)this.findViewById(R.id.joiningImage);
        ImageView leaveIcon = (ImageView)this.findViewById(R.id.leavingImage);
        ImageView waitingAnimation = (ImageView)this.findViewById(R.id.waitingAnimation);
        TextView txtJoin = (TextView)this.findViewById(R.id.txtJoiningPrompt);
        TextView txtLeaving = (TextView)this.findViewById(R.id.txtLeavingPrompt);
        if (join) {
            joinIcon.setVisibility(0);
            txtJoin.setVisibility(0);
            leaveIcon.setVisibility(8);
            txtLeaving.setVisibility(8);
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            String meetingName = "";
            if (confContext != null) {
                meetingName = confContext.getBOName();
            }
            if (joinReason == 1) {
                String joinStr = this.getResources().getString(R.string.zm_bo_lbl_join_by_host_prompt, new Object[]{meetingName});
                txtJoin.setText((CharSequence)joinStr);
            } else {
                String message = this.getResources().getString(R.string.zm_bo_lbl_joining_prompt, new Object[]{meetingName});
                txtJoin.setText((CharSequence)message);
            }
        } else {
            joinIcon.setVisibility(8);
            txtJoin.setVisibility(8);
            leaveIcon.setVisibility(0);
            txtLeaving.setVisibility(0);
        }
        waitingAnimation.setImageResource(R.anim.zm_bo_connecting);
        Drawable drawable2 = waitingAnimation.getDrawable();
        if (drawable2 instanceof AnimationDrawable) {
            ((AnimationDrawable)drawable2).start();
        }
    }

    private void showBOStatusChangeUI(final boolean join, final int joinReason) {
        this.getWindow().setFlags(1024, 1024);
        this.mPanelBOStatusChange.setVisibility(0);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ConfActivityNormal.this.showBOStatusChange(join, joinReason);
            }
        });
    }

    private void hideBOStatusChangeUI() {
        this.updateSystemStatusBar();
        this.mPanelBOStatusChange.setVisibility(4);
    }

    private void showEndAllBODialogInMasterConf() {
        BOMeetingEndDialogFragment f = (BOMeetingEndDialogFragment)this.getSupportFragmentManager().findFragmentByTag(BO_MEETING_END_ALL_BO_IN_MASTER_TAG);
        if (f == null) {
            BOMeetingEndDialogFragment.showDialogFragment(this.getSupportFragmentManager(), 60, true, 1, BO_MEETING_END_ALL_BO_IN_MASTER_TAG);
        }
    }

    private boolean endAllBO() {
        this.mBOControllerStopTickStarted = false;
        boolean hostInMaster = this.isInBOController() && !this.isInBOMeeting();
        boolean ret = this.endBO();
        if (ret && hostInMaster) {
            this.showEndAllBODialogInMasterConf();
        }
        return ret;
    }

    public void selectBOLeaveType(int type) {
        if (type == BOLeaveFragment.BO_TYPE_LEAVE_BO) {
            this.leaveBO();
        } else if (type == BOLeaveFragment.BO_TYPE_END_ALL_BO) {
            this.endAllBO();
        } else if (type == BOLeaveFragment.BO_TYPE_LEAVE_MEETING) {
            ConfLocalHelper.leaveCall(this);
        } else if (type == BOLeaveFragment.BO_TYPE_END_MEETING) {
            ConfLocalHelper.endCall(this);
        }
    }

    private void clearAllBOUI() {
        BOLeaveFragment leaveFragment;
        BOMeetingEndDialogFragment endBOInMasterFragment;
        BOMeetingEndDialogFragment endAllBOFragment;
        BOMeetingEndDialogFragment endLeaveFragment;
        FragmentManager manager = this.getSupportFragmentManager();
        if (manager == null) {
            return;
        }
        BOStartRequestDialog startFragment = (BOStartRequestDialog)manager.findFragmentByTag(BOStartRequestDialog.class.getName());
        if (startFragment != null) {
            startFragment.dismiss();
        }
        if ((endLeaveFragment = (BOMeetingEndDialogFragment)this.getSupportFragmentManager().findFragmentByTag(BO_MEETING_LEAVE_BO_TAG)) != null) {
            endLeaveFragment.dismiss();
        }
        if ((endAllBOFragment = (BOMeetingEndDialogFragment)this.getSupportFragmentManager().findFragmentByTag(BO_MEETING_END_ALL_BO_IN_BO_TAG)) != null) {
            endAllBOFragment.dismiss();
        }
        if ((endBOInMasterFragment = (BOMeetingEndDialogFragment)this.getSupportFragmentManager().findFragmentByTag(BO_MEETING_END_ALL_BO_IN_MASTER_TAG)) != null) {
            endBOInMasterFragment.dismiss();
        }
        if ((leaveFragment = (BOLeaveFragment)this.getSupportFragmentManager().findFragmentByTag(BOLeaveFragment.class.getSimpleName())) != null) {
            leaveFragment.dismiss();
        }
        NormalMessageButtonTip.dismiss(this.getSupportFragmentManager(), BO_NEW_ATTENDEE_UNASSIGNED_TAG);
        NormalMessageTip.dismiss(this.getSupportFragmentManager(), TipMessageType.TIP_BO_JOIN_BREAKOUT_SESSION.name());
        if (this.mBOHelpDialog != null && this.mBOHelpDialog.isShowing()) {
            this.mBOHelpDialog.dismiss();
        }
        this.mBOHelpDialog = null;
        if (this.mBOCannotForHelpDialog != null && this.mBOCannotForHelpDialog.isShowing()) {
            this.mBOCannotForHelpDialog.dismiss();
        }
        this.mBOCannotForHelpDialog = null;
        if (this.mBOControllerHasEndedDialog != null && this.mBOControllerHasEndedDialog.isShowing()) {
            this.mBOControllerHasEndedDialog.dismiss();
        }
        this.mBOControllerHasEndedDialog = null;
    }

    private void updatePracticeModeView() {
        if (this.mPracticeModeView != null && this.mBtnBroadcast != null) {
            if (this.canShowBroadcastButton()) {
                this.mPracticeModeView.setVisibility(0);
                this.mBtnBroadcast.setOnClickListener((View.OnClickListener)this);
                this.showToolbar(true, false);
                this.disableToolbarAutoHide();
            } else {
                this.mPracticeModeView.setVisibility(8);
            }
        }
    }

    private void onClickBroadcast() {
        this.mBtnBroadcast.setVisibility(8);
        this.mProgressBarBroadcasting.setVisibility(0);
        ConfMgr.getInstance().handleConfCmd(101);
    }

    private boolean canShowBroadcastButton() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        if (!confContext.isWebinar()) {
            return false;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return false;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null || !myself.isHost() && !myself.isCoHost()) {
            return false;
        }
        return confContext.isPracticeSessionFeatureOn() && confStatus.isInPracticeSession();
    }

    private void sinkConfPracticeSessionStatusChanged(final boolean isInPracticeSession) {
        this.getNonNullEventTaskManagerOrThrowException().push("handlerConfPracticeSessionStatusChanged", new EventAction("handlerConfPracticeSessionStatusChanged"){

            public void run(IUIElement ui) {
                ((ConfActivityNormal)ui).handlerConfPracticeSessionStatusChanged(isInPracticeSession);
            }
        });
    }

    private void handlerConfPracticeSessionStatusChanged(boolean isInPracticeSession) {
        if (!isInPracticeSession) {
            if (this.mPracticeModeView != null && this.mBroadcastingView != null && this.mPracticeModeView.getVisibility() == 0) {
                this.showToolbar(true, false);
                this.hideToolbarDelayed(5000L);
                this.mPracticeModeView.setVisibility(8);
                this.mBroadcastingView.setVisibility(0);
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ConfActivityNormal.this.mBroadcastingView.setVisibility(8);
                    }
                }, 5000L);
            }
        } else if (this.mBtnBroadcast != null && this.mProgressBarBroadcasting != null && this.mPracticeModeView.getVisibility() == 0) {
            this.showToolbar(true, false);
            this.mBtnBroadcast.setVisibility(0);
            this.mProgressBarBroadcasting.setVisibility(8);
        }
    }

    @Override
    public void enterHostKeyToClaimHost() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.hasHostinMeeting()) {
            return;
        }
        this.showEnterHostKeyDialog();
    }

    public void showEnterHostKeyDialog() {
        HostKeyEnterDialog.show(this.getSupportFragmentManager(), this.getMeetingHostName(), HostKeyEnterDialog.class.getName());
    }

    public void showVerifyHostKeyDialog() {
        if (this.mVerifyHostKeyWaitingDialog != null) {
            return;
        }
        this.mVerifyHostKeyWaitingDialog = new ProgressDialog((Context)this);
        this.mVerifyHostKeyWaitingDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                ConfActivityNormal.this.mVerifyHostKeyWaitingDialog = null;
            }
        });
        this.mVerifyHostKeyWaitingDialog.requestWindowFeature(1);
        this.mVerifyHostKeyWaitingDialog.setMessage((CharSequence)this.getString(R.string.zm_msg_verifying_hostkey));
        this.mVerifyHostKeyWaitingDialog.setCanceledOnTouchOutside(false);
        this.mVerifyHostKeyWaitingDialog.setCancelable(true);
        this.mVerifyHostKeyWaitingDialog.show();
    }

    private void dismissVerifyHostKeyDialog() {
        if (this.mVerifyHostKeyWaitingDialog == null) {
            return;
        }
        this.mVerifyHostKeyWaitingDialog.dismiss();
        this.mVerifyHostKeyWaitingDialog = null;
    }

    @Override
    public void onEnabledRC(boolean enabled) {
        ShareVideoScene shareVideoScene;
        boolean remoteControlMode = false;
        if (enabled) {
            this.showToolbar(false, true);
            this.mRCMouseView.showRCMouse(true);
            remoteControlMode = true;
            if (null != this.shareView) {
                this.shareView.stopAnnotation();
            }
        } else {
            this.showToolbar(true, true);
            this.mRCMouseView.showRCMouse(false);
            remoteControlMode = false;
        }
        if ((shareVideoScene = this.getShareVideoScene()) != null) {
            shareVideoScene.setInRemoteControlMode(remoteControlMode);
        }
    }

    @Override
    public RCMouseView getRCMouseView() {
        return this.mRCMouseView;
    }

    private void onAnnotationStarted() {
        if (this.isInRemoteControlMode()) {
            this.mRCFloatView.enableRC(false);
        }
    }

    private boolean isInRemoteControlMode() {
        if (this.mVideoSceneMgr == null) {
            return false;
        }
        AbsVideoScene activeScene = this.mVideoSceneMgr.getActiveScene();
        if (!(activeScene instanceof ShareVideoScene)) {
            return false;
        }
        return ((ShareVideoScene)activeScene).isInRemoteControlMode();
    }

    public ShareVideoScene getShareVideoScene() {
        if (this.mVideoSceneMgr == null) {
            return null;
        }
        AbsVideoScene activeScene = this.mVideoSceneMgr.getActiveScene();
        if (!(activeScene instanceof ShareVideoScene)) {
            return null;
        }
        return (ShareVideoScene)activeScene;
    }

    public void showAnnotateViewWhenSceneChanged(boolean visible) {
        if (this.isInShareVideoScene()) {
            this.checkShareViewIsCanVisible();
        } else if (!visible) {
            this.setShareViewVisible();
        }
    }

    private void checkShareViewIsCanVisible() {
        boolean isSupportAnnotate = this.checkConfSupportOrEnableAnnotate();
        if (this.mbPresenter) {
            this.shareView.setSharePauseStatuChanged(false);
        }
        this.setShareViewVisible();
    }

    private boolean checkConfSupportOrEnableAnnotate() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (null == shareMgr || null == this.shareView) {
            return false;
        }
        boolean bSupportAnnotate = shareMgr.senderSupportAnnotation(this.mCurSharerUserId);
        this.shareView.setAnnotationEnable(bSupportAnnotate);
        return bSupportAnnotate;
    }

    @Override
    public void onClosedCaptionMessageReceived(String msgID, String content, long time) {
        this.onRealtimeClosedCaptionMessageReceived(content);
    }

    @Override
    public void onRealtimeClosedCaptionMessageReceived(String content) {
        this.mClosedCaptionContent = content;
        this.updateClosedCaption(content, true);
        if (this.isNeedShowClosedCaption() && !StringUtil.isEmptyOrNull((String)content)) {
            this.mHandler.removeCallbacks(this.mClosedCaptionTimeoutRunnable);
            this.mHandler.postDelayed(this.mClosedCaptionTimeoutRunnable, (long)CLOSECAPTION_DURATION);
        }
    }

    private boolean isNeedShowClosedCaption() {
        boolean opened = PreferenceUtil.readBooleanValue("closed_caption_enabled", false);
        if (!opened) {
            return false;
        }
        return !this.isInDriveModeScence();
    }

    private void checkClosedCaption() {
        boolean opened = PreferenceUtil.readBooleanValue("closed_caption_enabled", false);
        if (!opened || StringUtil.isEmptyOrNull((String)this.mClosedCaptionContent)) {
            this.mClosedCaptionView.setVisibility(8);
            return;
        }
        this.updateClosedCaption(this.mClosedCaptionContent, false);
    }

    private void checkShowTimer() {
        this.mHandler.removeCallbacks(this.mTimerRunnable);
        if (PreferenceUtil.readBooleanValue("show_timer_enabled", false)) {
            ConfMgr.getInstance().setShowClockInMeeting(true);
            this.mTxtTimer.setVisibility(0);
            this.mHandler.post(this.mTimerRunnable);
        } else {
            ConfMgr.getInstance().setShowClockInMeeting(false);
            this.mTxtTimer.setVisibility(8);
        }
    }

    private void updateClosedCaption(String content, boolean announce) {
        if (this.mClosedCaptionView == null) {
            return;
        }
        if (!this.isNeedShowClosedCaption() || StringUtil.isEmptyOrNull((String)content)) {
            this.mClosedCaptionView.setVisibility(8);
            this.mClosedCaptionContent = null;
            this.mHandler.removeCallbacks(this.mClosedCaptionTimeoutRunnable);
            return;
        }
        this.mClosedCaptionView.setText(content);
        this.mClosedCaptionView.setVisibility(0);
        if (announce) {
            this.mClosedCaptionView.setContentDescription((CharSequence)content);
            this.mClosedCaptionView.sendAccessibilityEvent(16384);
        }
    }

    private void showUserJoinWaitingListDialog() {
        if (this.mJoinWaitingListDlg != null && this.mJoinWaitingListDlg.isShowing()) {
            this.mJoinWaitingListDlg.dismiss();
        }
        String message = "";
        List<CmmUser> userList = ConfMgr.getInstance().getClientOnHoldUserList();
        int count = userList.size();
        if (count == 1) {
            message = this.getString(R.string.zm_msg_xxx_join_meeting_in_waiting_list, new Object[]{userList.get(0).getScreenName()});
        } else if (count > 1) {
            message = this.getResources().getQuantityString(R.plurals.zm_msg_join_meeting_in_waiting_list, count, new Object[]{count});
        } else {
            return;
        }
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this).setTitle(message).setNegativeButton(R.string.zm_btn_see_waiting_list, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConfActivityNormal.this.showPList();
            }
        });
        if (count == 1) {
            final long userId = userList.get(0).getNodeId();
            builder.setPositiveButton(R.string.zm_btn_admit, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfMgr mgr = ConfMgr.getInstance();
                    if (mgr == null) {
                        return;
                    }
                    mgr.handleUserCmd(42, userId);
                }
            });
        }
        this.mJoinWaitingListDlg = builder.create();
        this.mJoinWaitingListDlg.show();
    }

    private void updateJoinWaitingList() {
        if (this.mJoinWaitingListDlg == null || !this.mJoinWaitingListDlg.isShowing()) {
            return;
        }
        this.showUserJoinWaitingListDialog();
    }

    private void updateLayoutMode(AbsVideoScene fromScene, AbsVideoScene toScene) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (toScene == null || confStatus == null) {
            return;
        }
        boolean isLiveOn = confStatus.isLiveOn();
        if (!isLiveOn) {
            return;
        }
        if (toScene instanceof GalleryVideoScene) {
            confStatus.setLiveLayoutMode(false);
        } else {
            confStatus.setLiveLayoutMode(true);
        }
    }

    public static class BOStartRequestDialog
    extends ZMDialogFragment {
        private static final String ARG_BOOBJECT_BID = "boobject_bid";

        public static void showDialog(FragmentManager fragmentMgr, String bid) {
            if (StringUtil.isEmptyOrNull((String)bid)) {
                return;
            }
            BOStartRequestDialog dlg = new BOStartRequestDialog();
            Bundle args = new Bundle();
            args.putString(ARG_BOOBJECT_BID, bid);
            dlg.setArguments(args);
            dlg.show(fragmentMgr, BOStartRequestDialog.class.getName());
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            final String bid = args.getString(ARG_BOOBJECT_BID);
            String meetingName = ((ConfActivityNormal)this.getActivity()).getBOMeetingNameByBid(bid);
            String message = this.getString(R.string.zm_bo_msg_start_request, new Object[]{meetingName});
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setMessage(message).setNegativeButton(R.string.zm_btn_later, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivityNormal confActivity = (ConfActivityNormal)BOStartRequestDialog.this.getActivity();
                    if (confActivity == null) {
                        return;
                    }
                    confActivity.pendingBOStartRequest();
                }
            }).setPositiveButton(R.string.zm_bo_btn_join_bo, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivityNormal confActivity = (ConfActivityNormal)BOStartRequestDialog.this.getActivity();
                    if (confActivity == null) {
                        return;
                    }
                    confActivity.joinBO(bid);
                }
            });
            return builder.create();
        }

        public void dismiss() {
            super.dismiss();
        }
    }

    private class DownloadFileListener
    implements IDownloadFileListener {
        private Uri mInput;

        public DownloadFileListener(Uri input, long totalBytes, String output) {
            this.mInput = input;
        }

        public void onDownloadCompleted(ZMAsyncURLDownloadFile task, Uri input, String output) {
            if (input == null || input != this.mInput) {
                return;
            }
            ConfActivityNormal.this.dismissDownloadFileWaitingDialog();
            if (StringUtil.isEmptyOrNull((String)output)) {
                return;
            }
            ConfActivityNormal.this.shareByPathExtension(output);
        }

        public void onDownloadFailed(ZMAsyncURLDownloadFile task, Uri input) {
            if (input == null || input != this.mInput) {
                return;
            }
            ConfActivityNormal.this.dismissDownloadFileWaitingDialog();
            String path = input.getPath();
            if (StringUtil.isEmptyOrNull((String)path)) {
                ShareAlertDialog.showDialog(ConfActivityNormal.this.getSupportFragmentManager(), ConfActivityNormal.this.getString(R.string.zm_msg_load_file_fail_without_name), false);
            } else {
                String name = AndroidAppUtil.getPathLastName((String)path);
                ShareAlertDialog.showDialog(ConfActivityNormal.this.getSupportFragmentManager(), ConfActivityNormal.this.getString(R.string.zm_msg_load_file_fail, new Object[]{name}), false);
            }
        }

        public void onDownloadProgress(ZMAsyncURLDownloadFile task, long totalBytes, long bytesRead) {
            ConfActivityNormal.this.updateProgressWaitingDialog(totalBytes, bytesRead);
        }

        public void onDownloadCanceled(ZMAsyncURLDownloadFile task, Uri input) {
            if (input == null || input != this.mInput) {
                return;
            }
            ConfActivityNormal.this.dismissDownloadFileWaitingDialog();
        }
    }

    public static class SelectURLDialog
    extends ZMDialogFragment {
        public static void show(FragmentManager fragmentMgr) {
            Bundle args = new Bundle();
            SelectURLDialog dlg = new SelectURLDialog();
            dlg.setArguments(args);
            dlg.show(fragmentMgr, SelectURLDialog.class.getName());
        }

        public SelectURLDialog() {
            this.setCancelable(true);
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            View editUrlView = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_inputurl, null, false);
            final EditText editTxt = (EditText)editUrlView.findViewById(R.id.inputurl);
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_btn_share_url).setView(editUrlView).setPositiveButton(R.string.zm_btn_share, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    String url = editTxt.getText().toString();
                    ConfActivityNormal confActivity = (ConfActivityNormal)SelectURLDialog.this.getActivity();
                    if ("".equals(url.trim())) {
                        if (confActivity != null) {
                            confActivity.alertUrlInvalid();
                        }
                        return;
                    }
                    if (!url.startsWith("http://") && !url.startsWith("https://")) {
                        url = "http://" + url;
                    }
                    if (confActivity != null) {
                        confActivity.startShareWebview(url);
                    }
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivityNormal confActivity = (ConfActivityNormal)SelectURLDialog.this.getActivity();
                    if (confActivity != null) {
                        confActivity.onClickStopShare();
                    }
                }
            });
            ZMAlertDialog dialog = builder.create();
            dialog.setCanceledOnTouchOutside(false);
            return builder.create();
        }

        public void onCancel(DialogInterface dialog) {
            super.onCancel(dialog);
            ConfActivityNormal confActivity = (ConfActivityNormal)this.getActivity();
            if (confActivity != null) {
                confActivity.onClickStopShare();
            }
        }
    }
}

