/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.nydus.VideoCapturer;
import com.zipow.videobox.CallingActivity;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.JoinByURLActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.AttentionTrackEventSinkUI;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmAttentionTrackMgr;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.TipMessageType;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.ZoomRaiseHandInWebinar;
import com.zipow.videobox.confapp.bo.BOLeaveFragment;
import com.zipow.videobox.confapp.bo.BOMessageTip;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.confapp.bo.BOObject;
import com.zipow.videobox.confapp.bo.BOUser;
import com.zipow.videobox.confapp.meeting.ConfParams;
import com.zipow.videobox.confapp.meeting.confhelper.CameraComponent;
import com.zipow.videobox.confapp.meeting.confhelper.FeccComponent;
import com.zipow.videobox.confapp.meeting.confhelper.ShareComponent;
import com.zipow.videobox.dialog.CmrFullStorageDialog;
import com.zipow.videobox.dialog.DialogActionCallBack;
import com.zipow.videobox.dialog.JoinFailedDialog;
import com.zipow.videobox.dialog.LeaveAlertDialog;
import com.zipow.videobox.dialog.ZMGDPRConfirmDialog;
import com.zipow.videobox.fragment.InviteViaDialogFragment;
import com.zipow.videobox.fragment.MeetingRunningInfoFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.fragment.WebinarRegisterDialog;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.UrlActionData;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.share.ScreenShareMgr;
import com.zipow.videobox.sip.CallHistoryMgr;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.DialogUtils;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.AudioTip;
import com.zipow.videobox.view.ChatTip;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.JoinLeaveTip;
import com.zipow.videobox.view.MessageTip;
import com.zipow.videobox.view.MoreTip;
import com.zipow.videobox.view.NormalMessageTip;
import com.zipow.videobox.view.RaiseHandTip;
import com.zipow.videobox.view.ShareTip;
import com.zipow.videobox.view.VideoTip;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.RCMouseView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import org.webrtc.voiceengine.VoiceEnginContext;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.ParamsList;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ConfActivity
extends ZMActivity
implements DialogActionCallBack {
    private static final String TAG = ConfActivity.class.getSimpleName();
    public static final String ACTION_JOIN_BY_ID = ConfActivity.class.getName() + ".action.JOIN_BY_ID";
    public static final String ACTION_JOIN_BY_URL = ConfActivity.class.getName() + ".action.JOIN_BY_URL";
    public static final String ACTION_START_CONFERENCE = ConfActivity.class.getName() + ".action.START_CONFERENCE";
    public static final String ACTION_ACCEPT_CALL = ConfActivity.class.getName() + "action.ACCEPT_CALL";
    public static final String ACTION_RETURN_TO_CONF = ConfActivity.class.getName() + ".action.RETURN_TO_CONF";
    public static final String ACTION_SWITCH_CALL = ConfActivity.class.getName() + ".action.SWITCH_CALL";
    public static final String ACTION_NEW_INCOMING_CALL = ConfActivity.class.getName() + ".action.ACTION_NEW_INCOMING_CALL";
    public static final String ACTION_PT_ASK_TO_LEAVE = ConfActivity.class.getName() + ".action.ACTION_PT_ASK_TO_LEAVE";
    public static final String ACTION_START_SHARE_CON = ConfActivity.class.getName() + ".action.ACTION_START_SHARE_CON";
    public static final String ACTION_MEETING_JBH = ".intent.action.JoinBeforeHost";
    public static final String ACTION_CALL_MY_PHONE = ".intent.action.CallMyPhone";
    public static final String ARG_CONF_NUMBER = "confno";
    public static final String ARG_SCREEN_NAME = "screenName";
    public static final String ARG_URL_ACTION = "urlAction";
    public static final String ARG_INVITATION = "invitation";
    public static final String ARG_IS_START = "isStart";
    public static final String ARG_LEAVE_REASON = "leaveReason";
    public static final int REQUEST_INVITE = 1000;
    public static final int REQUEST_PLIST = 1001;
    public static final int REQUEST_CHAT = 1002;
    public static final int REQUEST_CONF_INFO = 1003;
    public static final int REQUEST_BOOKMARK = 1006;
    public static final int REQUEST_INVITE_BY_PHONE = 1007;
    public static final int REQUEST_CALL_ME = 1008;
    public static final int REQUEST_POLLING = 1011;
    public static final int REQUEST_POLLING_RESULT = 1012;
    public static final int REQUEST_AV_START = 1015;
    public static final int REQUEST_AV_TOGGLE_MUTE = 1016;
    protected static final int REQUEST_ENABLE_BT = 1017;
    protected static final int REQUEST_LOCATION_PERMISSION_FOR_KUBI = 1018;
    protected static final int REQUEST_WAITING_JOIN = 1019;
    protected static final int REQUEST_SYSTEM_ALERT_WINDOW = 1020;
    public static final int REQUEST_HOST_ASK_UNMUTE = 1021;
    private static final String PREF_VIDEO_STARTTED = "video_startted";
    protected static final int BO_WAITING_SECONDS = 60;
    protected static final int REQUEST_PERMISSION_DELAY_TIME = 500;
    private static final int DIALOG_REQUEST_GDPR_JOIN_MEETING = 0;
    private static final int DIALOG_REQUEST_GDPR_CANNOT_JOIN_MEETING = 1;
    private static Handler g_handler = new Handler();
    private static int g_lastVolume = -1;
    private static int g_lastNotifiedVolume = -1;
    private static BroadcastReceiver g_networkStateReceiver;
    private static BroadcastReceiver g_volumeChangeReceiver;
    private static Runnable g_runnableNotifyVolumeChanged;
    private static final long TIMEOUT_NOTIFY_WIFI_SIGNAL = 10000L;
    private static Runnable g_taskNotifyWifiSignal;
    private Runnable mAttentionTrackTask = null;
    protected final ConfParams mConfParams = new ConfParams();
    private RetainedFragment mRetainedFragment;
    private long mMyAudioType = 2L;
    private boolean mbSendingVideo = false;
    private boolean mIsVideoStarted = false;
    private boolean mVideoOnBeforeShare = false;
    private boolean mbNeedSaveUrlParams = false;
    protected AbsVideoSceneMgr mVideoSceneMgr;
    private ArrayList<String> mPendingRequestPermissions = new ArrayList();
    private ArrayList<Integer> mPendingRequestPermissionCodes = new ArrayList();
    private boolean mInPendingRequestPermission = false;
    private Handler mHandler = new Handler();
    private long mRequestPermissionTime = 0L;
    private OrientationEventListener mOrientationListener;
    private ConfUI.IConfUIListener mConfUIListener = new ConfUI.SimpleConfUIListener(){

        @Override
        public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
            return ConfActivity.this._onUserStatusChanged(cmd, userId);
        }

        @Override
        public boolean onConfStatusChanged2(int cmd, long ret) {
            return ConfActivity.this._onConfStatusChanged2(cmd, ret);
        }

        @Override
        public boolean onConfStatusChanged(int status) {
            return ConfActivity.this._onConfStatusChanged(status);
        }

        @Override
        public void onPTAskToLeave(int reason) {
            ConfActivity.this._onPTAskToLeave(reason);
        }

        @Override
        public void onJoinConfConfirmMeetingInfo(boolean success, boolean hasPassword, boolean hasScreenName) {
            ConfActivity.this._onJoinConfConfirmMeetingInfo(success, hasPassword, hasScreenName);
        }

        @Override
        public void onJoinConfConfirmPasswordValidateResult(boolean success, boolean needWait) {
            ConfActivity.this._onJoinConfConfirmPasswordValidateResult(success, needWait);
        }

        @Override
        public void onJoinConfConfirmMeetingStatus(boolean canJoinNow, boolean hasScreenName) {
            ConfActivity.this._onJoinConfConfirmMeetingStatus(canJoinNow, hasScreenName);
        }

        @Override
        public void onCallTimeOut() {
            ConfActivity.this._onCallTimeOut();
        }

        @Override
        public void onDeviceStatusChanged(int cmd, int ret) {
            ConfActivity.this._onDeviceStatusChanged(cmd, ret);
        }

        @Override
        public void onWebinarNeedRegister(boolean bNeedApproval) {
            ConfActivity.this._onWebinarNeedRegister(bNeedApproval);
        }

        @Override
        public void onUpgradeThisFreeMeeting(int ret) {
            ConfActivity.this._onUpgradeThisFreeMeeting(ret);
        }

        @Override
        public void onCheckCMRPrivilege(int ret, boolean canStartNow) {
            ConfActivity.this._onCheckCMRPrivilege(ret, canStartNow);
        }
    };
    private AttentionTrackEventSinkUI.IAttentionTrackEventSinkUIListener mIAttentionTrackEventSinkUIListener = new AttentionTrackEventSinkUI.SimpleAttentionTrackEventSinkUIListener(){

        @Override
        public void OnConfAttentionTrackStatusChanged(boolean bEnabled) {
            ConfActivity.this._onConfAttentionTrackStatusChanged(bEnabled);
        }
    };
    private ZMActivity.GlobalActivityListener mGlobalActivityListener = new ZMActivity.GlobalActivityListener(){

        public void onUserActivityOnUI() {
        }

        public void onUIMoveToBackground() {
            ConfActivity.this._onUIMoveToBackground();
        }

        public void onActivityMoveToFront(ZMActivity activity) {
            ConfActivity.this.onActivityMoveToFront(activity);
        }
    };
    private static int g_notifyUpdateWaitCountDown;
    private static AudioManager g_audioManager;
    private Runnable mHandleRequestPermissionsRunnable = new Runnable(){

        @Override
        public void run() {
            if (ConfActivity.this.mPendingRequestPermissions.isEmpty()) {
                return;
            }
            int length = ConfActivity.this.mPendingRequestPermissions.size();
            if (length <= 0) {
                return;
            }
            boolean hasPrompt = PreferenceUtil.readBooleanValue("permission_promt_for_meeting", false);
            if (!hasPrompt && Build.VERSION.SDK_INT >= 23) {
                PermissionPromptDialog.showDialog(ConfActivity.this.getSupportFragmentManager());
                PreferenceUtil.saveBooleanValue("permission_promt_for_meeting", true);
            } else {
                ConfActivity.this.doRequestPermission();
            }
        }
    };

    private static Class<?> getConfActivityImplClass(Context context) {
        String className = context.getString(R.string.zm_config_conf_activity);
        Class<Object> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null || !ConfActivityNormal.class.isAssignableFrom(clazz)) {
            clazz = ConfActivityNormal.class;
        }
        return clazz;
    }

    private static void runOnConfProcessReady(final Runnable runnable, final long timeout) {
        if (VideoBoxApplication.getInstance().isConfProcessReady()) {
            runnable.run();
        } else if (timeout > 0L) {
            g_handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConfActivity.runOnConfProcessReady(runnable, timeout - 20L);
                }
            }, 20L);
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        }
    }

    public static void joinById(final Context context, final long confNumber, final String screenName, String vanityUrl, String pwd, boolean noAudio, boolean noVideo) {
        if (context == null || confNumber <= 0L && StringUtil.isEmptyOrNull((String)vanityUrl) || StringUtil.isEmptyOrNull((String)screenName)) {
            return;
        }
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        app.clearConfAppContext();
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        PTApp.getInstance().joinFromIconTray(screenName, vanityUrl, confNumber, pwd, noAudio, noVideo);
        ConfActivity.runOnConfProcessReady(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
                if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive()) {
                    intent.setFlags(0x10000000);
                }
                intent.setAction(ACTION_JOIN_BY_ID);
                intent.putExtra(ConfActivity.ARG_CONF_NUMBER, confNumber);
                intent.putExtra(ConfActivity.ARG_SCREEN_NAME, screenName);
                context.startActivity(intent);
            }
        }, 2000L);
    }

    public static boolean joinByUrl(Context context, String urlAction) {
        String confIdFromUrl;
        UrlActionData actionData;
        PTUserProfile profile;
        PTApp ptApp = PTApp.getInstance();
        String screenName = null;
        if (PTApp.getInstance().isWebSignedOn() && (profile = PTApp.getInstance().getCurrentUserProfile()) != null) {
            screenName = profile.getUserName();
        }
        String numberFromUrl = (actionData = ptApp.parseURLActionData(urlAction)) != null ? actionData.getConfno() : null;
        String string2 = confIdFromUrl = actionData != null ? actionData.getConfid() : null;
        if (ptApp.hasActiveCall()) {
            String number = String.valueOf(ptApp.getActiveMeetingNo());
            String confId = ptApp.getActiveCallId();
            if (confId == null) {
                confId = "";
            }
            if (number.equals(numberFromUrl) || confId.equals(confIdFromUrl)) {
                ConfActivity.returnToConf(context);
                return true;
            }
            Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
            intent.addFlags(131072);
            intent.setAction(ACTION_SWITCH_CALL);
            intent.putExtra(ARG_URL_ACTION, urlAction);
            intent.putExtra(ARG_SCREEN_NAME, screenName);
            context.startActivity(intent);
        } else if (StringUtil.isEmptyOrNull((String)numberFromUrl)) {
            Mainboard.getMainboard().notifyUrlAction(urlAction);
            if (UIMgr.isLargeMode(context)) {
                return false;
            }
        } else {
            return ConfActivity.joinByUrl(context, urlAction, screenName);
        }
        return true;
    }

    public static boolean joinByUrl(final Context context, final String urlAction, final String screenName) {
        if (context == null || StringUtil.isEmptyOrNull((String)urlAction)) {
            return true;
        }
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        app.clearConfAppContext();
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        Mainboard.getMainboard().notifyUrlAction(urlAction);
        ConfActivity.runOnConfProcessReady(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
                if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive()) {
                    intent.setFlags(0x10000000);
                }
                intent.setAction(ACTION_JOIN_BY_URL);
                intent.putExtra(ConfActivity.ARG_URL_ACTION, urlAction);
                intent.putExtra(ConfActivity.ARG_SCREEN_NAME, screenName);
                context.startActivity(intent);
            }
        }, 2000L);
        return true;
    }

    public static boolean webStart(final Context context, final String urlAction) {
        String confIdFromUrl;
        UrlActionData actionData;
        PTUserProfile profile;
        PTApp ptApp = PTApp.getInstance();
        String screenName = null;
        if (PTApp.getInstance().isWebSignedOn() && (profile = PTApp.getInstance().getCurrentUserProfile()) != null) {
            screenName = profile.getUserName();
        }
        String numberFromUrl = (actionData = ptApp.parseURLActionData(urlAction)) != null ? actionData.getConfno() : null;
        String string2 = confIdFromUrl = actionData != null ? actionData.getConfid() : null;
        if (ptApp.hasActiveCall()) {
            String number = String.valueOf(ptApp.getActiveMeetingNo());
            String confId = ptApp.getActiveCallId();
            if (confId == null) {
                confId = "";
            }
            if (number.equals(numberFromUrl) || confId.equals(confIdFromUrl)) {
                ConfActivity.returnToConf(context);
                return true;
            }
            Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
            intent.addFlags(131072);
            intent.setAction(ACTION_SWITCH_CALL);
            intent.putExtra(ARG_URL_ACTION, urlAction);
            intent.putExtra(ARG_SCREEN_NAME, screenName);
            intent.putExtra(ARG_IS_START, true);
            context.startActivity(intent);
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(true);
            Mainboard.getMainboard().notifyUrlAction(urlAction);
            final String _screenName = screenName;
            ConfActivity.runOnConfProcessReady(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
                    if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive()) {
                        intent.setFlags(0x10000000);
                    }
                    intent.setAction(ACTION_JOIN_BY_URL);
                    intent.putExtra(ConfActivity.ARG_URL_ACTION, urlAction);
                    intent.putExtra(ConfActivity.ARG_SCREEN_NAME, _screenName);
                    context.startActivity(intent);
                }
            }, 2000L);
        }
        return true;
    }

    public static int startConference(Context context) {
        return ConfActivity.startConference(context, 3);
    }

    public static int startConference(Context context, int confType) {
        return ConfActivity.startGroupCall(context, null, confType);
    }

    public static int startGroupCall(final Context context, String[] jids, int confType) {
        if (context == null) {
            return 1;
        }
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        int ret = PTApp.getInstance().startGroupVideoCall(jids, null, context.getString(R.string.zm_msg_invitation_message_template), 0L, confType);
        if (ret == 0) {
            ConfActivity.runOnConfProcessReady(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
                    if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive()) {
                        intent.setFlags(0x10000000);
                    }
                    intent.setAction(ACTION_START_CONFERENCE);
                    context.startActivity(intent);
                }
            }, 2000L);
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        }
        return ret;
    }

    public static int inviteToVideoCall(final Context context, String buddyJid, int confType) {
        if (context == null) {
            return 1;
        }
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        int ret = PTApp.getInstance().inviteToVideoCall(buddyJid, context.getString(R.string.zm_msg_invitation_message_template), confType);
        if (ret == 0) {
            ConfActivity.runOnConfProcessReady(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
                    if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive()) {
                        intent.setFlags(0x10000000);
                    }
                    intent.setAction(ACTION_START_CONFERENCE);
                    context.startActivity(intent);
                }
            }, 2000L);
            CallHistoryMgr mgr = PTApp.getInstance().getCallHistoryMgr();
            if (mgr != null) {
                mgr.insertZoomMeetingHistory("zoomMeeting" + System.currentTimeMillis(), 2, buddyJid, confType == 0, true);
            }
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        }
        return ret;
    }

    public static int startMeetingCallFromZoomMessenger(final Context context, String groupId, String buddyJid, long meetingNum, int confType) {
        if (context == null) {
            return 1;
        }
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return 1;
        }
        int ret = messenger.startMeeting(groupId, buddyJid, meetingNum, confType);
        if (ret == 0) {
            ConfActivity.runOnConfProcessReady(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
                    if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive()) {
                        intent.setFlags(0x10000000);
                    }
                    intent.setAction(ACTION_START_CONFERENCE);
                    context.startActivity(intent);
                }
            }, 2000L);
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        }
        return ret;
    }

    public static int callABContact(final Context context, int abCallType, IMAddrBookItem contact) {
        if (context == null || contact == null) {
            return 1;
        }
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper == null) {
            return 1;
        }
        ArrayList<String> numbers = new ArrayList<String>();
        int count = contact.getPhoneNumberCount();
        for (int i = 0; i < count; ++i) {
            numbers.add(contact.getNormalizedPhoneNumber(i));
        }
        int ret = contactsHelper.callABContact(abCallType, numbers, contact.getScreenName(), context.getString(R.string.zm_msg_invitation_message_template));
        if (ret == 0) {
            ConfActivity.runOnConfProcessReady(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
                    if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive()) {
                        intent.setFlags(0x10000000);
                    }
                    intent.setAction(ACTION_START_CONFERENCE);
                    context.startActivity(intent);
                }
            }, 2000L);
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        }
        return ret;
    }

    public static void returnToConf(Context context) {
        Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
        intent.addFlags(131072);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        intent.setAction(ACTION_RETURN_TO_CONF);
        context.startActivity(intent);
    }

    public static void startConfUI(Context context) {
        Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
        if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive()) {
            intent.setFlags(0x10000000);
        }
        intent.addFlags(131072);
        context.startActivity(intent);
    }

    public static void acceptCall(final Context context, PTAppProtos.InvitationItem invitation, boolean isAutoAccept) {
        if (context == null || invitation == null) {
            return;
        }
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        int ret = PTApp.getInstance().acceptVideoCall(invitation, context.getResources().getString(R.string.zm_msg_accept_call), isAutoAccept);
        if (ret == 0) {
            ConfActivity.runOnConfProcessReady(new Runnable(){

                @Override
                public void run() {
                    Context launcherContext = context;
                    Intent intent = null;
                    boolean needNewTaskFlag = false;
                    if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive() || context instanceof CallingActivity) {
                        ZMActivity frontActivity = ZMActivity.getFrontActivity();
                        if (frontActivity != null && !(frontActivity instanceof CallingActivity) && frontActivity.isActive()) {
                            launcherContext = frontActivity;
                        } else {
                            needNewTaskFlag = true;
                        }
                    }
                    intent = new Intent(launcherContext, ConfActivity.getConfActivityImplClass(context));
                    if (needNewTaskFlag) {
                        intent.setFlags(0x10000000);
                    }
                    intent.setAction(ACTION_ACCEPT_CALL);
                    launcherContext.startActivity(intent);
                }
            }, 2000L);
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        }
    }

    public static void handleOnPTAskToLeaveForUpdate() {
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService != null) {
            try {
                ptService.showNeedUpdate();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            ConfMgr.getInstance().leaveConference();
        } else if (g_notifyUpdateWaitCountDown-- > 0) {
            g_handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConfActivity.handleOnPTAskToLeaveForUpdate();
                }
            }, 100L);
        }
    }

    public static int launchCallForWebStart(final Context context) {
        if (context == null) {
            return 1;
        }
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        int errorCode = PTApp.getInstance().launchCallForWebStart();
        if (errorCode == 0) {
            ConfActivity.runOnConfProcessReady(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent(context, ConfActivity.getConfActivityImplClass(context));
                    if (!(context instanceof ZMActivity) || !((ZMActivity)context).isActive()) {
                        intent.setFlags(0x10000000);
                    }
                    intent.setAction(ACTION_START_CONFERENCE);
                    context.startActivity(intent);
                }
            }, 2000L);
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        }
        return errorCode;
    }

    public static void onNewIncomingCall(ZMActivity activity, PTAppProtos.InvitationItem invitation) {
        Intent intent = new Intent((Context)activity, ConfActivity.getConfActivityImplClass((Context)activity));
        intent.addFlags(131072);
        intent.setAction(ACTION_NEW_INCOMING_CALL);
        intent.putExtra(ARG_INVITATION, (Serializable)((Object)invitation));
        activity.startActivity(intent);
    }

    public static boolean startMeeting(final ZMActivity activity, long meetingNo, String meetingId) {
        if (activity == null) {
            return false;
        }
        if (PTApp.getInstance().hasActiveCall()) {
            long activeMeetingNo = PTApp.getInstance().getActiveMeetingNo();
            String activeCallId = PTApp.getInstance().getActiveCallId();
            if (activeMeetingNo == meetingNo || activeCallId != null && activeCallId.equals(meetingId)) {
                ConfActivity.returnToConf((Context)activity);
                return true;
            }
            SwitchStartMeetingDialog dialog = SwitchStartMeetingDialog.newSwitchStartMeetingDialog(meetingNo, meetingId);
            dialog.show(activity.getSupportFragmentManager(), SwitchStartMeetingDialog.class.getName());
            return true;
        }
        VideoBoxApplication.getInstance().setConfUIPreloaded(true);
        boolean ret = PTApp.getInstance().startMeeting(meetingNo);
        if (ret) {
            ConfActivity.runOnConfProcessReady(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent((Context)activity, ConfActivity.getConfActivityImplClass((Context)activity));
                    if (!activity.isActive()) {
                        intent.setFlags(0x10000000);
                    }
                    intent.setAction(ACTION_START_CONFERENCE);
                    activity.startActivity(intent);
                }
            }, 2000L);
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
        }
        return ret;
    }

    public boolean isImmersedModeEnabled() {
        return UIUtil.isImmersedModeSupported();
    }

    protected void onCreate(Bundle savedInstanceState) {
        CmmConfContext confContext;
        ConfMgr confMgr;
        super.onCreate(savedInstanceState);
        this.disableFinishActivityByGesture(true);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish(true);
            VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
            if (videoBoxApplication != null) {
                videoBoxApplication.stopConfService();
            } else {
                Process.killProcess((int)Process.myPid());
            }
            return;
        }
        this.initRetainedFragment();
        if (savedInstanceState != null) {
            this.mVideoOnBeforeShare = savedInstanceState.getBoolean(PREF_VIDEO_STARTTED, false);
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        AttentionTrackEventSinkUI.getInstance().addListener(this.mIAttentionTrackEventSinkUIListener);
        ZMActivity.addGlobalActivityListener((ZMActivity.GlobalActivityListener)this.mGlobalActivityListener);
        this.initStatus();
        this.initOrientationListener();
        ConfActivity.startNotifyWifiSignal();
        ConfActivity.startListenNetworkState((Context)this);
        ConfActivity.startListenVolumeChange((Context)this);
        if (savedInstanceState == null) {
            this.doIntent(this.getIntent());
        }
        if ((confMgr = ConfMgr.getInstance()).isConfConnected() && (confContext = ConfMgr.getInstance().getConfContext()) != null) {
            ParamsList params = confContext.getAppContextParams();
            this.mConfParams.parseFromParamsList(params);
            if (this.mConfParams.isMbNoDrivingMode()) {
                UIMgr.setDriverModeEnabled(false);
            }
            ConfUI.getInstance().setIsMeetingEndMessageDisabled(this.mConfParams.isMbNoMeetingEndMsg());
        }
    }

    public void onDestroy() {
        super.onDestroy();
        VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
        if (videoBoxApplication == null) {
            return;
        }
        ConfUI.getInstance().removeListener(this.mConfUIListener);
        AttentionTrackEventSinkUI.getInstance().removeListener(this.mIAttentionTrackEventSinkUIListener);
        ZMActivity.removeGlobalActivityListener((ZMActivity.GlobalActivityListener)this.mGlobalActivityListener);
        this.destroyOrientationListener();
        if (ConfUI.getInstance().isLeavingConference()) {
            ConfActivity.stopNotifyWifiSignal();
            ConfActivity.stopListenNetworkState((Context)this);
            ConfActivity.stopListenVolumeChange((Context)this);
        }
    }

    public AbsVideoSceneMgr getmVideoSceneMgr() {
        return this.mVideoSceneMgr;
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            this.getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        }
    }

    public RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = this.getSupportFragmentManager();
        RetainedFragment retainedFragment = (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
        return retainedFragment;
    }

    public FeccComponent getmFeccComponent() {
        return null;
    }

    public CameraComponent getmCameraComponent() {
        return null;
    }

    public ShareComponent getmShareComponent() {
        return null;
    }

    public boolean getIsVideoStarted() {
        return this.mIsVideoStarted;
    }

    public boolean isCallingOut() {
        return ConfMgr.getInstance().isCallingOut();
    }

    public ConfParams getConfParams() {
        return this.mConfParams;
    }

    public boolean isUserJoinOrLeaveTipDisabled() {
        return PreferenceUtil.readBooleanValue("no_user_join_or_leave_tip", false);
    }

    public boolean isArrowAcceleratorDisabled() {
        return ResourcesUtil.getBoolean((Context)this, (int)R.bool.zm_config_no_arrow_accelerator, (boolean)false);
    }

    private void doIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if (ACTION_JOIN_BY_ID.equals(action)) {
            long confno = intent.getLongExtra(ARG_CONF_NUMBER, 0L);
            String screenName = intent.getStringExtra(ARG_SCREEN_NAME);
            this.joinById(confno, screenName);
        } else if (ACTION_JOIN_BY_URL.equals(action)) {
            String urlAction = intent.getStringExtra(ARG_URL_ACTION);
            String screenName = intent.getStringExtra(ARG_SCREEN_NAME);
            this.joinByUrl(urlAction, screenName);
        } else if (ACTION_SWITCH_CALL.equals(action)) {
            String urlAction = intent.getStringExtra(ARG_URL_ACTION);
            String screenName = intent.getStringExtra(ARG_SCREEN_NAME);
            boolean isStart = intent.getBooleanExtra(ARG_IS_START, false);
            this.alertSwitchCall(urlAction, screenName, isStart);
        } else if (ACTION_NEW_INCOMING_CALL.equals(action)) {
            PTAppProtos.InvitationItem invitation = (PTAppProtos.InvitationItem)((Object)intent.getSerializableExtra(ARG_INVITATION));
            if (invitation != null) {
                this.alertNewIncomingCall(invitation);
            }
        } else if (ACTION_PT_ASK_TO_LEAVE.equals(action)) {
            int reason = intent.getIntExtra(ARG_LEAVE_REASON, 0);
            this.handleOnPTAskToLeave(reason);
        }
    }

    private void joinById(long confno, String screenName) {
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        Bundle args = new Bundle();
        args.putInt("commandType", 1);
        args.putLong(ARG_CONF_NUMBER, confno);
        args.putString(ARG_SCREEN_NAME, screenName);
        app.startConfService(args);
    }

    private void joinByUrl(String urlAction, String screenName) {
        Uri uri = Uri.parse((String)urlAction);
        if (uri != null) {
            this.mConfParams.parseFromUri(uri);
            if (this.mConfParams.isMbNoDrivingMode()) {
                UIMgr.setDriverModeEnabled(false);
            }
            ConfUI.getInstance().setIsMeetingEndMessageDisabled(this.mConfParams.isMbNoMeetingEndMsg());
            ConfMgr confMgr = ConfMgr.getInstance();
            if (confMgr.isConfConnected()) {
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext != null) {
                    ParamsList params = confContext.getAppContextParams();
                    this.mConfParams.saveParamList(params);
                    confContext.setAppContextParams(params);
                    this.mbNeedSaveUrlParams = false;
                }
            } else {
                this.mbNeedSaveUrlParams = true;
            }
        }
    }

    private void alertSwitchCall(final String urlAction, final String screenName, final boolean isStart) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("alertSwitchCall"){

            public void run(IUIElement ui) {
                SwitchCallDialog dialog = new SwitchCallDialog();
                Bundle args = new Bundle();
                args.putString(ConfActivity.ARG_SCREEN_NAME, screenName);
                args.putString(ConfActivity.ARG_URL_ACTION, urlAction);
                args.putBoolean(ConfActivity.ARG_IS_START, isStart);
                dialog.setArguments(args);
                dialog.show(((ConfActivity)ui).getSupportFragmentManager(), SwitchCallDialog.class.getName());
            }
        });
    }

    private void switchCall(String urlAction, String screenName) {
        ConfLocalHelper.leaveCall(this);
        JoinByURLActivity.switchCallTo(this.getApplicationContext(), urlAction, screenName);
    }

    private void alertNewIncomingCall(final PTAppProtos.InvitationItem invitation) {
        long meetingNumber = invitation.getMeetingNumber();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.getConfNumber() == meetingNumber) {
            return;
        }
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("alertNewIncomingCall"){

            public void run(IUIElement ui) {
                ConfActivity confActivity = (ConfActivity)ui;
                if (ui != null) {
                    NewIncomingCallDialog.showDialog(confActivity, invitation);
                }
            }
        });
    }

    private void acceptNewIncomingCall(PTAppProtos.InvitationItem invitation) {
        IntegrationActivity.acceptNewIncomingCall(this.getApplicationContext(), invitation);
        ConfLocalHelper.leaveCall(this);
    }

    private void declineNewIncomingCall(PTAppProtos.InvitationItem invitation) {
        IntegrationActivity.declineNewIncomingCall(this.getApplicationContext(), invitation);
    }

    private void upgradeFreeMeeting() {
        ConfMgr.getInstance().tryUpgradeThisFreeMeeting();
    }

    private boolean _onUserStatusChanged(int cmd, long userId) {
        switch (cmd) {
            case 21: {
                this.sinkAudioTypeChanged(userId);
                break;
            }
            case 4: {
                this.sinkUserVideoStatus(userId);
                break;
            }
            case 51: {
                this.checkAttentionTrackMode();
            }
        }
        return true;
    }

    private boolean _onConfStatusChanged(int status) {
        switch (status) {
            case 12: {
                this.sinkConfReady(status);
            }
        }
        return true;
    }

    private void sinkConfReady(final long status) {
        this.getEventTaskManager().push(new EventAction("onConfReady"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).onConfReady(status);
            }
        });
    }

    private void onConfReady(long status) {
        if (this.isCallingOut()) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.inSilentMode()) {
            return;
        }
        if (confContext != null) {
            ParamsList params = confContext.getAppContextParams();
            if (this.mbNeedSaveUrlParams) {
                this.mbNeedSaveUrlParams = false;
                this.mConfParams.saveParamList(params);
                confContext.setAppContextParams(params);
            } else {
                this.mConfParams.parseFromParamsList(params);
            }
            ConfUI.getInstance().setIsMeetingEndMessageDisabled(this.mConfParams.isMbNoMeetingEndMsg());
        }
    }

    private boolean _onConfStatusChanged2(int cmd, long ret) {
        switch (cmd) {
            case 1: {
                this.sinkConfLeaveComplete(ret);
                break;
            }
            case 2: {
                this.sinkConfFail(ret);
                break;
            }
            case 71: {
                this.sinkConfPlayerReminder(ret);
                break;
            }
            case 66: {
                this.sinkConfNoHost(ret);
                break;
            }
            case 67: {
                this.sinkConfCloseOtherMeeting();
                break;
            }
            case 72: {
                this.sinkConfMeetingUpgraded();
                break;
            }
            case 68: {
                if (ret != 7L) break;
                ConfMgr.getInstance().checkCMRPrivilege();
                break;
            }
            case 121: {
                this.attendeeVideoControlChanged(ret);
                break;
            }
            case 120: {
                this.attendeeVideoLayoutChanged(ret);
            }
        }
        return true;
    }

    protected void attendeeVideoControlChanged(long videoControlMode) {
    }

    protected void attendeeVideoLayoutChanged(long videoLayout) {
    }

    public boolean isInDivveMode() {
        return this.mVideoSceneMgr != null && this.mVideoSceneMgr.isInDriverMode();
    }

    private void sinkConfLeaveComplete(long ret) {
        if (this.onConfLeaveComplete(ret)) {
            ConfMgr.getInstance().cleanupConf();
            VideoBoxApplication.getInstance().stopConfService();
        }
    }

    protected boolean onConfLeaveComplete(long ret) {
        this.finishSubActivities();
        this.finish(true);
        return true;
    }

    private void sinkAudioTypeChanged(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isMyself(userId)) {
            CmmUser myself = ConfMgr.getInstance().getMyself();
            if (myself == null) {
                return;
            }
            CmmAudioStatus audioStatus = myself.getAudioStatusObj();
            if (audioStatus == null) {
                return;
            }
            this.mMyAudioType = audioStatus.getAudiotype();
        }
    }

    private void sinkUserVideoStatus(long userId) {
        CmmVideoStatus videoStatus;
        CmmUser user;
        boolean isMyself = false;
        CmmConfStatus status = ConfMgr.getInstance().getConfStatusObj();
        boolean bl = isMyself = status != null && status.isMyself(userId);
        if (isMyself && (user = ConfMgr.getInstance().getMyself()) != null && (videoStatus = user.getVideoStatusObj()) != null) {
            this.mbSendingVideo = videoStatus.getIsSending();
        }
    }

    private void updateAudioType() {
        if (!ConfMgr.getInstance().isConfConnected()) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return;
        }
        this.mMyAudioType = audioStatus.getAudiotype();
    }

    private void updateVideoStatus() {
        CmmVideoStatus videoStatus;
        if (!ConfMgr.getInstance().isConfConnected()) {
            return;
        }
        CmmUser user = ConfMgr.getInstance().getMyself();
        if (user != null && (videoStatus = user.getVideoStatusObj()) != null) {
            this.mbSendingVideo = videoStatus.getIsSending();
        }
    }

    protected void onResume() {
        super.onResume();
        this.finishSubActivities();
        this.updateAudioType();
        this.updateVideoStatus();
        this.initStatus();
        CameraComponent cameraComponent = this.getmCameraComponent();
        if (cameraComponent != null) {
            cameraComponent.onResume();
        }
        this.checkNetworkRestrictionMode();
    }

    public void initStatus() {
        RetainedFragment f = this.getRetainedFragment();
        this.mIsVideoStarted = f.restoreIsVideoStarted();
    }

    protected void onNewIntent(Intent intent) {
        this.doIntent(intent);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(PREF_VIDEO_STARTTED, this.mVideoOnBeforeShare);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 1000: {
                if (resultCode != -1) break;
                this.onSentInvitationDone(data);
            }
        }
    }

    public void onBackPressed() {
        if (MeetingRunningInfoFragment.dismiss(this.getSupportFragmentManager())) {
            return;
        }
        if (this.isCallingOut()) {
            return;
        }
        if (this.isSharingOut()) {
            this.moveTaskToBack(true);
            return;
        }
        if (ConfMgr.getInstance().isConfConnected()) {
            this.onClickBtnBack();
        } else {
            this.onClickLeave();
        }
    }

    private void initOrientationListener() {
        this.mOrientationListener = new OrientationEventListener((Context)this, 2){

            public void onOrientationChanged(int orientation) {
                ConfActivity.this.onOrientationChanged(orientation);
            }
        };
        if (this.mOrientationListener.canDetectOrientation()) {
            this.mOrientationListener.enable();
        }
    }

    private void destroyOrientationListener() {
        if (this.mOrientationListener != null && this.mOrientationListener.canDetectOrientation()) {
            this.mOrientationListener.disable();
        }
    }

    private void onOrientationChanged(int orientation) {
        this.checkRotation();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.checkRotation();
    }

    private void checkRotation() {
        CameraComponent cameraComponent = this.getmCameraComponent();
        if (cameraComponent != null) {
            cameraComponent.checkRotation();
        }
    }

    public void onSentInvitationDone(Intent data) {
        final int count = data.getIntExtra("invitations_count", 0);
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).showTipInvitationsSent(count);
            }
        });
    }

    public boolean canSwitchAudioSource() {
        boolean headsetOn;
        if (!ConfMgr.getInstance().isConfConnected() || this.isCallingOut()) {
            return false;
        }
        int streamType = VoiceEnginContext.getSelectedPlayerStreamType();
        boolean isStreamVoiceCall = streamType == 0 || streamType < 0 && ConfUI.getInstance().isCallOffHook();
        boolean supportTelephony = VoiceEngineCompat.isFeatureTelephonySupported((Context)this);
        boolean bl = headsetOn = HeadsetUtil.getInstance().isBluetoothHeadsetOn() || HeadsetUtil.getInstance().isWiredHeadsetOn();
        return !(!isStreamVoiceCall || !supportTelephony && !headsetOn || this.mMyAudioType != 0L && !ConfUI.getInstance().isCallOffHook());
    }

    public long getMyAudioType() {
        return this.mMyAudioType;
    }

    public void confirmWebinarRegisterInfo(String name, String email, boolean cancel) {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (!StringUtil.isEmptyOrNull((String)name)) {
            PreferenceUtil.saveStringValue("screen_name", name);
        }
        if (!StringUtil.isEmptyOrNull((String)email)) {
            PreferenceUtil.saveStringValue("email", email);
        }
        confMgr.onUserRegisterWebinar(name, email, cancel);
    }

    public void muteAudio(boolean mute) {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            long oldConfOption = confContext.getConfOption();
            if (mute) {
                audioMgr.setMutebySelfFlag(true);
                if (!audioMgr.stopAudio()) {
                    audioMgr.setMutebySelfFlag(confContext.getOldMuteMyselfFlag(oldConfOption));
                }
            } else {
                boolean canUnmute = ConfMgr.getInstance().canUnmuteMyself();
                if (canUnmute) {
                    audioMgr.setMutebySelfFlag(false);
                    if (!audioMgr.startAudio()) {
                        audioMgr.setMutebySelfFlag(confContext.getOldMuteMyselfFlag(oldConfOption));
                    }
                } else {
                    this.showTipCannotUnmuteForSharingAudioStarted();
                }
            }
        }
    }

    protected void hostAskUnmute() {
        ConfLocalHelper.hostAskUnmute();
    }

    public void finish(boolean isLeavingConference) {
        if (isLeavingConference) {
            ConfUI.getInstance().setIsLeavingConference(true);
        }
        if (this.mConfParams.isMbCloseOnLeaveMeeting()) {
            this.moveTaskToBack(true);
        }
        this.finishSubActivities();
        super.finish();
    }

    public void finishSubActivities() {
        this.finishActivity(1000);
        this.finishActivity(1007);
        this.finishActivity(1004);
        this.finishActivity(1010);
        this.finishActivity(1013);
        this.finishActivity(1014);
        this.finishActivity(1099);
        this.finishActivity(1019);
        int activityCount = ZMActivity.getInProcessActivityCountInStack();
        if (activityCount > 0) {
            for (int i = activityCount - 1; i >= 0; --i) {
                ZMActivity activity = ZMActivity.getInProcessActivityInStackAt((int)i);
                if (activity instanceof ConfActivityNormal || activity == null) continue;
                activity.finish();
            }
        }
    }

    public boolean dismissTempTips() {
        CmmConfContext confContext;
        boolean ret = false;
        if (ChatTip.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        if (MessageTip.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        if (BOMessageTip.dismissAll(this.getSupportFragmentManager())) {
            ret = true;
        }
        if (JoinLeaveTip.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        if (AudioTip.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        if (VideoTip.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        if (InviteViaDialogFragment.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        if (ShareTip.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        if ((confContext = ConfMgr.getInstance().getConfContext()) != null && !confContext.isWebinar() && RaiseHandTip.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        if (MoreTip.dismiss(this.getSupportFragmentManager())) {
            ret = true;
        }
        for (TipMessageType tipMessageType : TipMessageType.values()) {
            if (!NormalMessageTip.dismiss(this.getSupportFragmentManager(), tipMessageType.name())) continue;
            ret = true;
        }
        return ret;
    }

    public boolean hasTipPointToToolbar() {
        if (ChatTip.isShown(this.getSupportFragmentManager())) {
            return true;
        }
        if (BOMessageTip.isShown(this.getSupportFragmentManager())) {
            return true;
        }
        if (JoinLeaveTip.isShown(this.getSupportFragmentManager())) {
            return true;
        }
        if (AudioTip.isShown(this.getSupportFragmentManager())) {
            return true;
        }
        if (VideoTip.isShown(this.getSupportFragmentManager())) {
            return true;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && !confContext.isWebinar() && RaiseHandTip.isShown(this.getSupportFragmentManager())) {
            return true;
        }
        if (NormalMessageTip.hasTip(this.getSupportFragmentManager(), TipMessageType.TIP_WAITING_TO_INVITE.name())) {
            return true;
        }
        if (NormalMessageTip.hasTip(this.getSupportFragmentManager(), TipMessageType.TIP_MIC_ECHO_DETECTED.name())) {
            return true;
        }
        if (NormalMessageTip.hasTip(this.getSupportFragmentManager(), TipMessageType.TIP_BO_JOIN_BREAKOUT_SESSION.name())) {
            return true;
        }
        if (ShareTip.isShown(this.getSupportFragmentManager())) {
            return true;
        }
        return MoreTip.isShown(this.getSupportFragmentManager());
    }

    public void startMyVideo() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        String defCamera = videoMgr.getDefaultCameraToUse();
        videoMgr.setDefaultDevice(defCamera);
        if (!ConfMgr.getInstance().canUnmuteMyVideo()) {
            CameraComponent cameraComponent = this.getmCameraComponent();
            if (cameraComponent != null) {
                cameraComponent.alertCameraDisabledByHost();
            }
        } else {
            this.mIsVideoStarted = videoMgr.startMyVideo(0L);
            if (!this.mIsVideoStarted && !VideoCapturer.getInstance().isCapturing()) {
                this.alertStartCameraFailed();
            }
            RetainedFragment f = this.getRetainedFragment();
            f.saveIsVideoStarted(this.mIsVideoStarted);
        }
        AbsVideoSceneMgr videoSceneMgr = this.getVideoSceneMgr();
        if (videoMgr.isPreviewing()) {
            if (videoSceneMgr != null) {
                videoMgr.stopPreviewDevice(videoSceneMgr.getPreviewRenderInfo());
            } else {
                videoMgr.stopPreviewDevice(0L);
            }
        }
    }

    public boolean isSendingVideo() {
        return this.mbSendingVideo;
    }

    public void setIsVideoOnBeforeShare(boolean bOn) {
        this.mVideoOnBeforeShare = bOn;
    }

    public boolean getIsVideoOnBeforeShare() {
        return this.mVideoOnBeforeShare;
    }

    public void checkStartVideo() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (this.mIsVideoStarted && !videoMgr.isVideoStarted() && !confContext.inSilentMode()) {
            this.mIsVideoStarted = videoMgr.startMyVideo(0L);
            if (!this.mIsVideoStarted) {
                this.alertStartCameraFailed();
            }
            RetainedFragment f = this.getRetainedFragment();
            f.saveIsVideoStarted(this.mIsVideoStarted);
        }
    }

    public void muteVideo(boolean mute) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        this.setIsVideoOnBeforeShare(false);
        if (mute) {
            this.mIsVideoStarted = videoMgr.isVideoStarted() ? !videoMgr.stopMyVideo(0L) : false;
        } else if (!ConfMgr.getInstance().canUnmuteMyVideo()) {
            CameraComponent cameraComponent = this.getmCameraComponent();
            if (cameraComponent != null) {
                cameraComponent.alertCameraDisabledByHost();
            }
        } else {
            PreferenceUtil.removeValue("camera_is_freezed");
            this.mIsVideoStarted = videoMgr.startMyVideo(0L);
            if (!this.mIsVideoStarted && !VideoCapturer.getInstance().isCapturing()) {
                this.alertStartCameraFailed();
            }
        }
        RetainedFragment f = this.getRetainedFragment();
        f.saveIsVideoStarted(this.mIsVideoStarted);
    }

    public boolean isNetworkRestrictionMode() {
        int networkType = NetworkUtil.getDataNetworkType((Context)this);
        switch (networkType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean isToolbarShowing() {
        return false;
    }

    public void onClickBtnAudio() {
    }

    public void onHostAskUnmute() {
    }

    public void onClickBtnBack() {
        boolean isSignedIn = PTAppDelegation.getInstance().isWebSignedOn();
        if (isSignedIn && !VideoBoxApplication.getInstance().isSDKMode()) {
            IMActivity.show((Context)this, true);
        } else {
            this.moveTaskToBack(true);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void onClickLeave() {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.getSystemService("accessibility");
        boolean isTalkbackEnabled = false;
        if (accessibilityManager != null && accessibilityManager.isEnabled() && Build.VERSION.SDK_INT > 13 && accessibilityManager.isTouchExplorationEnabled()) {
            isTalkbackEnabled = true;
        }
        if (this.isInBOMeeting() || this.isInBOController() && this.getBOControlStatus() == 2) {
            this.showLeaveBODialog();
        } else {
            CmmAudioStatus audioStatus;
            CmmUser myself = ConfMgr.getInstance().getMyself();
            long audioType = 0L;
            if (myself != null && (audioStatus = myself.getAudioStatusObj()) != null) {
                audioType = audioStatus.getAudiotype();
            }
            if (isTalkbackEnabled && myself != null && !myself.isHost() && audioType != 1L) {
                int confStatus = ConfMgr.getInstance().getConfStatus();
                if (confStatus == 8 || confStatus == 9) {
                    ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(8), true);
                } else {
                    ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(1), true);
                }
                ConfLocalHelper.leaveCall(this);
            } else {
                new LeaveAlertDialog().show(this.getSupportFragmentManager(), LeaveAlertDialog.class.getName());
            }
        }
    }

    public void onClickSwitchCamera() {
        CameraComponent cameraComponent = this.getmCameraComponent();
        if (cameraComponent != null) {
            cameraComponent.switchToNextCamera();
        }
    }

    public void hideToolbarDefaultDelayed() {
    }

    public boolean isSharingOut() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return false;
        }
        return shareMgr.getShareStatus() == 2;
    }

    public boolean isSharingScreen() {
        return this.isSharingOut() && ScreenShareMgr.getInstance().isSharing();
    }

    public boolean isWebinarAttendeeRaiseHand(String jid) {
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar != null) {
            return raiseHandInWebinar.getRaisedHandStatus(jid);
        }
        return false;
    }

    private void sinkConfFail(final long ret) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onConfFail"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).onConfFail(ret);
            }
        });
    }

    private void onConfFail(long ret) {
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            if (ret == 10L) {
                ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(4), true);
                ConfLocalHelper.leaveCall(this);
                return;
            }
            if (ret == 23L) {
                ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(26), true);
                ConfLocalHelper.leaveCall(this);
                return;
            }
        }
        if (this.mConfParams.isMbNoMeetingErrorMsg()) {
            ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(ConfLocalHelper.errorCodeToLeaveReason((int)ret)), true, (int)ret == 1);
            ConfLocalHelper.leaveCall(this);
        } else {
            JoinFailedDialog.show(this.getSupportFragmentManager(), JoinFailedDialog.class.getName(), (int)ret);
        }
    }

    private void sinkConfPlayerReminder(final long ret) {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkConfPlayerReminder", new EventAction("sinkConfPlayerReminder"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).onConfPlayerReminder(ret);
            }
        });
    }

    private void onConfPlayerReminder(long ret) {
        boolean isOrigalHost;
        boolean bl = isOrigalHost = ret == 1L;
        if (this.handleConfPayReminder(isOrigalHost)) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (isOrigalHost && confContext != null && confContext.canUpgradeThisFreeMeeting()) {
            this.showUpgradeFreeMeetingDialog();
        } else {
            this.showPlayerReminderDialog(isOrigalHost);
        }
    }

    protected boolean handleConfPayReminder(boolean isOrignalHost) {
        return false;
    }

    private void sinkConfNoHost(final long ret) {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkConfNoHost", new EventAction("sinkConfNoHost"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).onConfNoHost(ret);
            }
        });
    }

    private void onConfNoHost(long ret) {
        this.showConfNoHostDialog(ret);
    }

    private void showPlayerReminderDialog(boolean isOriginalHost) {
        PlayerReminderDialog dialog = PlayerReminderDialog.newPlayerReminderDialog(isOriginalHost);
        dialog.show(this.getSupportFragmentManager(), PlayerReminderDialog.class.getSimpleName());
    }

    private void showUpgradeFreeMeetingDialog() {
        UpgradeFreeMeetingDialog.showDialog(this.getSupportFragmentManager());
    }

    private void showConfNoHostDialog(long ret) {
        String message = this.getString(R.string.zm_msg_conf_no_host, new Object[]{ret});
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(message);
        dialog.show(this.getSupportFragmentManager(), SimpleMessageDialog.class.getSimpleName());
    }

    private void sinkConfCloseOtherMeeting() {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkConfCloseOtherMeeting", new EventAction("sinkConfCloseOtherMeeting"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).onConfCloseOtherMeeting();
            }
        });
    }

    private void onConfCloseOtherMeeting() {
        CloseOtherMeetingDialog.show(this.getSupportFragmentManager());
    }

    private void sinkConfMeetingUpgraded() {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkConfMeetingUpgraded", new EventAction("sinkConfMeetingUpgraded"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).onConfMeetingUpgrade();
            }
        });
    }

    private void onConfMeetingUpgrade() {
        UpgradeFreeMeetingDialog.dismiss(this.getSupportFragmentManager());
    }

    private void sinkCmrStorageFull() {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkCmrStorageFull", new EventAction("sinkCmrStorageFull"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).showCmrStorageFull();
            }
        });
    }

    protected void showCmrStorageFull() {
        CmrFullStorageDialog cmrFullStorageDialog = new CmrFullStorageDialog();
        cmrFullStorageDialog.show(this.getSupportFragmentManager(), CmrFullStorageDialog.class.getName());
    }

    private void _onPTAskToLeave(int reason) {
        switch (reason) {
            case 0: 
            case 8: {
                this.finish(true);
                return;
            }
            case 38: {
                if (ConfLocalHelper.isGe2NotCallingOut()) {
                    return;
                }
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext != null) {
                    IntegrationActivity.showCallNotAnsweredMessage((Context)this, confContext.get1On1BuddyScreeName());
                }
                this.finish(true);
                return;
            }
        }
        if (this.isActive()) {
            this.handleOnPTAskToLeave(reason);
        } else {
            ConfUI.getInstance().clearPTAskToLeaveReason();
            Intent intent = new Intent((Context)this, this.getClass());
            intent.setAction(ACTION_PT_ASK_TO_LEAVE);
            intent.addFlags(131072);
            intent.putExtra(ARG_LEAVE_REASON, reason);
            this.startActivity(intent);
        }
    }

    protected void handleOnPTAskToLeave(final int reason) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("handleOnPTAskToLeave"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).handleOnPTAskToLeaveImpl(reason);
            }
        });
    }

    private void handleOnPTAskToLeaveImpl(int reason) {
        switch (reason) {
            case 5: {
                JoinFailedDialog.show(this.getSupportFragmentManager(), JoinFailedDialog.class.getName(), 1);
                break;
            }
            case 6: {
                JoinFailedDialog.show(this.getSupportFragmentManager(), JoinFailedDialog.class.getName(), 50);
                break;
            }
            case 1: 
            case 3: {
                this.onClickLeave();
                break;
            }
            default: {
                JoinFailedDialog.show(this.getSupportFragmentManager(), JoinFailedDialog.class.getName(), -1);
            }
        }
    }

    private void _onJoinConfConfirmMeetingInfo(final boolean success, final boolean hasPassword, final boolean hasScreenName) {
        this.getNonNullEventTaskManagerOrThrowException().push("handleJoinConfConfirmMeetingInfo", new EventAction("handleJoinConfConfirmMeetingInfo"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).handleJoinConfConfirmMeetingInfo(success, hasPassword, hasScreenName);
            }
        });
    }

    private void handleJoinConfConfirmMeetingInfo(boolean success, boolean hasPassword, boolean hasScreenName) {
        if (success) {
            if (hasPassword) {
                NamePasswordDialog dialog = new NamePasswordDialog();
                Bundle args = new Bundle();
                if (hasScreenName) {
                    args.putSerializable("showScreenName", (Serializable)Boolean.valueOf(false));
                } else {
                    String savedName = PreferenceUtil.readStringValue("screen_name", "");
                    args.putSerializable(ARG_SCREEN_NAME, (Serializable)((Object)savedName));
                    RetainedFragment f = this.getRetainedFragment();
                    f.mHasPopupNameDialog = true;
                }
                dialog.setArguments(args);
                dialog.show(this.getSupportFragmentManager(), NewIncomingCallDialog.class.getName());
            } else if (!hasScreenName) {
                AccessibilityManager accessibilityManager = (AccessibilityManager)this.getSystemService("accessibility");
                String savedName = PreferenceUtil.readStringValue("screen_name", "");
                if (accessibilityManager != null && accessibilityManager.isEnabled() && Build.VERSION.SDK_INT > 13 && accessibilityManager.isTouchExplorationEnabled()) {
                    if (StringUtil.isEmptyOrNull((String)savedName)) {
                        savedName = Mainboard.getDeviceDefaultName();
                    }
                    this.confirmNamePassword("", savedName);
                }
            }
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null && !confContext.isVideoOn()) {
                VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
                AbsVideoSceneMgr videoSceneMgr = this.getVideoSceneMgr();
                if (videoMgr != null && videoMgr.isPreviewing() && videoSceneMgr != null) {
                    videoMgr.stopPreviewDevice(videoSceneMgr.getPreviewRenderInfo());
                }
            }
        }
    }

    private void cancelJoinMeeting() {
        ConfMgr.getInstance().onUserInputPassword("", "", true);
        ConfLocalHelper.leaveCall(this);
    }

    private void confirmNamePassword(String password, String userName) {
        if (!StringUtil.isEmptyOrNull((String)password)) {
            if (!StringUtil.isEmptyOrNull((String)userName)) {
                PreferenceUtil.saveStringValue("screen_name", userName);
            }
            ConfMgr.getInstance().onUserInputPassword(password, userName, false);
        } else {
            PreferenceUtil.saveStringValue("screen_name", userName);
            ConfMgr.getInstance().onUserConfirmToJoin(true, userName);
            if (this.getRetainedFragment().mIsAbleToJoin && !this.isCallingOut()) {
                this.switchViewToConfView();
            }
        }
    }

    private void _onJoinConfConfirmPasswordValidateResult(final boolean success, final boolean needWait) {
        this.getNonNullEventTaskManagerOrThrowException().push("handleJoinConfConfirmPasswordValidateResult", new EventAction("handleJoinConfConfirmPasswordValidateResult"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).handleJoinConfConfirmPasswordValidateResult(success, needWait);
            }
        });
    }

    private void handleJoinConfConfirmPasswordValidateResult(boolean success, boolean needWait) {
        if (success) {
            if (needWait) {
                this.switchViewToWaitingJoinView();
            }
        } else {
            NamePasswordDialog dialog = new NamePasswordDialog();
            Bundle args = new Bundle();
            args.putSerializable("showScreenName", (Serializable)Boolean.valueOf(false));
            args.putSerializable("passwordError", (Serializable)Boolean.valueOf(true));
            dialog.setArguments(args);
            dialog.show(this.getSupportFragmentManager(), NewIncomingCallDialog.class.getName());
        }
    }

    private void _onJoinConfConfirmMeetingStatus(final boolean canJoinNow, final boolean hasScreenName) {
        this.getNonNullEventTaskManagerOrThrowException().push("handleJoinConfConfirmMeetingStatus", new EventAction("handleJoinConfConfirmMeetingStatus"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).handleJoinConfConfirmMeetingStatus(canJoinNow, hasScreenName);
            }
        });
    }

    private void handleJoinConfConfirmMeetingStatus(boolean canJoinNow, boolean hasScreenName) {
        if (canJoinNow) {
            this.getRetainedFragment().mIsAbleToJoin = true;
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext == null) {
                return;
            }
            boolean needUserConfirm = confContext.needUserConfirmToJoinOrStartMeeting();
            if (!needUserConfirm) {
                if (!this.isCallingOut()) {
                    this.switchViewToConfView();
                }
            } else {
                String name = confContext.getMyScreenName();
                boolean needConfirm = confContext.needConfirmGDPR();
                String tosUrl = confContext.getToSUrl();
                String privacyUrl = confContext.getPrivacyUrl();
                if (StringUtil.isEmptyOrNull((String)name)) {
                    RetainedFragment f = this.getRetainedFragment();
                    if (f.mHasPopupNameDialog) {
                        return;
                    }
                    f.mHasPopupNameDialog = true;
                    NamePasswordDialog dialog = new NamePasswordDialog();
                    Bundle args = new Bundle();
                    String savedName = PreferenceUtil.readStringValue("screen_name", "");
                    args.putSerializable(ARG_SCREEN_NAME, (Serializable)((Object)savedName));
                    args.putSerializable("showPassword", (Serializable)Boolean.valueOf(false));
                    dialog.setArguments(args);
                    dialog.show(this.getSupportFragmentManager(), NewIncomingCallDialog.class.getName());
                } else if (needConfirm && !StringUtil.isEmptyOrNull((String)tosUrl) && !StringUtil.isEmptyOrNull((String)privacyUrl)) {
                    ZMGDPRConfirmDialog f = ZMGDPRConfirmDialog.findFragment(this.getSupportFragmentManager());
                    if (f != null) {
                        f.dismiss();
                    }
                    ZMGDPRConfirmDialog.showDialog(this, 0, 2, tosUrl, privacyUrl);
                }
            }
            ConfActivity.notifyNetworkType();
        }
        this.onJoinMeetingConfirmed();
    }

    protected void onJoinMeetingConfirmed() {
    }

    private void _onCallTimeOut() {
        if (ConfLocalHelper.isGe2NotCallingOut()) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            IntegrationActivity.showCallNotAnsweredMessage((Context)this, confContext.get1On1BuddyScreeName());
        }
        ConfLocalHelper.endCall(this);
    }

    private void _onDeviceStatusChanged(int cmd, final int ret) {
        if (cmd == 1) {
            if (ret == 10) {
                this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onMicFeedbackDetected"){

                    public void run(IUIElement ui) {
                        ((ConfActivity)ui).handleOnMicEchoDetected();
                    }
                });
            } else if (ret == 2) {
                this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onMicDeviceErrorFound"){

                    public void run(IUIElement ui) {
                        ((ConfActivity)ui).handleOnMicDeviceError();
                    }
                });
            }
        } else if (cmd == 3) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onCameraStatusEvent"){

                public void run(IUIElement ui) {
                    ((ConfActivity)ui).handleOnCameraStatusEvent(ret);
                }
            });
        }
    }

    private void handleOnMicDeviceError() {
        if (Build.VERSION.SDK_INT >= 23 && this.zm_checkSelfPermission("android.permission.RECORD_AUDIO") != 0) {
            this.requestPermission("android.permission.RECORD_AUDIO", 1015, 500L);
            return;
        }
    }

    private void handleOnMicEchoDetected() {
        this.showTipMicEchoDetected();
    }

    public void handleOnCameraStatusEvent(int event) {
        if (event == 2) {
            this.muteVideo(true);
        }
        this.onCameraStatusEvent(event);
    }

    public void onCameraStatusEvent(int event) {
    }

    private void _onWebinarNeedRegister(final boolean bNeedApproval) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onWebinarNeedRegister"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).handleOnWebinarNeedRegister(bNeedApproval);
            }
        });
    }

    private void _onUpgradeThisFreeMeeting(final int ret) {
        if (ret == 0) {
            return;
        }
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("_onUpgradeThisFreeMeeting"){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).handleOnUpgradeThisFreeMeeting(ret);
            }
        });
    }

    private void _onCheckCMRPrivilege(int ret, boolean canStartNow) {
        if (ret != 0) {
            this.showCheckCMRPrivilegeErrorMessage();
            return;
        }
        if (canStartNow) {
            RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
            if (recordMgr.canStartCMR()) {
                recordMgr.startCMR();
            }
        } else {
            this.sinkCmrStorageFull();
        }
    }

    private void showCheckCMRPrivilegeErrorMessage() {
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this).setTitle(R.string.zm_record_msg_start_cmr_error_5537).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
    }

    private void _onConfAttentionTrackStatusChanged(boolean bEnabled) {
        this.checkAttentionTrackMode();
    }

    private void _onUIMoveToBackground() {
        this.checkAttentionTrackMode();
    }

    private void onActivityMoveToFront(ZMActivity activity) {
        this.checkAttentionTrackMode();
    }

    private void handleOnWebinarNeedRegister(boolean bNeedApproval) {
        if (bNeedApproval) {
            this.showWebinarNeedRegisterMessage();
        } else {
            this.showWebinarRegisterDialog();
        }
    }

    private void handleOnUpgradeThisFreeMeeting(int ret) {
        if (ret == 0) {
            return;
        }
        UpgradeFreeMeetingErrorDialog.showDialog(this.getSupportFragmentManager(), ret);
    }

    private void showWebinarNeedRegisterMessage() {
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm != null) {
            WebinarNeedRegisterDialog dialog = new WebinarNeedRegisterDialog();
            dialog.show(fm, WebinarNeedRegisterDialog.class.getName());
        }
    }

    private void showWebinarRegisterDialog() {
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm != null) {
            String defName = null;
            String defEmail = null;
            int instruction = 0;
            boolean isWebinar = false;
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null) {
                defName = confContext.getMyScreenName();
                defEmail = confContext.getMyEmail();
                isWebinar = confContext.isWebinar();
            }
            if (StringUtil.isEmptyOrNull(defName)) {
                defName = PreferenceUtil.readStringValue("screen_name", "");
            }
            if (StringUtil.isEmptyOrNull(defEmail)) {
                defEmail = PreferenceUtil.readStringValue("email", "");
            }
            instruction = isWebinar ? R.string.zm_msg_webinar_need_register : R.string.zm_msg_meeting_need_register;
            WebinarRegisterDialog.show(fm, defName, defEmail, instruction);
        }
    }

    private static void onNetworkState(Intent intent) {
        ConfActivity.notifyNetworkType();
        ZMActivity activity = ZMActivity.getFrontActivity();
        if (activity instanceof ConfActivityNormal && activity.isActive()) {
            ConfActivity confActivity = (ConfActivity)activity;
            confActivity.checkNetworkRestrictionMode();
        }
    }

    private static void notifyNetworkType() {
        ConfUI.getInstance().notifyNetworkType();
    }

    private static void notifyWifiSignal() {
        ConfUI.getInstance().notifyWifiSignal();
    }

    private static void startNotifyWifiSignal() {
        if (g_taskNotifyWifiSignal == null) {
            g_taskNotifyWifiSignal = new Runnable(){

                @Override
                public void run() {
                    ConfActivity.notifyWifiSignal();
                    g_handler.postDelayed((Runnable)this, 10000L);
                }
            };
            g_handler.postDelayed(g_taskNotifyWifiSignal, 10000L);
        }
    }

    private static void stopNotifyWifiSignal() {
        if (g_taskNotifyWifiSignal != null) {
            g_handler.removeCallbacks(g_taskNotifyWifiSignal);
            g_taskNotifyWifiSignal = null;
        }
    }

    private void checkNetworkRestrictionMode() {
        if (ConfMgr.getInstance().isConfConnected()) {
            boolean isRestrictionMode = this.isNetworkRestrictionMode();
            AbsVideoSceneMgr videoSceneMgr = this.getVideoSceneMgr();
            if (videoSceneMgr != null) {
                videoSceneMgr.onNetworkRestrictionModeChanged(isRestrictionMode);
            }
        }
    }

    private static void startListenNetworkState(Context context) {
        if (g_networkStateReceiver == null) {
            g_networkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                        return;
                    }
                    ConfActivity.onNetworkState(intent);
                }
            };
            context.getApplicationContext().registerReceiver(g_networkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private static void stopListenNetworkState(Context context) {
        if (g_networkStateReceiver != null) {
            context.getApplicationContext().unregisterReceiver(g_networkStateReceiver);
            g_networkStateReceiver = null;
        }
    }

    private static void startListenVolumeChange(Context context) {
        if (g_volumeChangeReceiver == null) {
            g_volumeChangeReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                    int value = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", -1);
                    ConfActivity.onVolumeChanged(streamType, value);
                }
            };
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.media.VOLUME_CHANGED_ACTION");
            context.getApplicationContext().registerReceiver(g_volumeChangeReceiver, filter);
        }
    }

    private static void stopListenVolumeChange(Context context) {
        if (g_volumeChangeReceiver != null) {
            context.getApplicationContext().unregisterReceiver(g_volumeChangeReceiver);
            g_volumeChangeReceiver = null;
        }
    }

    private static void onVolumeChanged(final int streamType, int value) {
        if (streamType == 3 && "Amazon".equals(Build.MANUFACTURER) && !VoiceEngineCompat.isFeatureTelephonySupported((Context)VideoBoxApplication.getInstance())) {
            if (g_audioManager == null) {
                g_audioManager = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
            }
            if (g_audioManager == null) {
                return;
            }
            float percent = (float)value / (float)g_audioManager.getStreamMaxVolume(streamType);
            int volume = (int)((float)g_audioManager.getStreamMaxVolume(0) * percent);
            g_audioManager.setStreamVolume(0, volume, 0);
        }
        if (VoiceEnginContext.getSelectedPlayerStreamType() != streamType) {
            return;
        }
        if (value != g_lastVolume) {
            g_lastVolume = value;
            if (g_runnableNotifyVolumeChanged == null) {
                g_runnableNotifyVolumeChanged = new Runnable(){

                    @Override
                    public void run() {
                        boolean up = g_lastNotifiedVolume < g_lastVolume;
                        ConfActivityNormal.notifyVolumeChanged(up, g_lastVolume, streamType);
                    }
                };
            }
            g_handler.removeCallbacks(g_runnableNotifyVolumeChanged);
            g_handler.postDelayed(g_runnableNotifyVolumeChanged, 1000L);
        }
    }

    public static void notifyVolumeChanged(boolean up, int value, int streamType) {
        AudioSessionMgr audioSessionMgr = ConfMgr.getInstance().getAudioObj();
        if (audioSessionMgr != null) {
            g_lastNotifiedVolume = value;
            if (g_audioManager == null) {
                g_audioManager = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
            }
            if (g_audioManager == null) {
                return;
            }
            int percent = Math.round((float)value * 100.0f / (float)g_audioManager.getStreamMaxVolume(streamType));
            audioSessionMgr.notifyVolumeChanged(up, percent);
        }
    }

    private void showTipCannotUnmuteForSharingAudioStarted() {
        String message = this.getString(R.string.zm_msg_cannot_unmute_for_host_muted_all);
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_CANNOT_UNMUTE_FOR_SHARING_AUDIO_STARTED.name(), null, message, 3000L);
    }

    private void showTipInvitationsSent(int count) {
        String message = this.getResources().getQuantityString(R.plurals.zm_msg_invitations_sent, count, new Object[]{count});
        NormalMessageTip.show(this.getSupportFragmentManager(), TipMessageType.TIP_INVITATIONS_SENT.name(), null, message, R.drawable.zm_ic_tick, 0, 0, 3000L);
    }

    public void alertStartCameraFailed() {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ConfActivity activity = (ConfActivity)ui;
                activity.handleStartCameraFailed();
            }
        });
    }

    private void handleStartCameraFailed() {
        if (Build.VERSION.SDK_INT >= 23 && this.zm_checkSelfPermission("android.permission.CAMERA") != 0) {
            this.requestPermission("android.permission.CAMERA", 1015, 500L);
            return;
        }
        DialogUtils.showAlertDialog((ZMActivity)this, R.string.zm_alert_start_camera_failed_title, R.string.zm_alert_start_camera_failed_msg, R.string.zm_btn_ok);
    }

    public void disconnectAudio() {
        CmmConfStatus confStatus;
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return;
        }
        long audioType = audioStatus.getAudiotype();
        if (0L == audioType) {
            audioMgr.turnOnOffAudioSession(false);
        } else if (1L == audioType && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null) {
            confStatus.hangUp();
        }
    }

    public int getToolbarHeight() {
        return 0;
    }

    public int getTopbarHeight() {
        return 0;
    }

    public int getVideoViewLocationonScrennY() {
        return 0;
    }

    public void refreshUnreadChatCount() {
    }

    public void onPListTipClosed() {
    }

    public void showPList() {
    }

    public void showAttendeeList() {
    }

    public AbsVideoSceneMgr getVideoSceneMgr() {
        return null;
    }

    public void onVideoSceneChanged(AbsVideoScene fromScene, AbsVideoScene toScene) {
    }

    public void onDraggingVideoScene() {
    }

    public void onDropVideoScene(boolean activeSceneChanged) {
    }

    public void switchViewToConfView() {
    }

    public void switchViewToWaitingJoinView() {
    }

    public void showTipMicEchoDetected() {
    }

    public void enterHostKeyToClaimHost() {
    }

    @Override
    public void performDialogAction(int requestCode, int action, Bundle args) {
        if (requestCode == 0) {
            if (action == -1) {
                ConfMgr.getInstance().confirmGDPR(true);
            } else if (action == -2) {
                if (args == null) {
                    return;
                }
                final String tosUrl = args.getString("args_terms_url");
                final String privacyUrl = args.getString("args_privacy_url");
                if (StringUtil.isEmptyOrNull((String)tosUrl) || StringUtil.isEmptyOrNull((String)privacyUrl)) {
                    return;
                }
                this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("alertNewIncomingCall"){

                    public void run(IUIElement ui) {
                        ConfActivity confActivity = (ConfActivity)ui;
                        if (ui != null) {
                            ZMGDPRConfirmDialog.showDialog(confActivity, 1, 3, tosUrl, privacyUrl);
                        }
                    }
                });
            }
        } else if (requestCode == 1) {
            if (action == -1) {
                ConfMgr.getInstance().confirmGDPR(true);
            } else if (action == -2) {
                ConfMgr.getInstance().confirmGDPR(false);
            }
        }
    }

    protected boolean joinBO(String bid, int reason) {
        if (StringUtil.isEmptyOrNull((String)bid)) {
            return false;
        }
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return false;
        }
        if (reason != 1 && boMgr.isInBOMeeting()) {
            return false;
        }
        return boMgr.joinBO(bid, reason);
    }

    public boolean leaveBO() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return false;
        }
        if (!boMgr.isInBOMeeting()) {
            return false;
        }
        return boMgr.leaveBO();
    }

    public boolean endBO() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return false;
        }
        if (!boMgr.isBOController()) {
            return false;
        }
        return boMgr.stop(60);
    }

    protected void checkBOStatus() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return;
        }
        int status = boMgr.getControlStatus();
        if (boMgr.isInBOMeeting() && status != 2) {
            this.leaveBO();
        }
    }

    protected void requestBOForHelp() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return;
        }
        if (!boMgr.isInBOMeeting() || boMgr.isBOController()) {
            return;
        }
        boMgr.requestForHelp();
    }

    protected BOObject getMyBOMeeting(int flag) {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return null;
        }
        BOObject myObject = boMgr.getMyBOObject(flag);
        return myObject;
    }

    protected String getMyBOMeetingName(int flag) {
        BOObject myBOObject = this.getMyBOMeeting(flag);
        if (myBOObject == null) {
            return "";
        }
        String name = myBOObject.getMeetingName();
        if (StringUtil.isEmptyOrNull((String)name)) {
            return "";
        }
        return name;
    }

    protected boolean isInBOMeeting() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return false;
        }
        return boMgr.isInBOMeeting();
    }

    protected boolean isInBOController() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return false;
        }
        return boMgr.isBOController();
    }

    protected int getBOControlStatus() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return 1;
        }
        return boMgr.getControlStatus();
    }

    protected boolean isBOControllerStarted() {
        int status = this.getBOControlStatus();
        return status == 2 || status == 3;
    }

    protected int getBOConfStatus(BOObject bo) {
        if (bo == null) {
            return 5;
        }
        return bo.getMeetingStatus();
    }

    protected int getBOUserStatus(BOObject bo, CmmUser user) {
        if (bo == null || user == null) {
            return 1;
        }
        String userGUID = user.getUserGUID();
        if (StringUtil.isEmptyOrNull((String)userGUID)) {
            return 1;
        }
        BOUser boUser = bo.getUserByUserGUID(userGUID);
        if (boUser == null) {
            return 1;
        }
        return boUser.getUserStatus();
    }

    private CmmUserList getBOMasterConfUserList() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return null;
        }
        return boMgr.getMasterConfUserList();
    }

    public String getBOMeetingNameByBid(String bid) {
        if (StringUtil.isEmptyOrNull((String)bid)) {
            return "";
        }
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return "";
        }
        BOObject object = boMgr.getBOObjectByBId(bid);
        if (object == null) {
            return "";
        }
        return object.getMeetingName();
    }

    protected CmmUser getBOHostUser() {
        CmmUserList userList = this.getBOMasterConfUserList();
        if (userList == null) {
            return null;
        }
        return userList.getHostUser();
    }

    protected CmmUser getBOUser(long userId) {
        CmmUserList userList = this.getBOMasterConfUserList();
        if (userList == null) {
            return null;
        }
        return userList.getUserById(userId);
    }

    protected boolean isHostInThisBoMeeting() {
        if (!this.isInBOMeeting()) {
            return false;
        }
        return this.isUserInThisBOMeeting(this.getBOHostUser());
    }

    protected boolean isUserInThisBOMeeting(CmmUser user) {
        return this.isUserInBOMeeting(this.getMyBOMeeting(2), user);
    }

    protected boolean isUserInBOMeeting(BOObject BOObject2, CmmUser user) {
        if (BOObject2 == null || user == null) {
            return false;
        }
        BOUser boUser = BOObject2.getUserByUserGUID(user.getUserGUID());
        if (boUser == null) {
            return false;
        }
        int status = boUser.getUserStatus();
        return status == 2;
    }

    public boolean isBOStartedAndUnassigned() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return false;
        }
        if (boMgr.isInBOMeeting()) {
            return false;
        }
        if (this.getBOControlStatus() != 2) {
            return false;
        }
        if (this.isInBOController()) {
            return false;
        }
        return this.getMyBOMeeting(3) == null;
    }

    protected void showLeaveBODialog() {
        BOLeaveFragment.showAsDialog(this.getSupportFragmentManager(), this.isInBOController(), this.isInBOMeeting(), BOLeaveFragment.class.getSimpleName());
    }

    protected void doRequestPermission() {
        int length = this.mPendingRequestPermissions.size();
        if (length <= 0) {
            return;
        }
        boolean allSame = true;
        int requestCode = this.mPendingRequestPermissionCodes.get(0);
        for (int i = 1; i < length; ++i) {
            if (requestCode == this.mPendingRequestPermissionCodes.get(i)) continue;
            allSame = false;
            break;
        }
        if (allSame) {
            String[] permissions = this.mPendingRequestPermissions.toArray(new String[length]);
            if (permissions.length > 0) {
                this.mRequestPermissionTime = System.currentTimeMillis();
                this.zm_requestPermissions(permissions, requestCode);
            }
            this.mPendingRequestPermissions.clear();
            this.mPendingRequestPermissionCodes.clear();
        } else {
            String permission2 = this.mPendingRequestPermissions.get(0);
            this.mRequestPermissionTime = System.currentTimeMillis();
            this.zm_requestPermissions(new String[]{permission2}, requestCode);
            this.mPendingRequestPermissions.remove(0);
            this.mPendingRequestPermissionCodes.remove(0);
        }
        this.mInPendingRequestPermission = false;
    }

    protected void requestPendingPermission() {
        this.requestPermission("", 0, 0L);
    }

    protected void requestPermission(String permission2, int requestCode, long delay) {
        if (StringUtil.isEmptyOrNull((String)permission2) || this.mPendingRequestPermissions.contains(permission2)) {
            return;
        }
        this.mPendingRequestPermissions.add(permission2);
        this.mPendingRequestPermissionCodes.add(requestCode);
        if (this.mInPendingRequestPermission) {
            return;
        }
        this.mInPendingRequestPermission = true;
        this.mHandler.removeCallbacks(this.mHandleRequestPermissionsRunnable);
        this.mHandler.postDelayed(this.mHandleRequestPermissionsRunnable, delay);
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        final long requestTime = System.currentTimeMillis() - this.mRequestPermissionTime;
        this.mRequestPermissionTime = 0L;
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((ConfActivity)ui).handleRequestPermissionResult(requestCode, permissions, grantResults, requestTime);
            }
        });
    }

    private void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults, long requesDuration) {
        if (permissions == null || grantResults == null) {
            return;
        }
        if (requesDuration > 100L) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (grantResults[i] == 0) continue;
            PermissionUnableAccessDialog.showDialog(this.getSupportFragmentManager(), permissions[i]);
        }
    }

    public RCMouseView getRCMouseView() {
        return null;
    }

    private void checkAttentionTrackMode() {
        CmmAttentionTrackMgr atMgr = ConfMgr.getInstance().getAttentionTrackAPI();
        if (atMgr == null) {
            return;
        }
        ZMActivity fontActivity = ZMActivity.getFrontActivity();
        if (fontActivity == null) {
            return;
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        if (shareMgr.getShareStatus() == 2 || !atMgr.isConfAttentionTrackEnabled() || fontActivity.isActive()) {
            if (this.mAttentionTrackTask != null) {
                this.mHandler.removeCallbacks(this.mAttentionTrackTask);
                this.mAttentionTrackTask = null;
            }
            if (atMgr.isWebAttentionTrackEnabled()) {
                atMgr.changeMyAttentionStatus(true);
            }
            return;
        }
        if (this.mAttentionTrackTask == null) {
            this.mAttentionTrackTask = new Runnable(){

                @Override
                public void run() {
                    CmmAttentionTrackMgr atMgr = ConfMgr.getInstance().getAttentionTrackAPI();
                    if (atMgr == null) {
                        return;
                    }
                    ZMActivity fontActivity = ZMActivity.getFrontActivity();
                    if (fontActivity == null) {
                        return;
                    }
                    if (!atMgr.isConfAttentionTrackEnabled()) {
                        return;
                    }
                    atMgr.changeMyAttentionStatus(fontActivity.isActive());
                    ConfActivity.this.mAttentionTrackTask = null;
                }
            };
            this.mHandler.postDelayed(this.mAttentionTrackTask, (long)((25 + new Random().nextInt(16)) * 1000));
        }
    }

    static {
        g_taskNotifyWifiSignal = null;
        g_notifyUpdateWaitCountDown = 20;
    }

    public static class PermissionUnableAccessDialog
    extends ZMDialogFragment {
        private static final String ARG_PERMISSION = "arg_permission";

        public static void showDialog(FragmentManager fragmentMgr, String permission2) {
            if (StringUtil.isEmptyOrNull((String)permission2)) {
                return;
            }
            PermissionUnableAccessDialog dlg = new PermissionUnableAccessDialog();
            Bundle args = new Bundle();
            args.putString(ARG_PERMISSION, permission2);
            dlg.setArguments(args);
            dlg.show(fragmentMgr, PermissionUnableAccessDialog.class.getName());
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            String permission2 = args.getString(ARG_PERMISSION);
            String title = "";
            String message = "";
            if ("android.permission.CAMERA".equals(permission2)) {
                title = this.getString(R.string.zm_title_unable_access_camera);
                message = this.getString(R.string.zm_msg_unable_access_camera);
            } else if ("android.permission.RECORD_AUDIO".equals(permission2)) {
                title = this.getString(R.string.zm_title_unable_access_mic);
                message = this.getString(R.string.zm_msg_unable_access_mic);
            } else if ("android.permission.READ_EXTERNAL_STORAGE".equals(permission2)) {
                title = this.getString(R.string.zm_title_unable_access_storage);
                message = this.getString(R.string.zm_msg_unable_access_storage);
            }
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTitle(title).setMessage(message).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            });
            return builder.create();
        }
    }

    public static class PermissionPromptDialog
    extends ZMDialogFragment {
        public static void showDialog(FragmentManager fragmentMgr) {
            PermissionPromptDialog dlg = new PermissionPromptDialog();
            dlg.show(fragmentMgr, PermissionPromptDialog.class.getName());
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTitle(R.string.zm_title_permission_prompt).setMessage(R.string.zm_msg_meeting_permission).setPositiveButton(R.string.zm_btn_got_it, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PermissionPromptDialog.this.handlePermissionRequest();
                }
            });
            ZMAlertDialog dlg = builder.create();
            dlg.setCanceledOnTouchOutside(false);
            return dlg;
        }

        public void onCancel(DialogInterface dialog) {
            super.onCancel(dialog);
            this.handlePermissionRequest();
        }

        private void handlePermissionRequest() {
            ConfActivityNormal activity = (ConfActivityNormal)this.getActivity();
            if (activity == null) {
                return;
            }
            activity.doRequestPermission();
        }
    }

    public static class PlayerReminderDialog
    extends ZMDialogFragment {
        private static final String ARG_IS_ORIGINAL_HOST = "isOriginalHost";

        public static PlayerReminderDialog newPlayerReminderDialog(boolean isOriginalHost) {
            PlayerReminderDialog dialog = new PlayerReminderDialog();
            Bundle args = new Bundle();
            args.putBoolean(ARG_IS_ORIGINAL_HOST, isOriginalHost);
            dialog.setArguments(args);
            return dialog;
        }

        public PlayerReminderDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            boolean isOriginalHost = false;
            Bundle args = this.getArguments();
            if (args != null) {
                isOriginalHost = args.getBoolean(ARG_IS_ORIGINAL_HOST);
            }
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true);
            if (isOriginalHost) {
                builder.setTitle(R.string.zm_msg_meeting_player_reminder_for_host_title).setMessage(R.string.zm_msg_meeting_player_reminder_for_host).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            } else {
                builder.setTitle(R.string.zm_msg_meeting_player_reminder_for_attendee_title).setMessage(R.string.zm_msg_meeting_player_reminder_for_attendee).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            }
            return builder.create();
        }
    }

    public static class UpgradeFreeMeetingErrorDialog
    extends ZMDialogFragment {
        private static final String ARG_ERROR_CODE = "arg_error_code";

        public static void showDialog(FragmentManager fm, int errorCode) {
            UpgradeFreeMeetingErrorDialog dlg = new UpgradeFreeMeetingErrorDialog();
            Bundle args = new Bundle();
            args.putInt(ARG_ERROR_CODE, errorCode);
            dlg.setArguments(args);
            dlg.show(fm, UpgradeFreeMeetingErrorDialog.class.getName());
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            int errorcode = args.getInt(ARG_ERROR_CODE, 0);
            String message = this.getString(R.string.zm_msg_upgrade_free_meeting_failed_15609, new Object[]{errorcode});
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTitle(R.string.zm_msg_upgrade_free_meeting_failed_title_15609).setMessage(message).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            });
            return builder.create();
        }
    }

    public static class UpgradeFreeMeetingDialog
    extends ZMDialogFragment {
        public static void showDialog(FragmentManager fm) {
            UpgradeFreeMeetingDialog dlg = new UpgradeFreeMeetingDialog();
            dlg.show(fm, UpgradeFreeMeetingDialog.class.getName());
        }

        public static void dismiss(FragmentManager fm) {
            ZMDialogFragment dlg = (ZMDialogFragment)fm.findFragmentByTag(UpgradeFreeMeetingDialog.class.getName());
            if (dlg != null) {
                dlg.dismiss();
            }
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTitle(R.string.zm_msg_upgrade_free_meeting_title_45772).setMessage(R.string.zm_msg_upgrade_free_meeting_45772).setCancelable(true).setPositiveButton(R.string.zm_btn_love_it_45772, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivity confActivity = (ConfActivity)UpgradeFreeMeetingDialog.this.getActivity();
                    if (confActivity != null) {
                        confActivity.upgradeFreeMeeting();
                    }
                }
            });
            return builder.create();
        }
    }

    public static class WebinarNeedRegisterDialog
    extends ZMDialogFragment {
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            boolean isWebinar = confContext != null && confContext.isWebinar();
            int title = isWebinar ? R.string.zm_msg_webinar_need_register : R.string.zm_msg_meeting_need_register;
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setPositiveButton(R.string.zm_btn_register, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    WebinarNeedRegisterDialog.this.registerWebninar();
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfLocalHelper.leaveCall((ConfActivity)WebinarNeedRegisterDialog.this.getActivity());
                }
            }).create();
            dialog.setCanceledOnTouchOutside(false);
            return dialog;
        }

        public void onCancel(DialogInterface dialog) {
            super.onCancel(dialog);
            ConfLocalHelper.leaveCall((ConfActivity)this.getActivity());
        }

        private void registerWebninar() {
            ConfLocalHelper.leaveCall((ConfActivity)this.getActivity());
            ConfActivityNormal confActivity = (ConfActivityNormal)this.getActivity();
            if (confActivity == null) {
                return;
            }
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext == null) {
                return;
            }
            MeetingInfo meetingInfo = confContext.getMeetingItem();
            if (meetingInfo == null) {
                return;
            }
            String url = meetingInfo.getWebinarRegUrl();
            if (!StringUtil.isEmptyOrNull((String)url)) {
                UIUtil.openURL((Context)confActivity, (String)url);
            }
        }
    }

    public static class NewIncomingCallDialog
    extends ZMDialogFragment {
        private static final String ARG_INVITATION = "invitation";
        private PTAppProtos.InvitationItem mInvitation;

        public NewIncomingCallDialog() {
            this.setCancelable(true);
        }

        public static void showDialog(@NonNull ConfActivity confActivity, @NonNull PTAppProtos.InvitationItem invitation) {
            Bundle args = new Bundle();
            args.putSerializable("invitation", (Serializable)((Object)invitation));
            NewIncomingCallDialog dialog = new NewIncomingCallDialog();
            dialog.setArguments(args);
            dialog.show(confActivity.getSupportFragmentManager(), NewIncomingCallDialog.class.getName());
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            this.mInvitation = (PTAppProtos.InvitationItem)((Object)args.getSerializable("invitation"));
            String message = this.getActivity().getResources().getString(R.string.zm_msg_calling_new, new Object[]{this.mInvitation.getFromUserScreenName()});
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(message).setNegativeButton(R.string.zm_btn_decline, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            }).setPositiveButton(R.string.zm_btn_accept, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivity confActivity = (ConfActivity)NewIncomingCallDialog.this.getActivity();
                    if (confActivity != null) {
                        confActivity.acceptNewIncomingCall(NewIncomingCallDialog.this.mInvitation);
                    }
                }
            }).create();
        }

        public void onCancel(DialogInterface dialog) {
            ConfActivity confActivity;
            super.onCancel(dialog);
            if (this.mInvitation != null && (confActivity = (ConfActivity)this.getActivity()) != null) {
                confActivity.declineNewIncomingCall(this.mInvitation);
            }
        }
    }

    public static class SwitchCallDialog
    extends ZMDialogFragment {
        private static final String ARG_SCREEN_NAME = "screenName";
        private static final String ARG_URL_ACTION = "urlAction";
        private static final String ARG_IS_START = "isStart";

        public SwitchCallDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            final String screenName = args.getString("screenName");
            final String urlAction = args.getString("urlAction");
            boolean isStart = args.getBoolean("isStart", false);
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(isStart ? R.string.zm_alert_switch_call_start : R.string.zm_alert_switch_call).setCancelable(true).setNegativeButton(R.string.zm_btn_no, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivity confActivity = (ConfActivity)SwitchCallDialog.this.getActivity();
                    if (confActivity != null) {
                        confActivity.switchCall(urlAction, screenName);
                    }
                }
            }).create();
        }
    }

    public static class NamePasswordDialog
    extends ZMDialogFragment
    implements TextWatcher,
    TextView.OnEditorActionListener {
        private static final String ARG_SCREEN_NAME = "screenName";
        private static final String ARG_INCORRECT_PSW = "passwordError";
        private static final String ARG_SHOW_SCREEN_NAME = "showScreenName";
        private static final String ARG_SHOW_PSW = "showPassword";
        private EditText mEdtScreenName = null;
        private EditText mEdtPassword = null;
        private Button mBtnOK = null;
        private boolean mbShowScreenName = true;
        private boolean mbShowPassword = true;

        public NamePasswordDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            String screenName = "";
            boolean bIncorrectPassword = false;
            Bundle args = this.getArguments();
            if (args != null) {
                screenName = args.getString("screenName");
                bIncorrectPassword = args.getBoolean(ARG_INCORRECT_PSW, false);
                this.mbShowScreenName = args.getBoolean(ARG_SHOW_SCREEN_NAME, true);
                this.mbShowPassword = args.getBoolean(ARG_SHOW_PSW, true);
            }
            View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_name_password, null, false);
            this.mEdtScreenName = (EditText)view.findViewById(R.id.edtScreenName);
            this.mEdtPassword = (EditText)view.findViewById(R.id.edtPassword);
            TextView txtInstructions = (TextView)view.findViewById(R.id.txtInstructions);
            View panelScreenName = view.findViewById(R.id.panelScreenName);
            View panelPassword = view.findViewById(R.id.panelPassword);
            if (!this.mbShowScreenName) {
                panelScreenName.setVisibility(8);
            } else {
                this.mEdtScreenName.setText((CharSequence)screenName);
            }
            if (!this.mbShowPassword) {
                panelPassword.setVisibility(8);
            }
            if (bIncorrectPassword) {
                txtInstructions.setText(R.string.zm_lbl_incorrect_meeting_password);
            } else if (this.mbShowScreenName && this.mbShowPassword) {
                txtInstructions.setText(R.string.zm_lbl_name_password_instructions);
            } else if (this.mbShowScreenName) {
                txtInstructions.setText(R.string.zm_lbl_name_instructions);
            } else if (this.mbShowPassword) {
                txtInstructions.setText(R.string.zm_lbl_password_instructions);
            }
            if (this.mbShowScreenName) {
                this.mEdtScreenName.setImeOptions(2);
                this.mEdtScreenName.setOnEditorActionListener((TextView.OnEditorActionListener)this);
            }
            if (!(!this.mbShowPassword || this.mbShowScreenName && StringUtil.isEmptyOrNull((String)screenName))) {
                this.mEdtPassword.setImeOptions(2);
                this.mEdtPassword.setOnEditorActionListener((TextView.OnEditorActionListener)this);
            }
            this.mEdtScreenName.addTextChangedListener((TextWatcher)this);
            this.mEdtPassword.addTextChangedListener((TextWatcher)this);
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(view).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            return dialog;
        }

        public void onResume() {
            super.onResume();
            this.mBtnOK = ((ZMAlertDialog)this.getDialog()).getButton(-1);
            this.mBtnOK.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!NamePasswordDialog.this.checkInput()) {
                        return;
                    }
                    NamePasswordDialog.this.onClickBtnOK();
                }
            });
            this.updateButtons();
        }

        public void onCancel(DialogInterface dialog) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnOK);
            ConfActivity confActivity = (ConfActivity)this.getActivity();
            if (confActivity != null) {
                confActivity.cancelJoinMeeting();
            }
        }

        private void onClickBtnOK() {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnOK);
            String password = this.mEdtPassword.getText().toString().trim();
            String screenName = this.mEdtScreenName.getText().toString().trim();
            if (this.mbShowPassword && password.length() == 0) {
                this.mEdtPassword.requestFocus();
                return;
            }
            if (this.mbShowScreenName && screenName.length() == 0) {
                this.mEdtScreenName.requestFocus();
                return;
            }
            this.dismissAllowingStateLoss();
            ConfActivity confActivity = (ConfActivity)this.getActivity();
            if (confActivity != null) {
                confActivity.confirmNamePassword(password, screenName);
            }
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            this.updateButtons();
        }

        private void updateButtons() {
            if (this.mBtnOK != null) {
                if (this.mbShowScreenName && StringUtil.isEmptyOrNull((String)this.mEdtScreenName.getText().toString()) || this.mbShowPassword && StringUtil.isEmptyOrNull((String)this.mEdtPassword.getText().toString())) {
                    this.mBtnOK.setEnabled(false);
                } else {
                    this.mBtnOK.setEnabled(true);
                }
            }
        }

        private boolean checkInput() {
            return (!this.mbShowScreenName || !StringUtil.isEmptyOrNull((String)this.mEdtScreenName.getText().toString())) && (!this.mbShowPassword || !StringUtil.isEmptyOrNull((String)this.mEdtPassword.getText().toString()));
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            switch (actionId) {
                case 2: {
                    this.onClickBtnOK();
                    return true;
                }
            }
            return false;
        }
    }

    public static class SwitchStartMeetingDialog
    extends ZMDialogFragment {
        private static final String ARG_MEETING_NUMBER = "meetingNumber";
        private static final String ARG_MEETING_ID = "meetingId";

        public static SwitchStartMeetingDialog newSwitchStartMeetingDialog(long meetingNumber, String meetingId) {
            SwitchStartMeetingDialog dialog = new SwitchStartMeetingDialog();
            Bundle args = new Bundle();
            args.putLong(ARG_MEETING_NUMBER, meetingNumber);
            args.putString(ARG_MEETING_ID, meetingId);
            dialog.setArguments(args);
            return dialog;
        }

        public SwitchStartMeetingDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_switch_start_meeting).setCancelable(true).setNegativeButton(R.string.zm_btn_no, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SwitchStartMeetingDialog.this.onClickYes();
                }
            }).create();
        }

        private void onClickYes() {
            Bundle args = this.getArguments();
            if (args == null) {
                return;
            }
            final long meetingNo = args.getLong(ARG_MEETING_NUMBER, 0L);
            final String meetingId = args.getString(ARG_MEETING_ID);
            if (meetingNo == 0L && StringUtil.isEmptyOrNull((String)meetingId)) {
                return;
            }
            PTApp.getInstance().forceLeaveCurrentCall();
            PTApp.getInstance().dispatchIdleMessage();
            final ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (PTApp.getInstance().hasActiveCall()) {
                        activity.getWindow().getDecorView().postDelayed((Runnable)this, 100L);
                    } else {
                        ConfActivityNormal.startMeeting(activity, meetingNo, meetingId);
                    }
                }
            };
            activity.getWindow().getDecorView().postDelayed(runnable, 100L);
        }
    }

    public static class CloseOtherMeetingDialog
    extends ZMDialogFragment {
        public static void show(FragmentManager fragmentMgr) {
            Bundle args = new Bundle();
            CloseOtherMeetingDialog dlg = new CloseOtherMeetingDialog();
            dlg.setArguments(args);
            dlg.show(fragmentMgr, CloseOtherMeetingDialog.class.getName());
        }

        public CloseOtherMeetingDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_meeting_alert).setMessage(R.string.zm_msg_conffail_single_meeting_restricted_confirm).setPositiveButton(R.string.zm_btn_end_other_meeting, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivity confActivity = (ConfActivity)CloseOtherMeetingDialog.this.getActivity();
                    if (confActivity != null) {
                        ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(1), true);
                        ConfLocalHelper.endOtherMeeting();
                    }
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivityNormal confActivity = (ConfActivityNormal)CloseOtherMeetingDialog.this.getActivity();
                    if (confActivity != null) {
                        ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(17), true);
                        ConfLocalHelper.leaveCall(confActivity);
                    }
                }
            });
            return builder.create();
        }

        public void onCancel(DialogInterface dialog) {
            super.onCancel(dialog);
            ConfActivityNormal confActivity = (ConfActivityNormal)this.getActivity();
            if (confActivity != null) {
                ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(17), true);
                ConfLocalHelper.leaveCall(confActivity);
            }
        }
    }

    public static class RetainedFragment
    extends ZMFragment {
        private AbsVideoSceneMgr mVideoSeceneMgr = null;
        private boolean mIsVideoStarted = false;
        private boolean mHasPopupNameDialog = false;
        private boolean mIsAbleToJoin = false;
        private boolean mHasPopupStartingRecord = false;

        public RetainedFragment() {
            this.setRetainInstance(true);
        }

        public void saveVideoSceneMgr(AbsVideoSceneMgr videoSeceneMgr) {
            this.mVideoSeceneMgr = videoSeceneMgr;
        }

        public AbsVideoSceneMgr restoreVideoSceneMgr() {
            return this.mVideoSeceneMgr;
        }

        public void saveIsVideoStarted(boolean isVideoStarted) {
            this.mIsVideoStarted = isVideoStarted;
        }

        public boolean restoreIsVideoStarted() {
            return this.mIsVideoStarted;
        }

        public void setHasPopupStartingRecord(boolean b) {
            this.mHasPopupStartingRecord = b;
        }

        public boolean hasPopupStartingRecord() {
            return this.mHasPopupStartingRecord;
        }
    }
}

