/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.os.Vibrator;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zipow.cmmlib.AppUtil;
import com.zipow.nydus.NydusUtil;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.IncomingCallManager;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTBuddyHelper;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.util.ContactsAvatarCache;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.ZMFacebookUtils;
import com.zipow.videobox.view.AudioClip;
import com.zipow.videobox.view.AvatarView;
import java.io.File;
import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class CallingActivity
extends ZMActivity
implements View.OnClickListener,
SurfaceHolder.Callback,
PTUI.IConfInvitationListener,
ABContactsCache.IABContactsCacheListener {
    public static final int TIMEOUT_VALUE = 60000;
    private static final String TAG = CallingActivity.class.getSimpleName();
    private static final String ARG_INVITATION = "invitation";
    private PTAppProtos.InvitationItem mInvitation;
    private Timer mTimer;
    private SurfaceView mSvPreview;
    private Camera mCamera;
    private TextView mUnlockMsg;
    private Button mBtnAccept;
    private Button mBtnDecline;
    private View mPanelSurfaceHolder;
    private AvatarView mAvatarView;
    private TextView mTxtCallerName;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;
    private final Handler mHandler = new Handler();
    private final Runnable mFirstFocusRunnable = new Runnable(){

        @Override
        public void run() {
            CallingActivity.this.mBtnAccept.setContentDescription((CharSequence)CallingActivity.this.getScreenContent());
            AccessibilityUtil.sendAccessibilityFocusEvent((View)CallingActivity.this.mBtnAccept);
            CallingActivity.this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (CallingActivity.this.isActive() && CallingActivity.this.mBtnAccept != null) {
                        CallingActivity.this.mBtnAccept.setContentDescription(null);
                    }
                }
            }, 200L);
        }
    };
    private long mLastActivatedTime = 0L;
    private AudioClip mRingClip = null;
    private Vibrator mVibrator;
    private boolean mIsSurfaceReady = false;
    private static final long[] VIBRATES = new long[]{2000L, 1000L, 2000L, 1000L};
    private int mFailedTimes = 0;

    public static void show(Context context, PTAppProtos.InvitationItem invitation) {
        if (context == null) {
            return;
        }
        Intent intent = new Intent(context, CallingActivity.class);
        intent.addFlags(0x10000000);
        intent.putExtra(ARG_INVITATION, (Serializable)((Object)invitation));
        context.startActivity(intent);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.disableFinishActivityByGesture(true);
        if (UIMgr.isLargeMode((Context)this)) {
            this.setRequestedOrientation(0);
        } else if (UIUtil.getDisplayMinWidthInDip((Context)this) >= 500.0f) {
            this.setRequestedOrientation(UIUtil.getCurrentOrientation((Context)this) == 2 ? 6 : 7);
        } else {
            this.setRequestedOrientation(1);
        }
        this.getWindow().addFlags(0x688080);
        this.setContentView(R.layout.zm_calling);
        this.mSvPreview = (SurfaceView)this.findViewById(R.id.svPreview);
        this.mBtnAccept = (Button)this.findViewById(R.id.btnAccept);
        this.mBtnDecline = (Button)this.findViewById(R.id.btnDecline);
        this.mPanelSurfaceHolder = this.findViewById(R.id.panelSurfaceHolder);
        this.mTxtCallerName = (TextView)this.findViewById(R.id.txtCallerName);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mUnlockMsg = (TextView)this.findViewById(R.id.unlock_msg);
        this.mBtnAccept.setOnClickListener((View.OnClickListener)this);
        this.mBtnDecline.setOnClickListener((View.OnClickListener)this);
        Intent intent = this.getIntent();
        if ((intent.getFlags() & 0x100000) != 0) {
            IncomingCallManager.getInstance().declineCall();
            this.finish();
            return;
        }
        this.mInvitation = (PTAppProtos.InvitationItem)((Object)intent.getSerializableExtra(ARG_INVITATION));
        if (this.mInvitation == null) {
            IncomingCallManager.getInstance().declineCall();
            this.finish();
            return;
        }
        PTUI.getInstance().addConfInvitationListener(this);
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                CallingActivity.this.onTimeOut();
            }
        }, 60000L);
        this.startRing();
        this.initUIForCallType();
    }

    private void updateCallerInfo() {
        if (this.mInvitation == null) {
            return;
        }
        String jid = this.mInvitation.getSenderJID();
        String callerPhoneNumber = this.mInvitation.getCallerPhoneNumber();
        if (!StringUtil.isEmptyOrNull((String)jid)) {
            String picPath;
            ZoomBuddy buddy;
            boolean isZoomBuddy = false;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger != null && (buddy = jid.indexOf(64) > 0 ? messenger.getBuddyWithJID(jid) : messenger.getBuddyWithPhoneNumber(jid)) != null) {
                isZoomBuddy = true;
                String screenName = this.mInvitation.getFromUserScreenName();
                if (StringUtil.isEmptyOrNull((String)screenName)) {
                    screenName = BuddyNameUtil.getBuddyDisplayName(buddy, null);
                }
                if (StringUtil.isEmptyOrNull((String)screenName) && !StringUtil.isEmptyOrNull((String)callerPhoneNumber)) {
                    screenName = this.getContactLocalNameFromPhoneNumber(callerPhoneNumber);
                }
                if (screenName == null) {
                    screenName = "";
                }
                this.mTxtCallerName.setText((CharSequence)screenName);
                boolean hasAvatar = false;
                picPath = buddy.getLocalBigPicturePath();
                if (!StringUtil.isEmptyOrNull((String)picPath) && ImageUtil.isValidImageFile(picPath)) {
                    this.mAvatarView.setAvatar(picPath);
                    hasAvatar = true;
                } else {
                    File file;
                    if (!StringUtil.isEmptyOrNull((String)picPath) && (file = new File(picPath)).exists()) {
                        file.delete();
                    }
                    if (!StringUtil.isEmptyOrNull((String)(picPath = buddy.getLocalPicturePath())) && ImageUtil.isValidImageFile(picPath)) {
                        this.mAvatarView.setAvatar(picPath);
                        hasAvatar = true;
                    }
                }
                if (!hasAvatar && !StringUtil.isEmptyOrNull((String)callerPhoneNumber)) {
                    Bitmap bitmap = this.getLocalContactAvatarFromPhoneNumber(callerPhoneNumber);
                    this.mAvatarView.setAvatar(bitmap);
                }
                messenger.refreshBuddyVCard(jid);
                messenger.refreshBuddyBigPicture(jid);
            }
            if (!isZoomBuddy) {
                PTBuddyHelper buddyHelper = PTApp.getInstance().getBuddyHelper();
                PTAppProtos.BuddyItem buddyItem = null;
                if (buddyHelper != null) {
                    buddyItem = buddyHelper.getBuddyItemByJid(jid);
                }
                if (buddyItem != null) {
                    String screenName = this.mInvitation.getFromUserScreenName();
                    if (StringUtil.isEmptyOrNull((String)screenName)) {
                        screenName = buddyItem.getScreenName();
                    }
                    if (StringUtil.isEmptyOrNull((String)screenName) && !StringUtil.isEmptyOrNull((String)callerPhoneNumber)) {
                        screenName = this.getContactLocalNameFromPhoneNumber(callerPhoneNumber);
                    }
                    if (screenName == null) {
                        screenName = "";
                    }
                    this.mTxtCallerName.setText((CharSequence)screenName);
                    picPath = buddyItem.getLocalPicturePath();
                    if (StringUtil.isEmptyOrNull((String)picPath)) {
                        picPath = buddyItem.getPicture();
                    }
                    if (StringUtil.isEmptyOrNull((String)picPath)) {
                        picPath = this.getPicPathFromJid(PTApp.getInstance().getPTLoginType(), jid);
                    }
                    this.mAvatarView.setAvatar(picPath);
                } else {
                    String screenName = this.mInvitation.getFromUserScreenName();
                    if (StringUtil.isEmptyOrNull((String)screenName) && !StringUtil.isEmptyOrNull((String)callerPhoneNumber)) {
                        screenName = this.getContactLocalNameFromPhoneNumber(callerPhoneNumber);
                    }
                    if (screenName == null) {
                        screenName = "";
                    }
                    this.mTxtCallerName.setText((CharSequence)screenName);
                    boolean hasAvatar = false;
                    String picPath2 = this.getPicPathFromJid(PTApp.getInstance().getPTLoginType(), jid);
                    if (picPath2 != null && ImageUtil.isValidImageFile(picPath2)) {
                        this.mAvatarView.setAvatar(picPath2);
                        hasAvatar = true;
                    } else {
                        picPath2 = this.getPicPathFromZoomJid(jid, true);
                        if (ImageUtil.isValidImageFile(picPath2)) {
                            this.mAvatarView.setAvatar(picPath2);
                            hasAvatar = true;
                        } else {
                            File file;
                            if (!StringUtil.isEmptyOrNull((String)picPath2) && (file = new File(picPath2)).exists()) {
                                file.delete();
                            }
                            if (ImageUtil.isValidImageFile(picPath2 = this.getPicPathFromZoomJid(jid, false))) {
                                this.mAvatarView.setAvatar(picPath2);
                                hasAvatar = true;
                            }
                        }
                    }
                    if (!hasAvatar && !StringUtil.isEmptyOrNull((String)callerPhoneNumber)) {
                        Bitmap bitmap = this.getLocalContactAvatarFromPhoneNumber(callerPhoneNumber);
                        this.mAvatarView.setAvatar(bitmap);
                    }
                }
            }
        } else {
            String screenName = this.mInvitation.getFromUserScreenName();
            if (StringUtil.isEmptyOrNull((String)screenName) && !StringUtil.isEmptyOrNull((String)callerPhoneNumber)) {
                screenName = this.getContactLocalNameFromPhoneNumber(callerPhoneNumber);
            }
            if (screenName == null) {
                screenName = "";
            }
            this.mTxtCallerName.setText((CharSequence)screenName);
        }
    }

    private String getContactLocalNameFromPhoneNumber(String callerPhoneNumber) {
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.addListener(this);
        if (!cache.isCached() && !cache.reloadAllContacts()) {
            return callerPhoneNumber;
        }
        ABContactsCache.Contact contact = cache.getFirstContactByPhoneNumber(callerPhoneNumber);
        if (contact != null && !StringUtil.isEmptyOrNull((String)contact.displayName)) {
            return contact.displayName;
        }
        return callerPhoneNumber;
    }

    private Bitmap getLocalContactAvatarFromPhoneNumber(String callerPhoneNumber) {
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.addListener(this);
        if (!cache.isCached() && !cache.reloadAllContacts()) {
            return null;
        }
        ABContactsCache.Contact contact = cache.getFirstContactByPhoneNumber(callerPhoneNumber);
        if (contact != null) {
            int contactId = contact.contactId;
            return ContactsAvatarCache.getInstance().getContactAvatar((Context)this, contactId);
        }
        return null;
    }

    private void initUIForCallType() {
        if (this.mInvitation.getIsAudioOnlyMeeting() || this.mInvitation.getIsShareOnlyMeeting()) {
            this.mAvatarView.setVisibility(0);
            this.mPanelSurfaceHolder.setVisibility(8);
        } else {
            this.mAvatarView.setVisibility(4);
            this.mPanelSurfaceHolder.setVisibility(0);
            SurfaceHolder holder = this.mSvPreview.getHolder();
            holder.setType(3);
            holder.addCallback((SurfaceHolder.Callback)this);
        }
    }

    private String getPicPathFromJid(int snsId, String jid) {
        int idx;
        if (PTApp.getInstance().getPTLoginType() == 0 && (idx = jid.indexOf(64)) > 0) {
            jid = jid.substring(0, idx);
        }
        return ZMFacebookUtils.getVCardFileName(snsId, jid);
    }

    private String getPicPathFromZoomJid(String jid, boolean big) {
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return "";
        }
        String myjid = PTApp.getInstance().getRecentZoomJid();
        if (StringUtil.isEmptyOrNull((String)myjid)) {
            return "";
        }
        if (jid.indexOf(64) < 0) {
            int idx = myjid.indexOf(64);
            if (idx < 0) {
                return "";
            }
            String domain = myjid.substring(idx);
            jid = jid + domain;
        }
        StringBuilder fn = new StringBuilder();
        fn.append(AppUtil.getDataPath());
        fn.append("/");
        fn.append(PTApp.getInstance().getRecentZoomJid());
        if (big) {
            fn.append("/pic_");
        } else {
            fn.append("/avatar_");
        }
        fn.append(jid);
        return fn.toString();
    }

    private void onTimeOut() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)CallingActivity.this)) {
                    AccessibilityUtil.announceForAccessibilityCompat((View)CallingActivity.this.mTxtCallerName, (CharSequence)CallingActivity.this.getString(R.string.zm_accessibility_call_missed_22876, new Object[]{StringUtil.safeString((String)CallingActivity.this.mTxtCallerName.getText().toString())}), (boolean)true);
                }
                CallingActivity.this.stopPreview();
                CallingActivity.this.stopRing();
                IncomingCallManager.getInstance().onCallTimeout();
                CallingActivity.this.finish();
            }
        });
    }

    public void onPause() {
        super.onPause();
        long activeTime = SystemClock.elapsedRealtime() - this.mLastActivatedTime;
        if (!this.isScreenLocked() && !this.isFinishing() && activeTime > 1000L) {
            this.onClickBtnDecline();
        }
        ABContactsCache.getInstance().removeListener(this);
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public void onResume() {
        super.onResume();
        this.mLastActivatedTime = SystemClock.elapsedRealtime();
        if (this.mIsSurfaceReady) {
            this.startPreview(this.mSvPreview.getHolder());
        }
        if (this.mZoomMessengerUIListener == null) {
            this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public void onIndicate_BuddyBigPictureDownloaded(String jid, int result) {
                    String callerJid;
                    if (CallingActivity.this.mInvitation != null && StringUtil.isSameString((String)jid, (String)(callerJid = CallingActivity.this.mInvitation.getSenderJID()))) {
                        CallingActivity.this.updateCallerInfo();
                    }
                }

                @Override
                public void onIndicateInfoUpdatedWithJID(String jid) {
                    String callerJid;
                    if (CallingActivity.this.mInvitation != null && StringUtil.isSameString((String)jid, (String)(callerJid = CallingActivity.this.mInvitation.getSenderJID()))) {
                        CallingActivity.this.updateCallerInfo();
                    }
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        this.updateCallerInfo();
        this.mUnlockMsg.setVisibility(this.isScreenLocked() ? 0 : 8);
        if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this)) {
            this.mHandler.removeCallbacks(this.mFirstFocusRunnable);
            this.mHandler.postDelayed(this.mFirstFocusRunnable, 1000L);
        }
    }

    @Override
    public void onContactsCacheUpdated() {
        ABContactsCache.getInstance().removeListener(this);
        String callerPhoneNumber = this.mInvitation.getCallerPhoneNumber();
        if (!StringUtil.isEmptyOrNull((String)callerPhoneNumber)) {
            this.updateCallerInfo();
        }
    }

    private boolean isScreenLocked() {
        KeyguardManager keyManager = (KeyguardManager)this.getSystemService("keyguard");
        return keyManager != null && keyManager.inKeyguardRestrictedInputMode();
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removeConfInvitationListener(this);
        this.stopRing();
        if (this.isFinishing()) {
            if (this.mTimer != null) {
                this.mTimer.cancel();
            }
            IncomingCallManager.getInstance().clearCurrentInvitation();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        this.mInvitation = (PTAppProtos.InvitationItem)((Object)intent.getSerializableExtra(ARG_INVITATION));
        if (this.mInvitation == null) {
            IncomingCallManager.getInstance().declineCall();
            this.finish();
            return;
        }
        this.updateCallerInfo();
    }

    public void onBackPressed() {
        this.onClickBtnDecline();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnAccept) {
            this.onClickBtnAccept();
        } else if (id2 == R.id.btnDecline) {
            this.onClickBtnDecline();
        }
    }

    private void onClickBtnAccept() {
        if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this)) {
            AccessibilityUtil.announceForAccessibilityCompat((View)this.mBtnAccept, (int)R.string.zm_accessibility_call_accepted_22876);
        }
        this.mBtnAccept.setEnabled(false);
        this.mBtnDecline.setEnabled(false);
        this.stopPreview();
        this.stopRing();
        IncomingCallManager.getInstance().acceptCall((Context)this, false);
        this.finish();
    }

    private void onClickBtnDecline() {
        if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this)) {
            AccessibilityUtil.announceForAccessibilityCompat((View)this.mBtnDecline, (int)R.string.zm_accessibility_call_declined_22876);
        }
        this.mBtnAccept.setEnabled(false);
        this.mBtnDecline.setEnabled(false);
        this.stopPreview();
        this.stopRing();
        IncomingCallManager.getInstance().declineCall();
        this.finish();
    }

    private void startRing() {
        int ringerMode = 2;
        try {
            AudioManager audioManager = (AudioManager)this.getSystemService("audio");
            if (audioManager == null) {
                return;
            }
            ringerMode = audioManager.getRingerMode();
        }
        catch (Exception audioManager) {
            // empty catch block
        }
        if (ringerMode == 2 && this.mRingClip == null) {
            boolean isInSipCall = SipCallManager.getInstance().isInCall();
            int stream = isInSipCall ? 0 : 2;
            this.mRingClip = new AudioClip(R.raw.zm_ring, stream);
            this.mRingClip.startPlay();
        }
        if ((ringerMode == 2 || ringerMode == 1) && this.mVibrator == null) {
            this.mVibrator = (Vibrator)this.getSystemService("vibrator");
            if (this.mVibrator != null) {
                this.mVibrator.vibrate(VIBRATES, 0);
            }
        }
    }

    public void stopRing() {
        if (this.mRingClip != null) {
            this.mRingClip.stopPlay();
            this.mRingClip = null;
        }
        if (this.mVibrator != null) {
            this.mVibrator.cancel();
            this.mVibrator = null;
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.stopPreview();
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mIsSurfaceReady = true;
        if (this.isActive()) {
            this.startPreview(holder);
        }
        this.mLastActivatedTime = SystemClock.elapsedRealtime();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mIsSurfaceReady = false;
        this.stopPreview();
    }

    private void startPreview(SurfaceHolder holder) {
        block8: {
            if (this.mCamera != null) {
                return;
            }
            boolean hasCameraFreezedBefore = PreferenceUtil.readBooleanValue("camera_is_freezed", false);
            if (hasCameraFreezedBefore) {
                return;
            }
            if (NydusUtil.getNumberOfCameras() == 0) {
                return;
            }
            int cameraId = NydusUtil.getFrontCameraId();
            if (cameraId < 0) {
                cameraId = 0;
            }
            try {
                this.mCamera = Camera.open((int)cameraId);
                this.mCamera.setPreviewDisplay(holder);
                int orientation = this.setCameraDisplayOrientation(cameraId, this.mCamera);
                Camera.Size size = this.setPreviewSize(this.mCamera);
                if (orientation % 180 == 90) {
                    int sizeHeight = size.width;
                    size.width = size.height;
                    size.height = sizeHeight;
                }
                this.mCamera.startPreview();
                this.relayoutSurfaceView(size);
            }
            catch (Exception e) {
                if (this.mCamera != null) {
                    this.mCamera.release();
                }
                this.mCamera = null;
                if (++this.mFailedTimes >= 4) break block8;
                this.getWindow().getDecorView().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (CallingActivity.this.isActive()) {
                            CallingActivity.this.startPreview(CallingActivity.this.mSvPreview.getHolder());
                        }
                    }
                }, 300L);
            }
        }
    }

    private Camera.Size setPreviewSize(Camera camera) {
        Camera.Parameters params = camera.getParameters();
        return params.getPreviewSize();
    }

    private void relayoutSurfaceView(Camera.Size videoSize) {
        if (videoSize == null) {
            return;
        }
        int displayWidth = this.getWindow().getDecorView().getWidth();
        int displayHeight = this.getWindow().getDecorView().getHeight();
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mSvPreview.getLayoutParams();
        if (NydusUtil.isSamsungIncorrectPreviewSizeFrontCameraDevice()) {
            int left = 0;
            int height = displayWidth * 4 / 3;
            int top = (displayHeight - height) / 2;
            layoutParams.leftMargin = left;
            layoutParams.rightMargin = left;
            layoutParams.width = displayWidth;
            layoutParams.topMargin = top;
            layoutParams.bottomMargin = top;
            layoutParams.height = height;
            layoutParams.gravity = 17;
        } else if (videoSize.width * displayHeight > displayWidth * videoSize.height) {
            int width = videoSize.width * displayHeight / videoSize.height;
            layoutParams.leftMargin = (displayWidth - width) / 2;
            layoutParams.width = width;
            layoutParams.topMargin = 0;
            layoutParams.height = displayHeight;
        } else {
            int height = videoSize.height * displayWidth / videoSize.width;
            layoutParams.topMargin = (displayHeight - height) / 2;
            layoutParams.height = height;
            layoutParams.leftMargin = 0;
            layoutParams.width = displayWidth;
        }
        this.mSvPreview.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mSvPreview.getParent().requestLayout();
    }

    private int setCameraDisplayOrientation(int cameraId, Camera camera) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        NydusUtil.getCameraInfo(cameraId, info);
        int cameraOrientaion = NydusUtil.getRealCameraOrientation(cameraId);
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (cameraOrientaion + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (cameraOrientaion - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(result);
        return result;
    }

    private void stopPreview() {
        if (this.mCamera == null) {
            return;
        }
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mCamera.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mCamera = null;
    }

    @Override
    public void onConfInvitation(PTAppProtos.InvitationItem invitation) {
    }

    @Override
    public void onCallAccepted(PTAppProtos.InvitationItem item) {
        if (item == null || this.mInvitation == null) {
            return;
        }
        if (item.getMeetingNumber() == this.mInvitation.getMeetingNumber()) {
            this.ignoreCall();
        }
    }

    @Override
    public void onCallDeclined(PTAppProtos.InvitationItem item) {
        if (item == null || this.mInvitation == null) {
            return;
        }
        if (item.getMeetingNumber() == this.mInvitation.getMeetingNumber()) {
            IncomingCallManager.getInstance().insertDeclineCallMsg();
            this.ignoreCall();
        }
    }

    private void ignoreCall() {
        this.stopPreview();
        this.stopRing();
        IncomingCallManager.getInstance().ignoreCall();
        this.finish();
    }

    private String getScreenContent() {
        return StringUtil.safeString((String)this.mTxtCallerName.getText().toString()) + " " + this.getString(R.string.zm_msg_calling) + ", " + this.getString(R.string.zm_accessibility_someone_accept_decline_call_22876) + ", " + this.getString(R.string.zm_btn_accept);
    }
}

