/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.WakeUpMessagesReceiver;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.util.NotificationMgr;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.thirdparty.login.facebook.AuthToken;
import us.zoom.thirdparty.login.facebook.FBSessionStore;
import us.zoom.thirdparty.login.facebook.FacebookError;
import us.zoom.thirdparty.login.facebook.ServiceListener;

public class AutoRecoveryUtil
implements PTUI.IPTUIListener {
    private static final String TAG = AutoRecoveryUtil.class.getSimpleName();
    private static AutoRecoveryUtil instance = null;
    private AuthToken mFacebookAuthToken;
    private Handler mHandler = new Handler();
    private int loginFailTimes = 0;

    public static synchronized AutoRecoveryUtil getInstance() {
        if (instance == null) {
            instance = new AutoRecoveryUtil();
        }
        return instance;
    }

    private AutoRecoveryUtil() {
    }

    public void autoRecovery(Context context) {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard != null) {
            this.mFacebookAuthToken = FBSessionStore.getSession((Context)context, (String)"facebook-session");
            if (!mainboard.isInitialized()) {
                if (!NetworkUtil.hasDataNetwork((Context)context)) {
                    return;
                }
                VideoBoxApplication.getInstance().initPTMainboard();
                if (!(ZMActivity.hasActivityCreated() || WakeUpMessagesReceiver.hasMessageReceived() || PTApp.getInstance().isDirectCallAvailable())) {
                    VideoBoxApplication.getInstance().exit();
                    return;
                }
                PTUI.getInstance().addPTUIListener(this);
                this.autoLogin(context);
            } else {
                ZMActivity frontActivity = ZMActivity.getFrontActivity();
                if (frontActivity != null) {
                    return;
                }
                PTUI.getInstance().addPTUIListener(this);
                this.autoLogin(context);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void autoLogin(Context context) {
        if (!NetworkUtil.hasDataNetwork((Context)context)) {
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        if (ptApp == null) {
            return;
        }
        if (ptApp.isAuthenticating()) return;
        if (ptApp.isWebSignedOn()) {
            return;
        }
        ZMActivity frontActivity = ZMActivity.getFrontActivity();
        if (frontActivity != null) {
            return;
        }
        int loginType = ptApp.getPTLoginType();
        switch (loginType) {
            case 0: {
                if (this.mFacebookAuthToken == null) {
                    return;
                }
                if (this.mFacebookAuthToken.isSessionValid()) {
                    boolean shouldAutoSignIn = false;
                    if (this.mFacebookAuthToken.shouldExtendAccessToken()) {
                        try {
                            if (this.mFacebookAuthToken.extendAccessToken(context, (ServiceListener)new ExtendTokenServiceListener())) {
                                return;
                            }
                            shouldAutoSignIn = true;
                        }
                        catch (Exception exception) {}
                    } else {
                        shouldAutoSignIn = true;
                    }
                    if (!shouldAutoSignIn) return;
                    if (ptApp.autoSignin()) return;
                    this.handleTokenExpired(loginType);
                    return;
                }
                this.handleTokenExpired(loginType);
                return;
            }
            case 2: 
            case 100: 
            case 101: {
                if (ptApp.autoSignin()) return;
                this.handleTokenExpired(loginType);
                return;
            }
        }
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 8: {
                this.sinkIMLogin(result);
                break;
            }
            case 0: {
                this.sinkWebLogin(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void onFBTokenExtended(String token) {
        FBSessionStore.save((String)"facebook-session", (AuthToken)this.mFacebookAuthToken, (Context)VideoBoxApplication.getInstance());
        if (StringUtil.isEmptyOrNull((String)token)) {
            return;
        }
        long expiresInSeconds = (this.mFacebookAuthToken.expires - System.currentTimeMillis()) / 1000L;
        PTApp ptApp = PTApp.getInstance();
        ptApp.loginXmppServer(token);
        ptApp.loginWithFacebook(token, expiresInSeconds);
    }

    private void sinkWebLogin(long result) {
        ZMActivity frontActivity = ZMActivity.getFrontActivity();
        if (frontActivity != null) {
            return;
        }
        if (result == 0L) {
            this.loginFailTimes = 0;
        } else if (result == 1006L) {
            this.handleTokenExpired(PTApp.getInstance().getPTLoginType());
        } else {
            ++this.loginFailTimes;
            int factor = this.loginFailTimes <= 8 ? this.loginFailTimes : 8;
            long delay = (2 << factor) * 1000;
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    boolean imSignedOn;
                    PTApp ptApp = PTApp.getInstance();
                    if (ptApp == null) {
                        return;
                    }
                    IMHelper imHelper = ptApp.getIMHelper();
                    boolean bl = imSignedOn = imHelper != null && imHelper.isIMSignedOn();
                    if (!(ptApp.isWebSignedOn() || ptApp.isAuthenticating() || imSignedOn)) {
                        AutoRecoveryUtil.this.autoLogin((Context)VideoBoxApplication.getInstance());
                    }
                }
            }, delay);
        }
    }

    private void sinkIMLogin(long result) {
        ZMActivity frontActivity = ZMActivity.getFrontActivity();
        if (frontActivity != null) {
            return;
        }
        switch ((int)result) {
            case 2: 
            case 3: {
                int loginType = PTApp.getInstance().getPTLoginType();
                if (loginType == 97) break;
                if (result == 3L && loginType == 0) {
                    FBSessionStore.clear((String)"facebook-session", (Context)VideoBoxApplication.getInstance());
                }
                PTApp.getInstance().setRencentJid("");
                this.handleTokenExpired(loginType);
            }
        }
    }

    private void handleTokenExpired(int loginType) {
        PTApp.getInstance().setTokenExpired(true);
        NotificationMgr.showLoginExpiredNotification((Context)VideoBoxApplication.getInstance(), loginType);
    }

    class ExtendTokenServiceListener
    implements ServiceListener {
        ExtendTokenServiceListener() {
        }

        public void onComplete(Bundle values) {
            AutoRecoveryUtil.this.onFBTokenExtended(((AutoRecoveryUtil)AutoRecoveryUtil.this).mFacebookAuthToken.token);
        }

        public void onFacebookError(FacebookError e) {
            AutoRecoveryUtil.this.handleTokenExpired(0);
        }

        public void onError(Error e) {
            AutoRecoveryUtil.this.handleTokenExpired(0);
        }
    }
}

