/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import com.zipow.videobox.fragment.IMAddrBookSettingFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.PTApp;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class AddrBookSettingActivity
extends ZMActivity {
    private static final String ARG_IS_PHONE_NUMBER_REGISTERED_ON_START = "isPhoneNumberRegisteredOnStart";
    public static final int REQUEST_SET_PHONE_NUMBER = 100;
    public static final String ARG_RESULT_ENABLED = "enabled";
    public static final String ARG_RESULT_DISABLED = "disabled";
    private boolean mIsPhoneNumberRegisteredOnStart = false;

    public static void show(ZMActivity activity, int requestCode) {
        Intent intent = new Intent((Context)activity, AddrBookSettingActivity.class);
        ABContactsHelper contactHelper = PTApp.getInstance().getABContactsHelper();
        intent.putExtra(ARG_IS_PHONE_NUMBER_REGISTERED_ON_START, contactHelper != null && !StringUtil.isEmptyOrNull((String)contactHelper.getVerifiedPhoneNumber()));
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public static void show(Fragment f, int requestCode) {
        ZMActivity activity = (ZMActivity)f.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, AddrBookSettingActivity.class);
        ABContactsHelper contactHelper = PTApp.getInstance().getABContactsHelper();
        intent.putExtra(ARG_IS_PHONE_NUMBER_REGISTERED_ON_START, contactHelper != null && !StringUtil.isEmptyOrNull((String)contactHelper.getVerifiedPhoneNumber()));
        f.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public void finish() {
        ABContactsHelper contactHelper = PTApp.getInstance().getABContactsHelper();
        if (contactHelper != null && !StringUtil.isEmptyOrNull((String)contactHelper.getVerifiedPhoneNumber())) {
            if (!this.mIsPhoneNumberRegisteredOnStart) {
                ABContactsHelper.setAddrBookEnabledDone(true);
                Intent data = new Intent();
                data.putExtra(ARG_RESULT_ENABLED, true);
                this.setResult(-1, data);
            } else {
                this.setResult(0);
            }
        } else if (this.mIsPhoneNumberRegisteredOnStart) {
            Intent data = new Intent();
            data.putExtra(ARG_RESULT_DISABLED, true);
            this.setResult(-1, data);
        } else {
            this.setResult(0);
        }
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        Mainboard mainboard;
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mIsPhoneNumberRegisteredOnStart = intent.getBooleanExtra(ARG_IS_PHONE_NUMBER_REGISTERED_ON_START, false);
        }
        if ((mainboard = Mainboard.getMainboard()) == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            IMAddrBookSettingFragment.showInActivity(this);
        }
    }

    public void onResume() {
        super.onResume();
        if (!PTApp.getInstance().isWebSignedOn()) {
            this.setResult(0);
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1) {
            IMAddrBookSettingFragment f;
            String countryCode = null;
            String number = null;
            if (data != null) {
                countryCode = data.getStringExtra("countryCode");
                number = data.getStringExtra("number");
            }
            if ((f = IMAddrBookSettingFragment.findFragment(this)) != null) {
                f.onSetPhoneNumberDone(countryCode, number);
            }
        }
    }
}

