/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Base64;
import android.view.SurfaceHolder;
import com.zipow.nydus.NydusUtil;
import com.zipow.nydus.VideoCapCapability;
import com.zipow.nydus.VideoFormat;
import com.zipow.nydus.VideoSize;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VideoCapturer
implements Camera.PreviewCallback {
    private static final String TAG = VideoCapturer.class.getSimpleName();
    public static final float RATIO_4_3 = 1.3333334f;
    public static final float RATIO_16_9 = 1.7777778f;
    private static VideoCapturer instance = null;
    private HashMap<Integer, VideoCapCapability[]> mCapsMap = new HashMap();
    private Set<Integer> mFailedCameras = new HashSet<Integer>();
    private static final VideoCapCapability[] FALLBACK_CAPS = new VideoCapCapability[1];
    private long mNativeHandle = 0L;
    private int mCameraId = 0;
    private VideoFormat mVideoFormat;
    private Camera mCamera;
    private Object mLockCamera = new Object();
    private boolean mIsCapturing = false;
    private boolean mIsCapturePaused = false;
    private SurfaceHolder mSurfaceHolder;
    private boolean mIsSurfaceInvalidated = true;
    private byte[] mLastFrameData = null;
    private long mLastDataTimeStamp = 0L;
    private VideoFormat mLastDataFormat = null;
    private Handler mHandler = new Handler();
    private Runnable mDectectCapturePausedRunnable;
    private Listener mListener;
    private float mSendRatio = 1.3333334f;
    private int mCurBuffSize = 0;
    private int mMaxCaptureHeight = 0;

    public void initCameraCapabilities() {
        new Thread("VideoCapturer init thread"){

            @Override
            public void run() {
                if (!VideoCapturer.this.loadCapabilitiesFromConfig()) {
                    int num = NydusUtil.getNumberOfCameras();
                    for (int i = 0; i < num; ++i) {
                        VideoCapturer.this.getCameraCapability(i);
                    }
                    if (VideoCapturer.this.mCapsMap.size() == num) {
                        VideoCapturer.this.saveCapabilitiesToConfig();
                    }
                }
            }
        }.start();
    }

    private VideoCapturer() {
    }

    public static synchronized VideoCapturer getInstance() {
        if (instance == null) {
            instance = new VideoCapturer();
        }
        return instance;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public boolean init(long nativeHandle, int cameraId, int videoType, int width, int height, float fps) {
        int num = NydusUtil.getNumberOfCameras();
        if (cameraId < 0 || cameraId >= num) {
            return false;
        }
        this.mNativeHandle = nativeHandle;
        this.mCameraId = cameraId;
        this.mVideoFormat = new VideoFormat();
        if (videoType != 0) {
            this.mVideoFormat.videoType = videoType;
            this.mVideoFormat.width = width;
            this.mVideoFormat.height = height;
            this.mVideoFormat.fps = fps;
        } else if (!this.selectDefaultVideoFormat(this.mVideoFormat, cameraId)) {
            return true;
        }
        return true;
    }

    public void uninit() {
        this.mNativeHandle = 0L;
    }

    private boolean selectDefaultVideoFormat(VideoFormat videoFormat, int cameraId) {
        VideoCapCapability[] caps = this.getCameraCapability(cameraId);
        if (caps == null || caps.length == 0) {
            return false;
        }
        boolean hasNv21 = false;
        for (int i = 0; i < caps.length; ++i) {
            if (caps[i].videoType != 12) continue;
            hasNv21 = true;
        }
        int height = 10000;
        int idx = -1;
        int maxCaptureHeight = this.getMaxCaptureHeight();
        for (int i = 0; i < caps.length; ++i) {
            if (hasNv21 && caps[i].videoType != 12 || caps[i].height < maxCaptureHeight || caps[i].height >= height) continue;
            idx = i;
            height = caps[i].height;
        }
        if (idx >= 0) {
            float deltaLast = 100.0f;
            for (int i = 0; i < caps.length; ++i) {
                float delta;
                if (hasNv21 && caps[i].videoType != 12 || caps[i].height != height || !((delta = Math.abs((float)caps[i].width / (float)caps[i].height - 1.3333334f)) < deltaLast)) continue;
                deltaLast = delta;
                idx = i;
            }
        }
        if (idx < 0) {
            idx = 0;
        }
        videoFormat.videoType = caps[idx].videoType;
        videoFormat.width = caps[idx].width;
        videoFormat.height = caps[idx].height;
        videoFormat.fps = caps[idx].maxFps;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoFormat getOutputVideoFormat() {
        if (this.mVideoFormat == null) {
            Object object = this.mLockCamera;
            synchronized (object) {
                if (this.mCamera != null) {
                    this.mVideoFormat = this.getOutputVideoFormat(this.mCamera);
                }
            }
        }
        return this.mVideoFormat;
    }

    public VideoFormat getOutputVideoFormat(Camera camera) {
        if (camera == null) {
            return null;
        }
        Camera.Parameters params = null;
        Camera.Size size = null;
        try {
            params = camera.getParameters();
            size = params.getPreviewSize();
        }
        catch (Exception e) {
            return null;
        }
        VideoFormat format = new VideoFormat();
        format.videoType = this.imageFormat2NydusVideoType(params.getPreviewFormat());
        format.width = size.width;
        format.height = size.height;
        format.fps = (float)params.getPreviewFrameRate() / 1000.0f;
        return format;
    }

    public void setSurfaceHolder(SurfaceHolder holder) {
        this.mIsSurfaceInvalidated = false;
        this.mSurfaceHolder = holder;
        if (this.mIsCapturing && this.mIsCapturePaused) {
            new Thread("StartCameraThread"){

                @Override
                public void run() {
                    VideoCapturer.this.startCapture();
                }
            }.start();
        }
    }

    public void onSurfaceInvalidated() {
        this.mIsSurfaceInvalidated = true;
        if (this.mIsCapturing) {
            this.onCapturePaused();
        }
    }

    public boolean isCapturePaused() {
        return this.mIsCapturePaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startCapture() {
        Object object = this.mLockCamera;
        synchronized (object) {
            if (this.mIsCapturePaused && this.mIsSurfaceInvalidated) {
                this.mIsCapturing = true;
                this.startToDetectCapturePaused();
                return true;
            }
            if (this.mCamera != null && this.mIsCapturing) {
                return true;
            }
            if (this.mCamera == null) {
                boolean hasCameraFreezedBefore = PreferenceUtil.readBooleanValue("camera_is_freezed", false);
                if (hasCameraFreezedBefore) {
                    return false;
                }
                try {
                    this.mCamera = Camera.open((int)this.mCameraId);
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (this.mCamera == null) {
                return false;
            }
            Camera.Parameters params = null;
            try {
                params = this.mCamera.getParameters();
                params.setZoom(0);
            }
            catch (Exception e) {
                this.mCamera.release();
                this.mCamera = null;
                return false;
            }
            if (this.mVideoFormat.videoType != 0) {
                params.setPreviewFormat(this.nydusVideoType2ImageFormat(this.mVideoFormat.videoType));
                params.setPreviewSize(this.mVideoFormat.width, this.mVideoFormat.height);
            } else {
                this.mVideoFormat.videoType = 12;
                try {
                    params.setPreviewFormat(this.nydusVideoType2ImageFormat(this.mVideoFormat.videoType));
                }
                catch (Exception e) {
                    this.mCamera.release();
                    this.mCamera = null;
                    return false;
                }
                Camera.Size size = params.getPreviewSize();
                if (size == null) {
                    this.mCamera.release();
                    this.mCamera = null;
                    return false;
                }
                this.mVideoFormat.width = size.width;
                this.mVideoFormat.height = size.height;
                this.mVideoFormat.fps = 30.0f;
            }
            List focusModes = params.getSupportedFocusModes();
            if (focusModes != null) {
                String curFocusMode = params.getFocusMode();
                if (focusModes.indexOf("continuous-picture") >= 0) {
                    params.setFocusMode("continuous-picture");
                } else if (focusModes.indexOf("continuous-video") >= 0) {
                    params.setFocusMode("continuous-video");
                }
            }
            String preferredAntibanding = null;
            try {
                preferredAntibanding = this.getPreferredCameraAntibanding();
                List supportedAntibanding = params.getSupportedAntibanding();
                if (supportedAntibanding != null && supportedAntibanding.contains(preferredAntibanding)) {
                    params.setAntibanding(preferredAntibanding);
                }
            }
            catch (Exception supportedAntibanding) {
                // empty catch block
            }
            try {
                this.mCamera.setParameters(params);
            }
            catch (Exception e) {
                this.mCamera.release();
                this.mCamera = null;
                return false;
            }
            byte[] buff = this.newCallbackBuffer(params);
            if (buff != null) {
                this.mCamera.addCallbackBuffer(buff);
                this.mCurBuffSize = buff.length;
            }
            if ((buff = this.newCallbackBuffer(params)) != null) {
                this.mCamera.addCallbackBuffer(buff);
            }
            this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            try {
                if (this.mSurfaceHolder != null) {
                    this.mCamera.setPreviewDisplay(this.mSurfaceHolder);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mCamera.startPreview();
            }
            catch (Exception e) {
                this.mCamera.setPreviewCallback(null);
                this.mCamera.release();
                this.mCamera = null;
                return false;
            }
            this.mIsCapturing = true;
            this.startToDetectCapturePaused();
        }
        return true;
    }

    private String getPreferredCameraAntibanding() {
        String antibanding = PreferenceUtil.readStringValue("camera_antibanding", null);
        return antibanding;
    }

    public boolean isCapturing() {
        return this.mIsCapturing;
    }

    private void startToDetectCapturePaused() {
        this.mLastDataTimeStamp = 0L;
        if (this.mDectectCapturePausedRunnable == null) {
            this.mDectectCapturePausedRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!VideoCapturer.this.mIsCapturing) {
                        return;
                    }
                    long time = SystemClock.uptimeMillis();
                    if (!VideoCapturer.this.mIsCapturePaused && VideoCapturer.this.mLastDataTimeStamp != 0L && time - VideoCapturer.this.mLastDataTimeStamp > 1000L && VideoCapturer.this.mSurfaceHolder != null) {
                        if (VideoCapturer.this.mIsSurfaceInvalidated) {
                            VideoCapturer.this.onCapturePaused();
                        } else if (time - VideoCapturer.this.mLastDataTimeStamp > 1500L) {
                            // empty if block
                        }
                    }
                    if (VideoCapturer.this.mIsCapturePaused && VideoCapturer.this.mLastDataFormat != null && VideoCapturer.this.mLastFrameData != null) {
                        VideoCapturer.this.onFrameCaptured(VideoCapturer.this.mNativeHandle, VideoCapturer.this.mLastFrameData, VideoCapturer.this.mLastDataFormat);
                    }
                    if (VideoCapturer.this.mDectectCapturePausedRunnable != null) {
                        VideoCapturer.this.mHandler.postDelayed(VideoCapturer.this.mDectectCapturePausedRunnable, 500L);
                    }
                }
            };
        }
        this.mHandler.removeCallbacks(this.mDectectCapturePausedRunnable);
        this.mHandler.postDelayed(this.mDectectCapturePausedRunnable, 500L);
    }

    private void stopToDetectCapturePaused() {
        if (this.mDectectCapturePausedRunnable != null) {
            this.mHandler.removeCallbacks(this.mDectectCapturePausedRunnable);
            this.mDectectCapturePausedRunnable = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCapturePaused() {
        Object object = this.mLockCamera;
        synchronized (object) {
            this.stopCapture(true);
            this.mIsCapturePaused = true;
            this.mIsCapturing = true;
            if (this.mListener != null) {
                this.mListener.onCapturePaused();
            }
        }
    }

    private void onCaptureResumed() {
        this.mIsCapturePaused = false;
        if (this.mListener != null) {
            this.mListener.onCaptureResumed();
        }
    }

    public VideoSize getVideoSize() {
        VideoSize size = new VideoSize();
        if (this.mVideoFormat != null && this.mVideoFormat.width != 0 && this.mVideoFormat.height != 0) {
            size.width = this.mVideoFormat.width;
            size.height = this.mVideoFormat.height;
        } else {
            VideoFormat fmt = new VideoFormat();
            int cameraId = -1;
            int num = NydusUtil.getNumberOfCameras();
            if (num > 0 && (cameraId = NydusUtil.getFrontCameraId()) < 0) {
                cameraId = 0;
            }
            if (cameraId >= 0 && this.selectDefaultVideoFormat(fmt, cameraId)) {
                size.width = fmt.width;
                size.height = fmt.height;
            } else {
                size.width = 640;
                size.height = 480;
            }
        }
        if (size.width > 0 && size.height > 0) {
            if ((float)(size.width / size.height) > this.mSendRatio) {
                size.width = Math.round((float)size.height * this.mSendRatio);
            } else {
                size.height = Math.round((float)size.width / this.mSendRatio);
            }
        }
        return size;
    }

    public boolean stopCapture() {
        return this.stopCapture(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopCapture(boolean isPause) {
        Object object = this.mLockCamera;
        synchronized (object) {
            if (!this.mIsCapturing) {
                return true;
            }
            if (this.mCamera != null) {
                long startTime = System.currentTimeMillis();
                try {
                    if (this.mIsCapturing) {
                        this.mCamera.setPreviewCallback(null);
                        this.mCamera.stopPreview();
                    }
                    this.mCamera.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mCamera = null;
                long l = System.currentTimeMillis();
            }
            this.mIsCapturing = false;
            if (!isPause) {
                this.stopToDetectCapturePaused();
            }
        }
        return true;
    }

    private byte[] newCallbackBuffer(Camera.Parameters params) {
        Camera.Size frameSize = params.getPreviewSize();
        if (frameSize == null) {
            return null;
        }
        int size = frameSize.width * frameSize.height * ImageFormat.getBitsPerPixel((int)params.getPreviewFormat()) / 8;
        try {
            byte[] buff = new byte[size];
            return buff;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        Object object = this.mLockCamera;
        synchronized (object) {
            if (!this.mIsCapturing || this.mCamera == null || data == null || data.length != this.mCurBuffSize) {
                return;
            }
            if (this.isCapturePaused()) {
                this.onCaptureResumed();
            }
            this.mLastFrameData = data;
            this.mLastDataTimeStamp = SystemClock.uptimeMillis();
            try {
                VideoFormat format;
                this.mLastDataFormat = format = this.getOutputVideoFormat();
                if (this.mNativeHandle != 0L) {
                    this.onFrameCaptured(this.mNativeHandle, data, format);
                    camera.addCallbackBuffer(data);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoCapCapability[] getCameraCapability(int cameraId) {
        Class<VideoCapCapability> clazz = VideoCapCapability.class;
        synchronized (VideoCapCapability.class) {
            VideoCapCapability[] retArrCaps;
            VideoCapCapability[] caps;
            if (this.mCapsMap != null) {
                caps = this.getCapsArrayFromCapsMap(this.mCapsMap, cameraId);
                if (caps != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return caps;
                }
                if (this.mFailedCameras.contains(cameraId)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return FALLBACK_CAPS;
                }
            }
            if (this.mCapsMap == null) {
                this.mCapsMap = new HashMap();
            }
            caps = new ArrayList();
            Camera camera = null;
            try {
                camera = Camera.open((int)cameraId);
            }
            catch (Exception e) {
                this.mFailedCameras.add(cameraId);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return FALLBACK_CAPS;
            }
            if (camera == null) {
                this.mFailedCameras.add(cameraId);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return FALLBACK_CAPS;
            }
            Camera.Parameters params = null;
            List formats = null;
            try {
                params = camera.getParameters();
                formats = params.getSupportedPreviewFormats();
            }
            catch (Exception e) {
                this.mFailedCameras.add(cameraId);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return FALLBACK_CAPS;
            }
            if (formats != null) {
                for (int formatIndex = 0; formatIndex < formats.size(); ++formatIndex) {
                    int format = (Integer)formats.get(formatIndex);
                    int vt = this.imageFormat2NydusVideoType(format);
                    ArrayList<int[]> ranges = null;
                    try {
                        ranges = params.getSupportedPreviewFpsRange();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (ranges == null || ranges.size() == 0) {
                        ranges = new ArrayList<int[]>();
                        ranges.add(new int[]{1000, 30000});
                    }
                    for (int rangeIndex = 0; rangeIndex < ranges.size(); ++rangeIndex) {
                        int[] range = (int[])ranges.get(rangeIndex);
                        int minFps = range[0];
                        int maxFps = range[1];
                        List sizes = null;
                        try {
                            sizes = params.getSupportedPreviewSizes();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (sizes == null) continue;
                        for (int sizeIndex = 0; sizeIndex < sizes.size(); ++sizeIndex) {
                            Camera.Size size = (Camera.Size)sizes.get(sizeIndex);
                            if (size == null) continue;
                            VideoCapCapability cap = new VideoCapCapability();
                            cap.videoType = vt;
                            cap.minFps = (float)minFps / 1000.0f;
                            cap.maxFps = (float)maxFps / 1000.0f;
                            cap.width = size.width;
                            cap.height = size.height;
                            caps.add(cap);
                        }
                    }
                }
            }
            camera.release();
            VideoCapCapability[] capsArray = new VideoCapCapability[caps.size()];
            if (caps.size() > 0) {
                capsArray = caps.toArray(capsArray);
                this.mCapsMap.put(cameraId, capsArray);
            }
            if ((retArrCaps = this.getCapsArrayFromCapsMap(this.mCapsMap, cameraId)) == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return FALLBACK_CAPS;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return retArrCaps;
        }
    }

    private VideoCapCapability[] getCapsArrayFromCapsMap(HashMap<Integer, VideoCapCapability[]> capsMap, int cameraId) {
        VideoCapCapability[] caps = this.mCapsMap.get(cameraId);
        if (caps == null) {
            return null;
        }
        if ("LENOVO".equals(Build.MANUFACTURER) && "Lenovo K900".equals(Build.MODEL)) {
            ArrayList<VideoCapCapability> list = new ArrayList<VideoCapCapability>();
            for (VideoCapCapability cap : caps) {
                if (cap.width != 800 && cap.height == 480) continue;
                list.add(cap);
            }
            VideoCapCapability[] capsRet = new VideoCapCapability[list.size()];
            list.toArray(capsRet);
            return capsRet;
        }
        return caps;
    }

    private boolean loadCapabilitiesFromConfig() {
        String strData = PreferenceUtil.readStringValue("camera_capabilities", null);
        if (strData == null || strData.length() == 0) {
            return false;
        }
        byte[] buff = null;
        try {
            buff = Base64.decode((String)strData, (int)8);
        }
        catch (Exception e) {
            return false;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(buff);
        try {
            ObjectInputStream is = new ObjectInputStream(bis);
            Object obj = is.readObject();
            this.mCapsMap = (HashMap)obj;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void saveCapabilitiesToConfig() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(this.mCapsMap);
        }
        catch (IOException e) {
            return;
        }
        byte[] buff = bos.toByteArray();
        String strData = Base64.encodeToString((byte[])buff, (int)8);
        PreferenceUtil.saveStringValue("camera_capabilities", strData);
    }

    private int imageFormat2NydusVideoType(int format) {
        switch (format) {
            case 17: {
                return 12;
            }
            case 20: {
                return 3;
            }
            case 842094169: {
                return 2;
            }
        }
        return 0;
    }

    private int nydusVideoType2ImageFormat(int vt) {
        switch (vt) {
            case 12: {
                return 17;
            }
            case 3: {
                return 20;
            }
            case 2: {
                return 842094169;
            }
        }
        return 0;
    }

    private int getMaxCaptureHeight() {
        if (this.mMaxCaptureHeight > 0) {
            return this.mMaxCaptureHeight;
        }
        this.mMaxCaptureHeight = 480;
        return this.mMaxCaptureHeight;
    }

    private native void onFrameCaptured(long var1, byte[] var3, VideoFormat var4);

    static {
        VideoCapturer.FALLBACK_CAPS[0] = new VideoCapCapability();
        VideoCapturer.FALLBACK_CAPS[0].videoType = 12;
        VideoCapturer.FALLBACK_CAPS[0].minFps = 1.0f;
        VideoCapturer.FALLBACK_CAPS[0].maxFps = 30.0f;
        VideoCapturer.FALLBACK_CAPS[0].width = 640;
        VideoCapturer.FALLBACK_CAPS[0].height = 480;
    }

    public static interface Listener {
        public void onCapturePaused();

        public void onCaptureResumed();
    }
}

