/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.os.Build;
import com.zipow.nydus.UVCUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class UVCPermissionUtil {
    private static final String TAG = UVCUtil.class.getSimpleName();
    private static UVCPermissionUtil instance;
    private Context mContext;
    private UVCUtil mUVCUtil;
    private HashSet<UsbDevice> mNewDevices = new HashSet();
    private UVCUtil.IUVCListener mUVCListener = new UVCUtil.IUVCListener(){

        @Override
        public void onPermissionGranted(UsbDevice device, boolean granted) {
            UVCPermissionUtil.this.mNewDevices.remove(device);
        }

        @Override
        public void onDeviceAttached(UsbDevice device) {
            UVCPermissionUtil.this.mNewDevices.add(device);
        }

        @Override
        public void onDeviceDetatched(UsbDevice device) {
            UVCPermissionUtil.this.mNewDevices.remove(device);
        }
    };

    public static synchronized UVCPermissionUtil getInstance(Context context) {
        if (Build.VERSION.SDK_INT < UVCUtil.getMinimumSupportedSdkInt()) {
            return null;
        }
        if (instance == null && context != null) {
            instance = new UVCPermissionUtil(context);
        }
        return instance;
    }

    private UVCPermissionUtil(Context context) {
        this.mContext = context.getApplicationContext();
        this.mUVCUtil = UVCUtil.getInstance(this.mContext);
        if (this.mUVCUtil != null) {
            this.mUVCUtil.addUVCListener(this.mUVCListener);
            List<UsbDevice> devices = this.mUVCUtil.getUVCDevices();
            if (devices != null) {
                this.mNewDevices.addAll(devices);
            }
        }
    }

    public void addUVCListener(UVCUtil.IUVCListener l) {
        this.mUVCUtil.addUVCListener(l);
    }

    public void removeUVCListener(UVCUtil.IUVCListener l) {
        this.mUVCUtil.removeUVCListener(l);
    }

    public Set<UsbDevice> getDevicesWithPermissionNotRequested() {
        List<UsbDevice> allDevices = this.mUVCUtil.getUVCDevices();
        if (allDevices != null) {
            Iterator<UsbDevice> itr = this.mNewDevices.iterator();
            while (itr.hasNext()) {
                UsbDevice device = itr.next();
                if (allDevices.contains(device) && !this.mUVCUtil.hasPermission(device)) continue;
                itr.remove();
            }
        }
        HashSet<UsbDevice> devices = new HashSet<UsbDevice>();
        devices.addAll(this.mNewDevices);
        return devices;
    }

    public void requestPermission(UsbDevice device) {
        this.mUVCUtil.requestPermission(device);
        this.mNewDevices.remove(device);
    }
}

