/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.os.Build;
import com.zipow.nydus.DeviceFilter;
import com.zipow.nydus.USBDeviceInfo;
import com.zipow.nydus.USBMonitor;
import com.zipow.nydus.UVCCamera;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class UVCDevice {
    private static final String TAG = UVCDevice.class.getSimpleName();
    private USBMonitor mUSBMonitor = null;
    private List<UVCCamera> mUVCCamera = null;
    private DeviceFilter mFilter = null;
    private static UVCDevice instance = null;
    private long mNotificationNativePtr = 0L;
    private Object mLockCamera = new Object();
    @SuppressLint(value={"NewApi"})
    private final USBMonitor.OnDeviceConnectListener mOnDeviceConnectListener = new USBMonitor.OnDeviceConnectListener(){

        @Override
        public void onAttach(UsbDevice device) {
            if (UVCDevice.this.mNotificationNativePtr != 0L) {
                UVCDevice.this.nativeDeviceAttach(UVCDevice.this.mNotificationNativePtr, device.getDeviceId(), device.getVendorId(), device.getProductId(), 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onConnect(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock, boolean createNew) {
            boolean res = false;
            Object object = UVCDevice.this.mLockCamera;
            synchronized (object) {
                for (UVCCamera camera : UVCDevice.this.mUVCCamera) {
                    if (!camera.IsSameCamera(ctrlBlock).booleanValue()) continue;
                    res = true == camera.open(ctrlBlock) ? camera.StartRecord() : false;
                    break;
                }
            }
            return res;
        }

        @Override
        public void onDisconnect(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock) {
        }

        @Override
        public void onDettach(UsbDevice device) {
            if (UVCDevice.this.mNotificationNativePtr != 0L) {
                UVCDevice.this.nativeDeviceAttach(UVCDevice.this.mNotificationNativePtr, device.getDeviceId(), device.getVendorId(), device.getProductId(), 0);
            }
        }
    };

    public static synchronized UVCDevice getInstance(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            if (instance == null) {
                instance = new UVCDevice(context.getApplicationContext());
            }
            return instance;
        }
        return null;
    }

    private UVCDevice(Context context) {
        this.mUSBMonitor = new USBMonitor(context, this.mOnDeviceConnectListener);
        this.mFilter = DeviceFilter.buildUVCDeviceFilter();
        this.mUVCCamera = new ArrayList<UVCCamera>();
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.register();
        }
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    public void unInit() {
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.unregister();
        }
    }

    @SuppressLint(value={"NewApi"})
    public USBDeviceInfo[] getUVCDeviceList() {
        List<UsbDevice> usbDeviceList = this.mUSBMonitor.getDeviceList(this.mFilter);
        if (usbDeviceList == null) {
            return new USBDeviceInfo[0];
        }
        USBDeviceInfo[] usbDeviceInfoArray = new USBDeviceInfo[usbDeviceList.size()];
        Iterator<UsbDevice> iterator = usbDeviceList.iterator();
        int sizeIndex = 0;
        if (Build.VERSION.SDK_INT >= 21) {
            UsbDevice device;
            TreeMap<String, UsbDevice> deviceMap = new TreeMap<String, UsbDevice>(String.CASE_INSENSITIVE_ORDER);
            while (iterator.hasNext()) {
                device = iterator.next();
                if (device == null) continue;
                deviceMap.put(device.getProductName() + device.getDeviceId(), device);
            }
            Set keys = deviceMap.keySet();
            for (String key : keys) {
                device = (UsbDevice)deviceMap.get(key);
                if (device == null) continue;
                USBDeviceInfo deviceInfo = new USBDeviceInfo();
                deviceInfo.deviceId = device.getDeviceId();
                deviceInfo.vendorId = device.getVendorId();
                deviceInfo.productId = device.getProductId();
                usbDeviceInfoArray[sizeIndex] = deviceInfo;
                ++sizeIndex;
            }
        } else {
            while (iterator.hasNext()) {
                UsbDevice device = iterator.next();
                if (device == null) continue;
                USBDeviceInfo deviceInfo = new USBDeviceInfo();
                deviceInfo.deviceId = device.getDeviceId();
                deviceInfo.vendorId = device.getVendorId();
                deviceInfo.productId = device.getProductId();
                usbDeviceInfoArray[sizeIndex] = deviceInfo;
                ++sizeIndex;
            }
        }
        return usbDeviceInfoArray;
    }

    @SuppressLint(value={"NewApi"})
    public String GetDeviceProductName(int deviceId) {
        List<UsbDevice> usbDeviceList = this.mUSBMonitor.getDeviceList(this.mFilter);
        for (UsbDevice device : usbDeviceList) {
            if (deviceId != device.getDeviceId() || Build.VERSION.SDK_INT < 21) continue;
            String deviceName = device.getProductName();
            if (deviceName != null) {
                return deviceName;
            }
            return "";
        }
        return "";
    }

    @SuppressLint(value={"NewApi"})
    public boolean StartCapture(int deviceId, int vendorId, int productId, long nativeCamera) {
        Iterator<UVCCamera> iterator = this.mUVCCamera.iterator();
        while (iterator.hasNext()) {
            UVCCamera camera = iterator.next();
            if (!camera.IsSameCamera(deviceId, vendorId, productId).booleanValue()) continue;
            camera.StopRecord();
            camera.destroy();
            iterator.remove();
            break;
        }
        List<UsbDevice> usbDeviceList = this.mUSBMonitor.getDeviceList(this.mFilter);
        for (UsbDevice device : usbDeviceList) {
            if (device == null || deviceId != device.getDeviceId() || vendorId != device.getVendorId() || productId != device.getProductId()) continue;
            boolean ret = false;
            UVCCamera newUVCCamera = new UVCCamera(deviceId, vendorId, productId);
            newUVCCamera.setNativePtr(nativeCamera);
            this.mUVCCamera.add(newUVCCamera);
            ret = this.mUSBMonitor.requestPermission(device);
            return ret;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean StopCapture(int deviceId, int vendorId, int productId) {
        Object object = this.mLockCamera;
        synchronized (object) {
            Iterator<UVCCamera> iterator = this.mUVCCamera.iterator();
            while (iterator.hasNext()) {
                UVCCamera camera = iterator.next();
                if (!camera.IsSameCamera(deviceId, vendorId, productId).booleanValue()) continue;
                this.mUSBMonitor.closeDevice(deviceId);
                camera.StopRecord();
                camera.destroy();
                iterator.remove();
            }
        }
        return true;
    }

    public boolean SetNotificationNativePtr(long id_notification) {
        this.mNotificationNativePtr = id_notification;
        return true;
    }

    private final native void nativeDeviceAttach(long var1, int var3, int var4, int var5, int var6);
}

