/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import android.text.TextUtils;
import com.zipow.nydus.USBDeviceInfo;
import com.zipow.nydus.USBMonitor;

public class UVCCamera {
    private static final String TAG = UVCCamera.class.getSimpleName();
    private static final String DEFAULT_USBFS = "/dev/bus/usb";
    private static boolean isLoaded;
    private USBMonitor.UsbControlBlock mCtrlBlock;
    private final int mVendorId;
    private final int mProductId;
    private final int mDeviceId;
    private long mNativePtr;

    public void setNativePtr(long nativeCamera) {
        this.mNativePtr = nativeCamera;
    }

    public UVCCamera(int deviceId, int VendorId, int ProductId) {
        this.mDeviceId = deviceId;
        this.mVendorId = VendorId;
        this.mProductId = ProductId;
    }

    public Boolean IsSameCamera(USBMonitor.UsbControlBlock ctrlBlock) {
        if (this.mDeviceId == ctrlBlock.getDeviceId() && this.mVendorId == ctrlBlock.getVendorId() && this.mProductId == ctrlBlock.getProductId()) {
            return true;
        }
        return false;
    }

    public Boolean IsSameCamera(USBDeviceInfo DeviceInfo2) {
        if (this.mDeviceId == DeviceInfo2.deviceId && this.mVendorId == DeviceInfo2.vendorId && this.mProductId == DeviceInfo2.productId) {
            return true;
        }
        return false;
    }

    public Boolean IsSameCamera(int deviceId, int vendorId, int productId) {
        if (this.mDeviceId == deviceId && this.mVendorId == vendorId && this.mProductId == productId) {
            return true;
        }
        return false;
    }

    private final String getUSBFSName(USBMonitor.UsbControlBlock ctrlBlock) {
        String[] v;
        String result = null;
        String name = ctrlBlock.getDeviceName();
        String[] stringArray = v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
        if (v != null && v.length > 2) {
            StringBuilder sb = new StringBuilder(v[0]);
            for (int i = 1; i < v.length - 2; ++i) {
                sb.append("/").append(v[i]);
            }
            result = sb.toString();
        }
        if (TextUtils.isEmpty(result)) {
            result = DEFAULT_USBFS;
        }
        return result;
    }

    public Boolean open(USBMonitor.UsbControlBlock ctrlBlock) {
        this.mCtrlBlock = ctrlBlock;
        if (0 == UVCCamera.nativeConnect(this.mNativePtr, this.mCtrlBlock.getVendorId(), this.mCtrlBlock.getProductId(), this.mCtrlBlock.getFileDescriptor(), this.getUSBFSName(this.mCtrlBlock))) {
            return true;
        }
        return false;
    }

    public void close() {
        this.mNativePtr = 0L;
        this.mCtrlBlock = null;
    }

    public void destroy() {
        this.close();
    }

    public Boolean StartRecord() {
        if (this.mCtrlBlock != null && this.mNativePtr != 0L) {
            if (0 == UVCCamera.nativeStart(this.mNativePtr)) {
                return true;
            }
            return false;
        }
        return false;
    }

    public void StopRecord() {
        if (this.mCtrlBlock != null && this.mNativePtr != 0L) {
            UVCCamera.nativeStop(this.mNativePtr);
        }
    }

    private static final native int nativeConnect(long var0, int var2, int var3, int var4, String var5);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    static {
        if (!isLoaded) {
            // empty if block
        }
    }
}

