/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import android.util.SparseArray;
import com.zipow.nydus.DeviceFilter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import us.zoom.androidlib.util.CollectionsUtil;

public class USBMonitor {
    private static final String TAG = USBMonitor.class.getSimpleName();
    private static final String ACTION_USB_PERMISSION = "com.zoomus.USB_PERMISSION";
    private final HashMap<UsbDevice, UsbControlBlock> mCtrlBlocks = new HashMap();
    private final WeakReference<Context> mWeakContext;
    private final UsbManager mUsbManager;
    private PendingIntent mPermissionIntent;
    private final OnDeviceConnectListener mOnDeviceConnectListener;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            String action = intent.getAction();
            if (USBMonitor.ACTION_USB_PERMISSION.equals(action)) {
                UsbDevice device2 = (UsbDevice)intent.getParcelableExtra("device");
                if (intent.getBooleanExtra("permission", false) && device2 != null) {
                    USBMonitor.this.processConnect(device2);
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                if (USBMonitor.this.mOnDeviceConnectListener != null) {
                    UsbDevice device3 = (UsbDevice)intent.getParcelableExtra("device");
                    USBMonitor.this.mOnDeviceConnectListener.onAttach(device3);
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
                UsbControlBlock ctrlBlock = null;
                HashMap hashMap = USBMonitor.this.mCtrlBlocks;
                synchronized (hashMap) {
                    ctrlBlock = (UsbControlBlock)USBMonitor.this.mCtrlBlocks.remove(device);
                }
                if (ctrlBlock != null) {
                    ctrlBlock.close();
                }
                if (USBMonitor.this.mOnDeviceConnectListener != null) {
                    USBMonitor.this.mOnDeviceConnectListener.onDettach(device);
                }
            }
        }
    };

    public USBMonitor(Context context, OnDeviceConnectListener listener) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        this.mOnDeviceConnectListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.unregister();
        HashMap<UsbDevice, UsbControlBlock> hashMap = this.mCtrlBlocks;
        synchronized (hashMap) {
            Set<UsbDevice> keys = this.mCtrlBlocks.keySet();
            if (!CollectionsUtil.isCollectionEmpty(keys)) {
                for (UsbDevice key : keys) {
                    UsbControlBlock ctrlBlock = this.mCtrlBlocks.remove(key);
                    ctrlBlock.close();
                }
                this.mCtrlBlocks.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void closeDevice(int deviceId) {
        HashMap<UsbDevice, UsbControlBlock> hashMap = this.mCtrlBlocks;
        synchronized (hashMap) {
            Set<UsbDevice> keys = this.mCtrlBlocks.keySet();
            if (!CollectionsUtil.isCollectionEmpty(keys)) {
                for (UsbDevice key : keys) {
                    if (deviceId != key.getDeviceId()) continue;
                    UsbControlBlock ctrlBlock = this.mCtrlBlocks.remove(key);
                    ctrlBlock.close();
                }
            }
        }
    }

    public void register() {
        this.unregister();
        Context context = (Context)this.mWeakContext.get();
        if (context != null) {
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            context.registerReceiver(this.mUsbReceiver, filter);
        }
    }

    public void unregister() {
        if (this.mPermissionIntent != null) {
            Context context = (Context)this.mWeakContext.get();
            if (context != null) {
                context.unregisterReceiver(this.mUsbReceiver);
            }
            this.mPermissionIntent = null;
        }
    }

    public List<UsbDevice> getDeviceList() {
        return this.getDeviceList(null);
    }

    public List<UsbDevice> getDeviceList(DeviceFilter filter) {
        HashMap<String, UsbDevice> deviceList = this.getUsbDeviceList(this.mUsbManager);
        Context context = (Context)this.mWeakContext.get();
        ArrayList<UsbDevice> result = null;
        if (deviceList != null) {
            result = new ArrayList<UsbDevice>();
            for (UsbDevice device : deviceList.values()) {
                if (filter != null && !filter.matches(context, device)) continue;
                result.add(device);
            }
        }
        return result;
    }

    public Iterator<UsbDevice> getDevices() {
        Iterator<UsbDevice> iterator = null;
        HashMap<String, UsbDevice> list = this.getUsbDeviceList(this.mUsbManager);
        if (list != null) {
            iterator = list.values().iterator();
        }
        return iterator;
    }

    public void dumpDevices() {
        HashMap<String, UsbDevice> list = this.getUsbDeviceList(this.mUsbManager);
        if (list != null) {
            Set<String> keys = list.keySet();
            if (!CollectionsUtil.isCollectionEmpty(keys)) {
                for (String key : keys) {
                    Log.i((String)TAG, (String)("key=" + key + ":" + list.get(key)));
                }
            } else {
                Log.i((String)TAG, (String)"no device");
            }
        } else {
            Log.i((String)TAG, (String)"no device");
        }
    }

    public boolean hasPermission(UsbDevice device) {
        return this.mUsbManager.hasPermission(device);
    }

    @SuppressLint(value={"NewApi"})
    public boolean requestPermission(UsbDevice device) {
        if (device != null) {
            if (this.mPermissionIntent != null && !this.mUsbManager.hasPermission(device)) {
                this.mUsbManager.requestPermission(device, this.mPermissionIntent);
            } else if (this.mUsbManager.hasPermission(device)) {
                return this.processConnect(device);
            }
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    private HashMap<String, UsbDevice> getUsbDeviceList(UsbManager usbManager) {
        HashMap deviceList = null;
        try {
            deviceList = usbManager.getDeviceList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processConnect(UsbDevice device) {
        UsbControlBlock ctrlBlock;
        boolean createNew = false;
        HashMap<UsbDevice, UsbControlBlock> hashMap = this.mCtrlBlocks;
        synchronized (hashMap) {
            ctrlBlock = this.mCtrlBlocks.get(device);
            if (ctrlBlock == null) {
                ctrlBlock = new UsbControlBlock(this, device);
                this.mCtrlBlocks.put(device, ctrlBlock);
                createNew = true;
            }
        }
        if (this.mOnDeviceConnectListener != null) {
            return this.mOnDeviceConnectListener.onConnect(device, ctrlBlock, createNew);
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public final class UsbControlBlock {
        private final WeakReference<USBMonitor> mWeakMonitor;
        private final WeakReference<UsbDevice> mWeakDevice;
        private UsbDeviceConnection mConnection;
        private final SparseArray<UsbInterface> mInterfaces = new SparseArray();

        public UsbControlBlock(USBMonitor monitor, UsbDevice device) {
            this.mWeakMonitor = new WeakReference<USBMonitor>(monitor);
            this.mWeakDevice = new WeakReference<UsbDevice>(device);
            this.mConnection = USBMonitor.this.mUsbManager.openDevice(device);
        }

        public UsbDevice getDevice() {
            return (UsbDevice)this.mWeakDevice.get();
        }

        public String getDeviceName() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceName() : "";
        }

        public UsbDeviceConnection getUsbDeviceConnection() {
            return this.mConnection;
        }

        public int getFileDescriptor() {
            return this.mConnection != null ? this.mConnection.getFileDescriptor() : 0;
        }

        public byte[] getRawDescriptors() {
            return this.mConnection != null ? this.mConnection.getRawDescriptors() : null;
        }

        public int getDeviceId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceId() : 0;
        }

        public int getVendorId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getVendorId() : 0;
        }

        public int getProductId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getProductId() : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"NewApi"})
        public void close(int interfaceIndex) {
            UsbInterface intf = null;
            SparseArray<UsbInterface> sparseArray = this.mInterfaces;
            synchronized (sparseArray) {
                intf = (UsbInterface)this.mInterfaces.get(interfaceIndex);
                if (intf != null) {
                    this.mInterfaces.delete(interfaceIndex);
                    this.mConnection.releaseInterface(intf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"NewApi"})
        public void close() {
            if (this.mConnection != null) {
                USBMonitor monitor = (USBMonitor)this.mWeakMonitor.get();
                if (monitor != null) {
                    UsbDevice device = (UsbDevice)this.mWeakDevice.get();
                    if (USBMonitor.this.mOnDeviceConnectListener != null) {
                        USBMonitor.this.mOnDeviceConnectListener.onDisconnect(device, this);
                    }
                    monitor.mCtrlBlocks.remove(device);
                }
                SparseArray<UsbInterface> sparseArray = this.mInterfaces;
                synchronized (sparseArray) {
                    int n = this.mInterfaces.size();
                    for (int i = 0; i < n; ++i) {
                        int key = this.mInterfaces.keyAt(i);
                        UsbInterface intf = (UsbInterface)this.mInterfaces.get(key);
                        boolean bl = this.mConnection.releaseInterface(intf);
                    }
                }
                this.mConnection.close();
                this.mConnection = null;
            }
        }
    }

    public static interface OnDeviceConnectListener {
        public void onAttach(UsbDevice var1);

        public void onDettach(UsbDevice var1);

        public boolean onConnect(UsbDevice var1, UsbControlBlock var2, boolean var3);

        public void onDisconnect(UsbDevice var1, UsbControlBlock var2);
    }
}

