/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import com.zipow.nydus.SysBusUsbDevice;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class SysBusUsbManager {
    private HashMap<String, SysBusUsbDevice> myUsbDevices = new HashMap();
    private static final String PATH_SYS_BUS_USB = "/sys/bus/usb/devices/";
    private static final String DEVICE_START = "__DEV_START__";
    private static final String DEVICE_END = "__DEV_END__";

    public HashMap<String, SysBusUsbDevice> getUsbDevices() {
        this.populateList(PATH_SYS_BUS_USB);
        return this.myUsbDevices;
    }

    private void populateList(String path) {
        this.myUsbDevices.clear();
        File dir = new File(path);
        if (!dir.isDirectory()) {
            return;
        }
        for (File child : dir.listFiles()) {
            if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
            String parentPath = child.getAbsolutePath() + File.separator;
            SysBusUsbDevice usb = new SysBusUsbDevice();
            usb.setDevicePath(parentPath);
            usb.setBusNumber(this.readFileContents(parentPath + "busnum"));
            usb.setDeviceClass(this.readFileContents(parentPath + "bDeviceClass"));
            usb.setDeviceNumber(this.readFileContents(parentPath + "devnum"));
            usb.setDeviceProtocol(this.readFileContents(parentPath + "bDeviceProtocol"));
            usb.setDeviceSubClass(this.readFileContents(parentPath + "bDeviceSubClass"));
            usb.setMaxPower(this.readFileContents(parentPath + "bMaxPower"));
            usb.setPID(this.readFileContents(parentPath + "idProduct"));
            usb.setReportedProductName(this.readFileContents(parentPath + "product"));
            usb.setReportedVendorName(this.readFileContents(parentPath + "manufacturer"));
            usb.setSerialNumber(this.readFileContents(parentPath + "serial"));
            usb.setSpeed(this.readFileContents(parentPath + "speed"));
            usb.setVID(this.readFileContents(parentPath + "idVendor"));
            usb.setUsbVersion(this.readFileContents(parentPath + "version"));
            if (usb.getBusNumber().length() <= 0 || usb.getDeviceNumber().length() <= 0) continue;
            String key = child.getName();
            this.myUsbDevices.put(key, usb);
        }
    }

    private String readFileContents(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return "";
        }
        if (file.isDirectory()) {
            return "";
        }
        StringBuffer fileData = new StringBuffer(1000);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filePath));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return fileData.toString().trim();
    }
}

