/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import android.hardware.Camera;
import android.os.Build;
import java.util.HashMap;

public class NydusUtil {
    private static final String TAG = NydusUtil.class.getSimpleName();
    private static int gNumberOfCameras = -1;
    private static HashMap<Integer, Camera.CameraInfo> gCameraInfoMap = new HashMap();
    private static final String[] SAMSUNG_ISSUE_FRONT_CAMERA_DEVICES = new String[]{"GT-I9003", "SPH-D700", "GT-P1000"};
    private static final String[] HTC_ISSUE_FRONT_CAMERA_DEVICES = new String[]{"HTC Glacier", "HTC Desire S", "HTC Thunderbolt", "HTC EVO 4G"};

    public static boolean isSamsungIncorrectPreviewSizeFrontCameraDevice() {
        if ("samsung".equalsIgnoreCase(Build.MANUFACTURER)) {
            for (int i = 0; i < SAMSUNG_ISSUE_FRONT_CAMERA_DEVICES.length; ++i) {
                if (!SAMSUNG_ISSUE_FRONT_CAMERA_DEVICES[i].equals(Build.MODEL)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getRealCameraOrientation(int cameraId) {
        if (cameraId == 1) {
            int i;
            if ("samsung".equalsIgnoreCase(Build.MANUFACTURER)) {
                for (i = 0; i < SAMSUNG_ISSUE_FRONT_CAMERA_DEVICES.length; ++i) {
                    if (!SAMSUNG_ISSUE_FRONT_CAMERA_DEVICES[i].equals(Build.MODEL)) continue;
                    return 0;
                }
            }
            if ("HTC".equalsIgnoreCase(Build.MANUFACTURER)) {
                for (i = 0; i < HTC_ISSUE_FRONT_CAMERA_DEVICES.length; ++i) {
                    if (!HTC_ISSUE_FRONT_CAMERA_DEVICES[i].equals(Build.MODEL)) continue;
                    return 0;
                }
            }
        }
        if (NydusUtil.getNumberOfCameras() <= cameraId) {
            return 0;
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        NydusUtil.getCameraInfo(cameraId, cameraInfo);
        return cameraInfo.orientation;
    }

    public static int getFrontCameraId() {
        int count = NydusUtil.getNumberOfCameras();
        for (int cameraId = 0; cameraId < count; ++cameraId) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            NydusUtil.getCameraInfo(cameraId, info);
            if (info.facing != 1) continue;
            return cameraId;
        }
        return -1;
    }

    public static int getBackCameraId() {
        int count = NydusUtil.getNumberOfCameras();
        for (int cameraId = 0; cameraId < count; ++cameraId) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            NydusUtil.getCameraInfo(cameraId, info);
            if (info.facing != 0) continue;
            return cameraId;
        }
        return -1;
    }

    public static boolean isFrontCamera(int cameraId) {
        if (cameraId < 0) {
            return false;
        }
        int frontCameraId = NydusUtil.getFrontCameraId();
        return frontCameraId == cameraId;
    }

    public static boolean isFrontCamera(String cameraId) {
        if (cameraId == null) {
            return false;
        }
        int iCameraId = 0;
        try {
            iCameraId = Integer.parseInt(cameraId);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return NydusUtil.isFrontCamera(iCameraId);
    }

    public static boolean isBackCamera(int cameraId) {
        if (cameraId < 0) {
            return false;
        }
        int backCameraId = NydusUtil.getBackCameraId();
        return backCameraId == cameraId;
    }

    public static boolean isBackCamera(String cameraId) {
        if (cameraId == null) {
            return false;
        }
        int iCameraId = 0;
        try {
            iCameraId = Integer.parseInt(cameraId);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return NydusUtil.isBackCamera(iCameraId);
    }

    public static boolean isCameraMirror(int cameraId) {
        if (cameraId == 1) {
            int i;
            if ("samsung".equalsIgnoreCase(Build.MANUFACTURER)) {
                for (i = 0; i < SAMSUNG_ISSUE_FRONT_CAMERA_DEVICES.length; ++i) {
                    if (!SAMSUNG_ISSUE_FRONT_CAMERA_DEVICES[i].equals(Build.MODEL)) continue;
                    return true;
                }
            }
            if ("HTC".equals(Build.MANUFACTURER)) {
                for (i = 0; i < HTC_ISSUE_FRONT_CAMERA_DEVICES.length; ++i) {
                    if (!HTC_ISSUE_FRONT_CAMERA_DEVICES[i].equals(Build.MODEL)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getNumberOfCameras() {
        if (gNumberOfCameras >= 0) {
            return gNumberOfCameras;
        }
        gNumberOfCameras = Camera.getNumberOfCameras();
        return gNumberOfCameras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getCameraInfo(int cameraId, Camera.CameraInfo cameraInfo) {
        if (cameraId < 0 || cameraInfo == null) {
            return;
        }
        Camera.CameraInfo info = null;
        HashMap<Integer, Camera.CameraInfo> hashMap = gCameraInfoMap;
        synchronized (hashMap) {
            info = gCameraInfoMap.get(cameraId);
            if (info == null && cameraId < NydusUtil.getNumberOfCameras()) {
                info = new Camera.CameraInfo();
                try {
                    Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
                    gCameraInfoMap.put(cameraId, info);
                }
                catch (Exception e) {
                    if (cameraId == 0) {
                        info.facing = 0;
                        info.orientation = 90;
                    }
                    info.facing = 1;
                    info.orientation = 270;
                }
            }
        }
        if (info != null) {
            cameraInfo.facing = info.facing;
            cameraInfo.orientation = info.orientation;
        }
    }
}

