/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.RemoteException;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.kubi.IKubiService;
import com.zipow.videobox.kubi.KubiDevice;
import com.zipow.videobox.kubi.KubiServiceManager;
import java.util.ArrayList;
import us.zoom.androidlib.util.HardwareUtil;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class KUBIDeviceController
implements KubiServiceManager.IKubiServiceConnectionListener {
    private static final int KubiRelativePanAction_Right = 1;
    private static final int KubiRelativePanAction_Left = -1;
    private static final int KubiRelativePanAction_Stop = 0;
    private static final int KubiRelativeTiltAction_Up = 1;
    private static final int KubiRelativeTiltAction_Down = -1;
    private static final int KubiRelativeTiltAction_Stop = 0;
    public static final int kubiDeviceConnected = 1;
    public static final int kubiDeviceDisConnected = 0;
    public static final int deviceFindDelay = 1;
    public static final int deviceNotificationDelay = 1;
    private static KUBIDeviceController instance;
    private static final String TAG;
    private long mNotificationNativePtr = 0L;
    private KubiServiceManager mKubiServiceMgr;
    private Handler mHandler;
    private ListenerList mKubiListeners = new ListenerList();
    private BroadcastReceiver mKubiMsgReceiver;

    public static synchronized KUBIDeviceController getInstance() {
        if (HardwareUtil.isBluetoothLESupported((Context)VideoBoxApplication.getInstance())) {
            if (instance == null) {
                instance = new KUBIDeviceController();
            }
            return instance;
        }
        return null;
    }

    private KUBIDeviceController() {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (context == null) {
            return;
        }
        this.mKubiServiceMgr = KubiServiceManager.getInstance((Context)context);
        this.mHandler = new Handler();
        this.mKubiServiceMgr.addConnectionListener(this);
        IntentFilter filter = new IntentFilter();
        filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_CONNECTION_STATUS");
        filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_DEVICE_FOUND");
        filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_FAILED");
        filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_STATUS_CHANGED");
        filter.addAction("us.zoom.videomeetings.KubiContract.ACTION_KUBI_SCAN_COMPLETE");
        this.mKubiMsgReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                KUBIDeviceController.this.onKubiMessageReceived(intent);
            }
        };
        context.registerReceiver(this.mKubiMsgReceiver, filter, context.getPackageName() + ".permission.KUBI_MESSAGE", this.mHandler);
    }

    public void addKubiListener(IKubiListener listener) {
        this.mKubiListeners.add((IListener)listener);
    }

    public void removeKubiListener(IKubiListener listener) {
        this.mKubiListeners.remove((IListener)listener);
    }

    private IKubiService getKubiService() {
        if (this.mKubiServiceMgr == null) {
            return null;
        }
        IKubiService kubiService = this.mKubiServiceMgr.getKubiService();
        return kubiService;
    }

    public int getKubiStatus() {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                return kubiService.getKubiStatus();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void destroy() {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (context != null && this.mKubiMsgReceiver != null) {
            context.unregisterReceiver(this.mKubiMsgReceiver);
        }
    }

    public boolean findKubiDevice() {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                return kubiService.findKubiDevice();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean releaseKubiDevice() {
        this.resetDevicePosition();
        return true;
    }

    public boolean disconnectKubi() {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                return kubiService.disconnectKubi();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public void findAllKubiDevices() {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                kubiService.findAllKubiDevices();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void connectToKubi(KubiDevice device) {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                kubiService.connectToKubi(device);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public KubiDevice getCurrentKubi() {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                return kubiService.getCurrentKubi();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public float devicePan() {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                return kubiService.getPan();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public float deviceTilt() {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                return kubiService.getTilt();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public boolean devicePanTo(float panValue) {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                kubiService.moveTo(panValue, this.deviceTilt(), 52.3f);
                return true;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean deviceTiltTo(float tiltValue) {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                kubiService.moveTo(this.devicePan(), tiltValue, 52.3f);
                return true;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean panAction(int padAction) {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                KubiDevice kubi = kubiService.getCurrentKubi();
                if (null != kubi) {
                    switch (padAction) {
                        case 1: {
                            kubiService.moveInPanDirectionWithSpeed(-1, 78);
                            break;
                        }
                        case -1: {
                            kubiService.moveInPanDirectionWithSpeed(1, 78);
                            break;
                        }
                        case 0: {
                            kubiService.moveInPanDirectionWithSpeed(0, 0);
                        }
                    }
                    return true;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean tiltAction(int tiltAction) {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                KubiDevice kubi = kubiService.getCurrentKubi();
                if (null != kubi) {
                    switch (tiltAction) {
                        case 1: {
                            kubiService.moveInTiltDirectionWithSpeed(1, 47);
                            break;
                        }
                        case -1: {
                            kubiService.moveInTiltDirectionWithSpeed(-1, 47);
                            break;
                        }
                        case 0: {
                            kubiService.moveInTiltDirectionWithSpeed(0, 0);
                        }
                    }
                    return true;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean resetDevicePosition() {
        IKubiService kubiService = this.getKubiService();
        if (null != kubiService) {
            try {
                kubiService.resetDevicePosition();
                return true;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean SetNotificationNativePtr(long id_notification) {
        this.mNotificationNativePtr = id_notification;
        return true;
    }

    private void onKubiMessageReceived(Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_CONNECTION_STATUS".equals(action)) {
            boolean connected = intent.getBooleanExtra("connected", false);
            this.onKubiDeviceConnectionStatus(connected);
        } else if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_DEVICE_FOUND".equals(action)) {
            KubiDevice device = (KubiDevice)intent.getParcelableExtra("device");
            this.onKubiDeviceFound(device);
        } else if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_FAILED".equals(action)) {
            int reason = intent.getIntExtra("reason", 0);
            this.onKubiManagerFailed(reason);
        } else if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_MANAGER_STATUS_CHANGED".equals(action)) {
            int oldStatus = intent.getIntExtra("oldStatus", 0);
            int newStatus = intent.getIntExtra("newStatus", 0);
            this.onKubiManagerStatusChanged(oldStatus, newStatus);
        } else if ("us.zoom.videomeetings.KubiContract.ACTION_KUBI_SCAN_COMPLETE".equals(action)) {
            ArrayList devices = intent.getParcelableArrayListExtra("devices");
            this.onKubiScanComplete(devices);
        }
    }

    private void onKubiDeviceConnectionStatus(boolean connected) {
        this.nativeKubiDeviceConnected(this.mNotificationNativePtr, connected ? 1 : 0);
    }

    private void onKubiDeviceFound(KubiDevice device) {
        IListener[] listeners;
        for (IListener l : listeners = this.mKubiListeners.getAll()) {
            ((IKubiListener)l).onKubiDeviceFound(device);
        }
    }

    private void onKubiManagerStatusChanged(int oldStatus, int newStatus) {
        IListener[] listeners;
        for (IListener l : listeners = this.mKubiListeners.getAll()) {
            ((IKubiListener)l).onKubiManagerStatusChanged(oldStatus, newStatus);
        }
    }

    private void onKubiManagerFailed(int reason) {
        IListener[] listeners;
        for (IListener l : listeners = this.mKubiListeners.getAll()) {
            ((IKubiListener)l).onKubiManagerFailed(reason);
        }
    }

    private void onKubiScanComplete(ArrayList<KubiDevice> devices) {
        IListener[] listeners;
        for (IListener l : listeners = this.mKubiListeners.getAll()) {
            ((IKubiListener)l).onKubiScanComplete(devices);
        }
    }

    @Override
    public void onKubiServiceConnected(IKubiService service) {
        if (service != null) {
            try {
                int status = service.getKubiStatus();
                this.onKubiDeviceConnectionStatus(status == 4);
                this.onKubiManagerStatusChanged(0, status);
                if (status == 4) {
                    service.resetDevicePosition();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onKubiServiceDisconnected() {
        this.onKubiDeviceConnectionStatus(false);
    }

    private final native void nativeKubiDeviceConnected(long var1, int var3);

    static {
        TAG = KUBIDeviceController.class.getSimpleName();
    }

    public static class SimpleKubiListener
    implements IKubiListener {
        @Override
        public void onKubiScanComplete(ArrayList<KubiDevice> devices) {
        }

        @Override
        public void onKubiManagerStatusChanged(int oldStatus, int newStatus) {
        }

        @Override
        public void onKubiManagerFailed(int reason) {
        }

        @Override
        public void onKubiDeviceFound(KubiDevice device) {
        }
    }

    public static interface IKubiListener
    extends IListener {
        public void onKubiDeviceFound(KubiDevice var1);

        public void onKubiManagerStatusChanged(int var1, int var2);

        public void onKubiManagerFailed(int var1);

        public void onKubiScanComplete(ArrayList<KubiDevice> var1);
    }
}

