/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.hardware.usb.UsbDevice;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

@SuppressLint(value={"NewApi"})
public final class DeviceFilter {
    private static final String TAG = "DeviceFilter";
    private static final int USB_CLASS_VIDEO = 14;
    private static final String DEFAULT_USBFS = "/dev/bus/usb";
    public final int mVendorId;
    public final int mProductId;
    public final int mClass;
    public final int mSubclass;
    public final int mProtocol;
    public final String mManufacturerName;
    public final String mProductName;
    public final String mSerialNumber;
    public final boolean mCheckVideoInterface;

    public static DeviceFilter buildUVCDeviceFilter() {
        return new DeviceFilter(-1, -1, 239, 2, -1, null, null, null, true);
    }

    public DeviceFilter(int vid, int pid, int clasz, int subclass, int protocol, String manufacturer, String product, String serialnum, boolean checkVideoInterface) {
        this.mVendorId = vid;
        this.mProductId = pid;
        this.mClass = clasz;
        this.mSubclass = subclass;
        this.mProtocol = protocol;
        this.mManufacturerName = manufacturer;
        this.mProductName = product;
        this.mSerialNumber = serialnum;
        this.mCheckVideoInterface = checkVideoInterface;
    }

    public DeviceFilter(UsbDevice device) {
        this.mVendorId = device.getVendorId();
        this.mProductId = device.getProductId();
        this.mClass = device.getDeviceClass();
        this.mSubclass = device.getDeviceSubclass();
        this.mProtocol = device.getDeviceProtocol();
        this.mManufacturerName = null;
        this.mProductName = null;
        this.mSerialNumber = null;
        this.mCheckVideoInterface = false;
    }

    public static List<DeviceFilter> getDeviceFilters(Context context, int deviceFilterXmlId) {
        XmlResourceParser parser = context.getResources().getXml(deviceFilterXmlId);
        ArrayList<DeviceFilter> deviceFilters = new ArrayList<DeviceFilter>();
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                DeviceFilter deviceFilter;
                if (eventType == 2 && (deviceFilter = DeviceFilter.read(context, (XmlPullParser)parser)) != null) {
                    deviceFilters.add(deviceFilter);
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            Log.d((String)TAG, (String)"XmlPullParserException", (Throwable)e);
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"IOException", (Throwable)e);
        }
        return Collections.unmodifiableList(deviceFilters);
    }

    private static final int getAttributeInteger(Context context, XmlPullParser parser, String namespace, String name, int defaultValue) {
        int result = defaultValue;
        try {
            String v = parser.getAttributeValue(namespace, name);
            if (!TextUtils.isEmpty((CharSequence)v) && v.startsWith("@")) {
                String r = v.substring(1);
                int resId = context.getResources().getIdentifier(r, null, context.getPackageName());
                if (resId > 0) {
                    result = context.getResources().getInteger(resId);
                }
            } else {
                result = Integer.parseInt(v);
            }
        }
        catch (Resources.NotFoundException e) {
            result = defaultValue;
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        catch (NullPointerException e) {
            result = defaultValue;
        }
        return result;
    }

    private static final String getAttributeString(Context context, XmlPullParser parser, String namespace, String name, String defaultValue) {
        String result = defaultValue;
        try {
            result = parser.getAttributeValue(namespace, name);
            if (result == null) {
                result = defaultValue;
            }
            if (!TextUtils.isEmpty((CharSequence)result) && result.startsWith("@")) {
                String r = result.substring(1);
                int resId = context.getResources().getIdentifier(r, null, context.getPackageName());
                if (resId > 0) {
                    result = context.getResources().getString(resId);
                }
            }
        }
        catch (Resources.NotFoundException e) {
            result = defaultValue;
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        catch (NullPointerException e) {
            result = defaultValue;
        }
        return result;
    }

    public static DeviceFilter read(Context context, XmlPullParser parser) throws XmlPullParserException, IOException {
        int vendorId = -1;
        int productId = -1;
        int deviceClass = -1;
        int deviceSubclass = -1;
        int deviceProtocol = -1;
        String manufacturerName = null;
        String productName = null;
        String serialNumber = null;
        boolean hasValue = false;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            String tag = parser.getName();
            if (!TextUtils.isEmpty((CharSequence)tag) && tag.equalsIgnoreCase("usb-device")) {
                if (eventType == 2) {
                    hasValue = true;
                    vendorId = DeviceFilter.getAttributeInteger(context, parser, null, "venderId", -1);
                    productId = DeviceFilter.getAttributeInteger(context, parser, null, "productId", -1);
                    deviceClass = DeviceFilter.getAttributeInteger(context, parser, null, "class", -1);
                    deviceSubclass = DeviceFilter.getAttributeInteger(context, parser, null, "subclass", -1);
                    deviceProtocol = DeviceFilter.getAttributeInteger(context, parser, null, "protocol", -1);
                    manufacturerName = DeviceFilter.getAttributeString(context, parser, null, "manufacture", null);
                    productName = DeviceFilter.getAttributeString(context, parser, null, "product", null);
                    serialNumber = DeviceFilter.getAttributeString(context, parser, null, "serial", null);
                } else if (eventType == 3 && hasValue) {
                    return new DeviceFilter(vendorId, productId, deviceClass, deviceSubclass, deviceProtocol, manufacturerName, productName, serialNumber, false);
                }
            }
            eventType = parser.next();
        }
        return null;
    }

    private boolean matches(int clasz, int subclass, int protocol) {
        return !(this.mClass != -1 && clasz != this.mClass || this.mSubclass != -1 && subclass != this.mSubclass || this.mProtocol != -1 && protocol != this.mProtocol);
    }

    public boolean matches(Context context, UsbDevice device) {
        if (UIUtil.isTV((Context)context)) {
            return false;
        }
        if (ResourcesUtil.getBoolean((Context)context, (int)R.bool.zm_config_no_uvc_camera, (boolean)false)) {
            return false;
        }
        if (this.mVendorId != -1 && device.getVendorId() != this.mVendorId) {
            return false;
        }
        if (this.mProductId != -1 && device.getProductId() != this.mProductId) {
            return false;
        }
        if (!this.matches(device.getDeviceClass(), device.getDeviceSubclass(), device.getDeviceProtocol())) {
            return false;
        }
        if (this.mCheckVideoInterface) {
            boolean hasVideoInterface = false;
            int HaveVideoInterface = DeviceFilter.nativeCheckVideoInterface(device.getVendorId(), device.getProductId(), 0, this.getUSBFSName(device));
            if (HaveVideoInterface == 1) {
                hasVideoInterface = true;
            }
            return hasVideoInterface;
        }
        return true;
    }

    private final String getUSBFSName(UsbDevice device) {
        String[] v;
        String result = null;
        String name = device.getDeviceName();
        String[] stringArray = v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
        if (v != null && v.length > 2) {
            StringBuilder sb = new StringBuilder(v[0]);
            for (int i = 1; i < v.length - 2; ++i) {
                sb.append("/").append(v[i]);
            }
            result = sb.toString();
        }
        if (TextUtils.isEmpty(result)) {
            Log.w((String)TAG, (String)("failed to get USBFS path, try to use default path:" + name));
            result = DEFAULT_USBFS;
        }
        return result;
    }

    public boolean matches(DeviceFilter f) {
        if (this.mVendorId != -1 && f.mVendorId != this.mVendorId) {
            return false;
        }
        if (this.mProductId != -1 && f.mProductId != this.mProductId) {
            return false;
        }
        if (f.mManufacturerName != null && this.mManufacturerName == null) {
            return false;
        }
        if (f.mProductName != null && this.mProductName == null) {
            return false;
        }
        if (f.mSerialNumber != null && this.mSerialNumber == null) {
            return false;
        }
        if (this.mManufacturerName != null && f.mManufacturerName != null && !this.mManufacturerName.equals(f.mManufacturerName)) {
            return false;
        }
        if (this.mProductName != null && f.mProductName != null && !this.mProductName.equals(f.mProductName)) {
            return false;
        }
        if (this.mSerialNumber != null && f.mSerialNumber != null && !this.mSerialNumber.equals(f.mSerialNumber)) {
            return false;
        }
        return this.matches(f.mClass, f.mSubclass, f.mProtocol);
    }

    public boolean equals(Object obj) {
        if (this.mVendorId == -1 || this.mProductId == -1 || this.mClass == -1 || this.mSubclass == -1 || this.mProtocol == -1) {
            return false;
        }
        if (obj instanceof DeviceFilter) {
            DeviceFilter filter = (DeviceFilter)obj;
            if (filter.mVendorId != this.mVendorId || filter.mProductId != this.mProductId || filter.mClass != this.mClass || filter.mSubclass != this.mSubclass || filter.mProtocol != this.mProtocol) {
                return false;
            }
            if (filter.mManufacturerName != null && this.mManufacturerName == null || filter.mManufacturerName == null && this.mManufacturerName != null || filter.mProductName != null && this.mProductName == null || filter.mProductName == null && this.mProductName != null || filter.mSerialNumber != null && this.mSerialNumber == null || filter.mSerialNumber == null && this.mSerialNumber != null) {
                return false;
            }
            return !(filter.mManufacturerName != null && this.mManufacturerName != null && !this.mManufacturerName.equals(filter.mManufacturerName) || filter.mProductName != null && this.mProductName != null && !this.mProductName.equals(filter.mProductName)) && (filter.mSerialNumber == null || this.mSerialNumber == null || this.mSerialNumber.equals(filter.mSerialNumber));
        }
        if (obj instanceof UsbDevice) {
            UsbDevice device = (UsbDevice)obj;
            return device.getVendorId() == this.mVendorId && device.getProductId() == this.mProductId && device.getDeviceClass() == this.mClass && device.getDeviceSubclass() == this.mSubclass && device.getDeviceProtocol() == this.mProtocol;
        }
        return false;
    }

    public int hashCode() {
        return (this.mVendorId << 16 | this.mProductId) ^ (this.mClass << 16 | this.mSubclass << 8 | this.mProtocol);
    }

    public String toString() {
        return "DeviceFilter[mVendorId=" + this.mVendorId + ",mProductId=" + this.mProductId + ",mClass=" + this.mClass + ",mSubclass=" + this.mSubclass + ",mProtocol=" + this.mProtocol + ",mManufacturerName=" + this.mManufacturerName + ",mProductName=" + this.mProductName + ",mSerialNumber=" + this.mSerialNumber + "]";
    }

    private static final native int nativeCheckVideoInterface(int var0, int var1, int var2, String var3);

    static {
        System.loadLibrary("nydus");
    }
}

