/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.cmmlib;

import com.zipow.videobox.VideoBoxApplication;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CmmTimer {
    private static final String TAG = CmmTimer.class.getSimpleName();
    private static ScheduledExecutorService sExecutorService;
    private long mNativeTimerProc = 0L;
    private ScheduledFuture<?> mTimer = null;
    private Runnable mNativeCaller = new Runnable(){

        @Override
        public void run() {
            long timeStart = System.currentTimeMillis();
            if (CmmTimer.this.mNativeTimerProc != 0L) {
                CmmTimer.this.callNativeTimerProc(CmmTimer.this.mNativeTimerProc, CmmTimer.this);
                long timeUsed = System.currentTimeMillis() - timeStart;
                if (timeUsed > 100L) {
                    // empty if block
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimer(long interval, long nativeTimerProc) {
        Class<CmmTimer> clazz = CmmTimer.class;
        synchronized (CmmTimer.class) {
            if (sExecutorService == null) {
                sExecutorService = Executors.newScheduledThreadPool(1);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (this.mTimer != null) {
                return;
            }
            this.mNativeTimerProc = nativeTimerProc;
            this.mTimer = sExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    VideoBoxApplication.getInstance().runOnMainThread(CmmTimer.this.mNativeCaller);
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
            return;
        }
    }

    public void killTimer() {
        if (this.mTimer == null) {
            return;
        }
        this.mTimer.cancel(false);
        this.mTimer = null;
        this.mNativeTimerProc = 0L;
    }

    private native void callNativeTimerProc(long var1, CmmTimer var3);
}

