/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.cmmlib;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.File;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.StringUtil;

public class AppUtil {
    private static final String TAG = AppUtil.class.getSimpleName();
    private static final long MIN_RESERVED_STORAGE_SPACE = 0xA00000L;
    private static final String SHARE_CACHE_FILE_NAME_PREFIX = "share_cache_file";
    public static final String ZOOM_PACKAGE_NAME = "us.zoom.videomeetings";
    private static final int REQUEST_CONTACT_PERMISSION_PERIOD = 259200000;

    public static String getAppPackageName() {
        return VideoBoxApplication.getInstance().getPackageName();
    }

    public static String getTempPath() {
        return FileUtils.getTempPath((Context)VideoBoxApplication.getInstance());
    }

    public static String createTempFile(String prefix, String dir) {
        return AppUtil.createTempFile(prefix, dir, null);
    }

    public static String createTempFile(String prefix, String dir, String ext) {
        return FileUtils.createTempFile((Context)VideoBoxApplication.getInstance(), (String)prefix, (String)dir, (String)ext);
    }

    public static String getDataPath() {
        return AppUtil.getDataPath(false, false);
    }

    public static String getCachePath() {
        return AppUtil.getDataPath();
    }

    public static String getShareCachePathByExtension(String dir, String file) {
        if (StringUtil.isEmptyOrNull((String)dir) || StringUtil.isEmptyOrNull((String)file)) {
            return null;
        }
        String extension = AndroidAppUtil.getFileExtendName((String)file);
        if (extension == null) {
            extension = "";
        }
        String path = dir.endsWith(File.separator) ? dir + SHARE_CACHE_FILE_NAME_PREFIX + extension : dir + File.separator + SHARE_CACHE_FILE_NAME_PREFIX + extension;
        return path;
    }

    public static String getLogParentPath() {
        String state = Environment.getExternalStorageState();
        if (state == null || !state.equals("mounted")) {
            return "/sdcard/Android/data/" + AppUtil.getAppPackageName();
        }
        File filesDir = VideoBoxApplication.getInstance().getExternalFilesDir(null);
        if (filesDir != null) {
            return filesDir.getParent();
        }
        return "/sdcard/Android/data/" + AppUtil.getAppPackageName();
    }

    public static String getDataPath(boolean createIfNotExist, boolean isPrivate) {
        return FileUtils.getDataPath((Context)VideoBoxApplication.getInstance(), (boolean)isPrivate, (boolean)createIfNotExist);
    }

    @SuppressLint(value={"NewApi"})
    public static boolean hasEnoughDiskSpace(String path, long size) {
        try {
            StatFs statFs = new StatFs(path);
            long availableBytes = 0L;
            availableBytes = Build.VERSION.SDK_INT < 18 ? (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize() : statFs.getAvailableBytes();
            return availableBytes >= size + 0xA00000L;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void saveRequestContactPermissionTime() {
        long time = System.currentTimeMillis();
        PreferenceUtil.saveLongValue("last_request_contact_permission_time", time);
    }

    public static boolean canRequestContactPermission() {
        long lastTime = PreferenceUtil.readLongValue("last_request_contact_permission_time", 0L);
        if (lastTime == 0L) {
            return true;
        }
        long time = System.currentTimeMillis();
        return time - lastTime > 259200000L;
    }
}

