/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.os.Bundle;
import com.zipow.annotate.AnnoToolType;
import com.zipow.annotate.AnnotateTextData;
import com.zipow.annotate.ZoomShareData;
import java.util.ArrayList;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.ZMLog;

public class ZoomAnnotate {
    public String KEY_TOOL_TYPE = "KEY_TOOL_TYPE";
    public String KEY_TOOL_WIDTH = "KEY_TOOL_WIDTH";
    public String KEY_TOOL_COLOR = "KEY_TOOL_COLOR";
    public String KEY_TOOL_ALPHA = "KEY_TOOL_ALPHA";
    public String KEY_TOOL_START_X = "KEY_TOOL_START_X";
    public String KEY_TOOL_START_Y = "KEY_TOOL_START_Y";
    public String KEY_TOOL_END_X = "KEY_TOOL_END_X";
    public String KEY_TOOL_END_Y = "KEY_TOOL_END_Y";
    public String KEY_TOOL_TEXT = "KEY_TOOL_TEXT";
    public String KEY_TOOL_LIST = "KEY_TOOL_LIST";
    public String KEY_DRAWOBJ_LIST = "KEY_DRAWOBJ_LIST";
    public String KEY_TOOL_BOLD = "KEY_TOOL_BOLD";
    public String KEY_TOOL_ITALIC = "KEY_TOOL_ITALIC";
    public String KEY_TOOL_FONT_SIZE = "KEY_TOOL_FONT_SIZE";
    public String KEY_TOOL_TEXT_SHORT_LIST = "KEY_TOOL_TEXT_SHORT_LIST";
    public static final int MSG_LAZY_ANNODRAW = 0;
    public static final int MSG_LAZY_ANNO_CLEAR_DRAW = 1;
    public static final int MSG_LAZY_TIMER = 10;
    private ListenerList mListenerList = new ListenerList();
    private IZoomAnnotateUIListener mListener;
    private static final String TAG = ZoomAnnotate.class.getSimpleName();
    private long mNativeHandle = 0L;

    public native void nativeInit();

    public native float getPrimaryDpiScaleImpl();

    public native void setIsPresenterImpl(boolean var1);

    public native void setAnnoToolImpl(int var1, long var2, long var4);

    public native void setAnnoWidthImpl(int var1, long var2, long var4);

    public native void setAnnoColorImpl(int var1, long var2, long var4);

    public native void undoImpl(long var1, long var3);

    public native void redoImpl(long var1, long var3);

    public native void clearAllImpl(long var1, long var3);

    public native int getCompserVersionImpl(long var1, long var3);

    public native void touchDownImpl(float var1, float var2);

    public native void touchMoveImpl(float var1, float var2);

    public native void touchUpImpl(float var1, float var2);

    public native void editTextDidEndEditingImpl(short[] var1, AnnotateTextData var2);

    public ZoomAnnotate(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.nativeInit();
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    public void addListener(IZoomAnnotateUIListener l) {
        if (l == null) {
            return;
        }
        this.mListener = l;
    }

    public float getPrimaryDpiScale() {
        return this.getPrimaryDpiScaleImpl();
    }

    public void setIsPresenter(boolean bPresenter) {
        this.setIsPresenterImpl(bPresenter);
    }

    public void setAnnoTool(int toolIndex) {
        this.setAnnoToolImpl(toolIndex, this.mNativeHandle, ZoomShareData.getInstance().getViewHandle());
    }

    public void setAnnoWidth(int width) {
        this.setAnnoWidthImpl(width, this.mNativeHandle, ZoomShareData.getInstance().getViewHandle());
    }

    public void setAnnoColor(int color) {
        this.setAnnoColorImpl(color, this.mNativeHandle, ZoomShareData.getInstance().getViewHandle());
    }

    public int getCompserVersion() {
        return this.getCompserVersionImpl(this.mNativeHandle, ZoomShareData.getInstance().getViewHandle());
    }

    public void undo() {
        this.undoImpl(this.mNativeHandle, ZoomShareData.getInstance().getViewHandle());
    }

    public void redo() {
        this.redoImpl(this.mNativeHandle, ZoomShareData.getInstance().getViewHandle());
    }

    public void clearAll() {
        this.clearAllImpl(this.mNativeHandle, ZoomShareData.getInstance().getViewHandle());
    }

    public void touchDown(float x, float y) {
        this.touchDownImpl(x, y);
    }

    public void touchMove(float x, float y) {
        this.touchMoveImpl(x, y);
    }

    public void touchUp(float x, float y) {
        this.touchUpImpl(x, y);
    }

    public void editTextDidEndEditing(short[] textShortArray, AnnotateTextData textData) {
        this.editTextDidEndEditingImpl(textShortArray, textData);
    }

    public void clear(int color, int alpha) {
        if (null != this.mListener) {
            this.mListener.clearAllAnnodateData();
        }
    }

    public void drawAnnoPath(int width, int color, int alpha, int type, ArrayList<String> annoPoints) {
        try {
            this.drawAnnoPathImpl(width, color, alpha, type, annoPoints);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void drawAnnoPathImpl(int width, int color, int alpha, int type, ArrayList<String> annoPoints) {
        Bundle data = new Bundle();
        data.putInt(this.KEY_TOOL_TYPE, type);
        data.putInt(this.KEY_TOOL_WIDTH, width);
        data.putInt(this.KEY_TOOL_COLOR, color);
        data.putInt(this.KEY_TOOL_ALPHA, alpha);
        data.putStringArrayList(this.KEY_TOOL_LIST, annoPoints);
        this.notificationAllListener(data);
    }

    public void fillAnnoPath(int color, int alpha, int type) {
        try {
            this.fillAnnoPathImpl(color, alpha, type);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void fillAnnoPathImpl(int color, int alpha, int type) {
        Bundle data = new Bundle();
        data.putInt(this.KEY_TOOL_TYPE, type);
        data.putInt(this.KEY_TOOL_COLOR, color);
        data.putInt(this.KEY_TOOL_ALPHA, alpha);
        this.notificationAllListener(data);
    }

    public void drawAutoShape(int width, int color, int alpha, float startX, float startY, float endX, float endY, int type) {
        try {
            this.drawAutoShapeImpl(width, color, alpha, startX, startY, endX, endY, type);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void drawAutoShapeImpl(int width, int color, int alpha, float startX, float startY, float endX, float endY, int type) {
        Bundle data = new Bundle();
        data.putInt(this.KEY_TOOL_TYPE, type);
        data.putInt(this.KEY_TOOL_WIDTH, width);
        data.putInt(this.KEY_TOOL_COLOR, color);
        data.putInt(this.KEY_TOOL_ALPHA, alpha);
        data.putFloat(this.KEY_TOOL_START_X, startX);
        data.putFloat(this.KEY_TOOL_START_Y, startY);
        data.putFloat(this.KEY_TOOL_END_X, endX);
        data.putFloat(this.KEY_TOOL_END_Y, endY);
        this.notificationAllListener(data);
    }

    public void drawArrow(int width, int color, int alpha, int titleLeft, int titleTop, int titleRight, int titleBottom, String title, ArrayList<String> annoPoints) {
        try {
            this.drawArrowImpl(width, color, alpha, titleLeft, titleTop, titleRight, titleBottom, title, annoPoints);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void drawArrowImpl(int width, int color, int alpha, int titleLeft, int titleTop, int titleRight, int titleBottom, String title, ArrayList<String> annoPoints) {
        Bundle data = new Bundle();
        data.putInt(this.KEY_TOOL_TYPE, AnnoToolType.ANNO_TOOL_TYPE_ARROW.ordinal());
        data.putInt(this.KEY_TOOL_WIDTH, width);
        data.putInt(this.KEY_TOOL_COLOR, color);
        data.putInt(this.KEY_TOOL_ALPHA, alpha);
        data.putFloat(this.KEY_TOOL_START_X, (float)titleLeft);
        data.putFloat(this.KEY_TOOL_START_Y, (float)titleTop);
        data.putFloat(this.KEY_TOOL_END_X, (float)titleRight);
        data.putFloat(this.KEY_TOOL_END_Y, (float)titleBottom);
        data.putString(this.KEY_TOOL_TEXT, title);
        data.putStringArrayList(this.KEY_TOOL_LIST, annoPoints);
        this.notificationAllListener(data);
    }

    public void drawText(short[] shortList, int color, int left, int top, int right, int bottom, boolean isBold, boolean isItalic, int fontSize) {
        try {
            this.drawTextImpl(shortList, color, left, top, right, bottom, isBold, isItalic, fontSize);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void drawTextImpl(short[] shortList, int color, int left, int top, int right, int bottom, boolean isBold, boolean isItalic, int fontSize) {
        Bundle data = new Bundle();
        data.putInt(this.KEY_TOOL_TYPE, AnnoToolType.ANNO_TOOL_TYPE_TEXTBOX.ordinal());
        data.putShortArray(this.KEY_TOOL_TEXT_SHORT_LIST, shortList);
        data.putInt(this.KEY_TOOL_COLOR, color);
        data.putFloat(this.KEY_TOOL_START_X, (float)left);
        data.putFloat(this.KEY_TOOL_START_Y, (float)top);
        data.putFloat(this.KEY_TOOL_END_X, (float)right);
        data.putFloat(this.KEY_TOOL_END_Y, (float)bottom);
        data.putBoolean(this.KEY_TOOL_BOLD, isBold);
        data.putBoolean(this.KEY_TOOL_ITALIC, isItalic);
        data.putInt(this.KEY_TOOL_FONT_SIZE, fontSize);
        this.notificationAllListener(data);
    }

    private void notificationAllListener(Bundle data) {
        if (null != this.mListener) {
            this.mListener.addDrawObjToList(data);
        }
    }

    public void clearAndDrawAllPath() {
        try {
            if (null != this.mListener) {
                this.mListener.clearAndDrawAllPath();
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void beginEditing(int x, int y, int fontColor) {
        try {
            if (null != this.mListener) {
                this.mListener.beginEditing(x, y);
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void endEditing() {
        ZMLog.w((String)TAG, (String)"beginEditing", (Object[])new Object[0]);
        try {
            if (null != this.mListener) {
                this.mListener.endEditing();
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void beginPath() {
        try {
            if (null != this.mListener) {
                this.mListener.beginPath();
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void closePath() {
        try {
            if (null != this.mListener) {
                this.mListener.closePath();
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void moveToAbs(float toPosX, float toPosY) {
        try {
            if (null != this.mListener) {
                this.mListener.moveToAbs(toPosX, toPosY);
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void lineToAbs(float toPosX, float toPosY) {
        try {
            if (null != this.mListener) {
                this.mListener.lineToAbs(toPosX, toPosY);
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void curveToQuadAbs(float toPosX, float toPosY, float endPosX, float endPosY) {
        try {
            if (null != this.mListener) {
                this.mListener.curveToQuadAbs(toPosX, toPosY, endPosX, endPosY);
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void curveToCubicAbs(float x1, float y1, float x2, float y2, float x3, float y3) {
        try {
            if (null != this.mListener) {
                this.mListener.curveToCubicAbs(x1, y1, x2, y2, x3, y3);
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public static interface IZoomAnnotateUIListener
    extends IListener {
        public void clearAllAnnodateData();

        public void clearAndDrawAllPath();

        public void addDrawObjToList(Bundle var1);

        public void beginEditing(int var1, int var2);

        public void endEditing();

        public void beginPath();

        public void closePath();

        public void moveToAbs(float var1, float var2);

        public void lineToAbs(float var1, float var2);

        public void curveToQuadAbs(float var1, float var2, float var3, float var4);

        public void curveToCubicAbs(float var1, float var2, float var3, float var4, float var5, float var6);
    }
}

